#ifndef UTIL_H
#define	UTIL_H

#include <xc.h> // include processor files - each processor file is guarded.  
#include "io.h"
#include "oled.h"
//for abs()
#include <stdlib.h>

//for smoothing
#define EXP_THRESHOLD 200
#define ESR_OS 2

//for Capacitance
#define ADC_SAMPLE_TIME 35
//capacitor sampling times in us
#define C4_TIME (4000UL)
#define C3_TIME (400UL)
#define C2_TIME (40UL)
#define C_UPPER_LIMIT (50000UL)

extern char udFlag;
extern char inSettings;
enum modes{ESR,RES,CAP,DUMMY};   //dummy to catch end of list
extern enum modes mode;
extern const char modeNames[DUMMY+1][8];

enum settingModes{SET_CAL,SET_BANDGAP,SET_HAND,SET_BRIGHT,SET_TIMEOUT,  //these are the core non-auto-cal
    SET_RLOW,SET_R1,SET_R2,SET_R3,SET_CFACTOR,
    SET_SAVERESTORE,SET_PROBE_R,SET_VSATLO,SET_VSATHI,SET_DUMMY};   
extern enum settingModes settingMode;
extern const char settingModeNames[SET_DUMMY+1][12];

enum saveStates{SAVE_IDLE, SAVE_SAVING,SAVE_DONE,SAVE_RESTORE,SAVE_DUMMY};
extern enum saveStates saveState;

unsigned int getScaled(unsigned int a, unsigned int b); //a*b/ADC_SCALE

void getC(long* v); //get low level reading from mid level pulse, use for capacitance
unsigned int getLow(void); //get low level reading from low level pulse 100uA nominal
unsigned int getR1(void); //get high level reading from low level pulse 100uA nominal; result in ADC
unsigned int getR2(void); //get high level reading from mid level pulse 1mA nominal; result in ADC
unsigned int getR3(void); //get high level reading from hi level pulse 10mA nominal; result in ADC

void doESR(void);
void doRES(void);
void doCAP(void);

void doSetCal(void);
void doSetBandgap(void);
void doSetHand(void);
void doSetBright(void);
void doSetTimeOut(void);
void doSetR(void);
void doSetC(void);
void doSetV(void);  //also handles ProbeR
void doSaveRestore(void);
void sleepAndWakeup(void);       //go to sleep and wait for SW1/SW2/SW3 then return
void doze(void);                //use doze to save power until an interrupt/button press

void skinnyDot(void);   //narrow decimal point to save some space

#endif	/* UTIL_H */

