#include "util.h"
#include "defaults.h"
#include "font.h"

char udFlag=0;  //1= partial redraw, 2=full redraw

char inSettings=0;
enum modes mode=ESR;
const char modeNames[DUMMY+1][8]={"ESR ","RES ","CAP ","??? "};

enum settingModes settingMode=0;
const char settingModeNames[SET_DUMMY+1][12]={
    "Calibrate ",
    "Bandgap   ",
    "Set Hand  ",
    "Brightness",    
    "Set Timer.",
    "Set Rlow  ",
    "Set Rval1 ",
    "Set Rval2 ",
    "Set Rval3 ",
    "Set Cfac. ",
    "Save/Rest.",
    "Probe Res.",
    "Set VsatLo",
    "Set VsatHi",
    "??????????"
};

enum saveStates saveState=0;
const char saveStateNames[SAVE_DUMMY+1][12]={
    "Ready     ",
    "Saving    ",
    "Save done ",
    "Load done ",
    "??????????"    
};

unsigned int getScaled(unsigned int a, unsigned int b){ //a*b/ADC_SCALE
    unsigned long n;
    n=((unsigned long)a)*((unsigned long)b);
    return n/ADC_SCALE;   
}

void getC(long* v){ //get low level reading from low level pulse, use for capacitance    
    unsigned int intcon2;
    intcon2=INTCON2bits.GIE;        //save and disable interrupts
    INTCON2bits.GIE=0;
    v[0]=getADC(ANALOG_LO);
    trisbits.MED_PULSE=1;
    trisbits.HI_PULSE=1;        //idle
    latbits.LOW_PULSE=1;    //active high
    __delay32(1);           //settling
    v[1]=getADC(ANALOG_LO);
    __delay_us(C2_TIME-ADC_SAMPLE_TIME);  //timed so everything is referred to v[1]
    v[2]=getADC(ANALOG_LO);
    __delay_us(C3_TIME-C2_TIME-ADC_SAMPLE_TIME);  //timed so everything is referred to v[1]
    v[3]=getADC(ANALOG_LO);
    __delay_us(C4_TIME-C3_TIME-ADC_SAMPLE_TIME);  //timed so everything is referred to v[1]
    v[4]=getADC(ANALOG_LO);
    latbits.LOW_PULSE=0;    //turn off
    trisbits.MED_PULSE=0;
    trisbits.HI_PULSE=0;        //discharge
    getADC(ADC_GND);
    INTCON2bits.GIE=intcon2;        //restore interrupts
}

unsigned int getLow(void){ //get low level reading from low level pulse 100uA nominal;
    unsigned int r0,r1;
    r0=getADC(ANALOG_LO);
    trisbits.MED_PULSE=1;
    trisbits.HI_PULSE=1;        //idle
    latbits.LOW_PULSE=1;    //active high
    //__delay_us(1);
    __delay32(1);           //settling
    r1=getADC(ANALOG_LO);
    //startADC(ANALOG_LO);
    latbits.LOW_PULSE=0;    //turn off
    trisbits.MED_PULSE=0;
    trisbits.HI_PULSE=0;        //discharge
    //r1=endADC();
    getADC(ADC_GND);
    if(r0>r1){return 0;}
    //return getScaled(r1-r0,vcc);        //in mV
    return r1-r0;                       //in ADC steps
}

unsigned int getR1(void){ //get high level reading from low level pulse 100uA nominal; result in ADC
    unsigned int r0,r1;
    r0=getADC(ANALOG_HI);
    trisbits.MED_PULSE=1;
    trisbits.HI_PULSE=1;        //idle
    latbits.LOW_PULSE=1;    //active high
    //__delay_us(1);
    __delay32(1);           //settling
    r1=getADC(ANALOG_HI);
    //startADC(ANALOG_HI);    
    latbits.LOW_PULSE=0;    //turn off
    trisbits.MED_PULSE=0;
    trisbits.HI_PULSE=0;        //discharge
    //r1=endADC();
    if(r0<r1){return 0;}
    //return getScaled(r0-r1,vcc);        //in mV
    return r0-r1;                       //in ADC steps
}

unsigned int getR2(void){ //get high level reading from mid level pulse 1mA nominal; result in ADC
    unsigned int r0,r1;
    r0=getADC(ANALOG_HI);
    trisbits.LOW_PULSE=1;
    trisbits.HI_PULSE=1;        //idle
    latbits.MED_PULSE=1;    //active high
    //__delay_us(1);
    __delay32(1);           //settling
    r1=getADC(ANALOG_HI);
    //startADC(ANALOG_HI);    
    latbits.MED_PULSE=0;    //turn off
    trisbits.LOW_PULSE=0;
    trisbits.HI_PULSE=0;        //discharge
    //r1=endADC();
    if(r0<r1){return 0;}
    //return getScaled(r0-r1,vcc);        //in mV
    return r0-r1;                       //in ADC steps
}

unsigned int getR3(void){ //get high level reading from hi level pulse 10mA nominal; result in ADC
    unsigned int r0,r1;
    r0=getADC(ANALOG_HI);
    trisbits.LOW_PULSE=1;
    trisbits.MED_PULSE=1;
    latbits.HI_PULSE=0;    //active low
    //__delay_us(1);
    __delay32(1);           //settling
    r1=getADC(ANALOG_HI);
    //startADC(ANALOG_HI);    
    latbits.HI_PULSE=1;    //turn off
    trisbits.LOW_PULSE=0;
    trisbits.MED_PULSE=0;   //discharge
    //r1=endADC();
    if(r0<r1){return 0;}
    //return getScaled(r0-r1,vcc);        //in mV
    return r0-r1;                       //in ADC steps
}

void doESR(void){
    long t;
    static long v[4];
    long r[4];
    if(ctr>2){  //update rate limiting
        ctr=0;        
        latbits.AMP_PWR=1;  //turn on
        __delay_ms(30);     //settle
        v[0]=getLow();
        if(v[0]>cur.d.vSatLow){      //high reading
            col=0;
            page=2;                
            OLEDchararray("  HI  ",grotesklite);
            latbits.AMP_PWR=0;  //turn off, left on if DUT present
        }else{  //normal reading
            //r[0]=(v[0]*cur.d.rLow)/(ADC_SCALE-v[0]);  //not used
            __delay_ms(10);     //settle
            t=getR1();
            if(abs(t-v[1])<EXP_THRESHOLD){
                v[1]=(t+v[1]*(ESR_OS-1))/ESR_OS;      //smoothing if close
            }else{  
                v[1]=t;                 //otherwise jump directly to value
            }
            __delay_ms(10);     //settle
            t=getR2();
            if(abs(t-v[2])<EXP_THRESHOLD){
                v[2]=(t+v[2]*(ESR_OS-1))/ESR_OS;      //smoothing if close
            }else{  
                v[2]=t;                 //otherwise jump directly to value
            }
            __delay_ms(10);     //settle
            t=getR3();
            if(abs(t-v[3])<EXP_THRESHOLD){
                v[3]=(t+v[3]*(ESR_OS-1))/ESR_OS;      //smoothing if close
            }else{  
                v[3]=t;                 //otherwise jump directly to value
            }
            r[1]=(v[1]*cur.d.r1)/vcc;
            r[2]=(v[2]*cur.d.r2)/vcc;
            r[3]=(v[3]*cur.d.r3)/vcc;
            col=0;
            page=2;                
            if(v[3]<cur.d.vSatHi){
                if(r[3]<cur.d.rProbe/10){
                    OLEDscanlong(0);                    //underflow
                }else{
                    OLEDscanlong(r[3]-cur.d.rProbe/10); //rProbe in mOhm
                }
                OLEDlzb(6);                    //2dp
                OLEDchar(dbuf[6],grotesklite);
                OLEDchar(dbuf[7],grotesklite);
                OLEDchar('.',grotesklite);
                OLEDchar(dbuf[8],grotesklite);
                OLEDchar(dbuf[9],grotesklite);
                OLEDchar(F_OMEGA,grotesklite);                            
            }else if(v[2]<cur.d.vSatHi){
                if(r[2]<cur.d.rProbe/10){
                    OLEDscanlong(0);                    //underflow
                }else{
                    OLEDscanlong(r[2]-cur.d.rProbe/10); //rProbe in mOhm
                }
                OLEDlzb(6);     //1dp, shifted
                OLEDchar(dbuf[5],grotesklite);
                OLEDchar(dbuf[6],grotesklite);
                OLEDchar(dbuf[7],grotesklite);
                OLEDchar('.',grotesklite);
                OLEDchar(dbuf[8],grotesklite);
                OLEDchar(F_OMEGA,grotesklite);                            
            }else if(v[1]<cur.d.vSatHi){
                if(r[1]<cur.d.rProbe/10){
                    OLEDscanlong(0);                    //underflow
                }else{
                    OLEDscanlong(r[1]-cur.d.rProbe/10); //rProbe in mOhm
                }
                OLEDlzb(6);                    //no dp, shifted
                OLEDchar(' ',grotesklite);
                OLEDchar(dbuf[4],grotesklite);
                OLEDchar(dbuf[5],grotesklite);
                OLEDchar(dbuf[6],grotesklite);
                OLEDchar(dbuf[7],grotesklite);
                OLEDchar(F_OMEGA,grotesklite);                                            
            }else{   //shouldn't happen, unless there's a glitch
                col=0;
                page=2;                
                OLEDchararray("  HI  ",grotesklite);
                latbits.AMP_PWR=0;  //turn off, left on if DUT present
            }
        }
        
    }
}

void doRES(void){
    long v,r;
    if(ctr>2){  //update rate limiting
        ctr=0;        
        latbits.AMP_PWR=1;  //needs to be on or biasing is wrong
        __delay_ms(30);     //settle
        v=getLow();        
        latbits.AMP_PWR=0;
        col=0;
        page=2;                
        if(v>cur.d.vSatLow){      //high reading
            OLEDchararray("  HI  ",grotesklite);            
        }else{  //normal reading
            r=(v*cur.d.rLow)/(ADC_SCALE-v);
            OLEDscanlong(r);
            OLEDlzb(7);
            OLEDchar(' ',grotesklite);
            OLEDchar(dbuf[5],grotesklite);
            OLEDchar(dbuf[6],grotesklite);
            OLEDchar(dbuf[7],grotesklite);
            OLEDchar(dbuf[8],grotesklite);
            OLEDchar(F_OMEGA,grotesklite);            
        }        
    }
}

void doCAP(void){
    long v[5];
    long i;
    if(ctr>2){  //update rate limiting
        ctr=0;        
        latbits.AMP_PWR=1;  //needs to be on or biasing is wrong
        __delay_ms(30);     //settle
        getC(&v[0]); 
        //capacitance display
        col=16;
        page=3;                
        if(v[1]>cur.d.vSatLow){
            OLEDchararray(" LOW CAP",arial);            
            latbits.AMP_PWR=0;      //shut off unless there's something connected
        }else if(v[4]<cur.d.vSatLow){    
            if((v[4]-v[1])>(C4_TIME*cur.d.cFactor/C_UPPER_LIMIT)){
                i=(C4_TIME*cur.d.cFactor)/(v[4]-v[1]);
                OLEDscanlong(i);
                OLEDlzb(5);
                OLEDchar(dbuf[4],arial);
                OLEDchar(dbuf[5],arial);
                OLEDchar(dbuf[6],arial);
                OLEDchar('.',arial);
                OLEDchar(dbuf[7],arial);
                OLEDchar(dbuf[8],arial);
                OLEDchar(F_MU,arial);
                OLEDchar('F',arial);
            }else{
                OLEDchar('-',arial);
                OLEDchar('-',arial);
                OLEDchar('-',arial);
                OLEDchar('.',arial);
                OLEDchar('-',arial);
                OLEDchar('-',arial);
                OLEDchar(F_MU,arial);
                OLEDchar('F',arial);                
            }
        }else if(v[3]<cur.d.vSatLow){    
            if((v[3]-v[1])>(C3_TIME*cur.d.cFactor/C_UPPER_LIMIT)){
                i=(C3_TIME*cur.d.cFactor)/(v[3]-v[1]);
                OLEDscanlong(i);
                OLEDlzb(5);
                OLEDchar(dbuf[4],arial);
                OLEDchar(dbuf[5],arial);
                OLEDchar(dbuf[6],arial);
                OLEDchar('.',arial);
                OLEDchar(dbuf[7],arial);
                OLEDchar(dbuf[8],arial);
                OLEDchar(F_MU,arial);
                OLEDchar('F',arial);
            }else{
                OLEDchar('-',arial);
                OLEDchar('-',arial);
                OLEDchar('-',arial);
                OLEDchar('.',arial);
                OLEDchar('-',arial);
                OLEDchar('-',arial);
                OLEDchar(F_MU,arial);
                OLEDchar('F',arial);                
            }
        }else if(v[2]<cur.d.vSatLow){    
            if((v[2]-v[1])>(C2_TIME*cur.d.cFactor/C_UPPER_LIMIT)){
                i=(C2_TIME*cur.d.cFactor)/(v[2]-v[1]);
                OLEDscanlong(i);
                OLEDlzb(5);
                OLEDchar(dbuf[4],arial);
                OLEDchar(dbuf[5],arial);
                OLEDchar(dbuf[6],arial);
                OLEDchar('.',arial);
                OLEDchar(dbuf[7],arial);
                OLEDchar(dbuf[8],arial);
                OLEDchar(F_MU,arial);
                OLEDchar('F',arial);
            }else{
                OLEDchar('-',arial);
                OLEDchar('-',arial);
                OLEDchar('-',arial);
                OLEDchar('.',arial);
                OLEDchar('-',arial);
                OLEDchar('-',arial);
                OLEDchar(F_MU,arial);
                OLEDchar('F',arial);                
            }
        }else{
            OLEDchararray(" ERROR  ",arial);            
        }
        //ESR/resistance
        col=28;
        page=6;                
        if((v[1]<v[0])||((v[1]-v[0])>cur.d.vSatLow)){
            OLEDchararray("HI ESR",arial);            
        }else{
            OLEDscanlong(((v[1]-v[0])*cur.d.rLow)/(ADC_SCALE-(v[1]-v[0])));
            OLEDlzb(7);
            OLEDchar(' ',arial);
            OLEDchar(dbuf[5],arial);
            OLEDchar(dbuf[6],arial);
            OLEDchar(dbuf[7],arial);
            OLEDchar(dbuf[8],arial);
            OLEDchar(F_OMEGA,arial);            
        }        
    }
}

void doSetCal(void){
    unsigned long t[4];
    col=0;
    page=4;                
    OLEDchararray("Leave probes open.",smallFont);
    col=0;
    page=5;                
    OLEDchararray("Press S1 to start.",smallFont);
    if(PRESSED(S1)){        
        col=0;
        page=6;                
        OLEDchararray("Running",arial);        
        while(PRESSED(S1)){}
        __delay_ms(100);        
        t[0]=(getLow()*4)/5;        //use 80%
        __delay_ms(100);        
        t[1]=(getR1()*4)/5;
        __delay_ms(100);        
        t[2]=(getR2()*4)/5;
        __delay_ms(100);        
        t[3]=(getR3()*4)/5;
        __delay_ms(300);        
        //sanity check here?
        cur.d.vSatLow=t[0];
        cur.d.vSatHi=t[1];
        if(t[2]<cur.d.vSatHi){cur.d.vSatHi=t[2];}
        if(t[3]<cur.d.vSatHi){cur.d.vSatHi=t[3];}
        col=0;
        page=6;                
        OLEDchararray("          ",arial);        
        col=0;
        page=4;                
        OLEDchararray("Short probes.     ",smallFont);
        col=0;
        page=5;                
        OLEDchararray("Press S1 for next.",smallFont);
        while(RELEASED(S1)){if(PRESSED(S2)){return;}}    //cancel on S2
        col=0;
        page=6;                
        OLEDchararray("Running",arial);        
        while(PRESSED(S1)){}
        __delay_ms(100);   
        t[0]=getR3();
        __delay_ms(300);        
        t[1]=(t[0]*cur.d.r3)/vcc;        
        col=0;
        page=6;                
        if(t[1]>R_LEAD_HI){
            OLEDchararray("Too hi!",arial);                    
        }else{
            cur.d.rProbe=t[1]*10;
            OLEDchararray("Done   ",arial);        
        }
    }
    s1Flag=0;
    s2Flag=0;
}

void doSetBandgap(void){
    if(s1Flag){
        s1Flag=0;
        cur.d.vBandgap=cur.d.vBandgap+1;
    }    
    if(s1Hold>HOLD_DELAY){
        s1Hold=s1Hold-HOLD_REPEAT;
        cur.d.vBandgap=cur.d.vBandgap+1;
    }
    if(s2Hold>HOLD_DELAY){
        s2Hold=s2Hold-HOLD_REPEAT;
        cur.d.vBandgap=cur.d.vBandgap-1;
    }
    if(s2Flag){
        s2Flag=0;
        cur.d.vBandgap=cur.d.vBandgap-1;
    }    
    if(cur.d.vBandgap<BANDGAP_MIN){cur.d.vBandgap=BANDGAP_MIN;}
    if(cur.d.vBandgap>BANDGAP_MAX){cur.d.vBandgap=BANDGAP_MAX;}
    col=0;
    page=4;                
    OLEDchararray("Trim: ",arial);
    OLEDscanlong(cur.d.vBandgap);
    OLEDlzb(8);                     //no decimals
    OLEDchararray(&dbuf[6],arial);  //last 4 digits only
    page=6;                
    col=28;
    OLEDscanlong(vcc);
    OLEDchar(dbuf[6],arial);
    OLEDchar('.',arial);
    OLEDchar(dbuf[7],arial);
    OLEDchar(dbuf[8],arial);
    OLEDchar(dbuf[9],arial);
    OLEDchar('V',arial);    
}

void doSetHand(void){
    col=0;
    page=4;                
    OLEDchararray("S1 toggle",arial);
    col=0;
    page=6;                
    if(cur.d.hand==TEXT_RH){
        OLEDchararray("Right hand",arial);        
    }else{
        OLEDchararray("Left hand ",arial);                
    }
    if(s1Flag){
        s1Flag=0;
        if(cur.d.hand==TEXT_RH){
            cur.d.hand=TEXT_LH;
        }else{
            cur.d.hand=TEXT_RH;
        }
        OLEDflip(cur.d.hand);   //update
        OLEDclear();
    }    
}

void doSetBright(void){
    col=0;
    page=4;                
    OLEDchararray("S1+/S2-",arial);
    if(s1Flag){
        s1Flag=0;
        cur.d.oledBright=cur.d.oledBright+5;
    }    
    if(s1Hold>HOLD_DELAY){
        s1Hold=s1Hold-HOLD_REPEAT;
        cur.d.oledBright=cur.d.oledBright+5;
    }
    if(s2Flag){
        s2Flag=0;
        cur.d.oledBright=cur.d.oledBright-5;
    }    
    if(s2Hold>HOLD_DELAY){
        s2Hold=s2Hold-HOLD_REPEAT;
        cur.d.oledBright=cur.d.oledBright-5;
    }
    if(cur.d.oledBright<OLED_B_MIN){cur.d.oledBright=OLED_B_MIN;}
    if(cur.d.oledBright>OLED_B_MAX){cur.d.oledBright=OLED_B_MAX;}
    OLEDbrightness(cur.d.oledBright);    
    col=80;
    page=6;                
    OLEDscanlong(cur.d.oledBright);
    OLEDlzb(8);                     //no decimals
    OLEDchararray(&dbuf[7],arial);  //last 3 digits only
}

void doSetTimeOut(){
    col=0;
    page=4;                
    OLEDchararray("S1+/S2-",arial);
    if(s1Flag){
        s1Flag=0;
        cur.d.dispTimeOut=cur.d.dispTimeOut+5;
    }    
    if(s1Hold>HOLD_DELAY){
        s1Hold=s1Hold-HOLD_REPEAT;
        cur.d.dispTimeOut=cur.d.dispTimeOut+5;
    }
    if(s2Flag){
        s2Flag=0;
        cur.d.dispTimeOut=cur.d.dispTimeOut-5;
    }    
    if(s2Hold>HOLD_DELAY){
        s2Hold=s2Hold-HOLD_REPEAT;
        cur.d.dispTimeOut=cur.d.dispTimeOut-5;
    }
    if(cur.d.dispTimeOut<0){cur.d.dispTimeOut=0;}
    if(cur.d.dispTimeOut>TIMEOUT_MAX){cur.d.dispTimeOut=TIMEOUT_MAX;}    
    col=80;
    page=6;                
    OLEDscanlong(cur.d.dispTimeOut);
    OLEDlzb(8);                     //no decimals
    OLEDchararray(&dbuf[7],arial);  //last 3 digits only    
}

void doSetR(void){
    long* t;
    long i=1;
    long v,r;
    col=0;
    page=4;                
    OLEDchararray("S1+/S2- ",smallFont);
    switch(settingMode){
        case SET_RLOW:
            t=&cur.d.rLow;
            OLEDchararray("Try 1000" C_OMEGA ,smallFont);
            v=getLow();
            col=0;
            page=5;                
            if(v>cur.d.vSatLow){      //high reading
                OLEDchararray("  OPEN   ",smallFont);
            }else{                    //normal reading
                r=(v*cur.d.rLow)/(ADC_SCALE-v);
                OLEDscanlong(r);
                OLEDlzb(7);
                OLEDchar(' ',smallFont);
                OLEDchar(dbuf[5],smallFont);
                OLEDchar(dbuf[6],smallFont);
                OLEDchar(dbuf[7],smallFont);
                OLEDchar(dbuf[8],smallFont);
                OLEDchar('.',smallFont);
                OLEDchar(dbuf[9],smallFont);
                OLEDchar(F_OMEGA,smallFont);            
            }                    
            break;
        case SET_R1:   
            t=&cur.d.r1;
            OLEDchararray("Try 1000" C_OMEGA ,smallFont);
            v=getR1();
            col=0;
            page=5;   
            if(v>cur.d.vSatHi){     //hi reading
                OLEDchararray("  OPEN   ",smallFont);
            }else{                  //normal reading
                r=(v*cur.d.r1)/vcc;
                OLEDscanlong(r-cur.d.rProbe/10);
                OLEDlzb(6);
                OLEDchar(' ',smallFont);
                OLEDchar(dbuf[4],smallFont);
                OLEDchar(dbuf[5],smallFont);
                OLEDchar(dbuf[6],smallFont);
                OLEDchar(dbuf[7],smallFont);
                OLEDchar('.',smallFont);
                OLEDchar(dbuf[8],smallFont);                
                OLEDchar(F_OMEGA,smallFont);   
            }
            break;
        case SET_R2:   
            t=&cur.d.r2;
            OLEDchararray(" Try 100" C_OMEGA ,smallFont);
            v=getR2();
            col=0;
            page=5;   
            if(v>cur.d.vSatHi){     //hi reading
                OLEDchararray("  OPEN   ",smallFont);
            }else{                  //normal reading
                r=(v*cur.d.r2)/vcc;
                OLEDscanlong(r-cur.d.rProbe/10);
                OLEDlzb(6);
                OLEDchar(' ',smallFont);
                OLEDchar(dbuf[4],smallFont);
                OLEDchar(dbuf[5],smallFont);
                OLEDchar(dbuf[6],smallFont);
                OLEDchar(dbuf[7],smallFont);
                OLEDchar('.',smallFont);
                OLEDchar(dbuf[8],smallFont);                
                OLEDchar(dbuf[9],smallFont);                
                OLEDchar(F_OMEGA,smallFont);   
            }
            break;
        case SET_R3:   
            t=&cur.d.r3;
            OLEDchararray("  Try 10" C_OMEGA ,smallFont);
            v=getR3();
            col=0;
            page=5;   
            if(v>cur.d.vSatHi){     //hi reading
                OLEDchararray("  OPEN   ",smallFont);
            }else{                  //normal reading
                r=(v*cur.d.r3)/vcc;
                OLEDscanlong(r-cur.d.rProbe/10);
                OLEDlzb(6);
                OLEDchar(' ',smallFont);
                OLEDchar(dbuf[4],smallFont);
                OLEDchar(dbuf[5],smallFont);
                OLEDchar(dbuf[6],smallFont);
                OLEDchar(dbuf[7],smallFont);
                OLEDchar('.',smallFont);
                OLEDchar(dbuf[8],smallFont);                
                OLEDchar(dbuf[9],smallFont);                
                OLEDchar(F_OMEGA,smallFont);   
            }
            break;
    }
    if((*t)>9999){i=10;}
    if((*t)>99999){i=100;}
    if(s1Flag){
        s1Flag=0;
        *t=*t+i;
    }    
    if(s1Hold>HOLD_DELAY){
        s1Hold=s1Hold-HOLD_REPEAT;
        *t=*t+i;
    }
    if(s2Hold>HOLD_DELAY){
        s2Hold=s2Hold-HOLD_REPEAT;
        *t=*t-i;
    }
    if(s2Flag){
        s2Flag=0;
        *t=*t-i;
    }    
    if(*t<0){*t=0;}
    if(*t>RMAX){*t=RMAX;}
    OLEDscanlong(*t);
    OLEDlzb(7);
    col=0;
    page=6;                
    OLEDchar(dbuf[3],arial);
    OLEDchar(dbuf[4],arial);
    OLEDchar(dbuf[5],arial);
    if(dbuf[5]>' '){OLEDchar(',',arial);}else{OLEDchar(' ',arial);}
    OLEDchar(dbuf[6],arial);
    OLEDchar(dbuf[7],arial);
    OLEDchar(dbuf[8],arial);
    OLEDchar('.',arial);
    OLEDchar(dbuf[9],arial);
    OLEDchar(F_OMEGA,arial);
}

void doSetC(void){
    int* t;
    static long v[5];
    t=&cur.d.cFactor;
    if(ctr>2){  //match rate of sampling
        ctr=0;        
        getC(&v[0]); 
    }    
    col=0;
    page=4;   
    OLEDchararray("S1+/S2-   Try 10" C_MU "F",smallFont);
    col=0;
    page=5;   
    if((v[1]>cur.d.vSatLow)||(v[4]>cur.d.vSatLow)){
        OLEDchararray(" LOW CAP",smallFont);            
    }else if((v[4]-v[1])>(C4_TIME*cur.d.cFactor/C_UPPER_LIMIT)){
        OLEDscanlong((C4_TIME*cur.d.cFactor)/(v[4]-v[1]));
        OLEDlzb(5);
        OLEDchar(dbuf[4],smallFont);
        OLEDchar(dbuf[5],smallFont);
        OLEDchar(dbuf[6],smallFont);
        OLEDchar('.',smallFont);
        OLEDchar(dbuf[7],smallFont);
        OLEDchar(dbuf[8],smallFont);
        OLEDchar(F_MU,smallFont);
        OLEDchar('F',smallFont);
    }else{
        OLEDchararray(" HI CAP ",smallFont);                        
    }    
    if(s1Flag){
        s1Flag=0;
        *t=*t+1;
    }    
    if(s1Hold>HOLD_DELAY){
        s1Hold=s1Hold-HOLD_REPEAT;
        *t=*t+1;
    }
    if(s2Hold>HOLD_DELAY){
        s2Hold=s2Hold-HOLD_REPEAT;
        *t=*t-1;
    }
    if(s2Flag){
        s2Flag=0;
        *t=*t-1;
    }    
    if(*t<0){*t=0;}
    if(*t>CMAX){*t=CMAX;}
    OLEDscanlong(*t);
    OLEDlzb(8);
    col=0;
    page=6;                
    OLEDchar(dbuf[6],arial);
    OLEDchar(dbuf[7],arial);
    OLEDchar(dbuf[8],arial);
    OLEDchar(dbuf[9],arial);    
}

void doSetV(void){
    int* t;
    char u='V';
    col=0;
    page=4;                
    OLEDchararray("S1+/S2-",arial);
    switch(settingMode){
        case SET_VSATLO:  t=&cur.d.vSatLow;break;
        case SET_VSATHI:  t=&cur.d.vSatHi;break;
        case SET_PROBE_R: t=&cur.d.rProbe;u=F_OMEGA;break;
    }
    if(s1Flag){
        s1Flag=0;
        *t=*t+1;
    }    
    if(s1Hold>HOLD_DELAY){
        s1Hold=s1Hold-HOLD_REPEAT;
        *t=*t+1;
    }
    if(s2Hold>HOLD_DELAY){
        s2Hold=s2Hold-HOLD_REPEAT;
        *t=*t-1;
    }
    if(s2Flag){
        s2Flag=0;
        *t=*t-1;
    }    
    if(*t<0){*t=0;}
    if(*t>VMAX){*t=VMAX;}
    OLEDscanlong(*t);
    OLEDlzb(8);
    col=0;
    page=6;                
    OLEDchar(dbuf[6],arial);
    OLEDchar(dbuf[7],arial);
    OLEDchar(dbuf[8],arial);
    OLEDchar(dbuf[9],arial);
    OLEDchar('m',arial);
    OLEDchar(u,arial);    
}

void doSaveRestore(void){
    col=0;
    page=4;                
    OLEDchararray("S1 to save to flash.",smallFont);
    col=0;
    page=5;                
    OLEDchararray("S2 to load defaults.",smallFont);
    col=0;
    page=6;                
    OLEDchararray(saveStateNames[saveState],arial);    
    if(saveState==SAVE_SAVING){
        flashSave((unsigned int*)&cur,FLASHADD(&sav));
        __delay_ms(500);
        saveState=SAVE_DONE;
    }
    if(s2Flag){
        s2Flag=0;  
        flashLoad((unsigned int*)&backup,(unsigned int*)&cur);   //load from backups
        saveState=SAVE_RESTORE;
    }
    if(s1Flag){
        s1Flag=0;
        saveState=SAVE_SAVING;        
    }
}

void sleepAndWakeup(void){      //go to sleep and wait for SW1/SW2/SW3 then return
    //unsigned int i;
    //shut down everything
    latbits.AMP_PWR=0;    //active high
    ANCFGbits.VBGEN3=0;         //disable bandgap
    RCONbits.RETEN=1;           //low power retention sleep
    INTCON2bits.GIE=0;          //disable interrupts                
    I2Cdeinit();    //shut down display
    PMD1=0xFFFF;
    PMD2=0xFFFF;
    PMD3=0xFFFF;
    PMD4=0xFFFF;
    PMD5=0xFFFF;
    PMD6=0xFFFF;
    PMD7=0xFFFF;
    PMD8=0xFFFF;
    setPMD();       //all peripherals disabled
    //set up to wake up on button change
    IOCFB=0;
    IOCFA=0;
    IOCSTAT=0;
    IFS1bits.IOCIF=0;
    iocpbits.S1=1;
    iocpbits.S2=1;
    iocpbits.S3=1;
    iocnbits.S1=1;
    iocnbits.S2=1;
    iocnbits.S3=1;
    PADCONbits.IOCON=1;
    IEC1bits.IOCIE=1;                
    //sleep
    Nop();Sleep();Nop();
    //for(i=0;i<30;i++) {doze();}       //for testing
    //__delay_ms(3000);                 //for testing
    //recover
    IEC1bits.IOCIE=0;
    PADCONbits.IOCON=0; //disable
    iocpbits.S1=0;
    iocpbits.S2=0;
    iocpbits.S3=0;
    iocnbits.S1=0;
    iocnbits.S2=0;
    iocnbits.S3=0;
    IOinit();           //same as boot sequence, using current OLED settings
    I2Cinit();
    OLEDinit();
    OLEDflip(cur.d.hand);
    OLEDbrightness(cur.d.oledBright);    
    initADC();
    setRefADC(ADC_VCC_REF);
    t1Init();
    //latbits.AMP_PWR=1;    //allow code to update as needed
    INTCON2bits.GIE=1;          //enable interrupts                
    while(PRESSED(S1)||PRESSED(S2)||PRESSED(S3)){}  //wait for release
    s1Flag=0;   //clear all button flags
    s2Flag=0;
    s3Flag=0;
    s1Hold=0;
    s2Hold=0;
    s3Hold=0;
    doze();
}

void doze(void){                //use doze to save power until an interrupt/button press, typically <100ms
    CLKDIVbits.DOZE=7;      //max divider
    CLKDIVbits.ROI=1;       //reset on interrupt
    CLKDIVbits.DOZEN=1;
    while(CLKDIVbits.DOZEN){ }  //interrupt should cause return
}

void skinnyDot(void){   //narrow decimal point to save some space
    OLEDsetcolumn(col);
    OLEDsetpage(page);        
    I2Cstart();
    I2Cbyte(OLED_ADDRESS);  //write
    I2Cbyte(0x40);          //write data
    I2Cbyte(0);I2Cbyte(0);
    I2Cstop();
    OLEDsetcolumn(col);
    OLEDsetpage(page+1);        
    I2Cstart();
    I2Cbyte(OLED_ADDRESS);  //write
    I2Cbyte(0x40);          //write data
    I2Cbyte(48);I2Cbyte(48);
    I2Cstop();
    col=col+2;
}