#ifndef PORTBITS_H
#define	PORTBITS_H
/*
 Generic port/IO register access for PIC24FJ256GA702 (and others?)
 see p24FJ256GA702.h for standard port definitions
 includes:
 trisbits,portbits,latbits,odcbits,ansbits
 iocpbits,iocnbits,iocfbits,iocpubits,iocpdbits
 enum analogChans_t that translates to analog channels

 Typical usage:
 #define LEDPIN a0
 ansbits.LEDPIN=0;trisbits.LEDPIN=0;latbits.LEDPIN=1;//on
 #define CHAN_1 b15
 ansbits.CHAN_1=1;AD1CHSbits.CH0SA=CHAN_1;AD1CON1bits.SAMP = 1; etc
 */

#include <xc.h> // include processor files - each processor file is guarded.  

typedef struct {
  uint16_t 
#ifdef _RA0
  a0
#endif
  :1;
  uint16_t 
#ifdef _RA1
  a1
#endif
  :1;
  uint16_t 
#ifdef _RA2
  a2
#endif
  :1;
  uint16_t 
#ifdef _RA3
  a3
#endif
  :1;
  uint16_t 
#ifdef _RA4
  a4
#endif
  :1;
  uint16_t 
#ifdef _RA5
  a5
#endif
  :1;
  uint16_t 
#ifdef _RA6
  a6
#endif
  :1;
  uint16_t 
#ifdef _RA7
  a7
#endif
  :1;
  uint16_t 
#ifdef _RA8
  a8
#endif
  :1;
  uint16_t 
#ifdef _RA9
  a9
#endif
  :1;
  uint16_t 
#ifdef _RA10
  a10
#endif
  :1;
  uint16_t 
#ifdef _RA11
  a11
#endif
  :1;
  uint16_t 
#ifdef _RA12
  a12
#endif
  :1;
  uint16_t 
#ifdef _RA13
  a13
#endif
  :1;
  uint16_t 
#ifdef _RA14
  a14
#endif
  :1;
  uint16_t 
#ifdef _RA15
  a15
#endif
  :1;

  uint16_t :16;uint16_t:16;uint16_t :16;    //18 bytes padding
  uint16_t :16;uint16_t:16;uint16_t :16;
  uint16_t :16;uint16_t:16;uint16_t :16;

  uint16_t 
#ifdef _RB0
  b0
#endif
  :1;
  uint16_t 
#ifdef _RB1
  b1
#endif
  :1;
  uint16_t 
#ifdef _RB2
  b2
#endif
  :1;
  uint16_t 
#ifdef _RB3
  b3
#endif
  :1;
  uint16_t 
#ifdef _RB4
  b4
#endif
  :1;
  uint16_t 
#ifdef _RB5
  b5
#endif
  :1;
  uint16_t 
#ifdef _RB6
  b6
#endif
  :1;
  uint16_t 
#ifdef _RB7
  b7
#endif
  :1;
  uint16_t 
#ifdef _RB8
  b8
#endif
  :1;
  uint16_t 
#ifdef _RB9
  b9
#endif
  :1;
  uint16_t 
#ifdef _RB10
  b10
#endif
  :1;
  uint16_t 
#ifdef _RB11
  b11
#endif
  :1;
  uint16_t 
#ifdef _RB12
  b12
#endif
  :1;
  uint16_t 
#ifdef _RB13
  b13
#endif
  :1;
  uint16_t 
#ifdef _RB14
  b14
#endif
  :1;
  uint16_t 
#ifdef _RB15
  b15
#endif
  :1;

  uint16_t :16;uint16_t:16;uint16_t :16;    //18 bytes padding
  uint16_t :16;uint16_t:16;uint16_t :16;
  uint16_t :16;uint16_t:16;uint16_t :16;

  uint16_t 
#ifdef _RC0
  c0
#endif
  :1;
  uint16_t 
#ifdef _RC1
  c1
#endif
  :1;
  uint16_t 
#ifdef _RC2
  c2
#endif
  :1;
  uint16_t 
#ifdef _RC3
  c3
#endif
  :1;
  uint16_t 
#ifdef _RC4
  c4
#endif
  :1;
  uint16_t 
#ifdef _RC5
  c5
#endif
  :1;
  uint16_t 
#ifdef _RC6
  c6
#endif
  :1;
  uint16_t 
#ifdef _RC7
  c7
#endif
  :1;
  uint16_t 
#ifdef _RC8
  c8
#endif
  :1;
  uint16_t 
#ifdef _RC9
  c9
#endif
  :1;
  uint16_t 
#ifdef _RC10
  c10
#endif
  :1;
  uint16_t 
#ifdef _RC11
  c11
#endif
  :1;
  uint16_t 
#ifdef _RC12
  c12
#endif
  :1;
  uint16_t 
#ifdef _RC13
  c13
#endif
  :1;
  uint16_t 
#ifdef _RC14
  c14
#endif
  :1;
  uint16_t 
#ifdef _RC15
  c15
#endif
  :1;
} portbits_t;

extern volatile portbits_t __attribute__((sfr(0x0662)))trisbits;
extern volatile portbits_t __attribute__((sfr(0x0664)))portbits;
extern volatile portbits_t __attribute__((sfr(0x0666)))latbits;
extern volatile portbits_t __attribute__((sfr(0x0668)))odcbits;
//note that ANS doesn't exist on the same bits, see below
extern volatile portbits_t __attribute__((sfr(0x066C)))iocpbits;
extern volatile portbits_t __attribute__((sfr(0x066E)))iocnbits;
extern volatile portbits_t __attribute__((sfr(0x0670)))iocfbits;
extern volatile portbits_t __attribute__((sfr(0x0672)))iocpubits;
extern volatile portbits_t __attribute__((sfr(0x0674)))iocpdbits;

typedef struct {
  uint16_t 
#ifdef _ANSELA0
  a0
#endif
  :1;
  uint16_t 
#ifdef _ANSELA1
  a1
#endif
  :1;
  uint16_t 
#ifdef _ANSELA2
  a2
#endif
  :1;
  uint16_t 
#ifdef _ANSELA3
  a3
#endif
  :1;
  uint16_t 
#ifdef _ANSELA4
  a4
#endif
  :1;
  uint16_t 
#ifdef _ANSELA5
  a5
#endif
  :1;
  uint16_t 
#ifdef _ANSELA6
  a6
#endif
  :1;
  uint16_t 
#ifdef _ANSELA7
  a7
#endif
  :1;
  uint16_t 
#ifdef _ANSELA8
  a8
#endif
  :1;
  uint16_t 
#ifdef _ANSELA9
  a9
#endif
  :1;
  uint16_t 
#ifdef _ANSELA10
  a10
#endif
  :1;
  uint16_t 
#ifdef _ANSELA11
  a11
#endif
  :1;
  uint16_t 
#ifdef _ANSELA12
  a12
#endif
  :1;
  uint16_t 
#ifdef _ANSELA13
  a13
#endif
  :1;
  uint16_t 
#ifdef _ANSELA14
  a14
#endif
  :1;
  uint16_t 
#ifdef _ANSELA15
  a15
#endif
  :1;

  uint16_t :16;uint16_t:16;uint16_t :16;    //18 bytes padding
  uint16_t :16;uint16_t:16;uint16_t :16;
  uint16_t :16;uint16_t:16;uint16_t :16;

  uint16_t 
#ifdef _ANSELB0
  b0
#endif
  :1;
  uint16_t 
#ifdef _ANSELB1
  b1
#endif
  :1;
  uint16_t 
#ifdef _ANSELB2
  b2
#endif
  :1;
  uint16_t 
#ifdef _ANSELB3
  b3
#endif
  :1;
  uint16_t 
#ifdef _ANSELB4
  b4
#endif
  :1;
  uint16_t 
#ifdef _ANSELB5
  b5
#endif
  :1;
  uint16_t 
#ifdef _ANSELB6
  b6
#endif
  :1;
  uint16_t 
#ifdef _ANSELB7
  b7
#endif
  :1;
  uint16_t 
#ifdef _ANSELB8
  b8
#endif
  :1;
  uint16_t 
#ifdef _ANSELB9
  b9
#endif
  :1;
  uint16_t 
#ifdef _ANSELB10
  b10
#endif
  :1;
  uint16_t 
#ifdef _ANSELB11
  b11
#endif
  :1;
  uint16_t 
#ifdef _ANSELB12
  b12
#endif
  :1;
  uint16_t 
#ifdef _ANSELB13
  b13
#endif
  :1;
  uint16_t 
#ifdef _ANSELB14
  b14
#endif
  :1;
  uint16_t 
#ifdef _ANSELB15
  b15
#endif
  :1;

  uint16_t :16;uint16_t:16;uint16_t :16;    //18 bytes padding
  uint16_t :16;uint16_t:16;uint16_t :16;
  uint16_t :16;uint16_t:16;uint16_t :16;

  uint16_t 
#ifdef _ANSELC0
  c0
#endif
  :1;
  uint16_t 
#ifdef _ANSELC1
  c1
#endif
  :1;
  uint16_t 
#ifdef _ANSELC2
  c2
#endif
  :1;
  uint16_t 
#ifdef _ANSELC3
  c3
#endif
  :1;
  uint16_t 
#ifdef _ANSELC4
  c4
#endif
  :1;
  uint16_t 
#ifdef _ANSELC5
  c5
#endif
  :1;
  uint16_t 
#ifdef _ANSELC6
  c6
#endif
  :1;
  uint16_t 
#ifdef _ANSELC7
  c7
#endif
  :1;
  uint16_t 
#ifdef _ANSELC8
  c8
#endif
  :1;
  uint16_t 
#ifdef _ANSELC9
  c9
#endif
  :1;
  uint16_t 
#ifdef _ANSELC10
  c10
#endif
  :1;
  uint16_t 
#ifdef _ANSELC11
  c11
#endif
  :1;
  uint16_t 
#ifdef _ANSELC12
  c12
#endif
  :1;
  uint16_t 
#ifdef _ANSELC13
  c13
#endif
  :1;
  uint16_t 
#ifdef _ANSELC14
  c14
#endif
  :1;
  uint16_t 
#ifdef _ANSELC15
  c15
#endif
  :1;
} ansbits_t;

extern volatile ansbits_t __attribute__((sfr(0x066A)))ansbits;

#ifdef __PIC24FJ256GA702__
//analog channels are in no specific order and vary by chip
typedef enum {
    a0=0,
    a1,
    b0,
    b1,
    b2,
    b3,
    b14,
    b13,
    b12,
    b15    
} analogChans_t ; 

//RPIN mapping differs to ADC mapping, so can only have one or the other
/*
typedef enum {
    b0=0,
    b1,
    b2,
    b3,
    b4,
    b5,
    b6,
    b7,
    b8,
    b9,
    b10,
    b11,
    b12,
    b13,
    b14,
    b15,
    a0=26,
    a1               
} rpinrbits_t;
*/

//'702 has different PPS pins available
typedef struct {
  uint16_t b0:6;uint16_t :2;    //RPOR0, RP0
  uint16_t b1:6;uint16_t :2;    //RPOR0
  uint16_t b2:6;uint16_t :2;
  uint16_t b3:6;uint16_t :2;
  uint16_t b4:6;uint16_t :2;
  uint16_t b5:6;uint16_t :2;
  uint16_t b6:6;uint16_t :2;
  uint16_t b7:6;uint16_t :2;
  uint16_t b8:6;uint16_t :2;
  uint16_t b9:6;uint16_t :2;
  uint16_t b10:6;uint16_t :2;
  uint16_t b11:6;uint16_t :2;
  uint16_t b12:6;uint16_t :2;
  uint16_t b13:6;uint16_t :2;
  uint16_t b14:6;uint16_t :2;   //RPOR7
  uint16_t b15:6;uint16_t :2;   //RPOR7, RP15
  uint16_t :16;     //no 16,17
  uint16_t :16;     //no 18,19
  uint16_t :16;     //no 20,21
  uint16_t :16;     //no 22,23
  uint16_t :16;     //no 24,25
  uint16_t a0:6;uint16_t :2;   //RPOR13, RP26
  uint16_t a1:6;uint16_t :2;   //RPOR13, RP27
} rporbits_t;

extern volatile rporbits_t __attribute__((sfr(0x07D4)))rporbits;

#endif /*__PIC24FJ256GA702__*/

#endif	/* PORTBITS_H */
