//Tim Blythman
#ifndef IO_H
#define	IO_H

//RB6  S1
//RB7  S2
//RB8  S3
//RB14 AMP_PWR
//RB12 AMP_OUT (HI ANALOG)
//RB13 LOW ANALOG
//RB11 LOW PULSE OUT (Active high)
//RB10 MED PUSLE OUT (Active high)
//RB9  HI PULSE OUT (Active low)

#include <xc.h> // include processor files - each processor file is guarded.  
#include <libpic30.h>   
#include "portbits.h"
#include "defaults.h"
#include "util.h"

#define VBG_REF (28)
#define ADC_GND (29)
#define ADC_VCC_REF (0)
#define ADC_VREF_REF (1)
#define ADC_OS (16)

#define AMP_PWR b14
#define ANALOG_HI b12
#define ANALOG_LO b13
#define LOW_PULSE b11
#define MED_PULSE b10
#define HI_PULSE b9

#define S1 b6
#define S2 b7
#define S3 b8
#define PRESSED(x) ((portbits.x)==0)
#define RELEASED(x) ((portbits.x)!=0)

#define UNUSED_1 a0
#define UNUSED_2 a1
#define UNUSED_3 a2
#define UNUSED_4 a3
#define UNUSED_5 b2
#define UNUSED_6 b3

#define HOLD_DELAY 4
#define HOLD_REPEAT 2

//extern unsigned int bgVoltage;
extern unsigned int vcc;
extern unsigned int ctr;
extern char s1Flag,s2Flag,s3Flag;
extern unsigned int s1Hold;
extern unsigned int s2Hold;
extern unsigned int s3Hold;
extern unsigned int tmOut;
extern char tmHold;

#define TIMER_HERTZ (10)
#define HOLD_COUNT TIMER_HERTZ

#define ADC_SCALE (4096UL)

void setPMD(void);  //disable all, require to be explicitly enabled
void setTmOut(void);    //for uniformity
void t1Init(void);
void IOinit(void);
void initADC(void);
void setRefADC(char c); //0=use VCC, 1=use VREF pin
void initCVR(void);
void setCVRDAC(unsigned char n);    //0-31
int getADC(int c);
void startADC(int c);   //split getADC to allow action while waiting for conversion ie startADC(c);res=endADC(); <=> res=getADC();
int endADC(void);      //split getADC to allow action while waiting for conversion
unsigned int getVCC(void); //in mV

#endif	/* IO_H */
