#include "config.h"
#include <xc.h>
#include "oled.h"
#include "io.h"
#include "util.h"
#include "flash.h"
#include "defaults.h"

//RB6  S1
//RB7  S2
//RB8  S3
//RB4  OLEDPWR
//RB5  SDA
//RA4  SCL
//RB14 AMP_PWR
//RB12 AMP_OUT (HI ANALOG)
//RB13 LOW ANALOG
//RB11 LOW PULSE OUT (Active high)
//RB10 MED PUSLE OUT (Active high)
//RB9  HI PULSE OUT (Active low)

//FCY set in Properties

int main(void) {
    INTCON2bits.GIE=0;
    CLKDIVbits.CPDIV=2;        //8MHz
    setPMD();
    IOinit();
    I2Cinit();
    OLEDinit();
    OLEDflip(TEXT_RH);
    initADC();
    setRefADC(ADC_VCC_REF);
    t1Init();
    if(PRESSED(S3)){    //skip flash load if button held on boot
        OLEDclear();
        col=16;
        page=3;                
        OLEDchararray("NO FLASH",arial);                                            
        while(PRESSED(S3)){}
        __delay_ms(100);
        OLEDclear();
    }else{
        loadCalValues();
    }        
    setTmOut();     
    INTCON2bits.GIE=1;      //ready for interrupts
    latbits.AMP_PWR=1;    //active high
    while(1){
        vcc=getVCC();        
        if(inSettings){
            latbits.AMP_PWR=1;    //active high
            if(s3Flag){
                s3Flag=0;
                settingMode=settingMode+1;
                if(settingMode>=SET_DUMMY){settingMode=0;}
                OLEDclear();
                s1Flag=0;   //clear all button flags
                s2Flag=0;
                s3Flag=0;
                s1Hold=0;
                s2Hold=0;
                saveState=0;
            }            
            col=0;
            page=0;                
            OLEDchararray("SETTINGS",arial);                                            
            col=0;
            page=2;                
            OLEDchararray(settingModeNames[settingMode],arial);                                            
            switch(settingMode){
                case SET_CAL:       doSetCal();     break;
                case SET_BANDGAP:   doSetBandgap(); break;
                case SET_HAND:      doSetHand();    break;
                case SET_BRIGHT:    doSetBright();  break;
                case SET_TIMEOUT:   doSetTimeOut(); break;
                case SET_RLOW:
                case SET_R1:
                case SET_R2:
                case SET_R3:
                    doSetR(); break;
                case SET_VSATLO:
                case SET_VSATHI:
                case SET_PROBE_R:
                    doSetV(); break;
                case SET_CFACTOR:       doSetC(); break;
                case SET_SAVERESTORE:   doSaveRestore(); break;
                case SET_DUMMY: break;                
            }
            if(s3Hold>HOLD_COUNT){
                OLEDclear();
                while(PRESSED(S3)){}    //wait for release
                inSettings=0;
                settingMode=0;      //start of settings
                s3Hold=0;   
                setTmOut();     //reset sleep timer              
            }
            doze();         //wait for timer            
        }else{
            if(s1Flag){s1Flag=0;setTmOut();tmHold=1;}     //reset sleep timer, start hold
            if(s2Flag){s2Flag=0;setTmOut();tmHold=0;}     //reset sleep timer, end hold
            if(s3Flag){setTmOut();tmHold=0;}     //reset sleep timer            
            if(s1Hold){setTmOut();}     //reset sleep timer            
            if(s2Hold){setTmOut();}     //reset sleep timer            
            if(s3Hold){setTmOut();}     //reset sleep timer                        
            if(s3Flag){
                s3Flag=0;
                mode=mode+1;
                if(mode>=DUMMY){mode=0;}
                udFlag=2;
            }            
            col=0;
            page=0;   
            if(udFlag>1){
                OLEDclear();
                udFlag=1;
            }
            OLEDchararray(modeNames[mode],arial);
            OLEDscanlong(vcc);
            OLEDchar(dbuf[6],arial);
            skinnyDot();
            OLEDchar(dbuf[7],arial);
            OLEDchar('V',arial);
            col=92;
            if(tmHold){
                OLEDchararray("---",arial);  
                setTmOut();     //reset sleep timer
            }else{
                OLEDscanlong(tmOut/TIMER_HERTZ);
                OLEDlzb(8);                     //no decimals
                OLEDchararray(&dbuf[7],arial);
            }            
            switch(mode){
                case ESR: doESR();break;
                case RES: doRES();break;
                case CAP: doCAP();break;
                case DUMMY: break;
            }
            if(s3Hold>HOLD_COUNT){
                OLEDclear();
                while(PRESSED(S3)){}    //wait for release
                inSettings=1;
                s3Hold=0;
            }
            if(tmOut==0){           //sleep, during normal operation only (not settings)
                sleepAndWakeup();
                setTmOut();     //reset sleep timer
            }
            doze();         //wait for timer            
        }
    }
    return 0;           //shouldn't get here, resets
}
