#include "io.h"
#include "util.h"

//unsigned int bgVoltage=BGVOLTAGE;
unsigned int vcc=3000;  //start with useful value
unsigned int ctr=0;
char s1Flag=0;
char s2Flag=0;
char s3Flag=0;
char s1Old=0;
char s2Old=0;
char s3Old=0;
unsigned int s1Hold=0;
unsigned int s2Hold=0;
unsigned int s3Hold=0;
unsigned int tmOut;
char tmHold=0;

void setTmOut(void){    //for uniformity
    tmOut=cur.d.dispTimeOut*TIMER_HERTZ+(TIMER_HERTZ-1);    //this gives a nicer count
}

void t1Init(void){
    PMD1bits.T1MD=0;    //re-enable peripherals
    //TIMER1
    T1CON=0;    //reset;TCS=FOSC/2, no sync, PS=1:1
    //LPRC:
    T1CONbits.TCS=1;        //not FOSC
    T1CONbits.TECS=2;       //LPRC=31kHz nominal
    PR1=31000/TIMER_HERTZ;  //
    IPC0bits.T1IP=4;        //4 is default interrupt priority
    IFS0bits.T1IF=0;
    IEC0bits.T1IE=1;
    T1CONbits.TON=1;        //running    
}

void setPMD(void){  //disable all, require to be explicitly enabled
    PMD1=0xFFFF;    
    PMD2=0xFFFF;
    PMD3=0xFFFF;
    PMD4=0xFFFF;
    PMD5=0xFFFF;
    PMD6=0xFFFF;
    PMD7=0xFFFF;
    PMD8=0xFFFF;    
}

void IOinit(void){
    //unused pins
    ansbits.UNUSED_1=0;   //comment as needed
    latbits.UNUSED_1=0;   //low output to reduce digital input leakage
    trisbits.UNUSED_1=0;
    ansbits.UNUSED_2=0;   //comment as needed
    latbits.UNUSED_2=0;   //low output to reduce digital input leakage
    trisbits.UNUSED_2=0;
    ansbits.UNUSED_3=0;   //comment as needed
    latbits.UNUSED_3=0;   //low output to reduce digital input leakage
    trisbits.UNUSED_3=0;
    ansbits.UNUSED_4=0;   //comment as needed
    latbits.UNUSED_4=0;   //low output to reduce digital input leakage
    trisbits.UNUSED_4=0;
    ansbits.UNUSED_5=0;   //comment as needed
    latbits.UNUSED_5=0;   //low output to reduce digital input leakage
    trisbits.UNUSED_5=0;
    ansbits.UNUSED_6=0;   //comment as needed
    latbits.UNUSED_6=0;   //low output to reduce digital input leakage
    trisbits.UNUSED_6=0;
    //buttons
    //ansbits.S1=0;   //comment as needed
    //ansbits.S2=0;   //comment as needed
    //ansbits.S3=0;   //comment as needed
    trisbits.S1=1;
    trisbits.S2=1;
    trisbits.S3=1;
    iocpubits.S1=1;
    iocpubits.S2=1;
    iocpubits.S3=1;
    //pulse output
    //ansbits.LOW_PULSE=0;   //comment as needed
    //ansbits.MED_PULSE=0;   //comment as needed
    ansbits.HI_PULSE=0;   //comment as needed
    latbits.LOW_PULSE=0;    //active high
    latbits.MED_PULSE=0;    //active high
    latbits.HI_PULSE=1;     //active low
    trisbits.LOW_PULSE=0;
    trisbits.MED_PULSE=0;
    trisbits.HI_PULSE=0;    //discharge
    //amp control
    ansbits.AMP_PWR=0;   //comment as needed
    latbits.AMP_PWR=0;    //active high
    trisbits.AMP_PWR=0;     //output
    //analog inputs
    ansbits.ANALOG_HI=1;
    ansbits.ANALOG_LO=1;
}

void initADC(void){
    PMD1bits.AD1MD=0;       //enable peripheral
    //ADC
    AD1CON1=0;              //reset ADC, right aligned absolute, 10bit
    AD1CON2=0;              //VDD/VSS, use CHA only
    AD1CON3=0;              //
    AD1CON4=0;              //
    AD1CON5=0;              //
    AD1CON1bits.MODE12=1;   //12bit
    AD1CON3bits.ADRC=1;     //use ADC RC clock
    AD1CON3bits.ADCS=1;     //
    AD1CHS=0;               //negative ref=VSS
    ANCFGbits.VBGEN3=1;     //enable bandgap reference for ADC; BG is 1.2V+-5%        
    AD1CON1bits.ADON=1;     //on            
}

void setRefADC(char c){ //0=use VCC, 1=use VREF pin
    AD1CON1bits.ADON=0;     //off
    AD1CON2bits.PVCFG=c;
    AD1CON1bits.ADON=1;     //on            
}

void initCVR(void){
    CVRCON=0;           //off, 5-bit DAC, ref=supply
    CVRCONbits.CVROE=1; //output on
    CVRCONbits.CVREN=1; //on
}

void setCVRDAC(unsigned char n){
    if(n>31){n=31;}
    CVRCONbits.CVR=n;
}

int getADC(int c){
    IFS0bits.AD1IF=0;           //reset FIFO
    AD1CHSbits.CH0SA=c;
    AD1CON1bits.SAMP = 1;       //start
    __delay32(1);              //sample delay    
    AD1CON1bits.SAMP = 0;       //start conversion
    while(!AD1CON1bits.DONE){}  // conversion done
    return ADC1BUF0;
}

void startADC(int c){   //split getADC to allow action while waiting for conversion
    IFS0bits.AD1IF=0;           //reset FIFO
    AD1CHSbits.CH0SA=c;
    AD1CON1bits.SAMP = 1;       //start
    __delay32(1);              //sample delay    
    AD1CON1bits.SAMP = 0;       //start conversion    
}

int endADC(void){   //split getADC to allow action while waiting for conversion
    while(!AD1CON1bits.DONE){}  // conversion done
    return ADC1BUF0;    
}

unsigned int getVCC(void){ //in mV
    unsigned int r=0;    
    unsigned int i;
    for(i=0;i<ADC_OS;i++){
        r=r+getADC(VBG_REF);
    }
    r=r/ADC_OS;
    if(r<cur.d.vBandgap){return 4000;}   //max out, shouldn't be over 3.6 anyway!
    return (ADC_SCALE*cur.d.vBandgap)/r;
}

void _ISR __attribute((no_auto_psv)) _T1Interrupt(void){
    IFS0bits.T1IF=0; 
    ctr++;
    if(tmOut){tmOut--;}
    char t;
    t=PRESSED(S1);
    if(t){
        if(s1Old==0){s1Flag=1;}   //pressed
        s1Hold++;
    }else{
        s1Hold=0;
    }
    s1Old=t;
    t=PRESSED(S2);
    if(t){
        if(s2Old==0){s2Flag=1;}   //pressed
        s2Hold++;
    }else{
        s2Hold=0;
    }
    s2Old=t;
    t=PRESSED(S3);
    if(t){
        if(s3Old==0){s3Flag=1;}   //pressed
        s3Hold++;
    }else{
        s3Hold=0;
    }
    s3Old=t;
}
