#ifndef DEFAULTS_H
#define	DEFAULTS_H

#include <xc.h>
#include "oled.h"
#include "flash.h"

//default data
//                     vBandgap,   hand,bright,timeout,probe R,  rLow1,      r1,     r2,    r3, vSatLow,vSatHi, cFactor  oledOffset
#define DATA_DEFAULTS {    1200,TEXT_RH,    30,     10,     60, 349000, 184700L, 16670L, 1660L,     150,  2400,     163,          0}

//check that these still work if flash used > 64k
//if these addresses change, then DSRPAG in flash.c may need to change too
#define IMG_DEFA const union flashpadded __attribute__((address(0x1000)))
#define IMG_DEFB const union flashpadded __attribute__((address(0x1000+_FLASH_PAGE*2)))

//limits for range checking, lower is 0 if not specified
#define BANDGAP_MAX (1400)
#define BANDGAP_MIN (1000)
#define OLED_B_MIN (30)
#define OLED_B_MAX (255)
#define RMAX (500000L)
#define VMAX (4095)
#define R_LEAD_HI (200)
#define CMAX (200)
#define TIMEOUT_MAX (995)

//struct for cal/setting data
struct flashdata{   //use signed values to help detect invalid (ie 0xFFFF<0)
    int vBandgap;
    char hand;    
    int oledBright;
    int dispTimeOut;
    int rProbe;    //milliOhms
    long rLow;     //these in tenths of an ohm
    long r1;        //these give results in 1/100 Ohm
    long r2;
    long r3;
    int vSatLow;   //saturation values in samples ADC
    int vSatHi;   //saturation values in mV, used for all amped ranges
    int cFactor;   //for capacitance calculation
    int oledOffset;
};

//union to ensure padding
union flashpadded{
    struct flashdata d;
    unsigned int padding[_FLASH_PAGE];  //pad to this size so that erases do not affect other objects
};

extern union flashpadded cur;
extern IMG_DEFA sav;
extern IMG_DEFB backup;
char checkCurOK(void);  //check if values are valid
void loadCalValues(void);

#endif	/* DEFAULTS_H */
