#include <SoftwareSerial.h>
#include <TinyGPS.h>
#include <string.h>
#include "LowPower.h"  //8 sec timer to use

#include <NewPing.h>
#define AVG_NUM 10    // 10 of iterations of the adc routine to average the adc readings
#define TRIGGER_PIN  11
#define ECHO_PIN     10
#define MAX_DISTANCE 2000
NewPing sonar(TRIGGER_PIN, ECHO_PIN, MAX_DISTANCE); // NewPing setup of pins and maximum distance.


#define GPSBAUD 9600
TinyGPS gps;

SoftwareSerial myGPS(8,9);  //Rx, Tx
SoftwareSerial myLoRa(5,6); // RX, TX

void getgps(TinyGPS &gps);

int aux=2;
int p0=3;
int p1=4;
int sw=7;
int gpss=12;

String dataString="";
uint8_t data2[9];
uint8_t data1[56];
uint8_t data3[9];
uint8_t data4[8];
uint8_t data5[8];
uint8_t data6[8];

float falt,flat,flon,fc,fk,fmph,fmps,fkmph,temp;
float dist,dist0;
byte month, day, hour, minute, second, hundredths;
int year,a,t,d,m,h,m1,s,sh,x,y;
int st=0;
unsigned long age;
unsigned long fix_age;
long lat1,lon1;
int i=0,j,k;
float level;


void setup(){
  
Serial.begin(115200);   
myGPS.begin(GPSBAUD);   
myLoRa.begin(GPSBAUD);    

pinMode(aux,OUTPUT);
pinMode(p0,OUTPUT);
pinMode(p1,OUTPUT);
pinMode(sw,OUTPUT);
pinMode(gpss,OUTPUT);

digitalWrite(aux,0);
digitalWrite(p0,1);
digitalWrite(p1,1);
digitalWrite(sw,0);
digitalWrite(gpss,0);

 }


void loop(){
    myGPS.listen();
    if(myGPS.available() )  {   // While there is data on the RX pin...
 
       byte c = myGPS.read();    // load the data into a variable...
      if(gps.encode(c))  {    // if there is a new valid sentence...
         getgps(gps);         // then grab the data.
     
     myGPS.end();
     myLoRa_recd();     
     myLoRa_send(); 

LowPower.powerDown(SLEEP_8S, ADC_OFF, BOD_OFF); 
LowPower.powerDown(SLEEP_8S, ADC_OFF, BOD_OFF);  
    }
    }
}

// The getgps function will get and print the values we want.
   void getgps(TinyGPS &gps)   {
   gps.f_get_position(&flat, &flon, &age);
   gps.get_position(&lat1, &lon1, &fix_age);
   falt = gps.f_altitude(); // +/- altitude in meters
   fc = gps.f_course(); // course in degrees
   fk = gps.f_speed_knots(); // speed in knots
   fmph = gps.f_speed_mph(); // speed in miles/hr
   fmps = gps.f_speed_mps(); // speed in m/sec
   fkmph = gps.f_speed_kmph(); // speed in km/hr

       	if (fix_age == TinyGPS::GPS_INVALID_AGE)
        Serial.println("No fix ever detected!");
	else if (fix_age > 2000)
	Serial.println("Data is getting STALE!");
	else

        Serial.println(falt);
        Serial.println(flat);
        Serial.println(flon);

   gps.crack_datetime(&year,&month,&day,&hour,&minute,&second,&hundredths);
 //day date block
    hour=hour+5; 
   minute=minute+30;   // correct for your time zone
   if(minute>59) {
     minute=minute-60;
     hour=hour+1;
     }
     if (hour>23) { 
     hour=hour-24;
     day=day+1;
     if(month==1 && day>31) month = month+1;
     if(month==2 && day>28) month = month+1;
     if(month==3 && day>31) month = month+1;
     if(month==4 && day>30) month = month+1;
     if(month==5 && day>31) month = month+1;
     if(month==6 && day>30) month = month+1;
     if(month==7 && day>31) month = month+1;
     if(month==8 && day>31) month = month+1;
     if(month==9 && day>30) month = month+1;
     if(month==10 && day>31) month = month+1;
     if(month==11 && day>30) month = month+1;
     if(month==12 && day>31) { month = month+1-12; year=year+1; }
     }

    d=day;
    m=month;
    y=year-2000;
    h=hour;
    m1=minute;
    s=second;
    sh=hundredths;
 //day date block ends
}



void myLoRa_send() {
level=read_sonar();
Serial.println(level,5);
dtostrf(level, 5, 1, (char*)data6); //level
myLoRa.listen();
digitalWrite(aux,1);  
digitalWrite(p0,0); 
digitalWrite(p1,0);

dtostrf(flat, 9, 6, (char*)data3);  //latitude
dtostrf(flon, 9, 6, (char*)data2); //longitude
//dtostrf(falt, 6, 0, (char*)data5);
sprintf((char*)data1, "%9s,%9s,%02d:%02d:%02d,%5s,%5s", (char*)data3,(char*)data2,h,m1,s,(char*)data6,"Loc-1");
myLoRa.println((char*)data1);

digitalWrite(aux,0);
digitalWrite(p0,1);
digitalWrite(p1,1);

//delay(6000);  //give some delay if you want to send more data

myLoRa.end();
}


void myLoRa_recd() {
 myLoRa.listen();
digitalWrite(aux,1);  
digitalWrite(p0,0); 
digitalWrite(p1,0);
//Serial.println("Ready");
//myLoRa.println("Ready");
if(myLoRa.available() >0 ){
  char cb=myLoRa.read();
  if(cb=='B') digitalWrite(sw,1);
  if(cb=='C') digitalWrite(sw,0);
 
  Serial.print( cb );
//  delay(500);
  myLoRa.write(cb  );
//  Serial.println("Message");
}

if(Serial.available() ){
  myLoRa.write(Serial.read());
}
myLoRa.end();
}

int read_sonar(){
  
int sum = 0;
int sample ;
  for (int i=0; i<AVG_NUM; i++)   { 
    sample = sonar.ping()/US_ROUNDTRIP_CM;// Send ping, get ping time in microseconds (uS).
    delay(105);   //100 give some time to chill Arduino
 //   sonar.timer_stop();
    sum += sample;      
  }
  return(sum / AVG_NUM);
} 


