#include <Wire.h>

#define XC3715_ADD 0x70
#define XC3715_ON 0x21
#define XC3715_DISP_ON 0x81
#define XC3715_BRIGHTNESS 0xE0
#define XC3715_DATA 0x00

#define XC3715_ZERO_STRIKETHROUGH 3135
#define XC3715_ZERO_NOSTRIKE 63
#define XC3715_DEGREES 227
#define XC3715_LETTER_OFFSET 55

unsigned int XC3715_blank[4]={0,0,0,0};
unsigned int XC3715_c[]={
  XC3715_ZERO_STRIKETHROUGH,1030,2187,1165,4832,237,253,5121,255,239,247,4751,57,4623,121,241,  //0-9,A-F
  189,246,4617,30,9328,56,1334,8502,63,243,8255,8435,237,4609,62,3120,10294,11520,5376,3081,     //G-Z
  227,      //degrees
};

unsigned int XC3715_arrow[8]={14336,6208,2368,832,1792,1664,9344,12416};  //up, then going clockwise in 45degree increments

int unHex(char c){
  if((c>='0')&&(c<='9')){return c-'0';}
  if((c>='a')&&(c<='f')){return c+10-'a';}
  if((c>='A')&&(c<='F')){return c+10-'A';}
  return -1;
}

void XC3715_data(unsigned int* d){  //four x 16-bit
  byte* p=(byte*)d;
  char i;
  Wire.beginTransmission(XC3715_ADD);
  Wire.write(XC3715_DATA);
  for(i=0;i<8;i++){
    Wire.write(p[i]);
  }
  Wire.endTransmission();  
}

void XC3715_init(void){
  Wire.begin();
  Wire.beginTransmission(XC3715_ADD);   //wake up
  Wire.write(XC3715_ON);
  Wire.endTransmission();
  XC3715_data(XC3715_blank);            //clear
  Wire.beginTransmission(XC3715_ADD);   //enable display
  Wire.write(XC3715_DISP_ON);
  Wire.endTransmission();
}

void XC3715_brightness(char b){
  if(b<0){b=0;}
  if(b>15){b=15;}
  Wire.beginTransmission(XC3715_ADD);
  Wire.write(XC3715_BRIGHTNESS|b);
  Wire.endTransmission();  
}