// demo: CAN-BUS Shield, send data
#include "mcp_can.h"
#include <SPI.h>
#include <stdio.h>
#include <stdlib.h>
const int SPI_CS_PIN = 9;
const int ledHIGH    = 1;
const int ledLOW     = 0;

const int ledpin=8;
int sample;
int canid,canport,canport_cmd;

#define THISCAN 255  //add & change CAN id here for each slave

MCP_CAN CAN(SPI_CS_PIN);                                    // Set CS pin

String dataString="";
uint8_t data2[9];
uint8_t data1[56];
uint8_t data3[4];
uint8_t data8[8];
uint8_t data5[8];
uint8_t data6[8];
unsigned char data4[4];


void setup(){
    pinMode(ledpin,OUTPUT);
    Serial.begin(115200);

//for(int i=2;i<=8;i++) pinMode(i,OUTPUT);

    while (CAN_OK != CAN.begin(CAN_100KBPS)) {             // init can bus : baudrate = 500k
        Serial.println("CAN BUS Shield init fail");
        Serial.println(" Init CAN BUS Shield again");
        delay(100);
    }
    Serial.println("CAN BUS Shield init ok!");
    digitalWrite(ledpin,0);
}

unsigned char stmp[8] = {ledHIGH, 1, 2, 3, ledLOW, 5, 6, 7};
unsigned char buf[5];
unsigned char len=0;

char nbuf[5];
char id;
int sampleid=0;
int idmsg;
//String buf;

void loop(){
    unsigned char buf1[5];    

    if(CAN_MSGAVAIL == CAN.checkReceive())  {    
        CAN.readMsgBuf(&len, buf1);  
        unsigned char canId = CAN.getCanId();

        if(canId==1) {
            Serial.print("Message from Master:");
            //Serial.println(canId);

            for(int i =0; i<len; i++) {   // print the data
                // Serial.print(char( buf1[i]));
                nbuf[i]=char(buf1[i]);
            }
//              Serial.println();
        }
    
    
        idmsg=atoi(nbuf);
        canid=idmsg/100;
        canport=(idmsg%100)/10;
        canport_cmd=(idmsg%100)%10;

        Serial.print(canid);
        Serial.print("..");
        Serial.print(canport);
        Serial.print("..");
        Serial.print(canport_cmd);
        Serial.print("..");

        Serial.println(idmsg);

        if(canid==THISCAN) {
            pinMode(canport, OUTPUT);
            digitalWrite(canport,canport_cmd);
        }
    }

    //Serial.println("In loop");
    sample = analogRead(A0) - 512; // reverse if the reading becomes negative
    dtostrf(sample, 4, 0, (char*)buf);  //latitude  
    // send data:  id = 0x00, standard frame, data len = 8, stmp: data buf
    CAN.sendMsgBuf(THISCAN,0, 4, buf);  //0x70   0 to (0x70  255,0,8,stmp)
    delay(1000);                       // send data once per second
}



