
#include <EEPROM.h>
#include "writeAnything.h"
#include "HX711.h"
#include <LiquidCrystal.h>
#include "floatToString.h"

#include <string.h>

#define calibration_factor -7050.0 //This value is obtained using the SparkFun_HX711_Calibration sketch

// #define zero_factor 8421804 //This large value is obtained using the SparkFun_HX711_Calibration sketch
//made off
//#define zero_factor 8330000 - h2

#define DOUT  2
#define CLK   3

struct config_t{
    int myInteger;
    int myInteger1;
} int2IEeprom;

HX711 scale(DOUT, CLK);
LiquidCrystal lcd(4,5,6,7,8,9);
float x;
long pos = 37;
long h2,h1;
int l,m;
byte tracker=0;

void setup() {
  Serial.begin(9600);
  lcd.begin(16, 2);
  pinMode(10,INPUT);

  lcd.setCursor(0,1);
  lcd.print("Wt.(gm):");

  scale.set_scale(calibration_factor); //This value is obtained by using the SparkFun_HX711_Calibration sketch
  EEPROM_readAnything(pos,int2IEeprom);
  h2= 8330000 - int2IEeprom.myInteger;
  Serial.println(h2);
  lcd.setCursor(0,0);
  lcd.print("(Mem):");
  lcd.print(h2);

  scale.set_offset(h2); //Zero out the scale using a previously known zero_factor
  scale.tare();

}

void loop() {
//  Serial.print("Reading: ");
  x=scale.get_units(25)*16.50;
  //453.592 ;
  
  if (x<0.5 and x>-1) x=0.0; //just to stabilize around 0

  String buffer1;
  buffer1=String(x,1);
  if(x<10) {
  lcd.setCursor(8,1);
  lcd.print(buffer1);
  lcd.print("        ");
  }

  if(x>=10 and x<100) {
  lcd.setCursor(8,1);
  lcd.print(buffer1);
  }
  if(x>=100 and x<1000) {
  lcd.setCursor(8,1);
  lcd.print(buffer1);
  }
  if(x>=1000) {
  lcd.setCursor(8,1);
  lcd.print(buffer1);
  }

int val=digitalRead(10);
if(val==LOW){
  lcd.setCursor(0,0);
  lcd.print("...calibrating");
  scale.set_scale(calibration_factor); //This value is obtained by using the SparkFun_HX711_Calibration sketch
  scale.set_offset(scale.read_average(5) ); //Zero out the scale using a previously known zero_factor
  scale.tare();
  l=8330000-scale.read_average(5);
  int2IEeprom.myInteger=l;
  tracker=EEPROM_writeAnything(pos,int2IEeprom.myInteger);

  lcd.setCursor(0,0);
  lcd.print("(Cal):");
//  lcd.print("(C):");
  lcd.print(l);
  lcd.print("      ");
  
  }
  
}
