// HelloWorld sketch for testing 16x2 LCD with serial backpack
// written by Jim Rowe, 1/11/2016

#include <Wire.h>
#include <LiquidCrystal_I2C.h>
// set the LCD I2C address to 0x27
// and for two lines of 16 characters
LiquidCrystal_I2C lcd(0x27,16,2);

void setup()
{
  lcd.init();         // initialise LCD
  lcd.backlight();    // enable backlight, hopefully
}

void loop()
{
  lcd.setBacklight(HIGH);         // turn the backlight on
  lcd.setCursor(0,0);             // set cursor to start of line 1
  lcd.print("Hello, world!   ");  // print a message
  delay(1000);                    // pause for one second
  lcd.setCursor(0,1);             // go to start of second line
  lcd.print("Silicon Chip    ");  // print second line
  delay(2000);                    // pause for two seconds
  lcd.clear();                    // clear the LCD and
  lcd.setBacklight(LOW);          // turn off the backlight
  delay(3000);                    // pause for 3s before looping back
}
