'                  REMOTE POSITION DISPLAY FOR GARAGE DOORS 
'                           (gd_display_14m2.bas)
'
' This program should be down loaded to both transmit and receive microprocessors.  
' The logic level on the C.0 input will select either transmit or receive programs.
' You may change the PIN code by changing the numbers in the default PIN code line
' Transmitter operates once a second to allow other transmitters on same frequency.
' Built this project into plastic not metal boxes to allow the antennas to radiate,
 
'     
'********************************* STARTUP SEQUENCE *******************************

start_up:' ----------- setup microcontroller and select program to run
pause 10
let b5 = 2: b6 = 0: b7 = 1: b8 = 7' (default PIN code)
let dirsB = %00111110:let pinsB = %00000000
let dirsC = %00000000:let pinsC = %00000000
let b15=b5: b16=b6: b17=b7: b18=b8' (transmit code) 
readadc C.4,b9: let b10 = 0
if pinC.0 = 0 then goto xmit_prog
if pinC.0 = 1 then goto recv_prog


'********************************* TRANSMIT PROGRAM *******************************

xmit_prog:' ---------- enable pullup resisters then flash the xmit LED
pause 10
pullup %0001111000000000
high B.1: pause 300: low B.1
'goto xmit_main

xmit_main:'----------- check door limits then output status each second
pause 10
for b0 = 0 to 50
if pinC.1 = 0  then: b1 = 1:else b1 = 0: endif'  (open1)
if pinC.1 = 1  then: b2 = 1:else b2 = 0: endif'  (close1)
if pinC.3 = 0  then: b3 = 1:else b3 = 0: endif'  (open2)
if pinC.3 = 1  then: b4 = 1:else b4 = 0: endif'  (close2)
pause 12
next b0
'goto xmit_code

xmit_code:'---------- transmit 8 byte Manchester code and flash xmit LED
pause 10 
high B.5: high B.1
rfout B.2, (b1,b2,b3,b4,b15,b16,b17,b18)
low B.5: low B.1 
goto xmit_main


'********************************* RECEIVE PROGRAM ********************************

recv_prog:'----------- enable pullup resistors then flash the recv LED
pause 10
pullup %0000101000000000
high B.1: pause 300: low B.1
'goto recv_main

recv_main:'----------- receiver waits for a transmission to be picked up 
pause 10
rfin C.2, b1,b2,b3,b4,b15,b16,b17,b18
'goto recv_code

recv_code:'----------- check if the correct PIN code has been received 
pause 10 
if b15=b5 and b16=b6 and b17=b7 and b18=b8 then goto recv_show 
goto recv_main

recv_show:'----------- flash the recv LED and drive the door status LEDs
high B.1
if b1 = 1 then: high B.5: else low B.5: endif' (open1)
if b2 = 1 then: high B.4: else low B.4: endif' (close1)
if b3 = 1 then: high B.3: else low B.3: endif' (open2)
if b4 = 1 then: high B.2: else low B.2: endif' (close2)
pause 50
low B.1
if b1 = 1 or b3 = 1 then goto recv_beep
let b10 = 0
goto recv_main 

recv_beep:'---------- adds a piezo beep at a rate set by VR1 at start-up
let b10 = b10+1 
if b10 < b9 then: goto recv_main: endif
if b10 => b9 then: sound B.0,(80,80): let b10 = 0: goto recv_main: endif

    
'************************************ VARIABLES ************************************ 
   
' b0, b10 =  temporary variables 
' b1, b2, b3, b4 =  door status codes 
' b5, b6, b7, b8 =  default PIN codes
' b15, b16, b17, b18 =  transmit codes  
