#define AUDIO_PIN A0
#define OVERSAMPLE 4
#define START_LEVEL 20
#define END_LEVEL 13
#define CLAP_WAIT 1000
#define SAMPLE_INTERVAL 5
#define LED_PIN 13

unsigned long audioSample=0;
int state=0;
int event=0;
unsigned long clapStart=0;
int clapCount=0;
unsigned long tmr=0;

void XC4438_begin(void){
  pinMode(LED_PIN,OUTPUT);
  digitalWrite(LED_PIN,LOW);
}

void XC4438_sample(void){
  while(millis()<tmr){}
  audioSample=(audioSample*(OVERSAMPLE-1)+analogRead(AUDIO_PIN))/OVERSAMPLE;
  if((state==0)&&(audioSample>START_LEVEL)){
    state=1;
    if(clapCount==0){clapStart=millis();}
    clapCount=clapCount+1;
  }
  if((state==1)&&(audioSample<END_LEVEL)){
    state=0;
  }
  if(((millis()-clapStart)>CLAP_WAIT)&&(clapCount>0)){
    event=clapCount;
    clapCount=0;
  }  
  digitalWrite(LED_PIN,state);
  Serial.print("0,");
  Serial.print(audioSample);
  Serial.print(",");
  Serial.print(state*100);  
  Serial.print(",");
  Serial.print(event*100);  
  Serial.println(",1023");
  tmr=tmr+SAMPLE_INTERVAL;  
}