#define TX_PIN 2
#define CARRIER_ON HIGH
#define CARRIER_OFF LOW
#define SYNC_TIME (8000)
#define SHORT_TIME (270)
#define LONG_TIME (450)
#define CHANNEL_BIT_SHIFT (10)
#define PACKET_REPEAT (10)

#define FAN_OFF (128)
#define FAN_LOW (4)
#define FAN_MED (32)
#define FAN_HI  (64)
#define ALL_OFF (2)
#define LIGHT_TOGGLE (8)

void rfBegin(void){
  pinMode(TX_PIN,OUTPUT);
  digitalWrite(TX_PIN,CARRIER_OFF);
}

void sendSync(void){
  digitalWrite(TX_PIN,CARRIER_OFF);
  delayMicroseconds(SYNC_TIME);
}

void sendBit(bool b){
  if(b){
    digitalWrite(TX_PIN,CARRIER_OFF);
    delayMicroseconds(SHORT_TIME);
    digitalWrite(TX_PIN,CARRIER_ON);
    delayMicroseconds(LONG_TIME);
  }else{
    digitalWrite(TX_PIN,CARRIER_OFF);
    delayMicroseconds(LONG_TIME);
    digitalWrite(TX_PIN,CARRIER_ON);
    delayMicroseconds(SHORT_TIME);
  }
}

void sendPacket(unsigned int d){  //lsb first
  unsigned int i;
  unsigned int m=2;
  sendSync();
  for(i=1;i<=13;i++){
    sendBit(d&m);
    m=m<<1;
  }
  digitalWrite(TX_PIN,CARRIER_OFF);
  //Serial.println(d,HEX);
}

void sendCommand(unsigned int c, unsigned int d){
  char i;
  for(i=0;i<PACKET_REPEAT;i++){
    sendPacket((c<<CHANNEL_BIT_SHIFT)|d);
  }
}
