#define PP_TX_PIN 2
#define PP_CARRIER_ON HIGH
#define PP_CARRIER_OFF LOW
#define PP_SYNC_TIME (8000)
#define PP_SHORT_TIME (270)
#define PP_LONG_TIME (450)
#define PP_PACKET_REPEAT (20)

#define PP_1_ON  0xF
#define PP_1_OFF 0xE
#define PP_2_ON  0xD
#define PP_2_OFF 0xC
#define PP_3_ON  0xB
#define PP_3_OFF 0xA
#define PP_4_ON  0x7
#define PP_4_OFF 0x6

#define PP_ADDRESS (0x12340)

byte reverse(byte d){ //reverse bit order in byte
  return ((d & 0x80) >> 7) | ((d & 0x40) >> 5) | ((d & 0x20) >> 3) | ((d & 0x10) >> 1) | ((d & 0x08) << 1) | ((d & 0x04) << 3) | ((d & 0x02) << 5) | ((d & 0x01) << 7);
}

byte ppCRC(unsigned long d){ //calculate crc
  byte a, b, c;
  a = reverse(d >> 16);
  b = reverse(d >> 8);
  c = reverse(d);
  return reverse(a + b + c);  
}

unsigned long ppPacket(unsigned long a, byte c){ //takes address, command, calculates crc
  unsigned long p;
  byte cx;
  p = ((a & 0xFFFFF) << 4) | (c & 0xF);
  cx = ppCRC(p);
  p = (p << 8) | cx;
  return p;
}

void ppBegin(void){
  pinMode(PP_TX_PIN,OUTPUT);
  digitalWrite(PP_TX_PIN,PP_CARRIER_OFF);
}

void ppSendRF(unsigned long k)
{ //send a raw packet
  unsigned long int i;
  for (int r = 0; r < PP_PACKET_REPEAT; r++){
    for (i = 0x80000000UL; i > 0; i = i >> 1)
    { //32 bits of sequence
      if (i & k)
      { //hi bit
        digitalWrite(PP_TX_PIN, PP_CARRIER_ON);
        delayMicroseconds(PP_LONG_TIME);
        digitalWrite(PP_TX_PIN, PP_CARRIER_OFF);
        delayMicroseconds(PP_SHORT_TIME);
      }
      else
      { //lo bit
        digitalWrite(PP_TX_PIN, PP_CARRIER_ON);
        delayMicroseconds(PP_SHORT_TIME);
        digitalWrite(PP_TX_PIN, PP_CARRIER_OFF);
        delayMicroseconds(PP_LONG_TIME);
      }
    }
    digitalWrite(PP_TX_PIN, PP_CARRIER_ON); //3 more lo bits
    delayMicroseconds(PP_SHORT_TIME);
    digitalWrite(PP_TX_PIN, PP_CARRIER_OFF);
    delayMicroseconds(PP_LONG_TIME);
    digitalWrite(PP_TX_PIN, PP_CARRIER_ON);
    delayMicroseconds(PP_SHORT_TIME);
    digitalWrite(PP_TX_PIN, PP_CARRIER_OFF);
    delayMicroseconds(PP_LONG_TIME);
    digitalWrite(PP_TX_PIN, PP_CARRIER_ON);
    delayMicroseconds(PP_SHORT_TIME);
    digitalWrite(PP_TX_PIN, PP_CARRIER_OFF);
    delayMicroseconds(PP_LONG_TIME);
    delayMicroseconds(PP_SYNC_TIME); //brief delay between repeats
  }
}
