#include <LiquidCrystal.h>
#include <SPI.h>
#include <SdFat.h>
#include <TinyGPS.h>

const uint8_t chipSelect = SS;
const uint32_t SAMPLE_INTERVAL_MS = 200;
#define FILE_BASE_NAME "Data"
SdFat sd;
SdFile file;
uint32_t logTime;
const uint8_t ANALOG_COUNT = 4;

// Error messages stored in flash.
#define error(msg) sd.errorHalt(F(msg))

// Write data header.
void writeHeader() {
    file.print(F("Sl  "));
    file.print(F("Date   "));
    file.print(F("  Time "));
    file.print(F("   Lattitude "));
    file.print(F("Longitude "));
    file.print(F(" Dist."));
    file.print(F(" Dist0"));
  //  file.print(i, DEC);
  file.println();
}
String dataString="";
char datadate[16];

float falt,fc,fk,fmph,fmps,fkmph;
float dist,dist0;
byte month, day, hour, minute, second, hundredths;
int year,a,t,d,m,h,m1,s,sh,x,y;
int st=0;
unsigned long age;
unsigned long fix_age;
long lat1,lon1;
float flat,flon,flat1,flon1,flat0,flon0;
int playpin=7;
int start_stoppin=6;
int blpin=9;
int gpspin=3;
TinyGPS gps;
void getgps(TinyGPS &gps);
LiquidCrystal lcd(A3,A2,A1,A0,4,5);


void setup(){

//clock_prescale_set (clock_div_2);  //to reduce speed to 4 MHz
  
pinMode(playpin,INPUT);
pinMode(start_stoppin,INPUT);  
pinMode(blpin,OUTPUT);  
digitalWrite(blpin,LOW);

lcd.begin(16,4);
Serial.begin(9600);
 const uint8_t BASE_NAME_SIZE = sizeof(FILE_BASE_NAME) - 1;
  char fileName[13] = FILE_BASE_NAME "00.csv";

  if (!sd.begin(chipSelect, SPI_FULL_SPEED)) sd.initErrorHalt();
   // Find an unused file name.
  if (BASE_NAME_SIZE > 6) error("FILE_BASE_NAME too long");
  while (sd.exists(fileName)) {
    if (fileName[BASE_NAME_SIZE + 1] != '9') {
      fileName[BASE_NAME_SIZE + 1]++;
    } else if (fileName[BASE_NAME_SIZE] != '9') {
      fileName[BASE_NAME_SIZE + 1] = '0';
      fileName[BASE_NAME_SIZE]++;
    } else {
      error("Can't create file name");
    }
  }
  if (!file.open(fileName, O_CREAT | O_WRITE | O_EXCL)) { //O_RDWR ->O_WRITE
    error("file.open");
  }
  writeHeader();
  lcd.print("Initializing SDcard");
  Serial.println("SD Card initialized.");
  lcd.clear();
  lcd.print("SDCard Ready");
  lcd.clear();
}


void loop(){
//runner.execute();
digitalWrite(gpspin,HIGH);
pinMode(playpin, INPUT_PULLUP);  
pinMode(start_stoppin, INPUT_PULLUP); 
//digitalWrite(blpin,LOW);

int val=digitalRead(playpin);  
int val1=digitalRead(start_stoppin);

lcd.setCursor(14,0);
lcd.print(st);

byte a;
if ( Serial.available() > 0 ) { // if there is data coming into the serial line
      a = Serial.read();          // get the byte of data
      if(gps.encode(a)) {          // if there is valid GPS data...
        getgps(gps);              // then grab the data and display it on the LCD
                
lcd.setCursor(0,0);
lcd.print("Lat:");
lcd.print(flat,6);
lcd.setCursor(0,1);
lcd.print("Lon:");
lcd.print(flon,6);

if(val==LOW && x==1) {
delay(500); 
x=0;
digitalWrite(blpin,HIGH);

dist=HaverSine(flat,flon,flat1,flon1); 
dist0=HaverSine(flat0,flon0,flat,flon);

if(st==0){
  dist=0.00;
  dist0=0.00;
}
if(st>0 && (dist<=2.5 || dist>=999999) ) dist=0.00; //9271972
if(dist0<=2.5 || dist0>=999999) dist0=0.00;

logData();

if (!file.sync() || file.getWriteError()) {
error("write error");
  }

Serial.print(flat0);
Serial.println(flon0);

//if(val==LOW) digitalWrite(blpin,HIGH);  //to be tried here
lcd.setCursor(0,2);  //-4,2
lcd.print("d/D:");
lcd.print(dist,2);
lcd.print("/");
lcd.print(dist0,2);
flat1=flat;
flon1=flon;

if(st==0){
  flat0=flat;
  flon0=flon;
}
//delay(3000);
st=st+1;
}

if(val==HIGH && x==0) {
  lcd.setCursor(0,2);
  lcd.print("                ");
  x=1;
  digitalWrite(blpin,LOW);

 }

if(val1==LOW){
  file.close();
  lcd.clear();
  lcd.setCursor(0,1);
  lcd.print("File closed");
  lcd.setCursor(0,2);    //-4,2
  lcd.print("Restart Arduino");
  while(1) {}   //halt everything !
}
              }  
           }
}


   void getgps(TinyGPS &gps)   {
   gps.f_get_position(&flat, &flon, &age);
   gps.get_position(&lat1, &lon1, &fix_age);
   falt = gps.f_altitude(); // +/- altitude in meters
   fc = gps.f_course(); // course in degrees
   fk = gps.f_speed_knots(); // speed in knots
   fmph = gps.f_speed_mph(); // speed in miles/hr
   fmps = gps.f_speed_mps(); // speed in m/sec
   fkmph = gps.f_speed_kmph(); // speed in km/hr

       	if (fix_age == TinyGPS::GPS_INVALID_AGE)
        Serial.println("No fix ever detected!");
	else if (fix_age > 2000)
	Serial.println("Data is getting STALE!");
	else
   gps.crack_datetime(&year,&month,&day,&hour,&minute,&second,&hundredths);
 //day date block
    hour=hour+5; 
   minute=minute+30;   // correct for your time zone
   if(minute>59) {
     minute=minute-60;
     hour=hour+1;
     }
     if (hour>23) { 
     hour=hour-24;
     day=day+1;
     if(month==1 && day>31) month = month+1;
     if(month==2 && day>28) month = month+1;
     if(month==3 && day>31) month = month+1;
     if(month==4 && day>30) month = month+1;
     if(month==5 && day>31) month = month+1;
     if(month==6 && day>30) month = month+1;
     if(month==7 && day>31) month = month+1;
     if(month==8 && day>31) month = month+1;
     if(month==9 && day>30) month = month+1;
     if(month==10 && day>31) month = month+1;
     if(month==11 && day>30) month = month+1;
     if(month==12 && day>31) { month = month+1-12; year=year+1; }
     }

    d=day;
    m=month;
    y=year-2000;
    h=hour;
    m1=minute;
    s=second;
    sh=hundredths;
 //day date block ends


sprintf(datadate, "%d/%d/%d %d:%d:%02d", d,m,y,h,m1,s);
lcd.setCursor(0,3);  //-4,3
lcd.print(datadate);
 
//end data line

}


//convert degrees to radians
double dtor(double fdegrees){
return(fdegrees * PI / 180);
}

//Convert radians to degrees
double rtod(double fradians){
return(fradians * 180.0 / PI);
}

//Calculate distance form lat1/lon1 to lat2/lon2 using haversine formula
//Note lat1/lon1/lat2/lon2 must be in radians
//Returns distance in feet
long CalcDistance(double lat1, double lon1, double lat2, double lon2){
double dlon, dlat, a, c;
double dist = 0.0;
dlon = dtor(lon2 - lon1);
dlat = dtor(lat2 - lat1);
a = pow(sin(dlat/2),2) + cos(dtor(lat1)) * cos(dtor(lat2)) * pow(sin(dlon/2),2);
c = 2 * atan2(sqrt(a), sqrt(1-a));
dist = 6378140 * c;  //radius of the earth (6378140 meters) in feet 20925656.2
return( (long) dist + 0.5);
}

//Calculate bearing from lat1/lon1 to lat2/lon2
//Note lat1/lon1/lat2/lon2 must be in radians
//Returns bearing in degrees
int CalcBearing(double lat1, double lon1, double lat2, double lon2){
lat1 = dtor(lat1);
lon1 = dtor(lon1);
lat2 = dtor(lat2);
lon2 = dtor(lon2);
//determine angle
double bearing = atan2(sin(lon2-lon1)*cos(lat2), (cos(lat1)*sin(lat2))-(sin(lat1)*cos(lat2)*cos(lon2-lon1)));
//convert to degrees
bearing = rtod(bearing);
//use mod to turn -90 = 270
bearing = fmod((bearing + 360.0), 360);
return (int) bearing + 0.5;
}

void ComputeDestPoint(double lat1, double lon1, int iBear, int iDist, double *lat2, double *lon2){
double bearing = dtor((double) iBear);
double dist = (double) iDist / 20925656.2;
lat1 = dtor(lat1);
lon1 = dtor(lon1);
*lat2 = asin(sin(lat1)* cos(dist)+ cos(lat1)* sin(dist)*cos(bearing));
*lon2 = lon1 + atan2(sin(bearing)*sin(dist)*cos(lat1), cos(dist)-sin(lat1)*sin(*lat2));
*lon2 = fmod( *lon2 + 3 * PI, 2*PI )- PI;
*lon2 = rtod( *lon2);
*lat2 = rtod( *lat2);
}

float HaverSine(float lat1, float lon1, float lat2, float lon2){
 float ToRad = PI / 180.0;
 float R = 6378140;   // radius earth in meter
 float dLat = (lat2-lat1) * ToRad;
 float dLon = (lon2-lon1) * ToRad; 
 float a = sin(dLat/2) * sin(dLat/2) +
       cos(lat1 * ToRad) * cos(lat2 * ToRad) * 
       sin(dLon/2) * sin(dLon/2); 
 float c = 2 * atan2(sqrt(a), sqrt(1-a)); 
 float d = R * c;
 return d;
}


// Log a data record.
void logData() {
file.print(st);
file.print("  ");
file.print(datadate);
file.print(" ");
file.print(flat,6);
file.print(" ");
file.print(flon,6);
file.print(" ");
file.print(dist,4);
file.print(" ");
file.println(dist0,4);
 }




