
#include <RHReliableDatagram.h>
#include <RH_RF95.h>
#include <SPI.h>
#include <TinyGPS.h>
#include <NewPing.h>


//#include <string.h>


#include <OneWire.h>
#include <DallasTemperature.h>

#define CLIENT_ADDRESS 19   //1938
#define SERVER_ADDRESS 29   //2938

#define AVG_NUM 10    // number of iterations of the adc routine to average the adc readings
#define TRIGGER_PIN  A4  // Arduino pin tied to trigger pin on the ultrasonic sensor.
#define ECHO_PIN     A5  // Arduino pin tied to echo pin on the ultrasonic sensor.
#define MAX_DISTANCE 2000 // Maximum distance we want to ping for (in centimeters). Maximum sensor distance is rated at 400-500cm.
#define tank_height 500

RH_RF95 driver;

RHReliableDatagram manager(driver, SERVER_ADDRESS);

NewPing sonar(TRIGGER_PIN, ECHO_PIN, MAX_DISTANCE); 

String dataString="";
uint8_t data2[9];
uint8_t data1[56];
uint8_t data3[9];
uint8_t data5[8];
uint8_t data6[8];
uint8_t data7[8];

float falt,fc,fk,fmph,fmps,fkmph;
float dist,dist0;
byte month, day, hour, minute, second, hundredths;
int year,a,t,d,m,h,m1,s,sh,x,y;
int st=0;
unsigned long age;
unsigned long fix_age;
long lat1,lon1;
float flat,flon,flat1,flon1,flat0,flon0;
int j,k;
//uint8_t data[];

TinyGPS gps;
void getgps(TinyGPS &gps);

// Data wire is plugged into port 2 on the Arduino
#define ONE_WIRE_BUS 3
// Setup a oneWire instance to communicate with any OneWire devices (not just Maxim/Dallas temperature ICs)
OneWire oneWire(ONE_WIRE_BUS);
// Pass our oneWire reference to Dallas Temperature. 
DallasTemperature sensors(&oneWire);


void setup() {
 
  Serial.begin(9600);
  while (!Serial) ; // Wait for serial port to be available
  if (!manager.init())
    Serial.println("init failed");
// Bw = 31.25 kHz, Cr = 4/8, Sf = 512chips/symbol, CRC on. Slow+long range
  // The default transmitter power is 13dBm, using PA_BOOST.
  // If you are using RFM95/96/97/98 modules which uses the PA_BOOST transmitter pin, then 
  // you can set transmitter powers from 5 to 23 dBm:
//  driver.setTxPower(23, true);
  // If you are using Modtronix inAir4 or inAir9,or any other module which uses the
  // transmitter RFO pins and not the PA_BOOST pins
  // then you can configure the power transmitter power for -1 to 14 dBm and with useRFO true. 
  // Failure to do that will result in extremely low transmit powers.
 driver.setTxPower(23);
 
}

uint8_t data4[] = "Hello Bera How U";
// Dont put this on the stack:
uint8_t buf[RH_RF95_MAX_MESSAGE_LEN];

void loop(){
 byte a;


if ( Serial.available() > 0 ) { // if there is data coming into the serial line
      a = Serial.read();          // get the byte of data
      if(gps.encode(a)) {          // if there is valid GPS data...
        getgps(gps);              // then grab the data and display it on the LCD
 
       }
}
 
  
  if (manager.available())  {
    // Wait for a message addressed to us from the client
    uint8_t len = sizeof(buf);
    uint8_t from;
    if (manager.recvfromAck(buf, &len, &from))    {
//      Serial.print("got request from : 0x");
//      Serial.print(from, HEX);
 
// Send a reply back to the originator client
if (!manager.sendtoWait(data1,sizeof(data1), from)){
 
}

 
   }
  }

}


   void getgps(TinyGPS &gps)   {
   gps.f_get_position(&flat, &flon, &age);
   gps.get_position(&lat1, &lon1, &fix_age);
   falt = gps.f_altitude(); // +/- altitude in meters
   fc = gps.f_course(); // course in degrees
   fk = gps.f_speed_knots(); // speed in knots
   fmph = gps.f_speed_mph(); // speed in miles/hr
   fmps = gps.f_speed_mps(); // speed in m/sec
   fkmph = gps.f_speed_kmph(); // speed in km/hr

       	if (fix_age == TinyGPS::GPS_INVALID_AGE)
        Serial.println("No fix ever detected!");
	else if (fix_age > 2000)
	Serial.println("Data is getting STALE!");
	else
   gps.crack_datetime(&year,&month,&day,&hour,&minute,&second,&hundredths);
 //day date block
    hour=hour+5; 
   minute=minute+30;   // correct for your time zone
   if(minute>59) {
     minute=minute-60;
     hour=hour+1;
     }
     if (hour>23) { 
     hour=hour-24;
     day=day+1;
     if(month==1 && day>31) month = month+1;
     if(month==2 && day>28) month = month+1;
     if(month==3 && day>31) month = month+1;
     if(month==4 && day>30) month = month+1;
     if(month==5 && day>31) month = month+1;
     if(month==6 && day>30) month = month+1;
     if(month==7 && day>31) month = month+1;
     if(month==8 && day>31) month = month+1;
     if(month==9 && day>30) month = month+1;
     if(month==10 && day>31) month = month+1;
     if(month==11 && day>30) month = month+1;
     if(month==12 && day>31) { month = month+1-12; year=year+1; }
     }

    d=day;
    m=month;
    y=year-2000;
    h=hour;
    m1=minute;
    s=second;
    sh=hundredths;
 //day date block ends

 
sensors.begin();
sensors.requestTemperatures(); // Send the command to get temperatures
 
dtostrf(flat, 9, 6, (char*)data3);  //latitude
dtostrf(flon, 9, 6, (char*)data2); //longitude
dtostrf(sensors.getTempCByIndex(0), 5, 2, (char*)data6); //temperature
dtostrf(read_sonar(), 5, 1, (char*)data7); //level in cm

//altitude
if(falt>100) {
dtostrf(falt, 6, 0, (char*)data5);
sprintf((char*)data1, "%9s,%9s,%02d:%02d:%02d,%02d/%02d/%2d,%6s,%5s,%5s", (char*)data3,(char*)data2,h,m1,s,d,m,y,(char*)data5,(char*)data7,(char*)data6);

}

else
sprintf((char*)data1, "%9s,%9s,%02d:%02d:%02d,%02d/%02d/%2d,%5s,%5s", (char*)data3,(char*)data2,h,m1,s,d,m,y,(char*)data7,(char*)data6);

}




 int read_sonar(){
  int sum = 0;
  int sample ;
  for (int i=0; i<AVG_NUM; i++)   { 
    sample = sonar.ping()/US_ROUNDTRIP_CM; // Send ping, get ping time in microseconds (uS).
    delay(50);   //give some time to chill Arduino
    sonar.timer_stop();
    sum += sample;      
  }
  return(sum / AVG_NUM);
} 



