// rf95_reliable_datagram_client.pde
// -*- mode: C++ -*-
// Example sketch showing how to create a simple addressed, reliable messaging client
// with the RHReliableDatagram class, using the RH_RF95 driver to control a RF95 radio.
// It is designed to work with the other example rf95_reliable_datagram_server
// Tested with Anarduino MiniWirelessLoRa, Rocket Scream Mini Ultra Pro with the RFM95W 

#include <RHReliableDatagram.h>
#include <RH_RF95.h>
#include <SPI.h>
#include <LiquidCrystal.h>
#include <string.h>


#define CLIENT_ADDRESS 19  //1938
#define SERVER_ADDRESS 29  //2938
#define MAX_STRING_LEN  56  //56
//float lat,lon,alt,temp;
char buflist[MAX_STRING_LEN];

int aux=A0;
int m0=A1;
int m1=A2;
int next;

// Singleton instance of the radio driver
RH_RF95 driver;
//RH_RF95 rf95(5, 2); // Rocket Scream Mini Ultra Pro with the RFM95W
LiquidCrystal lcd(3,4,5,6,7,8);

// Class to manage message delivery and receipt, using the driver declared above
RHReliableDatagram manager(driver, CLIENT_ADDRESS);

// Need this on Arduino Zero with SerialUSB port (eg RocketScream Mini Ultra Pro)
//#define Serial SerialUSB

void setup() {
  pinMode(aux,OUTPUT);
  pinMode(m0,INPUT);
  pinMode(m1,INPUT);
  pinMode(rst,OUTPUT);

  Serial.begin(9600);
  digitalWrite(aux,1);
  digitalWrite(m0,0);
  digitalWrite(m1,0);
  digitalWrite(rst,0);

//  Wire.begin();
  lcd.begin(20,4);
  
  while (!Serial) ; // Wait for serial port to be available
  if (!manager.init())    lcd.print("init failed");

driver.setTxPower(23);


}


uint8_t data[] = "Hello 19!";

uint8_t buf[RH_RF95_MAX_MESSAGE_LEN];

void loop(){
digitalWrite(rst,0);    


  // Send a message to manager_server
  if (manager.sendtoWait(data, sizeof(data), SERVER_ADDRESS))  {
 
    // Now wait for a reply from the server
    uint8_t len = sizeof(buf);
    uint8_t from;   
    if (manager.recvfromAckTimeout(buf, &len, 6000, &from)) {

    String q[5];  //default 5
    strncpy(buflist,(char*)buf,MAX_STRING_LEN);

digitalWrite(m0,0);  //1
digitalWrite(m1,0);

Serial.print(buflist);

Serial.print(",");
//Serial.print("From:0x");
Serial.println(from,HEX);


delay(1000);
digitalWrite(m0,1);
digitalWrite(m1,1);

q[0]=subStr(buflist, ',', 1);
q[1]=subStr(buflist, ',', 2);
q[2]=subStr(buflist, ',', 3);
q[3]=subStr(buflist, ',', 4);
q[4]=subStr(buflist, ',', 5);
q[5]=subStr(buflist, ',', 6);
      
lcd.setCursor(0,0);
lcd.print(buflist);

      lcd.setCursor(0,3);
      lcd.print("rply:0x");
      lcd.print(from,HEX);
      lcd.print(" D:");
      lcd.print(HaverSine(24.088729,82.648193,q[0].toFloat(),q[1].toFloat()));
//      lcd.print("           ");


    }
    else  {
 //     Serial.println("No reply, is rf95_reliable_datagram_server running?");
      lcd.print("No Reply,RF95");

    }
    
  }
  
 
    else  {
 //   Serial.println("send failed");
    lcd.setCursor(0,3);
    lcd.print("Send failed");
  }


}



// Function to return a substring defined by a delimiter at an index
char* subStr (char* str, char delim, int index) {
  char *act, *sub, *ptr;
  char copy[MAX_STRING_LEN];
  int i;

  // Since strtok consumes the first arg, make a copy
  strcpy(copy, str);

  for (i = 1, act = copy; i <= index; i++, act = NULL) {
     //Serial.print(".");
     sub = strtok_r(act, &delim, &ptr);
     if (sub == NULL) break;
  }
  return sub;

}



float HaverSine(float lat1, float lon1, float lat2, float lon2){
 float ToRad = PI / 180.0;
 float R = 6378140;   // radius earth in meter
 float dLat = (lat2-lat1) * ToRad;
 float dLon = (lon2-lon1) * ToRad; 
 float a = sin(dLat/2) * sin(dLat/2) +
       cos(lat1 * ToRad) * cos(lat2 * ToRad) * 
       sin(dLon/2) * sin(dLon/2); 
 float c = 2 * atan2(sqrt(a), sqrt(1-a)); 
 float d = R * c;
 return d;
}




