/**************************************************************
   Blynk is a platform with iOS and Android apps to control
   Arduino, Raspberry Pi and the likes over the Internet.
   You can easily build graphic interfaces for all your
   projects by simply dragging and dropping widgets.

     Downloads, docs, tutorials: http://www.blynk.cc
     Blynk community:            http://community.blynk.cc
     Social networks:            http://www.fb.com/blynkapp
                                 http://twitter.com/blynk_app

   Blynk library is licensed under MIT license


  **************************************************************/
#include <ESP8266WiFi.h>
#include <BlynkSimpleEsp8266.h>

// Get an Authorisation Token in the Blynk App.
// Go to the Project Settings (nut icon).
// Blynk will not work without the Auth code
// Also update the WiFi SSID and Security code in Setup
char auth[] = "";
unsigned long int comboDuration = 10;// seconds

int A = 0;
int B = 2;
int speedx = 100;
int speedStep = 40;
int scene = 0;
int randNumber = 0;
boolean up = true;
boolean slowGloControl = false;
boolean combination = true;
unsigned long int startTime = 0;
int brightness = 0;    // how bright the LED is
int fadeAmount = 10;    // how many points to fade the LED by
boolean autoOn = false;  //True for Blynk
//**************************************************************

void upDateSceneData()
{

  String sceneNumStr = "Scene: " + String(scene, DEC);
  Serial.print("[");
  Serial.print(millis());
  Serial.print("] ");
  Serial.println(sceneNumStr);
  Blynk.virtualWrite(21, sceneNumStr );
  switch (scene)
  {
    case 1:
      {
        Blynk.virtualWrite(22, "All on" );
        break;
      }
    case 2:
      {
        Blynk.virtualWrite(22, "In Waves" );
        break;
      }
    case 3:
      {
        speedx = 200;  //crash prevention
        Blynk.virtualWrite(22, "Sequential" );
        break;
      }
    case 4:
      {
        Blynk.virtualWrite(22, "Slo Glo" );
        break;
      }

    case 5:
      {
        Blynk.virtualWrite(22, "Chasing Flash" );
        break;
      }
    case 6:
      {
        Blynk.virtualWrite(22, "Slow Fade" );
        break;
      }
    case 7:
      {
        Blynk.virtualWrite(22, "Twinkle Flash" );
        break;
      }

    case 8: //Twinkle
      {
         Blynk.virtualWrite(22, "Twinkle" );
         break;
      }
    case 9:
      {
         Blynk.virtualWrite(22, "Varying Twinkle" );
         break;
      }
    case 10:
      {
         Blynk.virtualWrite(22, "Flicker" );
         break;
      }
    case 11:
      {
           Blynk.virtualWrite(22, "Flicker Alt" );
           break;
      }
    case 12:
      {
        Blynk.virtualWrite(22, "All Off" );
         break;
      }
  }
}

void setup()
{
  Serial.begin(74880);
  autoOn = true;
  Serial.println ();
  Serial.print("[");
  Serial.print(millis());
  Serial.print("]");
  Serial.println ("Auto ON");

  if (autoOn )
  {
    //enter your Wifi SSID and security code
    Blynk.begin(auth, "SSIDHere", "SecurityCode");
  }
  delay(1);
  //pinMode (A, OUTPUT);
  // pinMode (B, OUTPUT);

  digitalWrite(A, LOW);
  digitalWrite(B, LOW) ;

  if (autoOn)
  {
    Blynk.virtualWrite(21, "Scene 1" );
    Blynk.virtualWrite(22, "All on" );
    combination = true;
    scene = 1;
    startTime = millis();
  }
}
//*******************************************
void fade(int ledToFade)
{
  if (brightness <= 1024 and brightness >= 0)
  {
    analogWrite(ledToFade, brightness);
  }
  brightness = brightness + fadeAmount;
  if (brightness <= 0 or brightness >= 1024)
  {
    fadeAmount = -fadeAmount ;
  }
  delay(40);
}

//****************   MAIN LOOP  *************************************************
void loop()
{
  if (autoOn)
  {
    Blynk.run();
  }
  if (combination == true and (millis() - startTime) > comboDuration * 1000)
  {
    scene = scene + 1;
    if (scene == 3)
    {
      speedx = 200;  //to prevent improper range
    }
    if (scene > 11)
    {
      scene = 1;
    }
    upDateSceneData();
    startTime = millis();

  }
  switch (scene)
  {
    case 1:  //All on
      {
        analogWrite(A, 0);
        analogWrite(B, 0);
        break;
      }
    case 2:  // In Waves
      {

        for (int j = 20; j < 1024; j++)
        {
          yield();
          analogWrite(A, j);
          analogWrite(B, 1024 - j);
          delay(2);
        }
        delay(speedx);
        if (autoOn) {
          Blynk.run();
        }

        for (int j = 1024; j > 20 ; j--)
        {
          yield();
          analogWrite(A, j);
          analogWrite(B, 1024 - j);
          delay(2);
        }
        delay(speedx);
        if (autoOn) {
          Blynk.run();
        }
        speedx = speedx + speedStep;

        if (speedx <= 20 or speedx >= 600)
        {
          speedStep = -speedStep ;
        }
        if (speedx < 20)
        {
          speedx = 20;
        }

        break;
      }
    case 3: //   Sequential
      {
        for (int i = 0 ; i < 5; i++)
        {
          if (autoOn)
          {
            Blynk.run();
          }
          analogWrite(A, 1024);
          analogWrite(B, 0);
          if (speedx > 0)
          {
            delay(speedx);
          }
          analogWrite(A, 0);
          analogWrite(B, 1024);
          if (speedx > 0)
          {
            delay(speedx);
          }
        }
        if (speedx < 0 )
        {
          speedx = speedStep + 1;
        }
        if (speedx < 50 or speedx >300 )
        {
          speedStep = -speedStep ;
        }
        speedx = speedx + speedStep;
        break;
      }
    case 4:    //Slo glo
      {
        if (slowGloControl)
        {
          fade(A);
          analogWrite(B, 1024);
        }
        else
        {
          fade (B);
          analogWrite(A, 1024);
        }
        if (brightness >= 1024 )
        {
          delay (250);
            slowGloControl = !slowGloControl;
        }
        break;
      }
    case 5:   //Chasing Flash A flashes 5 times fast, then alternate a and b flash then b flashes 5 times fast then alternate and restart
      {

        int fF = 100;
        int altD = 120;
        int fN = 8;
        for (int i = 0; i < fN; i++) //A fast flash
        {
          analogWrite(B, 0);
          delay(1);
          analogWrite(A, 999);
          delay (fF);
          analogWrite(A, 0);
          delay (fF);
          if (autoOn) {
            Blynk.run();
          }
        }
        for (int i = 0; i < fN; i++) //Alternate
        {
          analogWrite(B, 1024);
          delay (altD);
          analogWrite(B, 0);
          delay(1);
          analogWrite(A, 1024);
          delay (altD);
          analogWrite(A, 0);
          if (autoOn) {
            Blynk.run();
          }
        }
        for (int i = 0; i < fN; i++) //B fast flash
        {
          analogWrite(A, 0);
          delay(1);
          analogWrite(B, 1024);
          delay (fF);
          analogWrite(B, 0);
          delay (fF);
          if (autoOn)
          {
            Blynk.run();
          }
        }
        for (int i = 0; i < fN; i++) //Alternate
        {
          analogWrite(B, 1024);
          delay (altD);
          analogWrite(B, 0);
          delay(1);
          analogWrite(A, 1024);
          delay (altD);
          analogWrite(A, 0);
          if (autoOn) {
            Blynk.run();
          }
        }
        break;
      }
    case 6:   //Slow Fade Together
      {
        if (brightness <= 1024 and brightness >= 0)
        {
          analogWrite(A, brightness);
          analogWrite(B, brightness);
        }

        brightness = brightness + fadeAmount;

        if (brightness <= 0 or brightness >= 1024)
        {
          fadeAmount = -fadeAmount ;
        }
        delay(40);
        break;
      }
    case 7://Twinkle Flash
      {
        int flashRate = 50;
        for (int i = 0 ; i < 4; i++)
        {
          analogWrite(B, 0);
          analogWrite(A, 1024);
          delay (flashRate);
          analogWrite(A, 0);
          delay (flashRate);
        }
        for (int i = 0 ; i < 4; i++)
        {
          analogWrite(A, 0);
          analogWrite(B, 1024);
          delay (flashRate);
          analogWrite(B, 0);
          delay (flashRate);
        }
        break;
      }
    case 8://Twinkle
      {
        analogWrite(A, 1024);
        analogWrite(B, 0);
        delay(speedx);
        analogWrite(A, 0);
        analogWrite(B, 1024);
        delay(speedx);
        if (autoOn)
        {
          Blynk.run();
        }
        break;
      }
    case 9: //Variable Twinkle
      {
        if (up)
        {
          speedx = speedx + 10;
          if (speedx > 250)
          {
            speedx = 250;
            up = false;
          }
        }
        else
        {
          speedx = speedx - 10;
          if (speedx < 0)
          {
            speedx = 0;
            up = true;
          }
        }
        analogWrite(A, 1024);
        analogWrite(B, 0);
        delay(speedx);
        analogWrite(A, 0);
        analogWrite(B, 1024);
        delay(speedx);
        if (autoOn) {
          Blynk.run();
        }
        break;
      }
    case 10: //flicker
      {
        randNumber = random(0, 1024);
        analogWrite(A, randNumber);
        analogWrite(B, randNumber);
        delay(100);
        break;
      }
    case 11:   //Flicker alt
      {
        randNumber = random(0, 1024);
        analogWrite(A, randNumber);
        delay(50);
        analogWrite(B, 1024 - randNumber);
        delay(50);

        break;
      }
    case 12:  //All Off
      {
        analogWrite(A, 1024);
        analogWrite(B, 1024);
        break;
      }
    default:
      {
        break;
      }
  }
}
//**************************************
void variableTwinkle()
{
  analogWrite(A, 1024);
  analogWrite(B, 0);
  delay(speedx);
  analogWrite(A, 0);
  analogWrite(B, 1024);
  delay(speedx);
  if (autoOn)
  {
    Blynk.run();
  }
}
//**************************************
BLYNK_WRITE(V0)//Scene Selection slider
{
  scene = param.asInt();
  if (scene > 12)
  {
    scene = 1;
  }
  upDateSceneData();
}
//**************************
BLYNK_WRITE(V1)//Scene Selection menu
{
  scene = param.asInt();
  if (scene > 12)
  {
    scene = 1;
  }
  upDateSceneData();
}
//**************************
BLYNK_WRITE(V2)
{
  speedx =  param.asInt();
  if (speedx < 0)
  {
    speedx = 0;
  }
  if (speedx > 1000)
  {
    speedx = 1000;
  }
  Serial.print("Twinkle speed is: ");
  Serial.println(String(speedx));
}
//*****************************************
BLYNK_WRITE(V3)
{
  comboDuration = param.asInt();
  Serial.print("Interval is ");
  Serial.println(String(comboDuration));
}
//*****************************************
BLYNK_WRITE(V4) //Combination toggle On/Off
{
  int recVal = param.asInt();
  if (recVal == 1)
  {
    combination = true;
    Blynk.virtualWrite(22, "Combo On" );
    Serial.println("Combo On");
  }
  else
  {
    combination = false;
    Blynk.virtualWrite(22, "Combo Off" );
    Serial.println("Combo Off");
  }
}






