//ESP32-CAM BackPack connections
//LCD     ESPCAM
//1       5V
//2       GND
//3 CS    IO12  DATA2
//4 RST   EN
//5 DC    IO13  DATA3
//6 MOSI  IO2   DATA0
//7 SCK   IO14  CLK
//8 LED   5V
//9 MISO  NC
//10 SCK  IO14  CLK
//11 TCS  IO15  CMD
//12 MOSI IO2   DATA0
//13 MISO IO4   DATA1
//14 TIRQ NC

#include "LCD.h"
#include "Arial_round_16x24.c"
#include "esp_camera.h"
#include <WiFi.h>

//camera includes and variables
#define CAMERA_MODEL_AI_THINKER // selected in camera_pins.h
//includes some helper functions camInit,showCamID, BMPHeader_t struct
//also getRow and getPixel for reading bitmaps
#include "camera_pins.h"
int e;      //error status
sensor_t * s;
uint16_t camID; //see camera_pid_t enum
BMPHeader_t* bmHeader;

//See the following for useful functions/structs/enums:
//sensor.h
//esp_camera.h
//img_converters.h

//GUI elements
button b0=  {.x=300,.y=  0,.w= 80,.h=35,.text="TEST",.pressed=0,.visible=1,.lastchange=0};//x,y,w,h,text,pressed,visible,lastchange
button b1=  {.x=250,.y= 40,.w= 80,.h=35,.text="SIZE",.pressed=0,.visible=1,.lastchange=0};//x,y,w,h,text,pressed,visible,lastchange
button b2=  {.x=250,.y= 80,.w=120,.h=35,.text="H-FLIP",.pressed=0,.visible=1,.lastchange=0};//x,y,w,h,text,pressed,visible,lastchange
button b3=  {.x=250,.y=120,.w=120,.h=35,.text="V-FLIP",.pressed=0,.visible=1,.lastchange=0};//x,y,w,h,text,pressed,visible,lastchange
button b4=  {.x=250,.y=160,.w= 35,.h=35,.text="-",.pressed=0,.visible=1,.lastchange=0};//x,y,w,h,text,pressed,visible,lastchange
button b5=  {.x=440,.y=160,.w= 35,.h=35,.text="+",.pressed=0,.visible=1,.lastchange=0};//x,y,w,h,text,pressed,visible,lastchange
button b6=  {.x=250,.y=200,.w= 35,.h=35,.text="-",.pressed=0,.visible=1,.lastchange=0};//x,y,w,h,text,pressed,visible,lastchange
button b7=  {.x=440,.y=200,.w= 35,.h=35,.text="+",.pressed=0,.visible=1,.lastchange=0};//x,y,w,h,text,pressed,visible,lastchange
button b8=  {.x=250,.y=240,.w= 35,.h=35,.text="-",.pressed=0,.visible=1,.lastchange=0};//x,y,w,h,text,pressed,visible,lastchange
button b9=  {.x=440,.y=240,.w= 35,.h=35,.text="+",.pressed=0,.visible=1,.lastchange=0};//x,y,w,h,text,pressed,visible,lastchange
button b10= {.x=250,.y=280,.w= 35,.h=35,.text="-",.pressed=0,.visible=1,.lastchange=0};//x,y,w,h,text,pressed,visible,lastchange
button b11= {.x=440,.y=280,.w= 35,.h=35,.text="+",.pressed=0,.visible=1,.lastchange=0};//x,y,w,h,text,pressed,visible,lastchange

//variables
bool testOn=0;
framesize_t frameSize=(framesize_t)0;    //see frameWidth, frameHeight and frameText arrays for parameters
#define FRAMESIZE_MAX ((framesize_t)8)
bool hFlip=0,vFlip=0;
int quality=10;
#define QUALITY_MAX (63)
#define QUALITY_MIN (4)
//note quality works in reverse (low # = better)
int brightness=0;
#define BRIGHT_MIN (-2)
#define BRIGHT_MAX (2)
int contrast=0;
#define CONTRAST_MIN (-2)
#define CONTRAST_MAX (2)
int effect=0;
#define EFFECT_MIN (0)
#define EFFECT_MAX (6)
//effects are:
//0: normal/none
//1: negative
//2: B&W
//3: red tint
//4: green tint
//5: blue tint
//6: retro

touchCoords t;
float fTime,fRate;
char str[256];  //for printing 

void setup() {
  Serial.begin(115200);
  //while(!Serial && millis()<5000){}
  displaySetup(); //this inits LCD controller, touch and backlight PWM
  setrotation(1);
  clear(BLACK);
  showarray(0,5,"ESP32-CAM BackPack",Arial_round_16x24,YELLOW,BLACK);
  drawbutton(&b0);
  drawbutton(&b1);
  drawbutton(&b2);
  drawbutton(&b3);
  drawbutton(&b4);
  drawbutton(&b5);
  drawbutton(&b6);
  drawbutton(&b7);
  drawbutton(&b8);
  drawbutton(&b9);
  drawbutton(&b10);
  drawbutton(&b11);
  showarray(400,  5,"OFF",Arial_round_16x24,YELLOW,BLACK);
  showarray(336, 45,frameText[frameSize],Arial_round_16x24,YELLOW,BLACK);
  showarray(400, 85,"OFF",Arial_round_16x24,YELLOW,BLACK);
  showarray(400,125,"OFF",Arial_round_16x24,YELLOW,BLACK);
  sprintf(str,"Qual:%2d",quality);
  str[7]=0;    //force null termination
  showarray(307,165,str,Arial_round_16x24,YELLOW,BLACK);
  sprintf(str,"Bright:%2d",brightness);
  str[9]=0;    //force null termination
  showarray(291,205,str,Arial_round_16x24,YELLOW,BLACK);
  sprintf(str,"Contr:%2d",contrast);
  str[8]=0;    //force null termination
  showarray(299,245,str,Arial_round_16x24,YELLOW,BLACK);
  sprintf(str,"Effect:%2d",effect);
  str[9]=0;    //force null termination
  showarray(291,285,str,Arial_round_16x24,YELLOW,BLACK);
  hline(0,39,241,WHITE);
  hline(0,280,241,WHITE);
  vline(0,39,280,WHITE);
  vline(241,39,280,WHITE);
  box(1,40,240,279,GREY);
  e=camInit();
  if(e==ESP_OK){
    Serial.println("Camera initialised");
  }else{
    Serial.printf("Camera init error %d.\r\n",e);
  }
  s = esp_camera_sensor_get();
  camID = s->id.PID;
  showCamID(camID);
  e=s->set_framesize(s,frameSize);  //framesize_t
  if(e==ESP_OK){
    Serial.println("Set Framesize OK");
  }else{
    Serial.printf("Set framesize; error %d.\r\n",e);
  }
  e=s->set_hmirror(s,hFlip);
  e=s->set_vflip(s,vFlip);
  //see sensor.h for other setting functions
  Serial.println("DONE");
}

void loop() {       //this displays at actual size
  int w,h,x,y;
  uint8_t* rowData;
  unsigned long tm=millis();
  uint8_t* out;     //for bitmap data
  size_t out_len;   //length of bitmap data
  //Serial.printf("%d,%d\r\n",touchx(),touchy()); 
  camera_fb_t *fb = NULL;
  e=ESP_OK;
  fb = esp_camera_fb_get();
  if(fb){
    if(frame2bmp(fb,&out,&out_len)){    //convert from jpg to bmp
      drawBitMap(out,1,40,240,240);
    }else{
      Serial.println("Convert to BMP capture failed.");  
      delay(100);
    }
  }else{
    Serial.println("Camera capture failed.");
    delay(100);
  }
  free(out);                  //release bitmap buffer
  esp_camera_fb_return(fb);   //release frame buffer
  fTime=millis()-tm;          //count cycle time for capture/display
  fRate=999;
  if(fTime>1){fRate=1000/fTime;} // time in ms <=> framerate frames per second
  sprintf(str,"%5.1f fps",fRate);
  str[10]=0;    //force null termination
  showarray(48,288,str,Arial_round_16x24,YELLOW,BLACK);    
  t=getTouchCoords();
  if(handleButton(&b0,t)==BUTTON_DOWN){ //test pattern
    if(testOn){
      testOn=0;
      showarray(400,  5,"OFF",Arial_round_16x24,YELLOW,BLACK);
    }else{
      testOn=1;
      showarray(400,  5,"ON ",Arial_round_16x24,YELLOW,BLACK);
    }
    e=s->set_colorbar(s,testOn);
  }
  if(handleButton(&b1,t)==BUTTON_DOWN){
    frameSize=(framesize_t)(frameSize+1);
    if(frameSize>FRAMESIZE_MAX){frameSize=(framesize_t)0;}
    showarray(336,45,frameText[frameSize],Arial_round_16x24,YELLOW,BLACK);
    e=s->set_framesize(s,frameSize);  //framesize_t
    box(1,40,240,279,GREY);
  }
  if(handleButton(&b2,t)==BUTTON_DOWN){ //hFlip
    if(hFlip){
      hFlip=0;
      showarray(400,85,"OFF",Arial_round_16x24,YELLOW,BLACK);
    }else{
      hFlip=1;
      showarray(400,85,"ON ",Arial_round_16x24,YELLOW,BLACK);
    }
    e=s->set_hmirror(s,hFlip);
  }
  if(handleButton(&b3,t)==BUTTON_DOWN){ //vFlip
    if(vFlip){
      vFlip=0;
      showarray(400,125,"OFF",Arial_round_16x24,YELLOW,BLACK);
    }else{
      vFlip=1;
      showarray(400,125,"ON ",Arial_round_16x24,YELLOW,BLACK);
    }
    e=s->set_vflip(s,vFlip);
  }
  if(handleButton(&b4,t)==BUTTON_DOWN){ //QUAL-
    quality=quality-1;
    if(quality<QUALITY_MIN){quality=QUALITY_MIN;}
    sprintf(str,"Qual:%2d",quality);
    str[7]=0;    //force null termination
    showarray(307,165,str,Arial_round_16x24,YELLOW,BLACK);
    e=s->set_quality(s,quality);
  }
  if(handleButton(&b5,t)==BUTTON_DOWN){ //QUAL+
    quality=quality+1;
    if(quality>QUALITY_MAX){quality=QUALITY_MAX;}
    sprintf(str,"Qual:%2d",quality);
    str[7]=0;    //force null termination
    showarray(307,165,str,Arial_round_16x24,YELLOW,BLACK);
    e=s->set_quality(s,quality);
  }
  if(handleButton(&b6,t)==BUTTON_DOWN){ //BRIGHT-
    brightness=brightness-1;
    if(brightness<BRIGHT_MIN){brightness=BRIGHT_MIN;}
    sprintf(str,"Bright:%2d",brightness);
    str[9]=0;    //force null termination
    showarray(291,205,str,Arial_round_16x24,YELLOW,BLACK);
    e=s->set_brightness(s,brightness);
  }
  if(handleButton(&b7,t)==BUTTON_DOWN){ //BRIGHT+
    brightness=brightness+1;
    if(brightness>BRIGHT_MAX){brightness=BRIGHT_MAX;}
    sprintf(str,"Bright:%2d",brightness);
    str[9]=0;    //force null termination
    showarray(291,205,str,Arial_round_16x24,YELLOW,BLACK);
    e=s->set_brightness(s,brightness);
  }
  if(handleButton(&b8,t)==BUTTON_DOWN){ //CONTRAST-
    contrast=contrast-1;
    if(contrast<CONTRAST_MIN){contrast=CONTRAST_MIN;}
    sprintf(str,"Contr:%2d",contrast);
    str[8]=0;    //force null termination
    showarray(299,245,str,Arial_round_16x24,YELLOW,BLACK);
    e=s->set_contrast(s,contrast);
  }
  if(handleButton(&b9,t)==BUTTON_DOWN){ //CONTRAST+
    contrast=contrast+1;
    if(contrast>CONTRAST_MAX){contrast=CONTRAST_MAX;}
    sprintf(str,"Contr:%2d",contrast);
    str[8]=0;    //force null termination
    showarray(299,245,str,Arial_round_16x24,YELLOW,BLACK);
    e=s->set_contrast(s,contrast);
  }
  if(handleButton(&b10,t)==BUTTON_DOWN){ //EFFECT-
    effect=effect-1;
    if(effect<EFFECT_MIN){effect=EFFECT_MIN;}
    sprintf(str,"Effect:%2d",effect);
    str[9]=0;    //force null termination
    showarray(291,285,str,Arial_round_16x24,YELLOW,BLACK);
    e=s->set_special_effect(s,effect);
  }
  if(handleButton(&b11,t)==BUTTON_DOWN){ //EFFECT+
    effect=effect+1;
    if(effect>EFFECT_MAX){effect=EFFECT_MAX;}
    sprintf(str,"Effect:%2d",effect);
    str[9]=0;    //force null termination
    showarray(291,285,str,Arial_round_16x24,YELLOW,BLACK);
    e=s->set_special_effect(s,effect);
  }
}

void drawBitMap( uint8_t * bm,unsigned int x,unsigned int y,unsigned int w,unsigned int h){  //draw bm to x,y, cropping (centred) to w,h if needed
  unsigned int bmw, bmh,cvw,cvh;  //bitmap, canvas= actual area drawn
  unsigned int bmx=0,bmy=0;       //top left corner of drawn part of bitmap
  unsigned int u,v;               //counters
  BMPHeader_t* header;  
  uint8_t* rowData;
  header=(BMPHeader_t*)bm;  //header is at start of bitmap data
  bmw=abs(header->width);
  bmh=abs(header->height);
  if(bmw>w){cvw=w;bmx=(bmw-cvw)/2;}else{cvw=bmw;x=x+(w-bmw)/2;}
  if(bmh>h){cvh=h;bmy=(bmh-cvh)/2;}else{cvh=bmh;y=y+(h-bmh)/2;}
  setarea(x,y,x+cvw-1,y+cvh-1);
  digitalWrite(LCDCS,LOW);
  for(v=0;v<cvh;v++){
    rowData=getRow(header,v+bmy);
    if(rowData){
      for(u=0;u<cvw*3;u=u+3){   //RGB triplets
        data8(rowData[u+bmx*3+2]);  //RGB<>BGR order
        data8(rowData[u+bmx*3+1]);
        data8(rowData[u+bmx*3+0]);
      }
    }else{
      for(u=0;u<cvw*3;u++){
        data8(128);   //grey
      }
    }
  }
  digitalWrite(LCDCS,HIGH);
  Serial.printf("%d x %d bitmap cropped to %d x %d pixels for display.\r\n",bmw,bmh,cvw,cvh);
}