#include "LCD.h"
#include "Arial_round_16x24.c"
#include "esp_camera.h"
#include <WiFi.h>

//camera includes and variables
#define CAMERA_MODEL_AI_THINKER // selected in camera_pins.h
//includes some helper functions camInit,showCamID, BMPHeader_t struct
//also getRow and getPixel for reading bitmaps
#include "camera_pins.h"
int e;      //error status
sensor_t * s;
uint16_t camID; //see camera_pid_t enum

void setup() {
  Serial.begin(115200);
  displaySetup(); //this inits LCD controller, touch and backlight PWM
  setrotation(1);
  clear(GREY);
  e=camInit();
  if(e==ESP_OK){
    Serial.println("Camera initialised");
  }else{
    Serial.printf("Camera init error %d.\r\n",e);
  }
  s = esp_camera_sensor_get();
  camID = s->id.PID;
  showCamID(camID);
  e=s->set_framesize(s,FRAMESIZE_QQVGA);  //framesize_t from sensor.h
  if(e==ESP_OK){
    Serial.println("Set Framesize OK");
  }else{
    Serial.printf("Set framesize; error %d.\r\n",e);
  }
}

void loop() {       //this displays at actual size
  camera_fb_t *fb = NULL;
  uint8_t* out;     //for bitmap data
  size_t out_len;   //length of bitmap data
  e=ESP_OK;
  fb = esp_camera_fb_get();
  if(fb){
    if(frame2bmp(fb,&out,&out_len)){    //convert from jpg to bmp
      drawBitMap(out,0,0,width,height);      //this should centre the image
    }else{
      Serial.println("Convert to BMP capture failed.");  
      delay(100);
    }
  }else{
    Serial.println("Camera capture failed.");
    delay(100);
  }
  free(out);                  //release bitmap buffer
  esp_camera_fb_return(fb);   //release frame buffer
}

void drawBitMap( uint8_t * bm,unsigned int x,unsigned int y,unsigned int w,unsigned int h){  //draw bm to x,y, cropping (centred) to w,h if needed
  unsigned int bmw, bmh,cvw,cvh;  //bitmap, canvas= actual area drawn
  unsigned int bmx=0,bmy=0;       //top left corner of drawn part of bitmap
  unsigned int u,v;               //counters
  BMPHeader_t* header;  
  uint8_t* rowData;
  header=(BMPHeader_t*)bm;  //header is at start of bitmap data
  bmw=abs(header->width);
  bmh=abs(header->height);
  if(bmw>w){cvw=w;bmx=(bmw-cvw)/2;}else{cvw=bmw;x=x+(w-bmw)/2;}
  if(bmh>h){cvh=h;bmy=(bmh-cvh)/2;}else{cvh=bmh;y=y+(h-bmh)/2;}
  setarea(x,y,x+cvw-1,y+cvh-1);
  digitalWrite(LCDCS,LOW);
  for(v=0;v<cvh;v++){
    rowData=getRow(header,v+bmy);
    if(rowData){
      for(u=0;u<cvw*3;u=u+3){   //RGB triplets
        data8(rowData[u+bmx*3+2]);  //RGB<>BGR order
        data8(rowData[u+bmx*3+1]);
        data8(rowData[u+bmx*3+0]);
      }
    }else{
      for(u=0;u<cvw*3;u++){
        data8(128);   //grey
      }
    }
  }
  digitalWrite(LCDCS,HIGH);
  Serial.printf("%d x %d bitmap cropped to %d x %d pixels for display.\r\n",bmw,bmh,cvw,cvh);
}