#PICAXE 08M2
; Version 1.0 Rowan Wigmore July 2021
pause 3000	; display init time
disconnect ; disable programming input to allow PB switch to operate
let dirs = %00000110 ; Configure pins 1,2 as outputs. 

fan:
count C.3,1000, b1 ; count pulses in 1 second (at 4MHz)
if b1>40 then gosub fanok
if b1<30 then fanfail

read 0,b3 ; read last set temp from eeprom
pause 100
b2=b3 ;eeprom compare value

setting:
serout 0,N2400,("?f") ; clear display and move to start of first line
serout 0,N2400,("Adjust Temperature","??") ; output text
serout 0,N2400,("?n") ; move to start of second line
serout 0,N2400,(" Temp set to ",#b3,"?7","C") ; output text
for b7 = 1 to 100	; define loop for 100 times
if pinC.5=1 then gosub incr
pause 100 next b7 ; end of loop
if b2<>b3 then write 0,b3 endif ;write value to eeprom if new

main:
serout 0,N2400,("?f") ; clear display and move to start of first line
serout 0,N2400,("   Temp set = ",#b3,"?7","C") ; output text

dstemp:
readtemp C.4,b0 ; read input 4 into variable b0
if b0>127 then let b0=0 endif ; test for negative and call it zero
serout 0,N2400,("?y1?l") ; move to start of second line
serout 0,N2400,("Actual Temp = ",#b0,"?7","C") ; output text
pause 1000
if b0<b3 then high C.1 endif ;turn heater on
if b0>b3 then low C.1 b4=1 endif ;turn heater off, set flag (b4) for undertemp.
b6=b3-3 ;undertemp setting
b7=b3+2 ;overtemp setting
if b0>b7 then gosub hialarm ;hi temp alarm
if b0<b6 and b4>0 then goto loalarm ;low temp alarm

count C.3,1000, b1 ; count pulses in 1 second (at 4MHz)
if b1<30 then fanfail

goto dstemp; loop back to start

incr:
pause 50
b3=b3+1
if b3=37 then let b3=25 endif
serout 0,N2400,("?f") ; clear display and move to start of first line
serout 0,N2400,(" Setting ... ",#b3,"?7","C") ; output text
return

loalarm:
serout 0,N2400,("?f") ; clear display and move to start of first line
serout 0,N2400,("  Low Temperature!") ; output text
for b9 = 1 to 3
high C.2 ; switch output 2 on
pause 200 ; wait 200ms
low C.2 ;switch output 2 off
if pinC.5=1 then goto rstalm ; alarm muter
pause 200
next b9
goto main

rstalm:
low C.2
b4=0
goto main

hialarm:
low C.1 ; turn heat off
serout 0,N2400,("?f") ; clear display and move to start of first line
serout 0,N2400,("  HIGH TEMP ALARM") ; output text
pause 100
serout 0,N2400,("?y1?l")
serout 0,N2400,("  SYSTEM SHUTDOWN") ; output text
goto noise

fanok:
serout 0,N2400,("?f") ; clear display and move to start of first line
serout 0,N2400,("      Fan OK") ;output result
pause 2000
return

fanfail:
serout 0,N2400,("?f") ; clear display and move to start of first line
serout 0,N2400,("    FAN FAILURE") ; output text
pause 100
serout 0,N2400,("?y1?l")
serout 0,N2400,("  SYSTEM SHUTDOWN") ; output text
low C.1; shutdown heater
goto noise

noise:
for b9 = 1 to 7
high C.2 ; switch output 2 alarm on
pause 200 ; wait 200ms
low C.2 ;switch output 2 alarm off
pause 200
next b9
pause 2000
goto noise


