'########################################
'# Data Logger with RTC                 #
'# Written by GM, Sept 2016		    #
'########################################

'Two serial ports are used in this program: 
'sertxd (program port) for communications with a local terminal eg setting time &
'debugging, and
'serout (c.7)for items which will be logged by the OpenLog module.
'c.2 is ADC1, the voltage monitor connected to the power feed. 17v max.
'b.2 is ADC2, set for 17v max
'b.3 is ADC3, set for 4v max.
'b.6 is the low volts alarm output
'When the cpu is powered up, there is an option to enter RTC setup mode.
'If the option is not taken up within 8 sec, then the software will
'automatically continue with the current RTC setting.
'The OpenLog module contains a start up script in the Module's SD card and does not
'require an initialization routine here.
'There is only 1 CALC subroutine for all ADCs. If greater accuracy is required for
'both 12v ADC ports, the CALC subroutines may be duplicated for each ADC port.

#picaxe 18m2

 'Initialize
 symbol loop_time=5		'sample rate. Time in secs between each read-log.
 					'Change this value as needed.
					'Note 500ms extra pause and total code latency
 symbol lowvolts=1		'set low volts alarm point as required
 					'This is raw ADC value (Word length) NOT volts. 
					'1 effectively disables the Alarm
 symbol alarm1=B.6		'define alarm output port
 low alarm1				'reset output
 
					'No point in defining symbols for ADC ports since 
					'they are only used once in the code.
Main:
	pause 1000			'let the Openlog module start up and settle
	'log startup
	serout c.7,T2400,("Power Up",cr,lf)	'log the power up event

	'DS1307 setup
	 pause 500
	' Set up i2c for device 
	 hi2csetup i2cmaster,%11010000,i2cslow,i2cbyte   '%11010000 is i2c bus address
	' Configure clock control register and set time/date
	'allow setting of RTC if Editor terminal is connected to program port,
	'it needs a flush char or CR after each number (ie character). This means
	'that each numeric character is entered followed by a flush character (eg z).
	'Using the Editor, the whole date and time string with flush chars, can be
	'assembled in the Editor Terminal SEND dialogue box and sent as one string.
	sertxd ("Press 1z to set RTC or else skip will occur in 8 secs", cr,lf)
	disconnect
	serrxd [9000],#b4		'get response or timeout and continue
	reconnect
	if b4!=1 then goto getdata 'if not 1, then go straight to application

	'set RTC
	tm1:
	'if Editor terminal is connected to program port,
	'then it needs a flush char or CR after each number (ie character).
	sertxd ("input HH MM DD MM YY with z or CR between each character (ie HzHz..)",cr,lf)
	disconnect
	serrxd [9000],#b3,#b4,#b1,#b2,#b5,#b6,#b7,#b8,#b9,#b10
	reconnect
	'check for valid input if timeout occurs and loop if there is not an input
	if b5=0 and b6=0 then goto tm1
	'report to the Terminal (not logged) what was entered to terminal for a check
	sertxd ("input was; ",#b3,#b4,#b1,#b2,#b5,#b6,#b7,#b8,#b9,#b10, cr,lf)
	'convert time input to BCD for loading to RTC
		b1=b1*16	'Mins MSD
		b1=b1+b2	'Mins total
		b3=b3*16	'Hrs MSD
		b3=b3+b4	'Hrs total
		b5=b5*16	'Day MSD
		b5=b5+b6	'Day total
		b7=b7*16	'Month MSD
		b7=b7+b8	'Month total
		b9=b9*16	'Year MSD
		b9=b9+b10	'Year total

	'load BCD time to RTC. Note that Day Of Week is a dummy number
	hi2cout 0, ($00,b1,b3,$04,b5,b7,b9,%00010000)
	   'sec & oscillator enable, Min, Hr, DoW, Day, Mo, Yr, Contorl register
	   'configure DS1307 with date/time and control register (%00010000)
	   'abitary DOW at $04
	   'highest bit of secs must be 0 to enable oscillator - set seconds at $00
	   'clk set feedback to Terminal
	sertxd ("RTC set",cr,lf)
	'Log clock set event
	serout c.7,T2400,("RTC set",cr,lf)
	
	'RTC set and ready. Begin logging
	getdata:		'main operating loop
		pause 500
		hi2csetup i2cmaster,%11010000,i2cslow,i2cbyte	'set RTC I2C
		'get current time
		'Presentation; day/month/year  hr:min:sec
			 hi2cin 4,(b0)    ' Day Read
			 bcdtoascii b0,b1,b2
			 sertxd (b1,b2,"/")    ' Write output to terminal for debug
			 serout c.7,T2400,(b1,b2,"/")
			 hi2cin 5,(b0)    ' Month Read
			 bcdtoascii b0,b1,b2
			 sertxd (b1,b2,"/")    ' Write output to terminal for debug
			 serout c.7,T2400,(b1,b2,"/")
			 hi2cin 6,(b0)    ' Year Read  
			 bcdtoascii b0,b1,b2   
			 sertxd (b1,b2)    ' Write output to terminal for debug
			 serout c.7,T2400,(b1,b2)
			 hi2cin 2,(b0)    ' Hour Read from register 2
			 bcdtoascii b0,b1,b2
			 sertxd (" ",b1,b2)    ' Write output to terminal for debug
			 serout c.7,T2400,(" ",b1,b2)
			 hi2cin 1,(b0)    ' Minute Read from register 1
			 bcdtoascii b0,b1,b2
			 sertxd (":",b1,b2)    ' Write output to terminal for debug
			 serout c.7,T2400,(":",b1,b2)
			 hi2cin 0,(b0)    ' Second Read from register 0
			 bcdtoascii b0,b1,b2
			 sertxd (":",b1,b2,"-> ",cr,lf)    ' Write output to terminal for debug
			 serout c.7,T2400,(":",b1,b2,"-> ",cr,lf)
		 
		'get voltage 
		'set ADC reference to 4.0946v before each ADC read
		 FVRSETUP FVR4096		'set Fixed Voltage Reference to 4.096v
		 ADCCONFIG %011		'set ADC to FVR
		'get ADC 1, Default power input. 
		'4mv per step with 1024 steps before voltage divider.
		'Voltage divider set to 56:236 of input =4.2. Therefore 4mv * 4.2=16.86mv per step. 
		readadc10 C.2, W6
			'convert steps to volts. Limiting case is 1024 steps * 16.86mv = 17.264v
			gosub calc
			bintoascii w6,b1,b2,b3,b4,b5
			serout c.7,T2400,("ADC1: ",b1,b2,".",b3,b4,b5,"v",cr,lf)
			sertxd ("ADC1: ",b1,b2,".",b3,b4,b5,"v",cr,lf)

		;check alarm point for low reading on ADC1
		if w6 < lowvolts then
			high alarm1		'may need to add hysteresis
			else low alarm1
		endif
		
		'set ADC reference to 4.0946v before each ADC read
		 FVRSETUP FVR4096		'set Fixed Voltage Reference to 4.096v
		 ADCCONFIG %011		'set ADC to FVR
		'get ADC 2, Scaled input. 4mv per step with 1024 steps before voltage divider.
		'Voltage divider set to 56:236 of input =4.2. 
		'Therefore 4mv * 4.2=16.86mv per step. 
		readadc10 b.2, W6
		'convert steps to volts. Limiting case is 1024 steps * 16.86mv = 17,264mv
			gosub calc
			bintoascii w6,b1,b2,b3,b4,b5
			serout c.7,T2400,("ADC2: ",b1,b2,".",b3,b4,b5,"v",cr,lf)
			'sertxd ("ADC2: ",b1,b2,".",b3,b4,b5,"v",cr,lf)
			
		'set ADC reference to 4.0946v before each ADC read
		 FVRSETUP FVR4096		'set Fixed Voltage Reference to 4.096v
		 ADCCONFIG %011		'set ADC to FVR
		'get ADC 3. GP input for low voltage or current sensor. 
		'4mv per step with 1024 steps.
		'Voltage divider set to 50:51 of input=1.02. 
		'Therefore 4mv * 1.02=4.08mv per step. 
		readadc10 b.3, w6
			'convert steps to volts. Limiting case is 1024 steps * 4.08mv = 4,178mv
			w8=w6/50	'get 2%
			w6=w6+w8	'add 2%

			bintoascii w6,b1,b2,b3,b4,b5
			serout c.7,T2400,("ADC3: ",b1,b2,".",b3,b4,b5,"v",cr,lf)
			'sertxd ("ADC3: ",b1,b2,".",b3,b4,b5,"v",cr,lf)

		 'loop delay
		 wait loop_time
	 
	 goto getdata	'loop to start
	 
'subroutine to calculate voltage for the 12v ADC ports
calc:		'adc value is in w6.
	'convert steps to volts. Limiting case is 1024 steps * 16.86mv = 17,264mv
	w9=w6
	w6=w6*16	'first factor 16.86 into 16 + 43/100 + 43/100
	w8=w9*37	'half of .83 x 100=41, add any CALIBRATION factor here
	w8=w8/100	'divide to resore decimal
	w8=w8*2	'x 2 to bring back to .83
	w6=w6+w8	'add to first factor
	return
	
	