import time
import RPi.GPIO as GPIO
import re
from mod_python import apache
import urllib

def index(req, action = '', prev_action = ''):
    pins = [ 26, 20, 21 ]
    pulse_ms = 500

    req.headers_out['Pragma'] = 'no-cache'
    req.headers_out['Cache-Control'] = 'no-cache'
    req.headers_out['Expires'] = '-1'
    GPIO.setwarnings(False)
    GPIO.setmode(GPIO.BCM)

    if action != '':
        output = 0
        dowhat = 'pulse'
        output = 1 if action == 'pulse output 1' or action == 'output 1 on' or action == 'output 1 off' else output
        output = 2 if action == 'pulse output 2' or action == 'output 2 on' or action == 'output 2 off' else output
        output = 3 if action == 'pulse output 3' or action == 'output 3 on' or action == 'output 3 off' else output
        dowhat = 'on' if action == 'output 1 on' or action == 'output 2 on' or action == 'output 3 on' else dowhat
        dowhat = 'off' if action == 'output 1 off' or action == 'output 2 off' or action == 'output 3 off' else dowhat
        if output > 0:
            GPIO.setup(pins[output-1], GPIO.OUT)
            if dowhat != 'off':
                GPIO.output(pins[output-1], GPIO.LOW)
            if dowhat == 'pulse':
                time.sleep(pulse_ms/1000.0)
            if dowhat != 'on':
                GPIO.output(pins[output-1], GPIO.HIGH)
            req.headers_out['location'] = req.uri + '?prev_action=' + urllib.quote(action)
            req.status = apache.HTTP_MOVED_PERMANENTLY
            return "You are being redirected"

    if GPIO.gpio_function(pins[0]) == GPIO.OUT:
        GPIO.setup(pins[0], GPIO.OUT)
    if GPIO.gpio_function(pins[1]) == GPIO.OUT:
        GPIO.setup(pins[1], GPIO.OUT)
    if GPIO.gpio_function(pins[2]) == GPIO.OUT:
        GPIO.setup(pins[2], GPIO.OUT)

    msg = "<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n"
    msg += "<title>Silicon Chip Remote Switch</title>"
    if re.search('\\b(?:iPhone|Android)\\b', req.headers_in['User-Agent']) != None:
        msg += "<style>body{zoom: 275%}</style>"
    msg += "</head><body>\n"
    msg += "<form method=\"get\">\n"
    msg += " <input type=\"submit\" name=\"action\" value=\"pulse output 1\"> &nbsp; <input type=\"submit\" name=\"action\" value=\"output 1 on\"> &nbsp; <input type=\"submit\" name=\"action\" value=\"output 1 off\">"
    if prev_action == "pulse output 1":
      msg += " PULSED"
    else:
      msg += " OFF" if GPIO.gpio_function(pins[0]) != GPIO.OUT or GPIO.input(pins[0]) else " ON"
    msg += "<br><br>\n";
    msg += " <input type=\"submit\" name=\"action\" value=\"pulse output 2\"> &nbsp; <input type=\"submit\" name=\"action\" value=\"output 2 on\"> &nbsp; <input type=\"submit\" name=\"action\" value=\"output 2 off\">"
    if prev_action == "pulse output 2":
      msg += " PULSED"
    else:
      msg += " OFF" if GPIO.gpio_function(pins[1]) != GPIO.OUT or GPIO.input(pins[1]) else " ON"
    msg += "<br><br>\n";
    msg += " <input type=\"submit\" name=\"action\" value=\"pulse output 3\"> &nbsp; <input type=\"submit\" name=\"action\" value=\"output 3 on\"> &nbsp; <input type=\"submit\" name=\"action\" value=\"output 3 off\">"
    if prev_action == "pulse output 3":
      msg += " PULSED"
    else:
      msg += " OFF" if GPIO.gpio_function(pins[2]) != GPIO.OUT or GPIO.input(pins[2]) else " ON"
    msg += "\n</form></body></html>";

    return msg
