#include <nRF24L01.h>
#include <RF24.h>
#include <RF24_config.h>

#include <RF24Network.h>
#include <RF24Network_config.h>
#include <Sync.h>

#include <nRF24L01.h>
#include <RF24.h>
#include <RF24_config.h>

#include <SPI.h>
#include <nRF24L01.h>
#include <RF24.h>
#include "printf.h"

#include <avr/power.h>
#include <avr/sleep.h>
#include <dht.h>     //Library for DHT22
#include "LowPower.h"  //8 sec timer to use

dht DHT;
#define DHTPIN 8     // connected to digital pin-13

//RF24 radio(9,10);

RF24 radio(9,10);

const byte rxAddr[6] = "00001";
const uint64_t pipe = 0xE8E8F0F0E1LL;

float h,t,f;
byte intCounter, adcsra, mcucr1, mcucr2;
int data[5];
int chk1=0;
char text[16];

int tx_power=3;
int dht_power=4;

int mins = 0;
int hrs = 0;

void setup(){
// slow clock down to 4 MHz so that it can work at 1.8 volt
clock_prescale_set (clock_div_2);

pinMode(tx_power, OUTPUT);          
pinMode(dht_power,OUTPUT);
digitalWrite(tx_power,HIGH);
digitalWrite(dht_power,HIGH);   

  Serial.begin(9600);
  printf_begin();
  radio.begin();
  radio.setRetries(15, 15);

radio.setPALevel( RF24_PA_MAX ) ; 
radio.setPayloadSize(32); // setting the payload size to the needed value
radio.setDataRate(RF24_250KBPS); // reducing bandwidth
radio.setChannel(108);
  
//radio.openWritingPipe(rxAddr);
radio.openWritingPipe(pipe); // set the transmitter address
radio.stopListening();
radio.printDetails();
}


void loop(){
  radio.powerUp();  
  
//if (radio.available()) {  
  
for (byte i=0; i<1; i++) {
pinMode(DHTPIN,INPUT);
digitalWrite(DHTPIN,LOW);

pinMode(tx_power,OUTPUT);
digitalWrite(tx_power, HIGH);
         
pinMode(dht_power,OUTPUT);
digitalWrite(dht_power, HIGH);

mins = mins+1;
if (mins>99) mins=0;
getdata();
sprintf(text, "%4d:%4d:%2d", data[1],data[2],mins);
delay(1000);
radio.write(&text, sizeof(text));
}

digitalWrite(dht_power, LOW);
pinMode(DHTPIN,INPUT);
digitalWrite(DHTPIN,LOW);
pinMode(dht_power,INPUT);
digitalWrite(dht_power, LOW);
pinMode(tx_power,INPUT);
digitalWrite(tx_power, LOW);
//delay(10);

/*
LowPower.powerDown(SLEEP_2S, ADC_OFF, BOD_OFF); 
*/

radio.powerDown ();

for(int ti=0;ti<5;ti++)   //upto 5*8 this works OK
LowPower.powerDown(SLEEP_8S, ADC_OFF, BOD_OFF); 

radio.powerUp();
radio.openWritingPipe(pipe); // set the transmitter address
radio.stopListening();


}


void getdata() {
 uint32_t start = micros();
 int chk = DHT.read22(DHTPIN);
 uint32_t stop = micros();
  data[0]=hrs;

  h=  DHT.humidity;
  t=  DHT.temperature;
  data[1]=h*100;
  data[2]=t*100;
  }  


