#include <SPI.h>
#include <nRF24L01.h>
#include <RF24.h>
#include "printf.h"

#include <Wire.h>     // for I2C
#include <Adafruit_GFX.h>

#include <Adafruit_SSD1306.h>
#define OLED_RESET 4
Adafruit_SSD1306 display(OLED_RESET);

#include <avr/sleep.h>
#include "LowPower.h"  //8 sec timer to use
#include <avr/power.h>



#if defined(_GFXFONT_H_)           //are we using the new library?
#include <Fonts/FreeSans9pt7b.h>
#else
#endif

RF24 radio(9,10 );

const byte rxAddr[6] = "00001";
const uint64_t pipe = 0xE8E8F0F0E1LL;

void setup(){
// slow clock down to 4 MHz so that it can work at 1.8 volt
clock_prescale_set (clock_div_2);
  
  
//  while (!Serial);
  Serial.begin(9600);
    printf_begin();
  radio.begin();
  
radio.setPALevel( RF24_PA_MAX ) ; 
radio.setPayloadSize(32); // setting the payload size to the needed value
radio.setDataRate(RF24_250KBPS); // reducing bandwidth
radio.setChannel(108);
 
  

//  radio.openReadingPipe(0, rxAddr);
radio.openReadingPipe(1, pipe); // Open one of the 6 pipes for reception
radio.startListening();
radio.printDetails();


display.begin(SSD1306_SWITCHCAPVCC, 0x3C);  // initialize with the I2C addr 0x3D (for the 128x64)
display.display();
delay(100);
display.clearDisplay();
//display.println('&radio.printDetails()');
//delay(2000);        
//display.display();    






}
int i=0;
int j=0;


void loop(){
  radio.powerUp();
  
//  radio.printDetails();  
    if (radio.available()) {
    char text[32] = {0};
    radio.read(&text, sizeof(text));
    Serial.print(j);
    Serial.print(':');
    Serial.print(i);
    Serial.print(':');
    Serial.println(text);

display.clearDisplay();
display.setTextSize(1);
display.setTextColor(1);
display.setCursor(0,0);
//display.println("Humidity  Temp (Cent)");
display.setTextSize(1);
display.setCursor(0,0);
display.print(text[10]);
display.print(text[11]);
display.print(':');
//display.print(i);
//display.print(" ");

display.setTextSize(2);
display.print("H:");
display.print(text[0]);
display.print(text[1]);
display.print('.');
display.print(text[2]);
display.println("%");

display.print(' ');
display.print(' ');
display.print("T:");
display.print(text[5]);
display.print(text[6]);
display.print('.');
display.print(text[7]);
display.print('C');

display.display();    

i=i+1;

if (i>59){i=0;j=j+1;}

radio.powerDown ();
for(int ti=0;ti<4;ti++) {  //upto 5*8 this works OK
LowPower.powerDown(SLEEP_8S, ADC_OFF, BOD_OFF); 
}
//delay(10000);
radio.powerUp();
radio.startListening();

  }
}



