#define SMALL_FONT_WIDTH 6
#define SMALL_FONT_HEIGHT 12

//16-bit colours
#define COLOUR_BLACK 0x0000
#define COLOUR_RED 0xF800
#define COLOUR_GREEN 0x07E0
#define COLOUR_BLUE 0x001F
#define COLOUR_CYAN 0x07FF
#define COLOUR_MAGENTA 0xF81F
#define COLOUR_YELLOW 0xFFE0
#define COLOUR_WHITE 0xFFFF
//#define COLOUR_GREY 0x8410
#define COLOUR_GREY 0x4208

const char cNames[][8]={
  "BLACK",
  "RED",
  "GREEN",
  "YELLOW",
  "BLUE",
  "MAGENTA",
  "CYAN",
  "WHITE"
};

const uint16_t termColours[]={
  COLOUR_BLACK,COLOUR_RED,COLOUR_GREEN,COLOUR_YELLOW,
  COLOUR_BLUE,COLOUR_MAGENTA,COLOUR_CYAN,COLOUR_WHITE
};

const uint8_t font_8x8[] = {
    0x00, 0x7E, 0x7E, 0x6C, 0x10, 0x38, 0x10, 0x00, 0xFF, 0x00, 0xFF, 0x0F,
    0x3C, 0x3F, 0x7F, 0x99, 0x80, 0x02, 0x18, 0x66, 0x7F, 0x3E, 0x00, 0x18,
    0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x6C, 0x6C,
    0x30, 0x00, 0x38, 0x60, 0x18, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06,
    0x7C, 0x30, 0x78, 0x78, 0x1C, 0xFC, 0x38, 0xFC, 0x78, 0x78, 0x00, 0x00,
    0x18, 0x00, 0x60, 0x78, 0x7C, 0x30, 0xFC, 0x3C, 0xF8, 0xFE, 0xFE, 0x3C,
    0xCC, 0x78, 0x1E, 0xE6, 0xF0, 0xC6, 0xC6, 0x38, 0xFC, 0x78, 0xFC, 0x78,
    0xFC, 0xCC, 0xCC, 0xC6, 0xC6, 0xCC, 0xFE, 0x78, 0xC0, 0x78, 0x10, 0x00,
    0x30, 0x00, 0xE0, 0x00, 0x1C, 0x00, 0x38, 0x00, 0xE0, 0x30, 0x0C, 0xE0,
    0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x1C, 0x18, 0xE0, 0x76, 0x00, 0x78, 0x00, 0x1C, 0x7E,
    0xCC, 0xE0, 0x30, 0x00, 0x7E, 0xCC, 0xE0, 0xCC, 0x7C, 0xE0, 0xC6, 0x30,
    0x1C, 0x00, 0x3E, 0x78, 0x00, 0x00, 0x78, 0x00, 0x00, 0xC3, 0xCC, 0x18,
    0x38, 0xCC, 0xF8, 0x0E, 0x1C, 0x38, 0x00, 0x00, 0x00, 0xFC, 0x3C, 0x38,
    0x30, 0x00, 0x00, 0xC3, 0xC3, 0x18, 0x00, 0x00, 0x22, 0x55, 0xDB, 0x18,
    0x18, 0x18, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x18, 0x00,
    0x18, 0x18, 0x00, 0x18, 0x00, 0x18, 0x18, 0x36, 0x36, 0x00, 0x36, 0x00,
    0x36, 0x00, 0x36, 0x18, 0x36, 0x00, 0x00, 0x36, 0x18, 0x00, 0x00, 0x36,
    0x18, 0x18, 0x00, 0xFF, 0x00, 0xF0, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0x00,
    0xFC, 0x00, 0x00, 0x00, 0xFC, 0x38, 0x38, 0x1C, 0x00, 0x06, 0x38, 0x78,
    0x00, 0x30, 0x60, 0x18, 0x0E, 0x18, 0x30, 0x00, 0x38, 0x00, 0x00, 0x0F,
    0x78, 0x70, 0x00, 0x00, 0x00, 0x81, 0xFF, 0xFE, 0x38, 0x7C, 0x10, 0x00,
    0xFF, 0x3C, 0xC3, 0x07, 0x66, 0x33, 0x63, 0x5A, 0xE0, 0x0E, 0x3C, 0x66,
    0xDB, 0x63, 0x00, 0x3C, 0x3C, 0x18, 0x18, 0x30, 0x00, 0x24, 0x18, 0xFF,
    0x00, 0x78, 0x6C, 0x6C, 0x7C, 0xC6, 0x6C, 0x60, 0x30, 0x30, 0x66, 0x30,
    0x00, 0x00, 0x00, 0x0C, 0xC6, 0x70, 0xCC, 0xCC, 0x3C, 0xC0, 0x60, 0xCC,
    0xCC, 0xCC, 0x30, 0x30, 0x30, 0x00, 0x30, 0xCC, 0xC6, 0x78, 0x66, 0x66,
    0x6C, 0x62, 0x62, 0x66, 0xCC, 0x30, 0x0C, 0x66, 0x60, 0xEE, 0xE6, 0x6C,
    0x66, 0xCC, 0x66, 0xCC, 0xB4, 0xCC, 0xCC, 0xC6, 0xC6, 0xCC, 0xC6, 0x60,
    0x60, 0x18, 0x38, 0x00, 0x30, 0x00, 0x60, 0x00, 0x0C, 0x00, 0x6C, 0x00,
    0x60, 0x00, 0x00, 0x60, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x18, 0x30, 0xDC, 0x10,
    0xCC, 0xCC, 0x00, 0xC3, 0x00, 0x00, 0x30, 0x00, 0xC3, 0x00, 0x00, 0x00,
    0xC6, 0x00, 0x38, 0x30, 0x00, 0x00, 0x6C, 0xCC, 0xCC, 0xE0, 0xCC, 0xE0,
    0xCC, 0x18, 0x00, 0x18, 0x6C, 0xCC, 0xCC, 0x1B, 0x00, 0x00, 0x1C, 0x1C,
    0xF8, 0x00, 0x6C, 0x6C, 0x00, 0x00, 0x00, 0xC6, 0xC6, 0x18, 0x33, 0xCC,
    0x88, 0xAA, 0x77, 0x18, 0x18, 0x18, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00,
    0x36, 0x36, 0x18, 0x00, 0x18, 0x18, 0x00, 0x18, 0x00, 0x18, 0x18, 0x36,
    0x36, 0x00, 0x36, 0x00, 0x36, 0x00, 0x36, 0x18, 0x36, 0x00, 0x00, 0x36,
    0x18, 0x00, 0x00, 0x36, 0x18, 0x18, 0x00, 0xFF, 0x00, 0xF0, 0x0F, 0xFF,
    0x00, 0x78, 0xFC, 0xFE, 0xCC, 0x00, 0x66, 0x76, 0x30, 0x6C, 0x6C, 0x30,
    0x00, 0x0C, 0x60, 0xCC, 0xFC, 0x30, 0x30, 0x30, 0x1B, 0x18, 0x30, 0x76,
    0x6C, 0x00, 0x00, 0x0C, 0x6C, 0x18, 0x00, 0x00, 0x00, 0xA5, 0xDB, 0xFE,
    0x7C, 0x38, 0x38, 0x18, 0xE7, 0x66, 0x99, 0x0F, 0x66, 0x3F, 0x7F, 0x3C,
    0xF8, 0x3E, 0x7E, 0x66, 0xDB, 0x38, 0x00, 0x7E, 0x7E, 0x18, 0x0C, 0x60,
    0xC0, 0x66, 0x3C, 0xFF, 0x00, 0x78, 0x6C, 0xFE, 0xC0, 0xCC, 0x38, 0xC0,
    0x60, 0x18, 0x3C, 0x30, 0x00, 0x00, 0x00, 0x18, 0xCE, 0x30, 0x0C, 0x0C,
    0x6C, 0xF8, 0xC0, 0x0C, 0xCC, 0xCC, 0x30, 0x30, 0x60, 0xFC, 0x18, 0x0C,
    0xDE, 0xCC, 0x66, 0xC0, 0x66, 0x68, 0x68, 0xC0, 0xCC, 0x30, 0x0C, 0x6C,
    0x60, 0xFE, 0xF6, 0xC6, 0x66, 0xCC, 0x66, 0xE0, 0x30, 0xCC, 0xCC, 0xC6,
    0x6C, 0xCC, 0x8C, 0x60, 0x30, 0x18, 0x6C, 0x00, 0x18, 0x78, 0x60, 0x78,
    0x0C, 0x78, 0x60, 0x76, 0x6C, 0x70, 0x0C, 0x66, 0x30, 0xCC, 0xF8, 0x78,
    0xDC, 0x76, 0xDC, 0x7C, 0x7C, 0xCC, 0xCC, 0xC6, 0xC6, 0xCC, 0xFC, 0x30,
    0x18, 0x30, 0x00, 0x38, 0xC0, 0x00, 0x78, 0x3C, 0x78, 0x78, 0x78, 0x78,
    0x3C, 0x78, 0x78, 0x70, 0x38, 0x70, 0x6C, 0x00, 0xFC, 0x7F, 0xCC, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0xCC, 0x7E, 0x64, 0x78, 0xCC, 0x18,
    0x78, 0x70, 0x00, 0x00, 0x00, 0xCC, 0x6C, 0x6C, 0x30, 0x00, 0x00, 0xCC,
    0xCC, 0x00, 0x66, 0x66, 0x22, 0x55, 0xDB, 0x18, 0x18, 0xF8, 0x36, 0x00,
    0xF8, 0xF6, 0x36, 0xFE, 0xF6, 0x36, 0xF8, 0x00, 0x18, 0x18, 0x00, 0x18,
    0x00, 0x18, 0x1F, 0x36, 0x37, 0x3F, 0xF7, 0xFF, 0x37, 0xFF, 0xF7, 0xFF,
    0x36, 0xFF, 0x00, 0x36, 0x1F, 0x1F, 0x00, 0x36, 0xFF, 0x18, 0x00, 0xFF,
    0x00, 0xF0, 0x0F, 0xFF, 0x76, 0xCC, 0xCC, 0x6C, 0x60, 0x7E, 0x66, 0xDC,
    0x78, 0xC6, 0xC6, 0x18, 0x7E, 0x7E, 0xC0, 0xCC, 0x00, 0xFC, 0x18, 0x60,
    0x1B, 0x18, 0x00, 0xDC, 0x6C, 0x00, 0x00, 0x0C, 0x6C, 0x30, 0x3C, 0x00,
    0x00, 0x81, 0xFF, 0xFE, 0xFE, 0xFE, 0x7C, 0x3C, 0xC3, 0x42, 0xBD, 0x7D,
    0x66, 0x30, 0x63, 0xE7, 0xFE, 0xFE, 0x18, 0x66, 0x7B, 0x6C, 0x00, 0x18,
    0x18, 0x18, 0xFE, 0xFE, 0xC0, 0xFF, 0x7E, 0x7E, 0x00, 0x30, 0x00, 0x6C,
    0x78, 0x18, 0x76, 0x00, 0x60, 0x18, 0xFF, 0xFC, 0x00, 0xFC, 0x00, 0x30,
    0xDE, 0x30, 0x38, 0x38, 0xCC, 0x0C, 0xF8, 0x18, 0x78, 0x7C, 0x00, 0x00,
    0xC0, 0x00, 0x0C, 0x18, 0xDE, 0xCC, 0x7C, 0xC0, 0x66, 0x78, 0x78, 0xC0,
    0xFC, 0x30, 0x0C, 0x78, 0x60, 0xFE, 0xDE, 0xC6, 0x7C, 0xCC, 0x7C, 0x70,
    0x30, 0xCC, 0xCC, 0xD6, 0x38, 0x78, 0x18, 0x60, 0x18, 0x18, 0xC6, 0x00,
    0x00, 0x0C, 0x7C, 0xCC, 0x7C, 0xCC, 0xF0, 0xCC, 0x76, 0x30, 0x0C, 0x6C,
    0x30, 0xFE, 0xCC, 0xCC, 0x66, 0xCC, 0x76, 0xC0, 0x30, 0xCC, 0xCC, 0xD6,
    0x6C, 0xCC, 0x98, 0xE0, 0x00, 0x1C, 0x00, 0x6C, 0xCC, 0xCC, 0xCC, 0x06,
    0x0C, 0x0C, 0x0C, 0xC0, 0x66, 0xCC, 0xCC, 0x30, 0x18, 0x30, 0xC6, 0x78,
    0x60, 0x0C, 0xFE, 0x78, 0x78, 0x78, 0xCC, 0xCC, 0xCC, 0x66, 0xCC, 0xC0,
    0xF0, 0xFC, 0xFA, 0x3C, 0x0C, 0x30, 0x78, 0xCC, 0xF8, 0xEC, 0x3E, 0x38,
    0x60, 0xFC, 0xFC, 0xDE, 0xDB, 0x18, 0xCC, 0x33, 0x88, 0xAA, 0xEE, 0x18,
    0x18, 0x18, 0x36, 0x00, 0x18, 0x06, 0x36, 0x06, 0x06, 0x36, 0x18, 0x00,
    0x18, 0x18, 0x00, 0x18, 0x00, 0x18, 0x18, 0x36, 0x30, 0x30, 0x00, 0x00,
    0x30, 0x00, 0x00, 0x00, 0x36, 0x00, 0x00, 0x36, 0x18, 0x18, 0x00, 0x36,
    0x18, 0x18, 0x00, 0xFF, 0x00, 0xF0, 0x0F, 0xFF, 0xDC, 0xF8, 0xC0, 0x6C,
    0x30, 0xD8, 0x66, 0x18, 0xCC, 0xFE, 0xC6, 0x7C, 0xDB, 0xDB, 0xF8, 0xCC,
    0xFC, 0x30, 0x30, 0x30, 0x18, 0x18, 0xFC, 0x00, 0x38, 0x18, 0x00, 0x0C,
    0x6C, 0x60, 0x3C, 0x00, 0x00, 0xBD, 0xC3, 0x7C, 0x7C, 0xFE, 0xFE, 0x3C,
    0xC3, 0x42, 0xBD, 0xCC, 0x3C, 0x30, 0x63, 0xE7, 0xF8, 0x3E, 0x18, 0x66,
    0x1B, 0x6C, 0x7E, 0x7E, 0x18, 0x7E, 0x0C, 0x60, 0xC0, 0x66, 0xFF, 0x3C,
    0x00, 0x30, 0x00, 0xFE, 0x0C, 0x30, 0xDC, 0x00, 0x60, 0x18, 0x3C, 0x30,
    0x00, 0x00, 0x00, 0x60, 0xF6, 0x30, 0x60, 0x0C, 0xFE, 0x0C, 0xCC, 0x30,
    0xCC, 0x0C, 0x00, 0x00, 0x60, 0x00, 0x18, 0x30, 0xDE, 0xFC, 0x66, 0xC0,
    0x66, 0x68, 0x68, 0xCE, 0xCC, 0x30, 0xCC, 0x6C, 0x62, 0xD6, 0xCE, 0xC6,
    0x60, 0xDC, 0x6C, 0x1C, 0x30, 0xCC, 0xCC, 0xFE, 0x38, 0x30, 0x32, 0x60,
    0x0C, 0x18, 0x00, 0x00, 0x00, 0x7C, 0x66, 0xC0, 0xCC, 0xFC, 0x60, 0xCC,
    0x66, 0x30, 0x0C, 0x78, 0x30, 0xFE, 0xCC, 0xCC, 0x66, 0xCC, 0x66, 0x78,
    0x30, 0xCC, 0xCC, 0xFE, 0x38, 0xCC, 0x30, 0x30, 0x18, 0x30, 0x00, 0xC6,
    0x78, 0xCC, 0xFC, 0x3E, 0x7C, 0x7C, 0x7C, 0xC0, 0x7E, 0xFC, 0xFC, 0x30,
    0x18, 0x30, 0xFE, 0xCC, 0x78, 0x7F, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC,
    0xCC, 0x66, 0xCC, 0xC0, 0x60, 0x30, 0xC6, 0x18, 0x7C, 0x30, 0xCC, 0xCC,
    0xCC, 0xFC, 0x00, 0x00, 0xC0, 0xC0, 0x0C, 0x33, 0x37, 0x18, 0x66, 0x66,
    0x22, 0x55, 0xDB, 0x18, 0xF8, 0xF8, 0xF6, 0xFE, 0xF8, 0xF6, 0x36, 0xF6,
    0xFE, 0xFE, 0xF8, 0xF8, 0x1F, 0xFF, 0xFF, 0x1F, 0xFF, 0xFF, 0x1F, 0x37,
    0x3F, 0x37, 0xFF, 0xF7, 0x37, 0xFF, 0xF7, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F,
    0x1F, 0x1F, 0x3F, 0xFF, 0xFF, 0xF8, 0x1F, 0xFF, 0xFF, 0xF0, 0x0F, 0x00,
    0xC8, 0xCC, 0xC0, 0x6C, 0x60, 0xD8, 0x66, 0x18, 0xCC, 0xC6, 0x6C, 0xCC,
    0xDB, 0xDB, 0xC0, 0xCC, 0x00, 0x30, 0x60, 0x18, 0x18, 0x18, 0x00, 0x76,
    0x00, 0x18, 0x18, 0xEC, 0x6C, 0x78, 0x3C, 0x00, 0x00, 0x99, 0xE7, 0x38,
    0x38, 0x7C, 0x7C, 0x18, 0xE7, 0x66, 0x99, 0xCC, 0x18, 0x70, 0x67, 0x3C,
    0xE0, 0x0E, 0x7E, 0x00, 0x1B, 0x38, 0x7E, 0x3C, 0x18, 0x3C, 0x18, 0x30,
    0xFE, 0x24, 0xFF, 0x18, 0x00, 0x00, 0x00, 0x6C, 0xF8, 0x66, 0xCC, 0x00,
    0x30, 0x30, 0x66, 0x30, 0x30, 0x00, 0x30, 0xC0, 0xE6, 0x30, 0xCC, 0xCC,
    0x0C, 0xCC, 0xCC, 0x30, 0xCC, 0x18, 0x30, 0x30, 0x30, 0xFC, 0x30, 0x00,
    0xC0, 0xCC, 0x66, 0x66, 0x6C, 0x62, 0x60, 0x66, 0xCC, 0x30, 0xCC, 0x66,
    0x66, 0xC6, 0xC6, 0x6C, 0x60, 0x78, 0x66, 0xCC, 0x30, 0xCC, 0x78, 0xEE,
    0x6C, 0x30, 0x66, 0x60, 0x06, 0x18, 0x00, 0x00, 0x00, 0xCC, 0x66, 0xCC,
    0xCC, 0xC0, 0x60, 0x7C, 0x66, 0x30, 0xCC, 0x6C, 0x30, 0xD6, 0xCC, 0xCC,
    0x7C, 0x7C, 0x60, 0x0C, 0x34, 0xCC, 0x78, 0xFE, 0x6C, 0x7C, 0x64, 0x30,
    0x18, 0x30, 0x00, 0xC6, 0x18, 0xCC, 0xC0, 0x66, 0xCC, 0xCC, 0xCC, 0x78,
    0x60, 0xC0, 0xC0, 0x30, 0x18, 0x30, 0xC6, 0xFC, 0x60, 0xCC, 0xCC, 0xCC,
    0xCC, 0xCC, 0xCC, 0xCC, 0x7C, 0x3C, 0xCC, 0x7E, 0xE6, 0xFC, 0xCF, 0x18,
    0xCC, 0x30, 0xCC, 0xCC, 0xCC, 0xDC, 0x7E, 0x7C, 0xCC, 0xC0, 0x0C, 0x66,
    0x6F, 0x18, 0x33, 0xCC, 0x88, 0xAA, 0x77, 0x18, 0x18, 0x18, 0x36, 0x36,
    0x18, 0x36, 0x36, 0x36, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x18,
    0x00, 0x18, 0x18, 0x36, 0x00, 0x36, 0x00, 0x36, 0x36, 0x00, 0x36, 0x00,
    0x00, 0x18, 0x36, 0x00, 0x00, 0x18, 0x36, 0x36, 0x18, 0x00, 0x18, 0xFF,
    0xFF, 0xF0, 0x0F, 0x00, 0xDC, 0xF8, 0xC0, 0x6C, 0xCC, 0xD8, 0x7C, 0x18,
    0x78, 0x6C, 0x6C, 0xCC, 0x7E, 0x7E, 0x60, 0xCC, 0xFC, 0x00, 0x00, 0x00,
    0x18, 0xD8, 0x30, 0xDC, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x3C, 0x00,
    0x00, 0x81, 0xFF, 0x10, 0x10, 0x38, 0x38, 0x00, 0xFF, 0x3C, 0xC3, 0xCC,
    0x7E, 0xF0, 0xE6, 0x5A, 0x80, 0x02, 0x3C, 0x66, 0x1B, 0xCC, 0x7E, 0x18,
    0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x6C,
    0x30, 0xC6, 0x76, 0x00, 0x18, 0x60, 0x00, 0x00, 0x30, 0x00, 0x30, 0x80,
    0x7C, 0xFC, 0xFC, 0x78, 0x1E, 0x78, 0x78, 0x30, 0x78, 0x70, 0x30, 0x30,
    0x18, 0x00, 0x60, 0x30, 0x78, 0xCC, 0xFC, 0x3C, 0xF8, 0xFE, 0xF0, 0x3E,
    0xCC, 0x78, 0x78, 0xE6, 0xFE, 0xC6, 0xC6, 0x38, 0xF0, 0x1C, 0xE6, 0x78,
    0x78, 0xFC, 0x30, 0xC6, 0xC6, 0x78, 0xFE, 0x78, 0x02, 0x78, 0x00, 0x00,
    0x00, 0x76, 0xDC, 0x78, 0x76, 0x78, 0xF0, 0x0C, 0xE6, 0x78, 0xCC, 0xE6,
    0x78, 0xC6, 0xCC, 0x78, 0x60, 0x0C, 0xF0, 0xF8, 0x18, 0x76, 0x30, 0x6C,
    0xC6, 0x0C, 0xFC, 0x1C, 0x18, 0xE0, 0x00, 0xFE, 0x0C, 0x7E, 0x78, 0x3F,
    0x7E, 0x7E, 0x7E, 0x0C, 0x3C, 0x78, 0x78, 0x78, 0x3C, 0x78, 0xC6, 0xCC,
    0xFC, 0x7F, 0xCE, 0x78, 0x78, 0x78, 0x7E, 0x7E, 0x0C, 0x18, 0x78, 0x18,
    0xFC, 0x30, 0xC6, 0xD8, 0x7E, 0x78, 0x78, 0x7E, 0xCC, 0xCC, 0x00, 0x00,
    0x78, 0x00, 0x00, 0xCC, 0xCF, 0x18, 0x00, 0x00, 0x22, 0x55, 0xDB, 0x18,
    0x18, 0x18, 0x36, 0x36, 0x18, 0x36, 0x36, 0x36, 0x00, 0x00, 0x00, 0x18,
    0x00, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x36, 0x00, 0x36, 0x00, 0x36,
    0x36, 0x00, 0x36, 0x00, 0x00, 0x18, 0x36, 0x00, 0x00, 0x18, 0x36, 0x36,
    0x18, 0x00, 0x18, 0xFF, 0xFF, 0xF0, 0x0F, 0x00, 0x76, 0xC0, 0xC0, 0x6C,
    0xFC, 0x70, 0x60, 0x18, 0x30, 0x38, 0xEE, 0x78, 0x00, 0x60, 0x38, 0xCC,
    0x00, 0xFC, 0xFC, 0xFC, 0x18, 0xD8, 0x30, 0x00, 0x00, 0x00, 0x00, 0x3C,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7E, 0x7E, 0x00, 0x00, 0x7C, 0x7C, 0x00,
    0xFF, 0x00, 0xFF, 0x78, 0x18, 0xE0, 0xC0, 0x99, 0x00, 0x00, 0x18, 0x00,
    0x00, 0x78, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8,
    0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x1E, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xF8, 0x00, 0x00, 0x18, 0x00, 0x30, 0xC7, 0x70, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x03, 0x00, 0x00, 0x00,
    0x88, 0xAA, 0xEE, 0x18, 0x18, 0x18, 0x36, 0x36, 0x18, 0x36, 0x36, 0x36,
    0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x36,
    0x00, 0x36, 0x00, 0x36, 0x36, 0x00, 0x36, 0x00, 0x00, 0x18, 0x36, 0x00,
    0x00, 0x18, 0x36, 0x36, 0x18, 0x00, 0x18, 0xFF, 0xFF, 0xF0, 0x0F, 0x00,
    0x00, 0xC0, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x00, 0xFC, 0x00, 0x00, 0x00,
    0x00, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x70, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x00};

/*
const char smallFont[] ={ //this is 6x8, not used in current version
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 

    0,0,0,0,0,0, // <space>
    0,0,95,0,0,0, // !
    0,3,0,3,0,0, // "
    20,62,20,62,20,0, // #
    36,42,127,42,18,0, // $
    34,16,8,36,34,0, // %
    54,73,73,54,72,0, // &
    0,0,2,1,0,0, // '
    0,28,34,65,0,0, // (
    0,65,34,28,0,0, // )
    0,20,8,20,0,0, // *
    8,8,62,8,8,0, // +
    0,128,64,0,0,0, // ,
    8,8,8,8,8,0, // -
    0,0,64,0,0,0, // .
    32,16,8,4,2,0, // /
    62,65,65,65,62,0, // 0
    0,66,127,64,0,0, // 1
    66,97,81,73,70,0, // 2
    34,65,73,73,54,0, // 3
    48,44,34,127,32,0, // 4
    39,69,69,69,57,0, // 5
    60,74,73,73,48,0, // 6
    1,1,97,25,7,0, // 7
    54,73,73,73,54,0, // 8
    6,73,73,73,62,0, // 9
    0,0,72,0,0,0, // :
    0,128,72,0,0,0, // ;
    0,8,20,34,65,0, // <
    40,40,40,40,40,0, // =
    65,34,20,8,0,0, // >
    2,1,81,9,6,0, // ?
    62,65,77,73,46,0, // @
    126,17,17,17,126,0, // A
    127,73,73,73,54,0, // B
    62,65,65,65,34,0, // C
    127,65,65,34,28,0, // D
    127,73,73,73,65,0, // E
    127,9,9,9,1,0, // F
    62,65,81,81,114,0, // G
    127,8,8,8,127,0, // H
    0,65,127,65,0,0, // I
    32,64,64,64,63,0, // J
    127,8,20,34,65,0, // K
    127,64,64,64,64,0, // L
    127,12,48,12,127,0, // M
    127,4,8,16,127,0, // N
    62,65,65,65,62,0, // O
    127,9,9,9,6,0, // P
    62,65,81,33,94,0, // Q
    127,9,25,41,70,0, // R
    38,73,73,73,50,0, // S
    1,1,127,1,1,0, // T
    63,64,64,64,63,0, // U
    7,24,96,24,7,0, // V
    127,48,12,48,127,0, // W
    99,20,8,20,99,0, // X
    7,8,112,8,7,0, // Y
    97,81,73,69,67,0, // Z
    0,127,65,65,0,0, // [
    2,4,8,16,32,0, // <backslash>
    0,65,65,127,0,0, // ]
    4,2,1,2,4,0, // ^
    64,64,64,64,64,0, // _
    248,64,64,56,64,0,  // mu/micro
    32,84,84,84,120,0, // a
    127,72,72,72,48,0, // b
    56,68,68,68,68,0, // c
    48,72,72,72,127,0, // d
    56,84,84,84,24,0, // e
    0,126,9,9,0,0, // f
    144,168,168,168,120,0, // g
    127,8,8,8,112,0, // h
    0,72,122,64,0,0, // i
    0,128,128,122,0,0, // j
    127,16,16,40,68,0, // k
    0,0,127,0,0,0, // l
    120,8,112,8,112,0, // m
    120,8,8,8,112,0, // n
    48,72,72,72,48,0, // o
    248,72,72,72,48,0, // p
    48,72,72,72,248,0, // q
    120,16,8,8,8,0, // r
    72,84,84,84,36,0, // s
    8,60,72,64,0,0, // t
    56,64,64,64,120,0, // u
    24,32,64,32,24,0, // v
    56,64,48,64,56,0, // w
    72,48,48,48,72,0, // x
    152,160,160,160,120,0, // y
    68,100,84,76,68,0, // z
    0,8,54,65,0,0, // {
    0,0,127,0,0,0, // |
    0,65,54,8,0,0, // }
    4,2,2,4,2,0, // ~
    0,0,0,0,0,0, 
};

*/

const uint16_t font0612[] ={
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 
    0,0,0,0,0,0, 

    0,0,0,0,0,0,			//space
    0,0,383,0,0,0,			//!
    0,3,0,3,0,0,			//"
    80,508,80,508,80,0, 	//#
    140,146,511,146,98,0,	//$
    386,101,146,332,131,0,	//%
    238,273,273,238,272,0,  //&
    0,0,3,0,0,0,			//'
    0,56,198,257,0,0,		//(
    0,257,198,56,0,0,		//)
    146,84,56,84,146,0,		//*
    16,16,254,16,16,0,		//+
    0,512,384,0,0,0,		//,
    16,16,16,16,16,0,		//-
    0,384,384,0,0,0,		//.
    384,96,16,12,3,0,		// slash
    254,353,273,269,254,0,	//0
    0,258,511,256,0,0,		//1
    386,321,289,273,270,0,	//2
    130,273,273,273,238,0,	//3
    96,92,66,511,64,0,		//4
    143,265,265,265,241,0,	//5
    252,274,273,273,224,0,	//6
    1,449,49,13,3,0,		//7
    238,273,273,273,238,0,	//8
    14,273,273,145,126,0,	//9
    0,408,408,0,0,0,		//:
    512,920,408,0,0,0,		//;
    16,40,68,130,257,0,		//<
    72,72,72,72,72,0,		//=
    257,130,68,40,16,0,		//>
    2,321,33,17,14,0,		//?
    124,130,186,162,60,0,	//@
    508,34,33,34,508,0,		//A
    511,273,273,273,238,0,	//B
    254,257,257,257,130,0,	//C
    511,257,257,130,124,0,	//D
    511,273,273,273,257,0,	//E
    511,17,17,17,1,0,		//F
    254,257,289,289,482,0,	//G
    511,16,16,16,511,0,		//H
    0,257,511,257,0,0,		//I
    128,256,256,256,255,0,	//J
    511,40,68,130,257,0,	//K
    511,256,256,256,256,0,	//L
    511,12,112,12,511,0,	//M
    511,6,56,192,511,0,		//N
    254,257,257,257,254,0,	//O
    511,17,17,17,14,0,		//P
    254,257,321,129,382,0,	//Q
    511,49,81,145,270,0,	//R
    142,273,273,273,226,0,	//S
    1,1,511,1,1,0,			//T
    255,256,256,256,255,0,	//U
    31,96,384,96,31,0,		//V
    511,96,28,96,511,0,		//W
    387,108,16,108,387,0,	//X
    7,24,480,24,7,0,		//Y
    385,353,273,269,259,0,	//Z
    0,511,257,257,0,0,		//[
    3,12,16,96,384,0,		// backslash
    0,257,257,511,0,0,		//]
    4,2,1,2,4,0,			//^
    256,256,256,256,256,0,	//_
    0,1,2,0,0,0,			//`
    192,296,296,296,496,0,	//a
    511,272,272,272,224,0,	//b
    240,264,264,264,144,0,	//c
    224,272,272,272,511,0,	//d
    224,336,336,336,96,0,	//e
    16,510,17,17,0,0,		//f
    224,1296,1296,1296,1008,0,	//g
    511,16,16,16,480,0,		//h
    0,272,500,256,0,0,		//i
    1024,1024,1024,1012,0,0,//j
    511,64,64,160,272,0,	//k
    0,257,511,256,0,0,		//l
    496,16,496,16,480,0,	//m
    496,16,16,16,480,0,		//n
    224,272,272,272,224,0,	//o
    2032,272,272,272,224,0,	//p
    224,272,272,272,2032,0,	//q
    480,16,16,16,16,0,		//r
    288,336,336,336,144,0,	//s
    252,272,272,272,272,0,	//t
    240,256,256,256,496,0,	//u
    48,192,256,192,48,0,	//v
    240,256,224,256,240,0,	//w
    272,160,64,160,272,0,	//x
    240,1280,1280,1280,1008,0,//y
    272,400,336,304,272,0,	//z
    0,16,238,257,0,0,		//{
    0,0,511,0,0,0,			//|
    0,257,238,16,0,0,		//}
    2,1,1,2,1,0,			//~
    0,0,0,0,0,0, 
    //0x80 onwards, based on Adafruit set, see also https://en.wikipedia.org/wiki/Code_page_437
    254,1281,1281,769,130,0,  //upper C cedilla   //128, 0x80
    240,260,256,260,496,0,    //lower u umlaut
    224,336,340,340,100,0,    //lower e acute     //130
    194,297,297,297,498,0,    //lower a circumflex
    192,298,296,298,496,0,    //lower a umlaut
    194,298,298,296,496,0,    //lower a grave
    192,299,299,296,496,0,    //lower a circle
    224,1296,1296,784,272,0,  //lower c cedilla
    228,338,338,338,100,0,    //lower e circumflex
    224,340,336,340,96,0,     //lower e umlaut
    228,340,340,336,96,0,     //lower e grave
    0,276,496,260,0,0,        //lower i umlaut
    4,274,498,258,4,0,        //lower i circumflex  //140
    4,276,500,256,0,0,        //lower i grave
    509,34,33,34,509,0,       //upper A umlaut
    496,75,71,72,496,0,       //upper A circle
    508,292,293,293,261,0,    //upper E acute     //0x90
    200,296,496,336,368,0,    //lower ae digraph
    510,33,511,273,257,0,     //upper AE digraph
    228,274,274,274,228,0,    //lower o circumflex
    224,276,272,276,224,0,    //lower o umlaut
    228,276,276,272,224,0,    //lower o grave
    244,258,258,258,500,0,    //lower u circumflex  //150
    244,260,260,256,496,0,    //lower u grave
    240,1284,1280,1284,1008,0,//lower y umlaut
    248,261,260,261,248,0,    //upper O umlaut
    252,257,256,257,252,0,    //upper U umlaut
    240,264,2046,264,144,0,   //cent symbol
    256,510,273,273,130,0,    //pound currency symbol
    87,88,496,88,87,0,        //Yen currency symbol
    511,17,14,240,288,0,      //Peseta currency symbol
    512,528,510,17,1,0,       //f with hook
    192,296,298,298,498,0,    //lower a acute, 160, 0xA0
    0,272,500,260,4,0,        //lower i acute
    224,272,276,276,228,0,    //lower o acute
    240,256,260,260,500,0,    //lower u acute
    498,17,17,18,481,0,       //lower n tilde
    506,17,97,130,505,0,      //upper N tilde
    38,41,41,41,47,0,         //superscript a
    38,41,41,41,38,0,         //superscript o
    224,272,264,261,128,0,    //inverted ?
    240,16,16,16,16,0,        //reversed negation
    16,16,16,16,240,0,        //negation    //170, 
    399,96,464,348,371,0,     //half 1/2
    399,96,208,172,499,0,     //quarter 1/4
    0,0,509,0,0,0,            //inverted !
    16,40,68,16,40,68,        //opening guillemet
    68,40,16,68,40,16,        //closing guillemet
    273,1092,273,1092,273,1092, //light shade //0xB0
    1365,2730,1365,2730,1365,2730,    //mid shade
    3822,3003,3822,3003,3822,3003,    //dark shade
    0,0,4095,0,0,0,           //graphics/box characters
    32,32,4095,0,0,0,         //180
    40,40,4095,0,0,0,
    32,4095,0,4095,0,0,
    32,4064,32,4064,0,0,
    40,40,4088,0,0,0,
    40,4079,0,4095,0,0,     //185
    0,4095,0,4095,0,0,
    40,4072,8,4088,0,0,
    40,47,32,63,0,0,
    32,63,32,63,0,0,
    40,40,63,0,0,0,       //190
    32,32,4064,0,0,0,
    0,0,63,32,32,32,      //192 //0xC0
    32,32,63,32,32,32,
    32,32,4064,32,32,32,
    0,0,4095,32,32,32,    //195
    32,32,32,32,32,32,
    32,32,4095,32,32,32,
    0,0,4095,40,40,40,
    0,4095,0,4095,40,40,
    0,63,32,47,40,40,   //200
    0,4088,8,4072,40,40,
    40,47,32,47,40,40,
    40,4072,8,4072,40,40,
    0,4095,0,4079,40,40,
    40,40,40,40,40,40,    //205
    40,4079,0,4079,40,40,
    40,40,47,40,40,40,
    32,63,32,63,32,32,    //208 //0xD0
    40,40,4072,40,40,40,
    32,4064,32,4064,32,32,  //210
    0,63,32,63,32,32,
    0,0,63,40,40,40,
    0,0,4088,40,40,40,
    0,4064,32,4064,32,32,
    32,4095,32,4095,32,32,    //215
    40,40,4095,40,40,40,
    32,32,63,0,0,0,
    0,0,4064,32,32,32,
    4095,4095,4095,4095,4095,4095,    //solid block
    4032,4032,4032,4032,4032,4032,    //lower half, 220
    4095,4095,4095,0,0,0,       //left half
    0,0,0,4095,4095,4095,       //right half
    63,63,63,63,63,63,          //upper half
    224,272,272,224,272,0,      //lower alpha, 224, 0xE0
    1022,1,273,297,198,0,       //lower beta
    511,1,1,1,1,0,              //upper gamma
    16,496,16,496,16,0,         //lower pi
    387,325,297,273,257,0,      //upper sigma
    224,272,272,240,16,0,       //lower sigma
    1024,752,256,256,496,0,     //lower mu, 230
    16,240,272,272,272,0,       //lower tau
    124,130,511,130,124,0,      //upper phi
    254,273,273,273,254,0,      //upper theta
    382,385,1,385,382,0,        //upper omega
    226,277,281,273,224,0,      //lower delta
    224,272,224,272,224,0,      //infinity
    224,272,1016,272,224,0,     //lower phi
    160,336,336,336,272,0,      //lower espilon
    510,1,1,1,510,0,            //set intersection
    84,84,84,84,84,0,           //set equivalence, 240, 0xF0
    272,272,380,272,272,0,      //plus or minus
    0,321,290,276,264,0,        //greater than or equal to
    0,264,276,290,321,0,        //less than or equal to
    0,0,4094,1,1,0,             //integral top
    256,256,255,0,0,0,          //integral bottom
    16,16,84,16,16,0,           //division
    72,36,36,72,36,0,           //approximately equal
    0,6,9,9,6,0,                //degrees
    0,0,48,48,0,0,              //large bullet
    0,0,16,0,0,0,               //small bullet, 250
    64,128,511,1,1,1,           //square root
    31,1,1,1,30,0,              //superscript n
    25,21,21,21,18,0,           //superscript 2
    0,504,504,504,0,0,          //black square
    0,0,0,0,0,0,                //blank/non breaking space










};