/**
  Generated main.c file from MPLAB Code Configurator

  @Company
    Microchip Technology Inc.

  @File Name
    main.c

  @Summary
    This is the generated main.c using PIC24 / dsPIC33 / PIC32MM MCUs.

  @Description
    This source file provides main entry point for system initialization and application code development.
    Generation Information :
        Product Revision  :  PIC24 / dsPIC33 / PIC32MM MCUs - 1.169.0
        Device            :  PIC24FJ256GA702
    The generated drivers are tested against the following:
        Compiler          :  XC16 v1.50
        MPLAB 	          :  MPLAB X v5.40
*/

/*
    (c) 2020 Microchip Technology Inc. and its subsidiaries. You may use this
    software and any derivatives exclusively with Microchip products.

    THIS SOFTWARE IS SUPPLIED BY MICROCHIP "AS IS". NO WARRANTIES, WHETHER
    EXPRESS, IMPLIED OR STATUTORY, APPLY TO THIS SOFTWARE, INCLUDING ANY IMPLIED
    WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY, AND FITNESS FOR A
    PARTICULAR PURPOSE, OR ITS INTERACTION WITH MICROCHIP PRODUCTS, COMBINATION
    WITH ANY OTHER PRODUCTS, OR USE IN ANY APPLICATION.

    IN NO EVENT WILL MICROCHIP BE LIABLE FOR ANY INDIRECT, SPECIAL, PUNITIVE,
    INCIDENTAL OR CONSEQUENTIAL LOSS, DAMAGE, COST OR EXPENSE OF ANY KIND
    WHATSOEVER RELATED TO THE SOFTWARE, HOWEVER CAUSED, EVEN IF MICROCHIP HAS
    BEEN ADVISED OF THE POSSIBILITY OR THE DAMAGES ARE FORESEEABLE. TO THE
    FULLEST EXTENT ALLOWED BY LAW, MICROCHIP'S TOTAL LIABILITY ON ALL CLAIMS IN
    ANY WAY RELATED TO THIS SOFTWARE WILL NOT EXCEED THE AMOUNT OF FEES, IF ANY,
    THAT YOU HAVE PAID DIRECTLY TO MICROCHIP FOR THIS SOFTWARE.

    MICROCHIP PROVIDES THIS SOFTWARE CONDITIONALLY UPON YOUR ACCEPTANCE OF THESE
    TERMS.
*/

/**
  Section: Included Files
*/
#define FOSC    8000000UL
#define FCY     (FOSC/2)
#include <xc.h>
#include "mcc_generated_files/system.h"
#include "mcc_generated_files/pin_manager.h"
#include "mcc_generated_files/adc1.h"
#include "mcc_generated_files/spi1_types.h"
#include "mcc_generated_files/memory/flash.h"
#include "mcc_generated_files/memory/flash_demo.h"
#include "LCD_lib_busy.h"
#include <stdio.h> /* include I/O facilities */
#include <libpic30.h> /* required for delays */
#include <stdbool.h>
#include "Low_Ohms.h"
#include "MAX112XX.h"
#include <math.h>

/* Global Defines */
LowOhmsDATA Low_Ohms_Data;
long int Data_To_Write[Max_Storage_Locations];


/* LCD Init */
void LCD_Boot(void)
{
    LCD_Start();
    LCD_Clear_Line1();
    LCD_Clear_Line2();
    LCD_TextOut(0,0,(unsigned char *)"TGM Says:       ");   // could be optimized
    LCD_TextOut(1,0,(unsigned char *)"LCD Booted OK   ");   // could be optimized
    __delay_ms(Splash_Time_ms);
}

/*  Splash Screen */
void LCD_Splash_Screen(void)
{
    LCD_TextOut(1,0,Splash_String_1);
    LCD_TextOut(0,0,Splash_String_0);
    __delay_ms (Splash_Time_ms);                  // keep Splash screen 1s
}


/* Save data to Flash  */
void Low_Ohms_Data_Save(void)
{

    // get the right data into the write array
    Data_To_Write[Number_Of_Writes_offset]= Data_To_Write[Number_Of_Writes_offset] + 1;  
    Data_To_Write[MilliOhms_Bits_Per_Ohm_offset]= Low_Ohms_Data.MilliOhms_Bits_Per_Ohm;  
    Data_To_Write[Ohms_Bits_Per_Ohm_offset]= Low_Ohms_Data.Ohms_Bits_Per_DeciOhm;  
    Data_To_Write[Resistance_On_100k_offset]= Low_Ohms_Data.Resistance_On_100k;  
    Data_To_Write[Resistance_On_1M_offset]= Low_Ohms_Data.Resistance_On_1M;  
    Data_To_Write[Resistance_On_20M_offset]= Low_Ohms_Data.Resistance_On_20M;  
    // And write it
    FlashWrite(&Data_To_Write[0]);
    
}

/* Initialise Data and Read Flash  */
void Low_Ohms_Data_Initialise(void)
{
    long int read_data; 
    int i;
    char error_detected = 0;

    // load in the data from EEPROM
    for(i=0; i<Max_Storage_Locations; i++)
    {
        FlashRead(&Data_To_Write[i],i);
    }
    Low_Ohms_Data.state = Low_Ohms_INIT;        /* Start ion INIT state */
    Low_Ohms_Data.Number_Of_Writes = 0;         /* Number of times FLASH written to */
    Low_Ohms_Data.UI_Count = 0;                 /* UI fast count. */
    Low_Ohms_Data.UI_Update_Display = 0;        /* UI needs update */
    Low_Ohms_Data.UI_Keypressed = 0;            /* UI action */
    Low_Ohms_Data.UI_Keypressed_Enter = 0;      /* UI action */
    Low_Ohms_Data.UI_Keypressed_Select = 0;     /* UI action */
    Low_Ohms_Data.UI_Action = Low_Ohms_ACTION_INIT; /* init */
    Low_Ohms_Data.Meas_Val = 0;                 /* Measured ADC result */
    Low_Ohms_Data.Meas_Resistance = 0;          /* Calculated Resistance */
    Low_Ohms_Data.Prev_Meas_Resistance = 0;     /* use for measurement filter */
    Low_Ohms_Data.MilliOhms_Bits_Per_Ohm = 0;   /* bits per Ohm on mOhms */
    Low_Ohms_Data.Ohms_Bits_Per_DeciOhm = 0;        /* bits per kOhm on Ohm range */
    Low_Ohms_Data.Cal_Step = 100;               /* start me on a non zero number */
    Low_Ohms_Data.Cal_Loops_While_Pressed = 0;  /* start me on zero */
    Low_Ohms_Data.Cal_direction = +1;           /* Start upwards */
    Low_Ohms_Data.Resistance_On_100k = 0;       /* 100k Cal resistor val - Ohms*/
    Low_Ohms_Data.Resistance_On_1M = 0;         /* Megohm range resitance Ohms */
    Low_Ohms_Data.Resistance_On_20M = 0;        /* 20 Meg Range Resistance Ohms */
    Low_Ohms_Data.heartbeatCount = 0;           /* Heartbeat LED toggle flag. */
    Low_Ohms_Data.heartbeatToggle = 0;
    Low_Ohms_Data.Zero_Offset = 0;              /* this starts at zero */

    // Read number of writes from memory
    FlashRead(&read_data,Number_Of_Writes_offset);
    Low_Ohms_Data.Number_Of_Writes = read_data;
    
    // Check data read from memory - if it is bizarre then set to nominal
    FlashRead(&read_data,MilliOhms_Bits_Per_Ohm_offset);
    Low_Ohms_Data.MilliOhms_Bits_Per_Ohm = read_data;
    if(Low_Ohms_Data.MilliOhms_Bits_Per_Ohm < MilliOhms_Bits_Per_Ohm_Min)
    {
        error_detected = 1; //set flag and trigger EEPROM update
        Low_Ohms_Data.MilliOhms_Bits_Per_Ohm = MilliOhms_Bits_Per_Ohm_Nom; // reset
    }
    else if(Low_Ohms_Data.MilliOhms_Bits_Per_Ohm > MilliOhms_Bits_Per_Ohm_Max)
    {
        error_detected = 1; //set flag and trigger EEPROM update
        Low_Ohms_Data.MilliOhms_Bits_Per_Ohm = MilliOhms_Bits_Per_Ohm_Nom; // reset
    }

    FlashRead(&read_data,Ohms_Bits_Per_Ohm_offset);
    Low_Ohms_Data.Ohms_Bits_Per_DeciOhm = read_data;
    if(Low_Ohms_Data.Ohms_Bits_Per_DeciOhm < Ohms_Bits_Per_DeciOhm_Min)
    {
        error_detected = 1; //set flag and trigger EEPROM update
        Low_Ohms_Data.Ohms_Bits_Per_DeciOhm = Ohms_Bits_Per_DeciOhm_Nom; // reset
    }
    else if(Low_Ohms_Data.Ohms_Bits_Per_DeciOhm > Ohms_Bits_Per_DeciOhm_Max)
    {
        error_detected = 1; //set flag and trigger EEPROM update
        Low_Ohms_Data.Ohms_Bits_Per_DeciOhm = Ohms_Bits_Per_DeciOhm_Nom; // reset
    }

    FlashRead(&read_data,Resistance_On_100k_offset);
    Low_Ohms_Data.Resistance_On_100k = read_data;
    if(Low_Ohms_Data.Resistance_On_100k < Resistance_On_100k_Min)
    {
        error_detected = 1; //set flag and trigger EEPROM update
        Low_Ohms_Data.Resistance_On_100k = Resistance_On_100k_Nom; // reset
    }
    else if(Low_Ohms_Data.Resistance_On_100k > Resistance_On_100k_Max)
    {
        error_detected = 1; //set flag and trigger EEPROM update
        Low_Ohms_Data.Resistance_On_100k = Resistance_On_100k_Nom; // reset
    }

    FlashRead(&read_data,Resistance_On_1M_offset);
    Low_Ohms_Data.Resistance_On_1M = read_data;
    if(Low_Ohms_Data.Resistance_On_1M < Resistance_On_1M_Min)
    {
        error_detected = 1; //set flag and trigger EEPROM update
        Low_Ohms_Data.Resistance_On_1M = Resistance_On_1M_Nom; // reset
    }
    else if(Low_Ohms_Data.Resistance_On_1M > Resistance_On_1M_Max)
    {
        error_detected = 1; //set flag and trigger EEPROM update
        Low_Ohms_Data.Resistance_On_1M = Resistance_On_1M_Nom; // reset
    }

    FlashRead(&read_data,Resistance_On_20M_offset);
    Low_Ohms_Data.Resistance_On_20M = read_data;
    if(Low_Ohms_Data.Resistance_On_20M < Resistance_On_20M_Min)
    {
        error_detected = 1; //set flag and trigger EEPROM update
        Low_Ohms_Data.Resistance_On_20M = Resistance_On_20M_Nom; // reset
    }
    else if(Low_Ohms_Data.Resistance_On_20M > Resistance_On_20M_Max)
    {
        error_detected = 1; //set flag and trigger EEPROM update
        Low_Ohms_Data.Resistance_On_20M = Resistance_On_20M_Nom; // reset
    }

    if(error_detected == 1)
    {
        // call data save routine
        Low_Ohms_Data_Save();
        // And tell user there was an error in read
        FlashWrite(&Data_To_Write[0]);
        LCD_ConstTextOut(0,0,Stored_Data_Read_Error_0);   // give user the bad news
        LCD_ConstTextOut(1,0,Stored_Data_Read_Error_1);   // give user the bad news
        __delay_ms(Bad_News_Time);
    }    
}

// Read ADC Channel pointed at
// Assumes ADC is initialised and enabled
// Uses adc1.c and adc1.h
long int Read_ADC_Input(ADC1_CHANNEL Selected_Channel)
{
    long int Read_Val = 0;
    
    ADC1_ChannelSelect(Selected_Channel);
    ADC1_SoftwareTriggerEnable();
    __delay_us(PIC_ADC_Trigger_Delay_us);
    ADC1_SoftwareTriggerDisable();
    while(!ADC1_IsConversionComplete(Selected_Channel));
    Read_Val = (long int)ADC1_ConversionResultGet(Selected_Channel);
    return(Read_Val);
}

// Choose next state
char Things_Are_Stable()
{
    if (fabs((Low_Ohms_Data.Meas_Resistance - Low_Ohms_Data.Prev_Meas_Resistance) < 
            (OK_Change_Meas_to_Meas * fabs(Low_Ohms_Data.Meas_Resistance + Low_Ohms_Data.Prev_Meas_Resistance)/2)))
        return (1);
    else
        return(0);
}


// Choose next state
void Choose_Next_State()
{
    // OK what is the next state?
    if (Low_Ohms_Data.Meas_Resistance > Max_Ohms_On_1M_Range)
        Low_Ohms_Data.state = Low_Ohms_STATE_20M; // to 20M range
    else if (Low_Ohms_Data.Meas_Resistance > Max_Ohms_On_100k_Range)
    {
        if ((Low_Ohms_Data.state == Low_Ohms_STATE_20M) && 
           (Low_Ohms_Data.Meas_Resistance > (Hysteresis_1M_20M_Range * Max_Ohms_On_1M_Range)))
            Low_Ohms_Data.state = Low_Ohms_STATE_20M; // stay in 20M range
        else
            Low_Ohms_Data.state = Low_Ohms_STATE_1M; //100k range is required
    }
    else if (Low_Ohms_Data.Meas_Resistance > Max_Ohms_On_Ohm_Range)
    {
        if ((Low_Ohms_Data.state == Low_Ohms_STATE_1M) && 
           (Low_Ohms_Data.Meas_Resistance > (Hysteresis_100k_1M_Range * Max_Ohms_On_100k_Range)))
            Low_Ohms_Data.state = Low_Ohms_STATE_1M; // stay in 1M range
        else
            Low_Ohms_Data.state = Low_Ohms_STATE_100k; // 4k5 to 95k ish
    }
    else if (Low_Ohms_Data.Meas_Resistance > Max_Ohms_On_milliOhm_Range)
    {
        if ((Low_Ohms_Data.state == Low_Ohms_STATE_100k) && 
           (Low_Ohms_Data.Meas_Resistance > (Hysteresis_Ohm_100k_Range * Max_Ohms_On_Ohm_Range)))
            Low_Ohms_Data.state = Low_Ohms_STATE_100k; // stay in 100k range
        else
            Low_Ohms_Data.state = Low_Ohms_STATE_Ohm; // notionally 45R to 4k5
    }
    else
    {
        if ((Low_Ohms_Data.state == Low_Ohms_STATE_Ohm) && 
           (Low_Ohms_Data.Meas_Resistance > (Hysteresis_mOhm_Ohm_Range * Max_Ohms_On_milliOhm_Range)))
            Low_Ohms_Data.state = Low_Ohms_STATE_Ohm; // stay in 100k range
        else
            Low_Ohms_Data.state = Low_Ohms_STATE_milliOhm; // less than 30R
    }
}


// Choose next state
void XXX_Choose_Next_State()
{
    // OK what is the next state?
    if (Low_Ohms_Data.Meas_Resistance > Max_Ohms_On_1M_Range)
        Low_Ohms_Data.state = Low_Ohms_STATE_20M; // to 20M range
    else if (Low_Ohms_Data.Meas_Resistance > Max_Ohms_On_100k_Range)
         Low_Ohms_Data.state = Low_Ohms_STATE_1M; // to 1M range
    else if (Low_Ohms_Data.Meas_Resistance > Max_Ohms_On_Ohm_Range)
         Low_Ohms_Data.state = Low_Ohms_STATE_100k; // 4k5 to 95k ish
    else if (Low_Ohms_Data.Meas_Resistance > Max_Ohms_On_milliOhm_Range)
         Low_Ohms_Data.state = Low_Ohms_STATE_Ohm; // notionally 45R to 4k5
    else Low_Ohms_Data.state = Low_Ohms_STATE_milliOhm; // less than 30R
}


// Set the cal step value
void Cal_Speed_Set()
{
    if (Low_Ohms_Data.Cal_Loops_While_Pressed < Cal_Low_Speed_Loops)
    {
        if(Low_Ohms_Data.state == Low_Ohms_STATE_CAL_mOhm)
            Low_Ohms_Data.Cal_Step = MilliOhms_Cal_Slow;
        else if(Low_Ohms_Data.state == Low_Ohms_STATE_CAL_Ohm)
            Low_Ohms_Data.Cal_Step = Ohms_Cal_Slow;    
        else if(Low_Ohms_Data.state == Low_Ohms_STATE_CAL_100K)
            Low_Ohms_Data.Cal_Step = Cal_Slow_100k;        
        else if(Low_Ohms_Data.state == Low_Ohms_STATE_CAL_1M)
            Low_Ohms_Data.Cal_Step = Cal_Slow_1M;        
        else if(Low_Ohms_Data.state == Low_Ohms_STATE_CAL_20M)
            Low_Ohms_Data.Cal_Step = Cal_Slow_20M;        
    }
    else if (Low_Ohms_Data.Cal_Loops_While_Pressed < Cal_Med_Speed_Loops)
    {
        if(Low_Ohms_Data.state == Low_Ohms_STATE_CAL_mOhm)
            Low_Ohms_Data.Cal_Step = MilliOhms_Cal_Med;
        else if(Low_Ohms_Data.state == Low_Ohms_STATE_CAL_Ohm)
            Low_Ohms_Data.Cal_Step = Ohms_Cal_Med;    
        else if(Low_Ohms_Data.state == Low_Ohms_STATE_CAL_100K)
            Low_Ohms_Data.Cal_Step = Cal_Med_100k;    
        else if(Low_Ohms_Data.state == Low_Ohms_STATE_CAL_1M)
            Low_Ohms_Data.Cal_Step = Cal_Med_1M;    
        else if(Low_Ohms_Data.state == Low_Ohms_STATE_CAL_20M)
            Low_Ohms_Data.Cal_Step = Cal_Med_20M;    
    }
    else
    {
        if(Low_Ohms_Data.state == Low_Ohms_STATE_CAL_mOhm)
            Low_Ohms_Data.Cal_Step = MilliOhms_Cal_Fast;
        else if(Low_Ohms_Data.state == Low_Ohms_STATE_CAL_Ohm)
            Low_Ohms_Data.Cal_Step = Ohms_Cal_Fast;    
        else if(Low_Ohms_Data.state == Low_Ohms_STATE_CAL_100K)
            Low_Ohms_Data.Cal_Step = Cal_Fast_100k;    
        else if(Low_Ohms_Data.state == Low_Ohms_STATE_CAL_1M)
            Low_Ohms_Data.Cal_Step = Cal_Fast_1M;    
        else if(Low_Ohms_Data.state == Low_Ohms_STATE_CAL_20M)
            Low_Ohms_Data.Cal_Step = Cal_Fast_20M;    
    }
}

/*  Main application */
int Low_Ohms_Tasks(void)
{
    char Temp_String[20];
    unsigned char Read_Val;
    bool Check;
    long int ADC_Read_Value;
    long int PIC_ADC = 0;
    float Result;

    //check if a button is pressed or not.
    if(KeyPressed)
    {
       Low_Ohms_Data.UI_Keypressed = 1;
       Low_Ohms_Data.UI_Keypressed_Enter = Enter_Key_Pressed;
       Low_Ohms_Data.UI_Keypressed_Select = Select_Key_Pressed;
    }
    else
    {
       Low_Ohms_Data.UI_Keypressed = 0;
       Low_Ohms_Data.UI_Keypressed_Enter = 0;
       Low_Ohms_Data.UI_Keypressed_Select = 0;
    }
            
    // Initialise stuff then move to operational states
    switch(Low_Ohms_Data.state)
    {
        // Initialise stuff then move to operational states
        case Low_Ohms_INIT:
        {
            LCD_Boot();
            LCD_Splash_Screen();


            // initialise the data structures
            Low_Ohms_Data_Initialise();
            /* insert SPI Init here*/
            Check = spi1_open(0);
            if (Check  == true)
                {
                }
            else
            {
                LCD_ConstTextOut(0,0,SPI_Error_1);   // could be optimized
                LCD_ConstTextOut(1,0,SPI_Error_2);   // could be optimized
                __delay_ms(Bad_News_Time);
            }

            MAX112XX_Init();    // initialise the ADC*/
            //Check stat bit.  If this is stuck then we have an error
            do{
            MAX112XX_Register_Read_Byte(MAX112XX_Stat1_RD_CMD, &Read_Val);
            if(Read_Val & MAX112XX_Stat_Bit)
                {
                sprintf(Temp_String, ADC_Init_Err_Msg);
                LCD_TextOut(0,0,(unsigned char *)Temp_String);   // could be optimized
                }
            } while(Read_Val & MAX112XX_Stat_Bit);

            //change 2022-03-28
            //Set in Bipolar Mode
            MAX112XX_Bipolar_Set();
           
            //Initialise PIC ADC to read battery voltage
            ADC1_Initialize();
            ADC1_Enable();  //Enable the ADC

            //Get the value
            PIC_ADC = Read_ADC_Input(Select_Key);
            Low_Ohms_Data.UI_Keypressed_Select = PIC_ADC;
            Low_Ohms_Data.state = Low_Ohms_STATE_IDLE;
            Low_Ohms_Data.UI_Action = Low_Ohms_ACTION_INIT;  // records current Action
            
            ADC_Read_Value = Read_ADC_Input(Select_Key);
            Result = (float)ADC_Read_Value * PIC_ADC_Scale;
            sprintf(Temp_String,"%*.1f Volts      ",3, Result);
            LCD_TextOut(0,0,(unsigned char *)"Battery Voltage:");   // could be optimized
            LCD_TextOut(1,0,(unsigned char *) Temp_String);   // could be optimized
            __delay_ms(Batt_Time);
            
            if (Result < (float)Low_Batt)
            {
                LCD_TextOut(0,0, Battery_Low1);   
                LCD_TextOut(1,0, Battery_Low2);   
                __delay_ms(Bad_News_Time);
            }

        }
        break;

        // Idle state - go here first, test resistance on 100k range then jump to measurements
        case Low_Ohms_STATE_IDLE:
        {
            // start on the 100k range as this is very low current 
            // Use this reading to select next range
            Config_100k;        
            Config_Settle;

            MAX112XX_Read_ADC_5SPS(&ADC_Read_Value);
            Low_Ohms_Data.Meas_Val = (long int)(ADC_Read_Value - ADC_Bipolar_Offset);
            Low_Ohms_Data.Meas_Resistance = (float)(ADC_Read_Value  - ADC_Bipolar_Offset);
            Low_Ohms_Data.Meas_Resistance = (float) Low_Ohms_Data.Meas_Resistance * (float)Low_Ohms_Data.Resistance_On_100k;
            Low_Ohms_Data.Meas_Resistance = (float) Low_Ohms_Data.Meas_Resistance / ADC_Max_Value;
            // OK what is the next state?
            Choose_Next_State();

            // But if the key is pressed we want to calibrate...    
           if (Low_Ohms_Data.UI_Keypressed)
           {
               if (Low_Ohms_Data.UI_Keypressed_Select)
                   Low_Ohms_Data.state = Low_Ohms_STATE_CAL;
               else;
           }
            Low_Ohms_Data.UI_Action = Low_Ohms_ACTION_IDLE;  // records current Action
        }
        break;

        // milliOhm range
        case Low_Ohms_STATE_milliOhm:
        {
            // Switch to milliohms
            Config_MilliOhms;        
            if (Low_Ohms_Data.UI_Action != Low_Ohms_ACTION_milliOhms)
                Config_Settle;  //then settle
            Low_Ohms_Data.Prev_Meas_Resistance = Low_Ohms_Data.Meas_Resistance; // Record previous value
            MAX112XX_Read_ADC_5SPS(&ADC_Read_Value);
            Low_Ohms_Data.Meas_Val = (long int)ADC_Read_Value  - ADC_Bipolar_Offset;
            Low_Ohms_Data.Meas_Resistance = (float)(ADC_Read_Value  - ADC_Bipolar_Offset);
            Low_Ohms_Data.Meas_Resistance = (float) Low_Ohms_Data.Meas_Resistance /(float)Low_Ohms_Data.MilliOhms_Bits_Per_Ohm;
            // OK what is the next state?
            Choose_Next_State();
            // if this is not the first time through
            if((Low_Ohms_Data.UI_Action == Low_Ohms_ACTION_milliOhms) && Things_Are_Stable())
            {
                sprintf(Temp_String,"%*.4f Ohms    ", 7, Low_Ohms_Data.Meas_Resistance);
                LCD_TextOut(0,0,(unsigned char *)Temp_String);   // could be optimized    
                LCD_TextOut(1,0,(unsigned char *)"milliOhms range ");   // could be optimized    
            }
            // Remind ourselves we were just in milliohms and what value we saw
            Low_Ohms_Data.UI_Action = Low_Ohms_ACTION_milliOhms;  // records current Action
            // goto cal if requested
            if (Low_Ohms_Data.UI_Keypressed) Low_Ohms_Data.state = Low_Ohms_STATE_CAL;
          }
        break;

        // Ohm range
        case Low_Ohms_STATE_Ohm:
        {
            // Switch to ohms
            Config_Ohms;        
            if (Low_Ohms_Data.UI_Action != Low_Ohms_ACTION_Ohms)
                Config_Settle; // then settle
            Low_Ohms_Data.Prev_Meas_Resistance = Low_Ohms_Data.Meas_Resistance; // Record previous value
            MAX112XX_Read_ADC_5SPS(&ADC_Read_Value);
            Low_Ohms_Data.Meas_Val = (long int)(ADC_Read_Value  - ADC_Bipolar_Offset);
            Low_Ohms_Data.Meas_Resistance = (float)(ADC_Read_Value  - ADC_Bipolar_Offset);
            Low_Ohms_Data.Meas_Resistance = (float) Low_Ohms_Data.Meas_Resistance /((float)Low_Ohms_Data.Ohms_Bits_Per_DeciOhm / 10); //scaled deciOhms
            // OK what is the next state?
            Choose_Next_State();
            // if this is not the first time through
            if((Low_Ohms_Data.UI_Action == Low_Ohms_ACTION_Ohms) && Things_Are_Stable())
            {
                sprintf(Temp_String,"%*.2f Ohms    ", 7, (float)Low_Ohms_Data.Meas_Resistance); 
                LCD_TextOut(0,0,(unsigned char *)Temp_String);   // could be optimized    
                LCD_TextOut(1,0,(unsigned char *)"Ohms Range      ");   // could be optimized    
            }

            // Remind ourselves we were just in Ohms and what value we saw
            Low_Ohms_Data.UI_Action = Low_Ohms_ACTION_Ohms;  // records current Action
            // goto cal if requested
            if (Low_Ohms_Data.UI_Keypressed) Low_Ohms_Data.state = Low_Ohms_STATE_CAL;
          }
        break;

        // 100k range
        case Low_Ohms_STATE_100k:
        {
            // Switch to 100k
            Config_100k;        
            if (Low_Ohms_Data.UI_Action != Low_Ohms_ACTION_100k)
                Config_Settle; // then settle
            Low_Ohms_Data.Prev_Meas_Resistance = Low_Ohms_Data.Meas_Resistance; // Record previous value
            MAX112XX_Read_ADC_5SPS(&ADC_Read_Value);
            Low_Ohms_Data.Meas_Val = (long int)(ADC_Read_Value  - ADC_Bipolar_Offset);
            Low_Ohms_Data.Meas_Resistance = (float)(ADC_Read_Value  - ADC_Bipolar_Offset);
            Low_Ohms_Data.Meas_Resistance = (float) Low_Ohms_Data.Meas_Resistance * (float)Low_Ohms_Data.Resistance_On_100k;
            Low_Ohms_Data.Meas_Resistance = (float) Low_Ohms_Data.Meas_Resistance / ADC_Max_Value;
            // OK what is the next state?
            Choose_Next_State();
            // if this is not the first time through
            if((Low_Ohms_Data.UI_Action == Low_Ohms_ACTION_100k) && Things_Are_Stable())
            {
                sprintf(Temp_String,"%*.3f KOhms   ", 7, Low_Ohms_Data.Meas_Resistance/1000);
                LCD_TextOut(0,0,(unsigned char *)Temp_String);   // could be optimized    
                LCD_TextOut(1,0,(unsigned char *)"100k Range      ");   // could be optimized    
            }
            // Remind ourselves we were just in 100k and what value we saw
            Low_Ohms_Data.UI_Action = Low_Ohms_ACTION_100k;  // records current Action
            // goto cal if requested
            if (Low_Ohms_Data.UI_Keypressed) Low_Ohms_Data.state = Low_Ohms_STATE_CAL;
          }
        break;

        // 1M range
        case Low_Ohms_STATE_1M:
        {
            // Switch to 1M
            Config_1M;        
            if (Low_Ohms_Data.UI_Action != Low_Ohms_ACTION_1M)
                Config_Settle; // then settle
            Low_Ohms_Data.Prev_Meas_Resistance = Low_Ohms_Data.Meas_Resistance; // Record previous value
            MAX112XX_Read_ADC_5SPS(&ADC_Read_Value);
            Low_Ohms_Data.Meas_Val = (long int)(ADC_Read_Value  - ADC_Bipolar_Offset);
            Low_Ohms_Data.Meas_Resistance = (float)(ADC_Read_Value  - ADC_Bipolar_Offset);
            Low_Ohms_Data.Meas_Resistance = (float) Low_Ohms_Data.Meas_Resistance * (float)Low_Ohms_Data.Resistance_On_1M;
            Low_Ohms_Data.Meas_Resistance = (float) Low_Ohms_Data.Meas_Resistance / ADC_Max_Value;
            // OK what is the next state?
            Choose_Next_State();
            // if this is not the first time through
            if((Low_Ohms_Data.UI_Action == Low_Ohms_ACTION_1M)  && Things_Are_Stable())
            {
                sprintf(Temp_String,"%*.2f KOhms   ", 7, Low_Ohms_Data.Meas_Resistance/1000);
                LCD_TextOut(0,0,(unsigned char *)Temp_String);   // could be optimized    
                LCD_TextOut(1,0,(unsigned char *)"1M Range        ");   // could be optimized    
            }
            // Remind ourselves we were just in 1M and what value we saw
            Low_Ohms_Data.UI_Action = Low_Ohms_ACTION_1M;  // records current Action
            // goto cal if requested
            if (Low_Ohms_Data.UI_Keypressed) Low_Ohms_Data.state = Low_Ohms_STATE_CAL;
          }
        break;

        // 20M range
        case Low_Ohms_STATE_20M:
        {
            // Switch to 20M
            Config_20M;        
            if (Low_Ohms_Data.UI_Action != Low_Ohms_ACTION_20M)
                Config_Settle; // then settle
            Low_Ohms_Data.Prev_Meas_Resistance = Low_Ohms_Data.Meas_Resistance; // Record previous value
            MAX112XX_Read_ADC_5SPS(&ADC_Read_Value);
            Low_Ohms_Data.Meas_Val = (long int)(ADC_Read_Value  - ADC_Bipolar_Offset);
            Low_Ohms_Data.Meas_Resistance = (float)(ADC_Read_Value  - ADC_Bipolar_Offset);
            Low_Ohms_Data.Meas_Resistance = (float) Low_Ohms_Data.Meas_Resistance * (float)Low_Ohms_Data.Resistance_On_20M * 10;
            Low_Ohms_Data.Meas_Resistance = (float) Low_Ohms_Data.Meas_Resistance / ADC_Max_Value;
            // OK what is the next state?
            Choose_Next_State();
            // if this is not the first time through
            if((Low_Ohms_Data.UI_Action == Low_Ohms_ACTION_20M)  && Things_Are_Stable())
            {
                sprintf(Temp_String,"%*.4f MegOhm  ", 7,((float)Low_Ohms_Data.Meas_Resistance/(float)1000000)); 
                LCD_TextOut(0,0,(unsigned char *)Temp_String);   // could be optimized    
                LCD_TextOut(1,0,(unsigned char *)"20M range       ");   // could be optimized    
            }
            // Remind ourselves we were just in 20M and what value we saw
            Low_Ohms_Data.UI_Action = Low_Ohms_ACTION_20M;  // records current Action

            //Check the exceptions - first open circuit
            if (Low_Ohms_Data.Meas_Val > Max_Meas_Val_20M_Range)
            {
                LCD_TextOut(0,0,(unsigned char *)Over_Range_String_1);   // could be optimized    
                LCD_TextOut(1,0,(unsigned char *)Over_Range_String_2);   // could be optimized 
                Low_Ohms_Data.Meas_Resistance = Max_Ohms_On_20M_Range + 1000; //simply make larger than max
                Low_Ohms_Data.state = Low_Ohms_STATE_20M; // stay here
                Low_Ohms_Data.UI_Action = Low_Ohms_ACTION_IDLE;  // records current Action
            }
            // second going from 20M range to a low resistance
            else if (Low_Ohms_Data.Meas_Resistance < Max_Ohms_On_100k_Range)
            {
                LCD_TextOut(0,0,(unsigned char *)Re_Range_String_1);   // could be optimized    
                LCD_TextOut(1,0,(unsigned char *)Re_Range_String_2);   // could be optimized    
                Low_Ohms_Data.state = Low_Ohms_STATE_100k; // stay here
                Low_Ohms_Data.UI_Action = Low_Ohms_ACTION_IDLE;  // records current Action
            }
            // goto cal if requested
            if (Low_Ohms_Data.UI_Keypressed) Low_Ohms_Data.state = Low_Ohms_STATE_CAL;
          }
        break;
        // CAL State
        case Low_Ohms_STATE_CAL:
        {
            LCD_ConstTextOut(0,0,CAL_Msg_1_1);
            LCD_ConstTextOut(1,0,CAL_Msg_1_2);   // Help for user
            __delay_ms(CAL_Msg_Time);
            LCD_ConstTextOut(0,0,CAL_Msg_2_1);
            LCD_ConstTextOut(1,0,CAL_Msg_2_2);   // Help for user
            __delay_ms(CAL_Msg_Time);    
            LCD_ConstTextOut(0,0,CAL_Msg_3_1);
            LCD_ConstTextOut(1,0,CAL_Msg_3_2);   // Help for user
            __delay_ms(CAL_Msg_Time);
            LCD_ConstTextOut(0,0,CAL_Msg_4_1);
            LCD_ConstTextOut(1,0,CAL_Msg_4_2);   // Help for user
            __delay_ms(CAL_Msg_Time);
            Low_Ohms_Data.UI_Action = Low_Ohms_ACTION_CAL;  // records current Action
            Low_Ohms_Data.state = Low_Ohms_STATE_CAL_mOhm;
            // Switch to milliohms
            Config_MilliOhms;        
        }
        break;
        // CALIBRATE milliohm
        case Low_Ohms_STATE_CAL_mOhm:
        {
            if(Low_Ohms_Data.UI_Action == Low_Ohms_ACTION_CAL) //give this msg once
            {
                LCD_ConstTextOut(0,0,CAL_Msg_milliOhms_1);
                LCD_ConstTextOut(1,0,CAL_Msg_milliOhms_2);   // Help for user
                __delay_ms(CAL_Msg_Time);
                LCD_ConstTextOut(0,0,CAL_Msg_All_1);
                LCD_ConstTextOut(1,0,CAL_Msg_All_2);   // Help for user
                __delay_ms(CAL_Msg_Time);
            }
            Low_Ohms_Data.UI_Action = Low_Ohms_ACTION_CAL_milliOhms;  // records current Action
            Cal_Speed_Set();           
            if(Low_Ohms_Data.UI_Keypressed_Select && !Low_Ohms_Data.UI_Keypressed_Enter) //then increment cal
            {
                Low_Ohms_Data.Cal_Loops_While_Pressed += 1; // increment this!
                Low_Ohms_Data.MilliOhms_Bits_Per_Ohm += 
                        Low_Ohms_Data.Cal_direction * Low_Ohms_Data.Cal_Step;
                if(Low_Ohms_Data.MilliOhms_Bits_Per_Ohm > MilliOhms_Bits_Per_Ohm_Max)
                    Low_Ohms_Data.MilliOhms_Bits_Per_Ohm = MilliOhms_Bits_Per_Ohm_Max;
                else if(Low_Ohms_Data.MilliOhms_Bits_Per_Ohm < MilliOhms_Bits_Per_Ohm_Min)
                    Low_Ohms_Data.MilliOhms_Bits_Per_Ohm = MilliOhms_Bits_Per_Ohm_Min;

           }
            else if(Low_Ohms_Data.UI_Keypressed_Select && Low_Ohms_Data.UI_Keypressed_Enter) //then reverse cal direction
            {
                Low_Ohms_Data.Cal_Loops_While_Pressed = 0; //reset this!
                Low_Ohms_Data.Cal_direction *= -1;
            }
            else if(!Low_Ohms_Data.UI_Keypressed_Select && Low_Ohms_Data.UI_Keypressed_Enter) //then accept cal and move on
            {
                Low_Ohms_Data.UI_Action = Low_Ohms_ACTION_CAL_milliOhms;  // records current Action
                Low_Ohms_Data.state = Low_Ohms_STATE_CAL_Ohm;
                Low_Ohms_Data.Cal_Loops_While_Pressed = 0; //reset this!
                Low_Ohms_Data.Cal_direction = 1;  // reset this too
                Config_Ohms;        // set relays to Ohms
            }
            else //both buttons are up...
            {
                Low_Ohms_Data.Cal_Loops_While_Pressed = 0; //reset this!
            }
            
            // now read the value and present
            Low_Ohms_Data.Prev_Meas_Resistance = Low_Ohms_Data.Meas_Resistance; // Record previous value
            MAX112XX_Read_ADC_5SPS(&ADC_Read_Value);
            Low_Ohms_Data.Meas_Val = (long int)(ADC_Read_Value  - ADC_Bipolar_Offset);
            Low_Ohms_Data.Meas_Resistance = (float)(ADC_Read_Value  - ADC_Bipolar_Offset);
            Low_Ohms_Data.Meas_Resistance = (float) Low_Ohms_Data.Meas_Resistance /(float)Low_Ohms_Data.MilliOhms_Bits_Per_Ohm;
            // help user if things look odd
            if(Low_Ohms_Data.Meas_Resistance > Max_Ohms_On_milliOhm_Range)
            {
                LCD_ConstTextOut(0,0,CAL_Msg_milliOhms_Err_1);   // prompt user    
                LCD_ConstTextOut(1,0,CAL_Msg_milliOhms_Err_2);   // Prompt user    
            }
            else //present value
            {
                LCD_ConstTextOut(0,0,CAL_Msg_All_1);  
                if ((Low_Ohms_Data.UI_Keypressed_Select && Low_Ohms_Data.UI_Keypressed_Enter)&& (Low_Ohms_Data.Cal_direction == 1))
                    sprintf(Temp_String,"Decrease Cal Val");
                else if ((Low_Ohms_Data.UI_Keypressed_Select && Low_Ohms_Data.UI_Keypressed_Enter)&& (Low_Ohms_Data.Cal_direction == -1))
                    sprintf(Temp_String,"Increase Cal Val");
                else if(Low_Ohms_Data.UI_Keypressed_Select && (Low_Ohms_Data.Cal_direction == 1))
                    sprintf(Temp_String,"%*.4f Ohms   <", 7, Low_Ohms_Data.Meas_Resistance);
                else if(Low_Ohms_Data.UI_Keypressed_Select && (Low_Ohms_Data.Cal_direction == -1))
                    sprintf(Temp_String,"%*.4f Ohms   >", 7, Low_Ohms_Data.Meas_Resistance);
                else 
                    sprintf(Temp_String,"%*.4f Ohms    ", 7, Low_Ohms_Data.Meas_Resistance);
                LCD_TextOut(1,0,(unsigned char *)Temp_String);   // could be optimized
            }
            Low_Ohms_Data.UI_Action = Low_Ohms_ACTION_CAL_milliOhms;  // records current Action
        }
        break;
        // CALIBRATE Ohms
        case Low_Ohms_STATE_CAL_Ohm:
        {
            if(Low_Ohms_Data.UI_Action == Low_Ohms_ACTION_CAL_milliOhms) //give this msg once
            {
                LCD_ConstTextOut(0,0,CAL_Msg_Ohms_1);
                LCD_ConstTextOut(1,0,CAL_Msg_Ohms_2);   // Help for user
                __delay_ms(CAL_Msg_Time);
                LCD_ConstTextOut(0,0,CAL_Msg_All_1);
                LCD_ConstTextOut(1,0,CAL_Msg_All_2);   // Help for user
                __delay_ms(CAL_Msg_Time);
            }
            Low_Ohms_Data.UI_Action = Low_Ohms_ACTION_CAL_Ohms;  // records current Action
            Cal_Speed_Set();           
            if(Low_Ohms_Data.UI_Keypressed_Select && !Low_Ohms_Data.UI_Keypressed_Enter) //then increment cal
            {
                Low_Ohms_Data.Cal_Loops_While_Pressed += 1; // increment this!
                Low_Ohms_Data.Ohms_Bits_Per_DeciOhm += 
                        Low_Ohms_Data.Cal_direction * Low_Ohms_Data.Cal_Step;
                if(Low_Ohms_Data.Ohms_Bits_Per_DeciOhm > Ohms_Bits_Per_DeciOhm_Max)
                    Low_Ohms_Data.Ohms_Bits_Per_DeciOhm = Ohms_Bits_Per_DeciOhm_Max;
                else if(Low_Ohms_Data.Ohms_Bits_Per_DeciOhm < Ohms_Bits_Per_DeciOhm_Min)
                    Low_Ohms_Data.Ohms_Bits_Per_DeciOhm = Ohms_Bits_Per_DeciOhm_Min;

           }
            else if(Low_Ohms_Data.UI_Keypressed_Select && Low_Ohms_Data.UI_Keypressed_Enter) //then reverse cal direction
            {
                Low_Ohms_Data.Cal_Loops_While_Pressed = 0; //reset this!
                Low_Ohms_Data.Cal_direction *= -1;
            }
            else if(!Low_Ohms_Data.UI_Keypressed_Select && Low_Ohms_Data.UI_Keypressed_Enter) //then accept cal and move on
            {
                Low_Ohms_Data.UI_Action = Low_Ohms_ACTION_CAL_Ohms;  // records current Action
                Low_Ohms_Data.state = Low_Ohms_STATE_CAL_100K;
                Low_Ohms_Data.Cal_Loops_While_Pressed = 0; //reset this!
                Low_Ohms_Data.Cal_direction = 1;  // reset this too
                Config_100k;
            }
            else //both buttons are up...
            {
                Low_Ohms_Data.Cal_Loops_While_Pressed = 0; //reset this!
            }
            
            // now read the value and present
            Low_Ohms_Data.Prev_Meas_Resistance = Low_Ohms_Data.Meas_Resistance; // Record previous value
            MAX112XX_Read_ADC_5SPS(&ADC_Read_Value);
            Low_Ohms_Data.Meas_Val = (long int)(ADC_Read_Value  - ADC_Bipolar_Offset);
            Low_Ohms_Data.Meas_Resistance = (float)(ADC_Read_Value  - ADC_Bipolar_Offset);
            Low_Ohms_Data.Meas_Resistance = (float) Low_Ohms_Data.Meas_Resistance /((float)Low_Ohms_Data.Ohms_Bits_Per_DeciOhm / 10); //scaled deciOhms
            // help user if things look odd
            if(Low_Ohms_Data.Meas_Resistance > Max_Ohms_On_Ohm_Range)
            {
                LCD_ConstTextOut(0,0,CAL_Msg_Ohms_Err_1);   // prompt user    
                LCD_ConstTextOut(1,0,CAL_Msg_Ohms_Err_2);   // Prompt user    
            }
            else //present value
            {
                LCD_ConstTextOut(0,0,CAL_Msg_All_1);  
                if ((Low_Ohms_Data.UI_Keypressed_Select && Low_Ohms_Data.UI_Keypressed_Enter)&& (Low_Ohms_Data.Cal_direction == 1))
                    sprintf(Temp_String,"Decrease Cal Val");
                else if ((Low_Ohms_Data.UI_Keypressed_Select && Low_Ohms_Data.UI_Keypressed_Enter)&& (Low_Ohms_Data.Cal_direction == -1))
                    sprintf(Temp_String,"Increase Cal Val");
                else if(Low_Ohms_Data.UI_Keypressed_Select && (Low_Ohms_Data.Cal_direction == 1))
                    sprintf(Temp_String,"%*.2f Ohms   <", 7, Low_Ohms_Data.Meas_Resistance);
                else if(Low_Ohms_Data.UI_Keypressed_Select && (Low_Ohms_Data.Cal_direction == -1))
                    sprintf(Temp_String,"%*.2f Ohms   >", 7, Low_Ohms_Data.Meas_Resistance);
                else 
                    sprintf(Temp_String,"%*.2f Ohms    ", 7, Low_Ohms_Data.Meas_Resistance);
                LCD_TextOut(1,0,(unsigned char *)Temp_String);   // could be optimized
            }
            Low_Ohms_Data.UI_Action = Low_Ohms_ACTION_CAL_Ohms;  // records current Action
        }
        break;
        // CALIBRATE 100k
        case Low_Ohms_STATE_CAL_100K:
        {
            if(Low_Ohms_Data.UI_Action == Low_Ohms_ACTION_CAL_Ohms) //give this msg once
            {
                LCD_ConstTextOut(0,0,CAL_Msg_100k_1);
                LCD_ConstTextOut(1,0,CAL_Msg_100k_2);   // Help for user
                __delay_ms(CAL_Msg_Time);
                LCD_ConstTextOut(0,0,CAL_Msg_All_1);
                LCD_ConstTextOut(1,0,CAL_Msg_All_2);   // Help for user
                __delay_ms(CAL_Msg_Time);
            }
            Low_Ohms_Data.UI_Action = Low_Ohms_ACTION_CAL_100k;  // records current Action
            Cal_Speed_Set();           
            if(Low_Ohms_Data.UI_Keypressed_Select && !Low_Ohms_Data.UI_Keypressed_Enter) //then increment cal
            {
                Low_Ohms_Data.Cal_Loops_While_Pressed += 1; // increment this!
                Low_Ohms_Data.Resistance_On_100k += 
                        Low_Ohms_Data.Cal_direction * Low_Ohms_Data.Cal_Step;
                if(Low_Ohms_Data.Resistance_On_100k > Resistance_On_100k_Max)
                    Low_Ohms_Data.Resistance_On_100k = Resistance_On_100k_Max;
                else if(Low_Ohms_Data.Resistance_On_100k < Resistance_On_100k_Min)
                    Low_Ohms_Data.Resistance_On_100k = Resistance_On_100k_Min;

           }
            else if(Low_Ohms_Data.UI_Keypressed_Select && Low_Ohms_Data.UI_Keypressed_Enter) //then reverse cal direction
            {
                Low_Ohms_Data.Cal_Loops_While_Pressed = 0; //reset this!
                Low_Ohms_Data.Cal_direction *= -1;
            }
            else if(!Low_Ohms_Data.UI_Keypressed_Select && Low_Ohms_Data.UI_Keypressed_Enter) //then accept cal and move on
            {
                Low_Ohms_Data.UI_Action = Low_Ohms_ACTION_CAL_100k;  // records current Action
                Low_Ohms_Data.state = Low_Ohms_STATE_CAL_1M;
                Low_Ohms_Data.Cal_Loops_While_Pressed = 0; //reset this!
                Low_Ohms_Data.Cal_direction = 1;  // reset this too
                Config_1M;
            }
            else //both buttons are up...
            {
                Low_Ohms_Data.Cal_Loops_While_Pressed = 0; //reset this!
            }
            
            // now read the value and present
            Low_Ohms_Data.Prev_Meas_Resistance = Low_Ohms_Data.Meas_Resistance; // Record previous value
            MAX112XX_Read_ADC_5SPS(&ADC_Read_Value);
            Low_Ohms_Data.Meas_Val = (long int)(ADC_Read_Value  - ADC_Bipolar_Offset);
            Low_Ohms_Data.Meas_Resistance = (float)(ADC_Read_Value  - ADC_Bipolar_Offset);
            Low_Ohms_Data.Meas_Resistance = (float) Low_Ohms_Data.Meas_Resistance * (float)Low_Ohms_Data.Resistance_On_100k;
            Low_Ohms_Data.Meas_Resistance = (float) Low_Ohms_Data.Meas_Resistance / ADC_Max_Value;            // help user if things look odd
            if(Low_Ohms_Data.Meas_Resistance > Max_Ohms_On_100k_Range)
            {
                LCD_ConstTextOut(0,0,CAL_Msg_100K_Err_1);   // prompt user    
                LCD_ConstTextOut(1,0,CAL_Msg_100K_Err_2);   // Prompt user    
            }
            else //present value
            {
                LCD_ConstTextOut(0,0,CAL_Msg_All_1);  
                if ((Low_Ohms_Data.UI_Keypressed_Select && Low_Ohms_Data.UI_Keypressed_Enter)&& (Low_Ohms_Data.Cal_direction == 1))
                    sprintf(Temp_String,"Increase Cal Val");
                else if ((Low_Ohms_Data.UI_Keypressed_Select && Low_Ohms_Data.UI_Keypressed_Enter)&& (Low_Ohms_Data.Cal_direction == -1))
                    sprintf(Temp_String,"Decrease Cal Val");
                else if(Low_Ohms_Data.UI_Keypressed_Select && (Low_Ohms_Data.Cal_direction == 1))
                    sprintf(Temp_String,"%*.3f KOhms  >", 7, Low_Ohms_Data.Meas_Resistance/1000);
                else if(Low_Ohms_Data.UI_Keypressed_Select && (Low_Ohms_Data.Cal_direction == -1))
                    sprintf(Temp_String,"%*.3f KOhms  <", 7, Low_Ohms_Data.Meas_Resistance/1000);
                else 
                    sprintf(Temp_String,"%*.3f KOhms   ", 7, Low_Ohms_Data.Meas_Resistance/1000);
                LCD_TextOut(1,0,(unsigned char *)Temp_String);   // could be optimized
            }
            Low_Ohms_Data.UI_Action = Low_Ohms_ACTION_CAL_100k;  // records current Action
        }
        break;
        // CALIBRATE 1M
        case Low_Ohms_STATE_CAL_1M:
        {
            if(Low_Ohms_Data.UI_Action == Low_Ohms_ACTION_CAL_100k) //give this msg once
            {
                LCD_ConstTextOut(0,0,CAL_Msg_1M_1);
                LCD_ConstTextOut(1,0,CAL_Msg_1M_2);   // Help for user
                __delay_ms(CAL_Msg_Time);
                LCD_ConstTextOut(0,0,CAL_Msg_All_1);
                LCD_ConstTextOut(1,0,CAL_Msg_All_2);   // Help for user
                __delay_ms(CAL_Msg_Time);
            }
            Low_Ohms_Data.UI_Action = Low_Ohms_ACTION_CAL_1M;  // records current Action
            Cal_Speed_Set();           
            if(Low_Ohms_Data.UI_Keypressed_Select && !Low_Ohms_Data.UI_Keypressed_Enter) //then increment cal
            {
                Low_Ohms_Data.Cal_Loops_While_Pressed += 1; // increment this!
                Low_Ohms_Data.Resistance_On_1M += 
                        Low_Ohms_Data.Cal_direction * Low_Ohms_Data.Cal_Step;
                if(Low_Ohms_Data.Resistance_On_1M > Resistance_On_1M_Max)
                    Low_Ohms_Data.Resistance_On_1M = Resistance_On_1M_Max;
                else if(Low_Ohms_Data.Resistance_On_1M < Resistance_On_1M_Min)
                    Low_Ohms_Data.Resistance_On_1M = Resistance_On_1M_Min;

           }
            else if(Low_Ohms_Data.UI_Keypressed_Select && Low_Ohms_Data.UI_Keypressed_Enter) //then reverse cal direction
            {
                Low_Ohms_Data.Cal_Loops_While_Pressed = 0; //reset this!
                Low_Ohms_Data.Cal_direction *= -1;
            }
            else if(!Low_Ohms_Data.UI_Keypressed_Select && Low_Ohms_Data.UI_Keypressed_Enter) //then accept cal and move on
            {
                Low_Ohms_Data.UI_Action = Low_Ohms_ACTION_CAL_1M;  // records current Action
                Low_Ohms_Data.state = Low_Ohms_STATE_CAL_20M;
                Low_Ohms_Data.Cal_Loops_While_Pressed = 0; //reset this!
                Low_Ohms_Data.Cal_direction = 1;  // reset this too
                Config_20M;
            }
            else //both buttons are up...
            {
                Low_Ohms_Data.Cal_Loops_While_Pressed = 0; //reset this!
            }
            
            // now read the value and present
            Low_Ohms_Data.Prev_Meas_Resistance = Low_Ohms_Data.Meas_Resistance; // Record previous value
            MAX112XX_Read_ADC_5SPS(&ADC_Read_Value);
            Low_Ohms_Data.Meas_Val = (long int)(ADC_Read_Value  - ADC_Bipolar_Offset);
            Low_Ohms_Data.Meas_Resistance = (float)(ADC_Read_Value  - ADC_Bipolar_Offset);
            Low_Ohms_Data.Meas_Resistance = (float) Low_Ohms_Data.Meas_Resistance * (float)Low_Ohms_Data.Resistance_On_1M;
            Low_Ohms_Data.Meas_Resistance = (float) Low_Ohms_Data.Meas_Resistance / ADC_Max_Value;            // help user if things look odd
            if(Low_Ohms_Data.Meas_Resistance > Max_Ohms_On_1M_Range)
            {
                LCD_ConstTextOut(0,0,CAL_Msg_1M_Err_1);   // prompt user    
                LCD_ConstTextOut(1,0,CAL_Msg_1M_Err_2);   // Prompt user    
            }
            else //present value
            {
                LCD_ConstTextOut(0,0,CAL_Msg_All_1);  
                if ((Low_Ohms_Data.UI_Keypressed_Select && Low_Ohms_Data.UI_Keypressed_Enter)&& (Low_Ohms_Data.Cal_direction == 1))
                    sprintf(Temp_String,"Increase Cal Val");
                else if ((Low_Ohms_Data.UI_Keypressed_Select && Low_Ohms_Data.UI_Keypressed_Enter)&& (Low_Ohms_Data.Cal_direction == -1))
                    sprintf(Temp_String,"Decrease Cal Val");
                else if(Low_Ohms_Data.UI_Keypressed_Select && (Low_Ohms_Data.Cal_direction == 1))
                    sprintf(Temp_String,"%*.3f KOhms >", 8, Low_Ohms_Data.Meas_Resistance/1000);
                else if(Low_Ohms_Data.UI_Keypressed_Select && (Low_Ohms_Data.Cal_direction == -1))
                    sprintf(Temp_String,"%*.3f KOhms <", 8, Low_Ohms_Data.Meas_Resistance/1000);
                else 
                    sprintf(Temp_String,"%*.3f KOhms  ", 8, Low_Ohms_Data.Meas_Resistance/1000);
                LCD_TextOut(1,0,(unsigned char *)Temp_String);   // could be optimized
            }
            Low_Ohms_Data.UI_Action = Low_Ohms_ACTION_CAL_1M;  // records current Action
        }
        break;
        // CALIBRATE 20M
        case Low_Ohms_STATE_CAL_20M:
        {
            if(Low_Ohms_Data.UI_Action == Low_Ohms_ACTION_CAL_1M) //give this msg once
            {
                LCD_ConstTextOut(0,0,CAL_Msg_20M_1);
                LCD_ConstTextOut(1,0,CAL_Msg_20M_2);   // Help for user
                __delay_ms(CAL_Msg_Time);
                LCD_ConstTextOut(0,0,CAL_Msg_All_1);
                LCD_ConstTextOut(1,0,CAL_Msg_All_2);   // Help for user
                __delay_ms(CAL_Msg_Time);
            }
            Low_Ohms_Data.UI_Action = Low_Ohms_ACTION_CAL_20M;  // records current Action
            Cal_Speed_Set();           
            if(Low_Ohms_Data.UI_Keypressed_Select && !Low_Ohms_Data.UI_Keypressed_Enter) //then increment cal
            {
                Low_Ohms_Data.Cal_Loops_While_Pressed += 1; // increment this!
                Low_Ohms_Data.Resistance_On_20M += 
                        Low_Ohms_Data.Cal_direction * Low_Ohms_Data.Cal_Step;
                if(Low_Ohms_Data.Resistance_On_20M > Resistance_On_20M_Max)
                    Low_Ohms_Data.Resistance_On_20M = Resistance_On_20M_Max;
                else if(Low_Ohms_Data.Resistance_On_20M < Resistance_On_20M_Min)
                    Low_Ohms_Data.Resistance_On_20M = Resistance_On_20M_Min;

           }
            else if(Low_Ohms_Data.UI_Keypressed_Select && Low_Ohms_Data.UI_Keypressed_Enter) //then reverse cal direction
            {
                Low_Ohms_Data.Cal_Loops_While_Pressed = 0; //reset this!
                Low_Ohms_Data.Cal_direction *= -1;
            }
            else if(!Low_Ohms_Data.UI_Keypressed_Select && Low_Ohms_Data.UI_Keypressed_Enter) //then accept cal and move on
            {
                Low_Ohms_Data.UI_Action = Low_Ohms_ACTION_IDLE;  // records current Action
                Low_Ohms_Data.state = Low_Ohms_STATE_IDLE;
                Low_Ohms_Data.Cal_Loops_While_Pressed = 0; //reset this!
                Low_Ohms_Data.Cal_direction = 1;  // reset this too
                Config_100k;
                Low_Ohms_Data_Save();  //write the data
                break;  // and punch out
            }
            else //both buttons are up...
            {
                Low_Ohms_Data.Cal_Loops_While_Pressed = 0; //reset this!
            }
            
            // now read the value and present
            Low_Ohms_Data.Prev_Meas_Resistance = Low_Ohms_Data.Meas_Resistance; // Record previous value
            MAX112XX_Read_ADC_5SPS(&ADC_Read_Value);
            Low_Ohms_Data.Meas_Val = (long int)(ADC_Read_Value  - ADC_Bipolar_Offset);
            Low_Ohms_Data.Meas_Resistance = (float)(ADC_Read_Value  - ADC_Bipolar_Offset);
            Low_Ohms_Data.Meas_Resistance = (float) Low_Ohms_Data.Meas_Resistance * (float)Low_Ohms_Data.Resistance_On_20M * 10;
            Low_Ohms_Data.Meas_Resistance = (float) Low_Ohms_Data.Meas_Resistance / ADC_Max_Value;            // help user if things look odd
            if(Low_Ohms_Data.Meas_Resistance > Max_Ohms_On_20M_Range)
            {
                LCD_ConstTextOut(0,0,CAL_Msg_20M_Err_1);   // prompt user    
                LCD_ConstTextOut(1,0,CAL_Msg_20M_Err_2);   // Prompt user    
            }
            else //present value
            {
                LCD_ConstTextOut(0,0,CAL_Msg_All_1);  
                if ((Low_Ohms_Data.UI_Keypressed_Select && Low_Ohms_Data.UI_Keypressed_Enter)&& (Low_Ohms_Data.Cal_direction == 1))
                    sprintf(Temp_String,"Increase Cal Val");
                else if ((Low_Ohms_Data.UI_Keypressed_Select && Low_Ohms_Data.UI_Keypressed_Enter)&& (Low_Ohms_Data.Cal_direction == -1))
                    sprintf(Temp_String,"Decrease Cal Val");
                else if(Low_Ohms_Data.UI_Keypressed_Select && (Low_Ohms_Data.Cal_direction == 1))
                    sprintf(Temp_String,"%*.5f Meg   >", 8,((float)Low_Ohms_Data.Meas_Resistance/(float)1000000));
                else if(Low_Ohms_Data.UI_Keypressed_Select && (Low_Ohms_Data.Cal_direction == -1))
                    sprintf(Temp_String,"%*.5f Meg   <", 8,((float)Low_Ohms_Data.Meas_Resistance/(float)1000000));
                else 
                    sprintf(Temp_String,"%*.5f Meg    ", 8,((float)Low_Ohms_Data.Meas_Resistance/(float)1000000));
                LCD_TextOut(1,0,(unsigned char *)Temp_String);   // could be optimized
            }
            Low_Ohms_Data.UI_Action = Low_Ohms_ACTION_CAL_20M;  // records current Action
        }
        break;

    
        // Test State
        case Low_Ohms_STATE_TEST:
        {
            sprintf(Temp_String,(char *)"In test state,  ");
            LCD_TextOut(0,0,(unsigned char *)Temp_String);   // could be optimized
            sprintf(Temp_String,(char *)"wondering why...");
            LCD_TextOut(1,0,(unsigned char *)Temp_String);   // could be optimized
            __delay_ms(Bad_News_Time);
            break;   
            //throw state back to idle
            Low_Ohms_Data.UI_Action = Low_Ohms_ACTION_TEST;  // records current Action
            Low_Ohms_Data.state = Low_Ohms_STATE_IDLE;
        }
        break;
        
        //Things have gone pear shaped if I find myself here...
        default:
        {
            sprintf(Temp_String,(char *)"Lost - Default! ");
            LCD_TextOut(0,0,(unsigned char *)Temp_String);   // could be optimized
            sprintf(Temp_String,(char *)"and feeling sad ");
            LCD_TextOut(1,0,(unsigned char *)Temp_String);   // could be optimized
            break;   
        }
    
    }

    return 1;
}

/*  Main application */
int main(void)
{
    // initialize the device
    SYSTEM_Initialize();
    
    do{
        Low_Ohms_Tasks();
    } while(1);
    return 1;
}
/**
 End of File
*/

