/**
  @Generated Pin Manager Header File

  @Company:
    Microchip Technology Inc.

  @File Name:
    pin_manager.h

  @Summary:
    This is the Pin Manager file generated using PIC10 / PIC12 / PIC16 / PIC18 MCUs

  @Description
    This header file provides APIs for driver for .
    Generation Information :
        Product Revision  :  PIC10 / PIC12 / PIC16 / PIC18 MCUs - 1.80.0
        Device            :  PIC16F18875
        Driver Version    :  2.11
    The generated drivers are tested against the following:
        Compiler          :  XC8 2.10 and above
        MPLAB 	          :  MPLAB X 5.30	
*/

/*
    (c) 2018 Microchip Technology Inc. and its subsidiaries. 
    
    Subject to your compliance with these terms, you may use Microchip software and any 
    derivatives exclusively with Microchip products. It is your responsibility to comply with third party 
    license terms applicable to your use of third party software (including open source software) that 
    may accompany Microchip software.
    
    THIS SOFTWARE IS SUPPLIED BY MICROCHIP "AS IS". NO WARRANTIES, WHETHER 
    EXPRESS, IMPLIED OR STATUTORY, APPLY TO THIS SOFTWARE, INCLUDING ANY 
    IMPLIED WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY, AND FITNESS 
    FOR A PARTICULAR PURPOSE.
    
    IN NO EVENT WILL MICROCHIP BE LIABLE FOR ANY INDIRECT, SPECIAL, PUNITIVE, 
    INCIDENTAL OR CONSEQUENTIAL LOSS, DAMAGE, COST OR EXPENSE OF ANY KIND 
    WHATSOEVER RELATED TO THE SOFTWARE, HOWEVER CAUSED, EVEN IF MICROCHIP 
    HAS BEEN ADVISED OF THE POSSIBILITY OR THE DAMAGES ARE FORESEEABLE. TO 
    THE FULLEST EXTENT ALLOWED BY LAW, MICROCHIP'S TOTAL LIABILITY ON ALL 
    CLAIMS IN ANY WAY RELATED TO THIS SOFTWARE WILL NOT EXCEED THE AMOUNT 
    OF FEES, IF ANY, THAT YOU HAVE PAID DIRECTLY TO MICROCHIP FOR THIS 
    SOFTWARE.
*/

#ifndef PIN_MANAGER_H
#define PIN_MANAGER_H

/**
  Section: Included Files
*/

#include <xc.h>

#define INPUT   1
#define OUTPUT  0

#define HIGH    1
#define LOW     0

#define ANALOG      1
#define DIGITAL     0

#define PULL_UP_ENABLED      1
#define PULL_UP_DISABLED     0

// get/set RA1 aliases
#define RA1_TRIS                 TRISAbits.TRISA1
#define RA1_LAT                  LATAbits.LATA1
#define RA1_PORT                 PORTAbits.RA1
#define RA1_WPU                  WPUAbits.WPUA1
#define RA1_OD                   ODCONAbits.ODCA1
#define RA1_ANS                  ANSELAbits.ANSA1
#define RA1_SetHigh()            do { LATAbits.LATA1 = 1; } while(0)
#define RA1_SetLow()             do { LATAbits.LATA1 = 0; } while(0)
#define RA1_Toggle()             do { LATAbits.LATA1 = ~LATAbits.LATA1; } while(0)
#define RA1_GetValue()           PORTAbits.RA1
#define RA1_SetDigitalInput()    do { TRISAbits.TRISA1 = 1; } while(0)
#define RA1_SetDigitalOutput()   do { TRISAbits.TRISA1 = 0; } while(0)
#define RA1_SetPullup()          do { WPUAbits.WPUA1 = 1; } while(0)
#define RA1_ResetPullup()        do { WPUAbits.WPUA1 = 0; } while(0)
#define RA1_SetPushPull()        do { ODCONAbits.ODCA1 = 0; } while(0)
#define RA1_SetOpenDrain()       do { ODCONAbits.ODCA1 = 1; } while(0)
#define RA1_SetAnalogMode()      do { ANSELAbits.ANSA1 = 1; } while(0)
#define RA1_SetDigitalMode()     do { ANSELAbits.ANSA1 = 0; } while(0)

// get/set RA2 aliases
#define RA2_TRIS                 TRISAbits.TRISA2
#define RA2_LAT                  LATAbits.LATA2
#define RA2_PORT                 PORTAbits.RA2
#define RA2_WPU                  WPUAbits.WPUA2
#define RA2_OD                   ODCONAbits.ODCA2
#define RA2_ANS                  ANSELAbits.ANSA2
#define RA2_SetHigh()            do { LATAbits.LATA2 = 1; } while(0)
#define RA2_SetLow()             do { LATAbits.LATA2 = 0; } while(0)
#define RA2_Toggle()             do { LATAbits.LATA2 = ~LATAbits.LATA2; } while(0)
#define RA2_GetValue()           PORTAbits.RA2
#define RA2_SetDigitalInput()    do { TRISAbits.TRISA2 = 1; } while(0)
#define RA2_SetDigitalOutput()   do { TRISAbits.TRISA2 = 0; } while(0)
#define RA2_SetPullup()          do { WPUAbits.WPUA2 = 1; } while(0)
#define RA2_ResetPullup()        do { WPUAbits.WPUA2 = 0; } while(0)
#define RA2_SetPushPull()        do { ODCONAbits.ODCA2 = 0; } while(0)
#define RA2_SetOpenDrain()       do { ODCONAbits.ODCA2 = 1; } while(0)
#define RA2_SetAnalogMode()      do { ANSELAbits.ANSA2 = 1; } while(0)
#define RA2_SetDigitalMode()     do { ANSELAbits.ANSA2 = 0; } while(0)

// get/set RA3 aliases
#define RA3_TRIS                 TRISAbits.TRISA3
#define RA3_LAT                  LATAbits.LATA3
#define RA3_PORT                 PORTAbits.RA3
#define RA3_WPU                  WPUAbits.WPUA3
#define RA3_OD                   ODCONAbits.ODCA3
#define RA3_ANS                  ANSELAbits.ANSA3
#define RA3_SetHigh()            do { LATAbits.LATA3 = 1; } while(0)
#define RA3_SetLow()             do { LATAbits.LATA3 = 0; } while(0)
#define RA3_Toggle()             do { LATAbits.LATA3 = ~LATAbits.LATA3; } while(0)
#define RA3_GetValue()           PORTAbits.RA3
#define RA3_SetDigitalInput()    do { TRISAbits.TRISA3 = 1; } while(0)
#define RA3_SetDigitalOutput()   do { TRISAbits.TRISA3 = 0; } while(0)
#define RA3_SetPullup()          do { WPUAbits.WPUA3 = 1; } while(0)
#define RA3_ResetPullup()        do { WPUAbits.WPUA3 = 0; } while(0)
#define RA3_SetPushPull()        do { ODCONAbits.ODCA3 = 0; } while(0)
#define RA3_SetOpenDrain()       do { ODCONAbits.ODCA3 = 1; } while(0)
#define RA3_SetAnalogMode()      do { ANSELAbits.ANSA3 = 1; } while(0)
#define RA3_SetDigitalMode()     do { ANSELAbits.ANSA3 = 0; } while(0)

// get/set LED_D2 aliases
#define LED_D2_TRIS                 TRISBbits.TRISB0
#define LED_D2_LAT                  LATBbits.LATB0
#define LED_D2_PORT                 PORTBbits.RB0
#define LED_D2_WPU                  WPUBbits.WPUB0
#define LED_D2_OD                   ODCONBbits.ODCB0
#define LED_D2_ANS                  ANSELBbits.ANSB0
#define LED_D2_SetHigh()            do { LATBbits.LATB0 = 1; } while(0)
#define LED_D2_SetLow()             do { LATBbits.LATB0 = 0; } while(0)
#define LED_D2_Toggle()             do { LATBbits.LATB0 = ~LATBbits.LATB0; } while(0)
#define LED_D2_GetValue()           PORTBbits.RB0
#define LED_D2_SetDigitalInput()    do { TRISBbits.TRISB0 = 1; } while(0)
#define LED_D2_SetDigitalOutput()   do { TRISBbits.TRISB0 = 0; } while(0)
#define LED_D2_SetPullup()          do { WPUBbits.WPUB0 = 1; } while(0)
#define LED_D2_ResetPullup()        do { WPUBbits.WPUB0 = 0; } while(0)
#define LED_D2_SetPushPull()        do { ODCONBbits.ODCB0 = 0; } while(0)
#define LED_D2_SetOpenDrain()       do { ODCONBbits.ODCB0 = 1; } while(0)
#define LED_D2_SetAnalogMode()      do { ANSELBbits.ANSB0 = 1; } while(0)
#define LED_D2_SetDigitalMode()     do { ANSELBbits.ANSB0 = 0; } while(0)

// get/set LED_D3 aliases
#define LED_D3_TRIS                 TRISBbits.TRISB1
#define LED_D3_LAT                  LATBbits.LATB1
#define LED_D3_PORT                 PORTBbits.RB1
#define LED_D3_WPU                  WPUBbits.WPUB1
#define LED_D3_OD                   ODCONBbits.ODCB1
#define LED_D3_ANS                  ANSELBbits.ANSB1
#define LED_D3_SetHigh()            do { LATBbits.LATB1 = 1; } while(0)
#define LED_D3_SetLow()             do { LATBbits.LATB1 = 0; } while(0)
#define LED_D3_Toggle()             do { LATBbits.LATB1 = ~LATBbits.LATB1; } while(0)
#define LED_D3_GetValue()           PORTBbits.RB1
#define LED_D3_SetDigitalInput()    do { TRISBbits.TRISB1 = 1; } while(0)
#define LED_D3_SetDigitalOutput()   do { TRISBbits.TRISB1 = 0; } while(0)
#define LED_D3_SetPullup()          do { WPUBbits.WPUB1 = 1; } while(0)
#define LED_D3_ResetPullup()        do { WPUBbits.WPUB1 = 0; } while(0)
#define LED_D3_SetPushPull()        do { ODCONBbits.ODCB1 = 0; } while(0)
#define LED_D3_SetOpenDrain()       do { ODCONBbits.ODCB1 = 1; } while(0)
#define LED_D3_SetAnalogMode()      do { ANSELBbits.ANSB1 = 1; } while(0)
#define LED_D3_SetDigitalMode()     do { ANSELBbits.ANSB1 = 0; } while(0)

// get/set LED_D4 aliases
#define LED_D4_TRIS                 TRISBbits.TRISB2
#define LED_D4_LAT                  LATBbits.LATB2
#define LED_D4_PORT                 PORTBbits.RB2
#define LED_D4_WPU                  WPUBbits.WPUB2
#define LED_D4_OD                   ODCONBbits.ODCB2
#define LED_D4_ANS                  ANSELBbits.ANSB2
#define LED_D4_SetHigh()            do { LATBbits.LATB2 = 1; } while(0)
#define LED_D4_SetLow()             do { LATBbits.LATB2 = 0; } while(0)
#define LED_D4_Toggle()             do { LATBbits.LATB2 = ~LATBbits.LATB2; } while(0)
#define LED_D4_GetValue()           PORTBbits.RB2
#define LED_D4_SetDigitalInput()    do { TRISBbits.TRISB2 = 1; } while(0)
#define LED_D4_SetDigitalOutput()   do { TRISBbits.TRISB2 = 0; } while(0)
#define LED_D4_SetPullup()          do { WPUBbits.WPUB2 = 1; } while(0)
#define LED_D4_ResetPullup()        do { WPUBbits.WPUB2 = 0; } while(0)
#define LED_D4_SetPushPull()        do { ODCONBbits.ODCB2 = 0; } while(0)
#define LED_D4_SetOpenDrain()       do { ODCONBbits.ODCB2 = 1; } while(0)
#define LED_D4_SetAnalogMode()      do { ANSELBbits.ANSB2 = 1; } while(0)
#define LED_D4_SetDigitalMode()     do { ANSELBbits.ANSB2 = 0; } while(0)

// get/set LED_D5 aliases
#define LED_D5_TRIS                 TRISBbits.TRISB3
#define LED_D5_LAT                  LATBbits.LATB3
#define LED_D5_PORT                 PORTBbits.RB3
#define LED_D5_WPU                  WPUBbits.WPUB3
#define LED_D5_OD                   ODCONBbits.ODCB3
#define LED_D5_ANS                  ANSELBbits.ANSB3
#define LED_D5_SetHigh()            do { LATBbits.LATB3 = 1; } while(0)
#define LED_D5_SetLow()             do { LATBbits.LATB3 = 0; } while(0)
#define LED_D5_Toggle()             do { LATBbits.LATB3 = ~LATBbits.LATB3; } while(0)
#define LED_D5_GetValue()           PORTBbits.RB3
#define LED_D5_SetDigitalInput()    do { TRISBbits.TRISB3 = 1; } while(0)
#define LED_D5_SetDigitalOutput()   do { TRISBbits.TRISB3 = 0; } while(0)
#define LED_D5_SetPullup()          do { WPUBbits.WPUB3 = 1; } while(0)
#define LED_D5_ResetPullup()        do { WPUBbits.WPUB3 = 0; } while(0)
#define LED_D5_SetPushPull()        do { ODCONBbits.ODCB3 = 0; } while(0)
#define LED_D5_SetOpenDrain()       do { ODCONBbits.ODCB3 = 1; } while(0)
#define LED_D5_SetAnalogMode()      do { ANSELBbits.ANSB3 = 1; } while(0)
#define LED_D5_SetDigitalMode()     do { ANSELBbits.ANSB3 = 0; } while(0)

// get/set RC6 procedures
#define RC6_SetHigh()            do { LATCbits.LATC6 = 1; } while(0)
#define RC6_SetLow()             do { LATCbits.LATC6 = 0; } while(0)
#define RC6_Toggle()             do { LATCbits.LATC6 = ~LATCbits.LATC6; } while(0)
#define RC6_GetValue()              PORTCbits.RC6
#define RC6_SetDigitalInput()    do { TRISCbits.TRISC6 = 1; } while(0)
#define RC6_SetDigitalOutput()   do { TRISCbits.TRISC6 = 0; } while(0)
#define RC6_SetPullup()             do { WPUCbits.WPUC6 = 1; } while(0)
#define RC6_ResetPullup()           do { WPUCbits.WPUC6 = 0; } while(0)
#define RC6_SetAnalogMode()         do { ANSELCbits.ANSC6 = 1; } while(0)
#define RC6_SetDigitalMode()        do { ANSELCbits.ANSC6 = 0; } while(0)

// get/set RC7 procedures
#define RC7_SetHigh()            do { LATCbits.LATC7 = 1; } while(0)
#define RC7_SetLow()             do { LATCbits.LATC7 = 0; } while(0)
#define RC7_Toggle()             do { LATCbits.LATC7 = ~LATCbits.LATC7; } while(0)
#define RC7_GetValue()              PORTCbits.RC7
#define RC7_SetDigitalInput()    do { TRISCbits.TRISC7 = 1; } while(0)
#define RC7_SetDigitalOutput()   do { TRISCbits.TRISC7 = 0; } while(0)
#define RC7_SetPullup()             do { WPUCbits.WPUC7 = 1; } while(0)
#define RC7_ResetPullup()           do { WPUCbits.WPUC7 = 0; } while(0)
#define RC7_SetAnalogMode()         do { ANSELCbits.ANSC7 = 1; } while(0)
#define RC7_SetDigitalMode()        do { ANSELCbits.ANSC7 = 0; } while(0)

// get/set LCD_D4 aliases
#define LCD_D4_TRIS                 TRISDbits.TRISD0
#define LCD_D4_LAT                  LATDbits.LATD0
#define LCD_D4_PORT                 PORTDbits.RD0
#define LCD_D4_WPU                  WPUDbits.WPUD0
#define LCD_D4_OD                   ODCONDbits.ODCD0
#define LCD_D4_ANS                  ANSELDbits.ANSD0
#define LCD_D4_SetHigh()            do { LATDbits.LATD0 = 1; } while(0)
#define LCD_D4_SetLow()             do { LATDbits.LATD0 = 0; } while(0)
#define LCD_D4_Toggle()             do { LATDbits.LATD0 = ~LATDbits.LATD0; } while(0)
#define LCD_D4_GetValue()           PORTDbits.RD0
#define LCD_D4_SetDigitalInput()    do { TRISDbits.TRISD0 = 1; } while(0)
#define LCD_D4_SetDigitalOutput()   do { TRISDbits.TRISD0 = 0; } while(0)
#define LCD_D4_SetPullup()          do { WPUDbits.WPUD0 = 1; } while(0)
#define LCD_D4_ResetPullup()        do { WPUDbits.WPUD0 = 0; } while(0)
#define LCD_D4_SetPushPull()        do { ODCONDbits.ODCD0 = 0; } while(0)
#define LCD_D4_SetOpenDrain()       do { ODCONDbits.ODCD0 = 1; } while(0)
#define LCD_D4_SetAnalogMode()      do { ANSELDbits.ANSD0 = 1; } while(0)
#define LCD_D4_SetDigitalMode()     do { ANSELDbits.ANSD0 = 0; } while(0)

// get/set LCD_D5 aliases
#define LCD_D5_TRIS                 TRISDbits.TRISD1
#define LCD_D5_LAT                  LATDbits.LATD1
#define LCD_D5_PORT                 PORTDbits.RD1
#define LCD_D5_WPU                  WPUDbits.WPUD1
#define LCD_D5_OD                   ODCONDbits.ODCD1
#define LCD_D5_ANS                  ANSELDbits.ANSD1
#define LCD_D5_SetHigh()            do { LATDbits.LATD1 = 1; } while(0)
#define LCD_D5_SetLow()             do { LATDbits.LATD1 = 0; } while(0)
#define LCD_D5_Toggle()             do { LATDbits.LATD1 = ~LATDbits.LATD1; } while(0)
#define LCD_D5_GetValue()           PORTDbits.RD1
#define LCD_D5_SetDigitalInput()    do { TRISDbits.TRISD1 = 1; } while(0)
#define LCD_D5_SetDigitalOutput()   do { TRISDbits.TRISD1 = 0; } while(0)
#define LCD_D5_SetPullup()          do { WPUDbits.WPUD1 = 1; } while(0)
#define LCD_D5_ResetPullup()        do { WPUDbits.WPUD1 = 0; } while(0)
#define LCD_D5_SetPushPull()        do { ODCONDbits.ODCD1 = 0; } while(0)
#define LCD_D5_SetOpenDrain()       do { ODCONDbits.ODCD1 = 1; } while(0)
#define LCD_D5_SetAnalogMode()      do { ANSELDbits.ANSD1 = 1; } while(0)
#define LCD_D5_SetDigitalMode()     do { ANSELDbits.ANSD1 = 0; } while(0)

// get/set LCD_D6 aliases
#define LCD_D6_TRIS                 TRISDbits.TRISD2
#define LCD_D6_LAT                  LATDbits.LATD2
#define LCD_D6_PORT                 PORTDbits.RD2
#define LCD_D6_WPU                  WPUDbits.WPUD2
#define LCD_D6_OD                   ODCONDbits.ODCD2
#define LCD_D6_ANS                  ANSELDbits.ANSD2
#define LCD_D6_SetHigh()            do { LATDbits.LATD2 = 1; } while(0)
#define LCD_D6_SetLow()             do { LATDbits.LATD2 = 0; } while(0)
#define LCD_D6_Toggle()             do { LATDbits.LATD2 = ~LATDbits.LATD2; } while(0)
#define LCD_D6_GetValue()           PORTDbits.RD2
#define LCD_D6_SetDigitalInput()    do { TRISDbits.TRISD2 = 1; } while(0)
#define LCD_D6_SetDigitalOutput()   do { TRISDbits.TRISD2 = 0; } while(0)
#define LCD_D6_SetPullup()          do { WPUDbits.WPUD2 = 1; } while(0)
#define LCD_D6_ResetPullup()        do { WPUDbits.WPUD2 = 0; } while(0)
#define LCD_D6_SetPushPull()        do { ODCONDbits.ODCD2 = 0; } while(0)
#define LCD_D6_SetOpenDrain()       do { ODCONDbits.ODCD2 = 1; } while(0)
#define LCD_D6_SetAnalogMode()      do { ANSELDbits.ANSD2 = 1; } while(0)
#define LCD_D6_SetDigitalMode()     do { ANSELDbits.ANSD2 = 0; } while(0)

// get/set LCD_D7 aliases
#define LCD_D7_TRIS                 TRISDbits.TRISD3
#define LCD_D7_LAT                  LATDbits.LATD3
#define LCD_D7_PORT                 PORTDbits.RD3
#define LCD_D7_WPU                  WPUDbits.WPUD3
#define LCD_D7_OD                   ODCONDbits.ODCD3
#define LCD_D7_ANS                  ANSELDbits.ANSD3
#define LCD_D7_SetHigh()            do { LATDbits.LATD3 = 1; } while(0)
#define LCD_D7_SetLow()             do { LATDbits.LATD3 = 0; } while(0)
#define LCD_D7_Toggle()             do { LATDbits.LATD3 = ~LATDbits.LATD3; } while(0)
#define LCD_D7_GetValue()           PORTDbits.RD3
#define LCD_D7_SetDigitalInput()    do { TRISDbits.TRISD3 = 1; } while(0)
#define LCD_D7_SetDigitalOutput()   do { TRISDbits.TRISD3 = 0; } while(0)
#define LCD_D7_SetPullup()          do { WPUDbits.WPUD3 = 1; } while(0)
#define LCD_D7_ResetPullup()        do { WPUDbits.WPUD3 = 0; } while(0)
#define LCD_D7_SetPushPull()        do { ODCONDbits.ODCD3 = 0; } while(0)
#define LCD_D7_SetOpenDrain()       do { ODCONDbits.ODCD3 = 1; } while(0)
#define LCD_D7_SetAnalogMode()      do { ANSELDbits.ANSD3 = 1; } while(0)
#define LCD_D7_SetDigitalMode()     do { ANSELDbits.ANSD3 = 0; } while(0)

// get/set LCD_RS aliases
#define LCD_RS_TRIS                 TRISDbits.TRISD4
#define LCD_RS_LAT                  LATDbits.LATD4
#define LCD_RS_PORT                 PORTDbits.RD4
#define LCD_RS_WPU                  WPUDbits.WPUD4
#define LCD_RS_OD                   ODCONDbits.ODCD4
#define LCD_RS_ANS                  ANSELDbits.ANSD4
#define LCD_RS_SetHigh()            do { LATDbits.LATD4 = 1; } while(0)
#define LCD_RS_SetLow()             do { LATDbits.LATD4 = 0; } while(0)
#define LCD_RS_Toggle()             do { LATDbits.LATD4 = ~LATDbits.LATD4; } while(0)
#define LCD_RS_GetValue()           PORTDbits.RD4
#define LCD_RS_SetDigitalInput()    do { TRISDbits.TRISD4 = 1; } while(0)
#define LCD_RS_SetDigitalOutput()   do { TRISDbits.TRISD4 = 0; } while(0)
#define LCD_RS_SetPullup()          do { WPUDbits.WPUD4 = 1; } while(0)
#define LCD_RS_ResetPullup()        do { WPUDbits.WPUD4 = 0; } while(0)
#define LCD_RS_SetPushPull()        do { ODCONDbits.ODCD4 = 0; } while(0)
#define LCD_RS_SetOpenDrain()       do { ODCONDbits.ODCD4 = 1; } while(0)
#define LCD_RS_SetAnalogMode()      do { ANSELDbits.ANSD4 = 1; } while(0)
#define LCD_RS_SetDigitalMode()     do { ANSELDbits.ANSD4 = 0; } while(0)

// get/set LCD_RW aliases
#define LCD_RW_TRIS                 TRISDbits.TRISD5
#define LCD_RW_LAT                  LATDbits.LATD5
#define LCD_RW_PORT                 PORTDbits.RD5
#define LCD_RW_WPU                  WPUDbits.WPUD5
#define LCD_RW_OD                   ODCONDbits.ODCD5
#define LCD_RW_ANS                  ANSELDbits.ANSD5
#define LCD_RW_SetHigh()            do { LATDbits.LATD5 = 1; } while(0)
#define LCD_RW_SetLow()             do { LATDbits.LATD5 = 0; } while(0)
#define LCD_RW_Toggle()             do { LATDbits.LATD5 = ~LATDbits.LATD5; } while(0)
#define LCD_RW_GetValue()           PORTDbits.RD5
#define LCD_RW_SetDigitalInput()    do { TRISDbits.TRISD5 = 1; } while(0)
#define LCD_RW_SetDigitalOutput()   do { TRISDbits.TRISD5 = 0; } while(0)
#define LCD_RW_SetPullup()          do { WPUDbits.WPUD5 = 1; } while(0)
#define LCD_RW_ResetPullup()        do { WPUDbits.WPUD5 = 0; } while(0)
#define LCD_RW_SetPushPull()        do { ODCONDbits.ODCD5 = 0; } while(0)
#define LCD_RW_SetOpenDrain()       do { ODCONDbits.ODCD5 = 1; } while(0)
#define LCD_RW_SetAnalogMode()      do { ANSELDbits.ANSD5 = 1; } while(0)
#define LCD_RW_SetDigitalMode()     do { ANSELDbits.ANSD5 = 0; } while(0)

// get/set LCD_E aliases
#define LCD_E_TRIS                 TRISDbits.TRISD6
#define LCD_E_LAT                  LATDbits.LATD6
#define LCD_E_PORT                 PORTDbits.RD6
#define LCD_E_WPU                  WPUDbits.WPUD6
#define LCD_E_OD                   ODCONDbits.ODCD6
#define LCD_E_ANS                  ANSELDbits.ANSD6
#define LCD_E_SetHigh()            do { LATDbits.LATD6 = 1; } while(0)
#define LCD_E_SetLow()             do { LATDbits.LATD6 = 0; } while(0)
#define LCD_E_Toggle()             do { LATDbits.LATD6 = ~LATDbits.LATD6; } while(0)
#define LCD_E_GetValue()           PORTDbits.RD6
#define LCD_E_SetDigitalInput()    do { TRISDbits.TRISD6 = 1; } while(0)
#define LCD_E_SetDigitalOutput()   do { TRISDbits.TRISD6 = 0; } while(0)
#define LCD_E_SetPullup()          do { WPUDbits.WPUD6 = 1; } while(0)
#define LCD_E_ResetPullup()        do { WPUDbits.WPUD6 = 0; } while(0)
#define LCD_E_SetPushPull()        do { ODCONDbits.ODCD6 = 0; } while(0)
#define LCD_E_SetOpenDrain()       do { ODCONDbits.ODCD6 = 1; } while(0)
#define LCD_E_SetAnalogMode()      do { ANSELDbits.ANSD6 = 1; } while(0)
#define LCD_E_SetDigitalMode()     do { ANSELDbits.ANSD6 = 0; } while(0)

// get/set LCD_POWER aliases
#define LCD_POWER_TRIS                 TRISDbits.TRISD7
#define LCD_POWER_LAT                  LATDbits.LATD7
#define LCD_POWER_PORT                 PORTDbits.RD7
#define LCD_POWER_WPU                  WPUDbits.WPUD7
#define LCD_POWER_OD                   ODCONDbits.ODCD7
#define LCD_POWER_ANS                  ANSELDbits.ANSD7
#define LCD_POWER_SetHigh()            do { LATDbits.LATD7 = 1; } while(0)
#define LCD_POWER_SetLow()             do { LATDbits.LATD7 = 0; } while(0)
#define LCD_POWER_Toggle()             do { LATDbits.LATD7 = ~LATDbits.LATD7; } while(0)
#define LCD_POWER_GetValue()           PORTDbits.RD7
#define LCD_POWER_SetDigitalInput()    do { TRISDbits.TRISD7 = 1; } while(0)
#define LCD_POWER_SetDigitalOutput()   do { TRISDbits.TRISD7 = 0; } while(0)
#define LCD_POWER_SetPullup()          do { WPUDbits.WPUD7 = 1; } while(0)
#define LCD_POWER_ResetPullup()        do { WPUDbits.WPUD7 = 0; } while(0)
#define LCD_POWER_SetPushPull()        do { ODCONDbits.ODCD7 = 0; } while(0)
#define LCD_POWER_SetOpenDrain()       do { ODCONDbits.ODCD7 = 1; } while(0)
#define LCD_POWER_SetAnalogMode()      do { ANSELDbits.ANSD7 = 1; } while(0)
#define LCD_POWER_SetDigitalMode()     do { ANSELDbits.ANSD7 = 0; } while(0)

/**
   @Param
    none
   @Returns
    none
   @Description
    GPIO and peripheral I/O initialization
   @Example
    PIN_MANAGER_Initialize();
 */
void PIN_MANAGER_Initialize (void);

/**
 * @Param
    none
 * @Returns
    none
 * @Description
    Interrupt on Change Handling routine
 * @Example
    PIN_MANAGER_IOC();
 */
void PIN_MANAGER_IOC(void);



#endif // PIN_MANAGER_H
/**
 End of File
*/