/* Microchip Technology Inc. and its subsidiaries.  You may use this software 
 * and any derivatives exclusively with Microchip products. 
 * 
 * THIS SOFTWARE IS SUPPLIED BY MICROCHIP "AS IS".  NO WARRANTIES, WHETHER 
 * EXPRESS, IMPLIED OR STATUTORY, APPLY TO THIS SOFTWARE, INCLUDING ANY IMPLIED 
 * WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY, AND FITNESS FOR A 
 * PARTICULAR PURPOSE, OR ITS INTERACTION WITH MICROCHIP PRODUCTS, COMBINATION 
 * WITH ANY OTHER PRODUCTS, OR USE IN ANY APPLICATION. 
 *
 * IN NO EVENT WILL MICROCHIP BE LIABLE FOR ANY INDIRECT, SPECIAL, PUNITIVE, 
 * INCIDENTAL OR CONSEQUENTIAL LOSS, DAMAGE, COST OR EXPENSE OF ANY KIND 
 * WHATSOEVER RELATED TO THE SOFTWARE, HOWEVER CAUSED, EVEN IF MICROCHIP HAS 
 * BEEN ADVISED OF THE POSSIBILITY OR THE DAMAGES ARE FORESEEABLE.  TO THE 
 * FULLEST EXTENT ALLOWED BY LAW, MICROCHIP'S TOTAL LIABILITY ON ALL CLAIMS 
 * IN ANY WAY RELATED TO THIS SOFTWARE WILL NOT EXCEED THE AMOUNT OF FEES, IF 
 * ANY, THAT YOU HAVE PAID DIRECTLY TO MICROCHIP FOR THIS SOFTWARE.
 *
 * MICROCHIP PROVIDES THIS SOFTWARE CONDITIONALLY UPON YOUR ACCEPTANCE OF THESE 
 * TERMS. 
 */

/* 
 * File:   MAX11207 header file
 * Author: Phil Prosser
 * Comments: Should be good for most MAZ112XX chips - but check!
 * Revision history: V0.1
 */

// This is a guard condition so that contents of this file are not included
// more than once.  
#ifndef MAX112XX_HEADER_TEMPLATE_H
#define	MAX112XX_HEADER_TEMPLATE_H



#include <xc.h> // include processor files - each processor file is guarded.  

// TODO Insert appropriate #include <>


/* board Definition*/
#define Low_Ohms_Meter

#if defined(Low_Ohms_Meter)
//    #warning "ADC-pinning for Low Ohms Meter"
    #define	ADC_CS_L	LATBbits.LATB3
    #define	ADC_CS_DIR	TRISBbits.TRISB3
    #define	ADC_SCLK	LATAbits.LATA0
    #define	ADC_DIN		LATAbits.LATA1
    #define	ADC_DOUT	LATBbits.LATB4
#else
    #error PLEASE SPECIFY LCD CONNECTIONS !
#endif

// ADC Constants to use
#define MAX112XX_Power_Up_Delay_ms 100
#define MAX112XX_200ms_Read_Delay_ms   250
#define MAX112XX_100ms_Read_Delay_ms   120
#define MAX112XX_Self_Cal_Time_ms 250  // data sheet stated min is 200ms
#define MAX112XX_Tiny_Delay_us 10
#define MAX112XX_Read_Loop_Max 2

// Define ADC interfaces
#define MAX112XX_CS_Assert      ADC_CS_L_SetLow();     
#define MAX112XX_CS_DeAssert    ADC_CS_L_SetHigh();

//COMMAND BYTE  - MODE 0
//COMMAND           START   MODE    CAL1    CAL0    IMPD    RATE2   RATE1   RATE0
//Self-Cal Cycle    1       0       0       1       0       0       0       0
//System Offset Cal 1       0       1       0       0       0       0       0
//System Gain Cal   1       0       1       1       0       0       0       0
//Immediate Pwr-Dn  1       0       0       0       1       0       0       0
//Convert 1sps      1       0       0       0       0       0       0       0
//Convert 2.5sps    1       0       0       0       0       0       0       1
//Convert 5sps      1       0       0       0       0       0       1       0
//Convert 10sps     1       0       0       0       0       0       1       1
//Convert 15sps     1       0       0       0       0       1       0       0
//Convert 30sps     1       0       0       0       0       1       0       1
//Convert 60sps     1       0       0       0       0       1       1       0
//Convert 120sps    1       0       0       0       0       1       1       1
//Define ADC Register values
#define MAX112XX_Self_Cal_5SPS      0x0092
#define MAX112XX_Self_Cal_10SPS     0x0093
#define MAX112XX_Sys_Offset_Cal     0x00A0  //not used
#define MAX112XX_Sys_Gain_Cal       0x00B0  //not used
#define MAX112XX_Pwr_Dn             0x0088  //not used
#define MAX112XX_Convert_1SPS       0x0080
#define MAX112XX_Convert_2_5SPS     0x0081
#define MAX112XX_Convert_5SPS       0x0082
#define MAX112XX_Convert_10SPS      0x0083
#define MAX112XX_Convert_15SPS      0x0084
#define MAX112XX_Convert_30SPS      0x0085
#define MAX112XX_Convert_60SPS      0x0086
#define MAX112XX_Convert_120SPS     0x0087


//COMMAND - MODE 1
//BIT           B7          B6          B5      B4  B3  B2  B1  B0
//BIT NAME      START = 1   MODE = 1    0       RS3 RS2 RS1 RS0 W/R

//Control Register MODE = 1
//  RS3     RS2     RS1     RS0     REGISTER ACCESS     POWER-ON RESET STATUS   REGISTER SIZE (BITS)
//  0       0       0       0       STAT1               0x00                    8   (READ))
//  0       0       0       1       CTRL1               0x02                    8
//  0       0       1       0       CTRL2               0x0F                    8
//  0       0       1       1       CTRL3               0x1E                    8
//  0       1       0       0       DATA                0x000000                24   (read this)
//  0       1       0       1       SOC                 0x000000                24   (dont care)
//  0       1       1       0       SGC                 0x000000                24   (dont care)
//  0       1       1       1       SCOC                0x000000                24   (dont care)
//  1       0       0       0       SCGC                0x000000                24   (dont care)

//STAT1
// Access via Command 0b11000000, 0xC0
#define MAX112XX_Stat1_RD_CMD 0x00c1  /* read */
// then READ one byte of Stat1 Data
//BIT       B7      B6      B5      B4      B3  B2  B1      B0
//BIT NAME  SYSOR   RATE2   RATE1   RATE0   OR  UR  MSTAT   RDY
//B7 = Sysor = Over Range during CAL
//B6,5,4 =  Rate 2, 1, 0 = rate at chich Cal was done
//B3, 2 = OR, UR over and under range meas
//B1 = MSTAT = Measurement Status 1=BUSY
//B0 RDY = Conversion Resut Available (will hold)
#define MAX112XX_SC_Gain_Read 0xCF    //read self cal offset register 
#define MAX112XX_SC_Offset_Read 0xD1  // Read Self Cal Gain register

#define MAX112XX_Stat_Bit    0x00002

//CTRL1
// Access by Command 0b1100001, 0xC1
#define MAX112XX_Ctrl1_WR_CMD 0x00c2 /* write */
#define MAX112XX_Ctrl1_RD_CMD 0x00c3 /* read */
//BIT       B7      B6      B5      B4      B3      B2      B1      B0
//BIT NAME  LINEF   U/B     EXTCLK  REFBUF  SIGBUF  FORMAT  SCYCLE  UNUSED
//DEFAULT   0       0       0       0       0       0       1       0
//B7 = LINEF, Line Freq 50Hz = 1, 60Hz = 0
//B6 = U/B, Unipolar(1) / Bipolar (0))
//B5 - EXTCLK (1 = Enabled)
//B4 = REFBUF 1 = Enabled, 0 = powered down
//B3 = SIGBUF 1 = Enabled, 0 = powered down
//B2 = FORMAT 0 = twos complement or 1 = Binary
//B1 = SCYCLE = Single cycle (1) or free run (0)
//B0 = UNUSED
//Want 0x1101 1110 with buffers
//want 0X1100 0110 using buffer op amp
#define MAX112XX_Ctrl1_Unipolar_Default 0xDE  //Unipolar meas Using internal buffers 
// For bipolar output set B6 = 0
// Want 0x1001 1110 with buffers
//Change 2022-03-28
#define MAX112XX_Ctrl1_Bipolar_Default 0x9E  //Bipolar Meas Using internal buffers 

//CTRL2
//Access by Command 0b11000100 0xC4
#define MAX112XX_Ctrl2_WR_CMD 0x00c4 /* write */
#define MAX112XX_Ctrl2_RD_CMD 0x00c5 /* read */
//BIT       B7      B6      B5      B4      B3      B2      B1      B0
//BIT NAME  DIR4    DIR3    DIR2    DIR1    DIO4    DIO3    DIO2    DIO1
//DEFAULT   0       0       0       0       1       1       1       1
//B7-4 = Bit Direction 0 = input 1 = output
//B3-0 = Value read / Written to port bits
#define MAX112XX_Ctrl2_Default 0xF0   // all outputs, all off
#define MAX112XX_Ctrl2_SET_ME1 0xF1   // GPIO1 high
#define MAX112XX_Ctrl2_SET_ME2 0xF2   // GPIO2 High
#define MAX112XX_Ctrl2_SET_ME3 0xF4   // all outputs, all off
#define MAX112XX_Ctrl2_SET_ME4 0xF8   // all outputs, all off

#define MAX112XX_Ctrl2_SET_500uA 0xF1   // ME1 Relay: Current Source 50mA on
#define MAX112XX_Ctrl2_SET_ResH_CurrentL 0xF2   // ME 2 Relay: 1M or Current H, 20M, 100k Low
#define MAX112XX_Ctrl2_SET_100k_CurrentH_10M_1ML 0xF4   // ME 3 Relay: Current Source 50mA on
#define MAX112XX_Ctrl2_SET_Ref_ResH_2_5VL 0xF8   // ME4: Switch Reference input to 2.5V or Reference Resistor

#define Relays_Meas_MilliOhms   (                                     MAX112XX_Ctrl2_SET_ResH_CurrentL | MAX112XX_Ctrl2_SET_100k_CurrentH_10M_1ML                             )
#define Relays_Meas_Ohms        (                                     MAX112XX_Ctrl2_SET_ResH_CurrentL | MAX112XX_Ctrl2_SET_100k_CurrentH_10M_1ML | MAX112XX_Ctrl2_SET_500uA)
#define Relays_Meas_100k        ( MAX112XX_Ctrl2_SET_Ref_ResH_2_5VL                                    | MAX112XX_Ctrl2_SET_100k_CurrentH_10M_1ML | MAX112XX_Ctrl2_SET_500uA)
#define Relays_Meas_1M          ( MAX112XX_Ctrl2_SET_Ref_ResH_2_5VL | MAX112XX_Ctrl2_SET_ResH_CurrentL |                                            MAX112XX_Ctrl2_SET_500uA)
#define Relays_Meas_20M         ( MAX112XX_Ctrl2_SET_Ref_ResH_2_5VL                                                                               | MAX112XX_Ctrl2_SET_500uA)

#define Config_MilliOhms        MAX112XX_Register_Write_Byte(MAX112XX_Ctrl2_WR_CMD, Relays_Meas_MilliOhms);
#define Config_Ohms             MAX112XX_Register_Write_Byte(MAX112XX_Ctrl2_WR_CMD, Relays_Meas_Ohms);
#define Config_100k             MAX112XX_Register_Write_Byte(MAX112XX_Ctrl2_WR_CMD, Relays_Meas_100k);
#define Config_1M               MAX112XX_Register_Write_Byte(MAX112XX_Ctrl2_WR_CMD, Relays_Meas_1M);
#define Config_20M              MAX112XX_Register_Write_Byte(MAX112XX_Ctrl2_WR_CMD, Relays_Meas_20M);
#define Config_Settle           __delay_ms(250)  //time for relay to stop bouncing and current to settle



//CTRL2
//Access by Command 0b11000110 0xC6
#define MAX112XX_Ctrl3_WR_CMD 0x00c6 /* write */
#define MAX112XX_Ctrl3_RD_CMD 0x00c7 /* read */
//BIT       B7      B6      B5      B4      B3      B2      B1      B0
//BIT NAME  DGAIN2* DGAIN1* DGAIN0* NOSYSG  NOSYSO  NOSCG   NOSCO   RESERVED
//DEFAULT   0       0       0       1       1       1       1       0
//B7-5 = dont care for no gain control devices
//B4 NoSyg = 1 disables System Gain
//B3 NOSYSO = 1 Disables use of system fofset correctiion
//B2 NOSCG = 1 Disables use of self cal gain
//B1 NOSCO = 1 disables use of self cal offset
//B0 RESERVED
#define MAX112XX_Ctrl3_Default 0x18  //Do this prior to self cal


//DATA
// FIRST Trigger a convert: #define MAX112XX_Convert_10SPS      0x0083
// THEN Read 0b11001001 0xC5
#define MAX112XX_Data_Read_Cmd 0xc9  //Then read three bytes


unsigned char MAX112XX_Register_Write_Byte(uint8_t Register_To_Write, uint8_t Value_To_Write);
unsigned char MAX112XX_Register_Read_Byte(uint8_t Register_To_Read, unsigned char *Value_Read);
unsigned char MAX112XX_Register_Read_Word(uint8_t Register_To_Read, long unsigned int *Value_Read);
unsigned char MAX112XX_Read_ADC_5SPS(long int *ADC_Value_Read);
unsigned char MAX112XX_Bipolar_Set(void);
unsigned char MAX112XX_Uniipolar_Set(void);



// live documentation

#ifdef	__cplusplus
extern "C" {
#endif /* __cplusplus */

    // TODO If C++ is being used, regular C code needs function names to have C 
    // linkage so the functions can be used by the c code. 

#ifdef	__cplusplus
}
#endif /* __cplusplus */

#endif	/* XC_HEADER_TEMPLATE_H */

