/* Microchip Technology Inc. and its subsidiaries.  You may use this software 
 * and any derivatives exclusively with Microchip products. 
 * 
 * THIS SOFTWARE IS SUPPLIED BY MICROCHIP "AS IS".  NO WARRANTIES, WHETHER 
 * EXPRESS, IMPLIED OR STATUTORY, APPLY TO THIS SOFTWARE, INCLUDING ANY IMPLIED 
 * WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY, AND FITNESS FOR A 
 * PARTICULAR PURPOSE, OR ITS INTERACTION WITH MICROCHIP PRODUCTS, COMBINATION 
 * WITH ANY OTHER PRODUCTS, OR USE IN ANY APPLICATION. 
 *
 * IN NO EVENT WILL MICROCHIP BE LIABLE FOR ANY INDIRECT, SPECIAL, PUNITIVE, 
 * INCIDENTAL OR CONSEQUENTIAL LOSS, DAMAGE, COST OR EXPENSE OF ANY KIND 
 * WHATSOEVER RELATED TO THE SOFTWARE, HOWEVER CAUSED, EVEN IF MICROCHIP HAS 
 * BEEN ADVISED OF THE POSSIBILITY OR THE DAMAGES ARE FORESEEABLE.  TO THE 
 * FULLEST EXTENT ALLOWED BY LAW, MICROCHIP'S TOTAL LIABILITY ON ALL CLAIMS 
 * IN ANY WAY RELATED TO THIS SOFTWARE WILL NOT EXCEED THE AMOUNT OF FEES, IF 
 * ANY, THAT YOU HAVE PAID DIRECTLY TO MICROCHIP FOR THIS SOFTWARE.
 *
 * MICROCHIP PROVIDES THIS SOFTWARE CONDITIONALLY UPON YOUR ACCEPTANCE OF THESE 
 * TERMS. 
 */

/* 
 * File:   Low Ohms header file
 * Author: Phil Prosser
 * Comments: Low Ohms specific header
 * Revision history: V0.1
 */

// This is a guard condition so that contents of this file are not included
// more than once.  
#ifndef XC_HEADER_TEMPLATE_H
#define	XC_HEADER_TEMPLATE_H

#include <xc.h> // include processor files - each processor file is guarded.  

// TODO Insert appropriate #include <>

// TODO Insert C++ class definitions if appropriate

// TODO Insert declarations

/*
 */

#define Splash_String_0  (unsigned char *)"Low Ohms Meter  "
#define Splash_String_1  (unsigned char *)"SC V3.0 2022    "
#define Blank            (const char *)"                "

#define Splash_Time_ms 1000

/*
 Interface Related Defines
 */
#define Select_Pressed_ADC_Val 100
#define Enter_Key_Pressed !Enter_Key_GetValue()
#define Select_Key_Pressed (Read_ADC_Input(Select_Key) < Select_Pressed_ADC_Val)
#define KeyPressed (Enter_Key_Pressed || Select_Key_Pressed)

/*
 ADC Related Constants
 */
// Full Scale ADC Value - Bipolar Mode
#define ADC_Max_Value                   0x7FFFFF //bottom 4 bits fixed
#define ADC_Bipolar_Offset              0x800000
#define PIC_ADC_Trigger_Delay_us        100

/* Global_Data*/
#define Max_Storage_Locations           10
#define Number_Of_Writes_offset         0
#define MilliOhms_Bits_Per_Ohm_offset   1
#define Ohms_Bits_Per_Ohm_offset        2
#define Resistance_On_100k_offset       3
#define Resistance_On_1M_offset         4
#define Resistance_On_20M_offset        5

// Constant Limits
#define Sense_Voltage_Nominal           2.5 //Volts
#define milliOhms_Sense_Voltage_Max     1.5 //Volts
#define Range_Switch_Margin             0.999 //switch to next range here
#define OK_Change_Meas_to_Meas          0.05 // this is 5%
#define Cal_Low_Speed_Loops             20 // seems a reasonable number of loops for slow steps
#define Cal_Med_Speed_Loops             40 // seems a reasonable number of loops for medium steps

// On milliohms range we use 50mA current and can measure 2.5V
// So Max resistance = 2.5/0.05 = 50 Ohms
// Ohms per bit = 2^23 / (2/0.05)= 335544 in bipolar mode
#define MilliOhms_Bits_Per_Ohm_Min      134000  //20% less
#define MilliOhms_Bits_Per_Ohm_Nom      167772 
#define MilliOhms_Bits_Per_Ohm_Max      200000  //20% more
#define Current_On_MilliOhms            0.05 //Amperes
#define Max_Ohms_On_milliOhm_Range     ((milliOhms_Sense_Voltage_Max)/Current_On_MilliOhms)
#define Hysteresis_mOhm_Ohm_Range       0.98 // add a couple of percent hysteresis
#define MilliOhms_Cal_Slow              3  // or 0.001%
#define MilliOhms_Cal_Med               15 // or 0.01%
#define MilliOhms_Cal_Fast              100 // or 0.1%


// On ohms range we use 0.5mA current and can measure 2.5V
// So Max resistance = 2.5/0.0005 = 5000 Ohms
// Ohms per bit = 2^23 / (2/0.0005)= 335544
#define Ohms_Bits_Per_DeciOhm_Min       13400    //20% less
#define Ohms_Bits_Per_DeciOhm_Nom       16777
#define Ohms_Bits_Per_DeciOhm_Max       20000    //20% more
#define Current_On_Ohms                 0.0005 //Amperes
#define Max_Ohms_On_Ohm_Range           ((milliOhms_Sense_Voltage_Max)/Current_On_Ohms)
#define Hysteresis_Ohm_100k_Range       0.98 // add a couple of percent hysteresis
#define Ohms_Cal_Slow                   1  // or 0.01%
#define Ohms_Cal_Med                    5 // or 0.1%
#define Ohms_Cal_Fast                   30 // or 1%// On 100k range we use a 100k reference resistor
// So Max resistance = 100k ohms
// And measured resistance = (Meas val/2^24)* reference
#define Resistance_On_100k_Min           90000     //10% less
#define Resistance_On_100k_Nom           100000
#define Resistance_On_100k_Max           110000    //10% more
#define Max_Ohms_On_100k_Range           (Range_Switch_Margin * Low_Ohms_Data.Resistance_On_100k)
#define Hysteresis_100k_1M_Range         0.98 // add a couple of percent hysteresis
#define Cal_Slow_100k                    1  // or 0.001%
#define Cal_Med_100k                     10 // or 0.01%
#define Cal_Fast_100k                    100 // or 0.1%// On 100k range we use a 100k reference resistor
                                             // On 1M range we use a 1M reference resistor
// So Max resistance = 1M ohms
// And measured resistance = (Meas val/2^24)* reference
#define Resistance_On_1M_Min             900000     //10% less
#define Resistance_On_1M_Nom             1000000
#define Resistance_On_1M_Max             1100000    //10% more
#define Max_Ohms_On_1M_Range             (Range_Switch_Margin * Low_Ohms_Data.Resistance_On_1M)
#define Hysteresis_1M_20M_Range          0.98 // add a couple of percent hysteresis
#define Cal_Slow_1M                      10  // or 0.001%
#define Cal_Med_1M                       100 // or 0.01%
#define Cal_Fast_1M                      1000 // or 0.1%// On 1M range we use a 1M reference resistor
// On 20M range we use a 1M reference resistor
// So Max resistance = 20M ohms
// And measured resistance = (Meas val/2^24)* reference
// NOTE this is 1/10 of the value to fit a long int
#define Resistance_On_20M_Min            1800000     //10% less
#define Resistance_On_20M_Nom            2000000
#define Resistance_On_20M_Max            2200000    //10% more
#define Cal_Slow_20M                     20  // or 0.001%
#define Cal_Med_20M                      200 // or 0.01%
#define Cal_Fast_20M                     2000 // or 0.1%// On 1M range we use a 1M reference resistor
#define Max_Ohms_On_20M_Range             (Low_Ohms_Data.Resistance_On_20M *10)
#define Max_Meas_Val_20M_Range           0xFFF000   //This will be ADC specific if change ADC type

//Measurement Constants
#define Measurement_Filter               0.95 // Filter coeff

#define Bad_News_Time                    3000 //Make user look at the bad news for 3 seconds
#define Stored_Data_Read_Error_0         (const char *)"Data read error "
#define Stored_Data_Read_Error_1         (const char *)"Using defaults  "
#define SPI_Error_1                      (const char *)"TGM Says: Oops  "
#define SPI_Error_2                      (const char *)"SPI Read Error  "
#define Over_Range_String_1              (const char *)"   Over Range   "
#define Over_Range_String_2              (const char *)"Check Sense Conn"
#define Re_Range_String_1                (const char *)" Changing Range "
#define Re_Range_String_2                (const char *)"                "
#define ADC_Init_Err_Msg                 (const char *)"ADC Init. error "
#define CAL_Msg_Time                      2000  //put meddages up for 2 secs each  
#define CAL_Msg_1_1                      (const char *)"  Calibration   "
#define CAL_Msg_1_2                      (const char *)"5 ranges in all "
#define CAL_Msg_2_1                      (const char *)"Select = change "
#define CAL_Msg_2_2                      (const char *)"cal factor      "
#define CAL_Msg_3_1                      (const char *)"Select + Enter  "
#define CAL_Msg_3_2                      (const char *)"change up / down"
#define CAL_Msg_4_1                      (const char *)"Enter alone will"
#define CAL_Msg_4_2                      (const char *)"accept change   "
#define CAL_Msg_milliOhms_1              (const char *)"mOhm Calinration"
#define CAL_Msg_milliOhms_2              (const char *)"Use 10-30 Ohms  "
#define CAL_Msg_milliOhms_Err_1          (const char *)"Connect Cal Res "
#define CAL_Msg_milliOhms_Err_2          (const char *)"Nom: 10-30 Ohms "
#define CAL_Msg_Ohms_1                   (const char *)"Ohm Calibration "
#define CAL_Msg_Ohms_2                   (const char *)"Use 1-3000 Ohms "
#define CAL_Msg_Ohms_Err_1               (const char *)"Connect Cal Res "
#define CAL_Msg_Ohms_Err_2               (const char *)"Nom: 1-3000 Ohms"
#define CAL_Msg_100k_1                   (const char *)"100k Calibration"
#define CAL_Msg_100k_2                   (const char *)"Use 10-99k Ohms "
#define CAL_Msg_100K_Err_1               (const char *)"Connect Cal Res "
#define CAL_Msg_100K_Err_2               (const char *)"Nom: 10-99K Ohms"
#define CAL_Msg_1M_1                     (const char *)"1M Calibration  "
#define CAL_Msg_1M_2                     (const char *)"Use 0.2-0.9MOhms"
#define CAL_Msg_1M_Err_1                 (const char *)"Connect Cal Res "
#define CAL_Msg_1M_Err_2                 (const char *)"Nom: 0.2-0.9MOhm"
#define CAL_Msg_20M_1                    (const char *)"20M Calibration "
#define CAL_Msg_20M_2                    (const char *)"Use 1-19M Ohms  "
#define CAL_Msg_20M_Err_1                (const char *)"Connect Cal Res "
#define CAL_Msg_20M_Err_2                (const char *)"Nom: 1-19M Ohms "
#define CAL_Msg_All_1                    (const char *)"Adjust to Cal.. "
#define CAL_Msg_All_2                    (const char *)"                "
#define Battery_Note                     (const char *)"Battery Voltage "
#define Battery_Low1                     (const char *)"Battery Low!    "
#define Battery_Low2                     (const char *)"Please Replace  "

#define PIC_ADC_Scale                    (float) (3.45 * (22+10)/10/1024)
#define Low_Batt                         (float) 6.5 
#define Batt_Time                        2000

// *****************************************************************************
// *****************************************************************************
/* Application states
  Summary:
  The first set are Application states enumeration
  Description:
    This enumeration defines the valid application states.  These states
    determine the behavior of the application at various times.
*/
// *****************************************************************************
// *****************************************************************************
typedef enum
{
	/* Application's state machine's initial state. */
	Low_Ohms_INIT=0,
	Low_Ohms_STATE_LCDINIT,
    Low_Ohms_STATE_TEST,
    Low_Ohms_STATE_milliOhm,        
    Low_Ohms_STATE_Ohm,
    Low_Ohms_STATE_100k,
    Low_Ohms_STATE_1M,
    Low_Ohms_STATE_20M,
    Low_Ohms_STATE_IDLE,
    Low_Ohms_STATE_CAL,
    Low_Ohms_STATE_CAL_mOhm,
    Low_Ohms_STATE_CAL_Ohm,
    Low_Ohms_STATE_CAL_100K,
    Low_Ohms_STATE_CAL_1M,
    Low_Ohms_STATE_CAL_20M
} Low_Ohms_STATES;




// *****************************************************************************
/* Application Data

  Summary:
    Holds Low_Ohms application action data

  Remarks:
    Application strings and buffers are be defined outside this structure. */
typedef enum
{
	/* Application's state machine's initial state. */
	Low_Ohms_ACTION_INIT=0,
	Low_Ohms_ACTION_NULL,
	Low_Ohms_ACTION_TEST,
	Low_Ohms_ACTION_IDLE,            
	Low_Ohms_ACTION_milliOhms,
    Low_Ohms_ACTION_Ohms,
    Low_Ohms_ACTION_100k,
    Low_Ohms_ACTION_1M,
    Low_Ohms_ACTION_20M,
	Low_Ohms_ACTION_CAL_milliOhms,
    Low_Ohms_ACTION_CAL_Ohms,
    Low_Ohms_ACTION_CAL_100k,
    Low_Ohms_ACTION_CAL_1M,
    Low_Ohms_ACTION_CAL_20M,
    Low_Ohms_ACTION_CAL,            
    Low_Ohms_ACTION_LOAD
           
	/* TODO: Define states used by the application state machine. */
} Low_Ohms_ACTIONS;


// *****************************************************************************
/* Application Data

  Summary:
    Holds Low_Ohms application data

  Remarks:
    Application strings and buffers are be defined outside this structure.
 */
// *****************************************************************************
// *****************************************************************************

typedef struct
{
    /* The application's current state */
    Low_Ohms_STATES     state;                  /* UI driver timer handle. */
    long int            UI_Count;               /* UI fast count. */
    long int            Number_Of_Writes;       /* UI fast count. */
    char                UI_Update_Display;      /* UI needs update */
    long int            UI_Keypressed;          /* UI action */
    long int            UI_Keypressed_Enter;    /* UI action Enter*/
    long int            UI_Keypressed_Select;   /* UI Action Select */
    Low_Ohms_ACTIONS    UI_Action;              /* Heartbeat driver timer handle. */
    long int            Meas_Val;               /* ADC value read */
    float               Meas_Resistance;        /* Measured Resistance */
    float               Prev_Meas_Resistance;   /* Measured Resistance */
    long int            MilliOhms_Bits_Per_Ohm; /* ADC conversion to Ohms on milliOhms range */
    long int            Ohms_Bits_Per_DeciOhm;      /* ADC conversion to Ohms on Ohms range */
    long int            Cal_Step;               /* used in calibratiuon - varies with speed */
    long int            Cal_Loops_While_Pressed; /* Count of how many cal steps the button has been down for */
    long int            Cal_direction;          /* used to increment or decrement cal value */
    long int            Resistance_On_100k;     /* Reference Resistance on 100k range */
    long int            Resistance_On_1M;       /* Reference Resistance on 1M range */
    long int            Resistance_On_20M;      /* Reference Resistance on 20M range */
    long int            heartbeatCount;         /* Heartbeat LED toggle flag. */
    char                heartbeatToggle;
    long int            Zero_Offset;            /* On low Ohms range what residual value do we see? Use as offset */
} LowOhmsDATA;


// Comment a function and leverage automatic documentation with slash star star
/**
    <p><b>Function prototype:</b></p>
  
    <p><b>Summary:</b></p>

    <p><b>Description:</b></p>

    <p><b>Precondition:</b></p>

    <p><b>Parameters:</b></p>

    <p><b>Returns:</b></p>

    <p><b>Example:</b></p>
    <code>
 
    </code>

    <p><b>Remarks:</b></p>
 */
// TODO Insert declarations or function prototypes (right here) to leverage 
// live documentation

#ifdef	__cplusplus
extern "C" {
#endif /* __cplusplus */

    // TODO If C++ is being used, regular C code needs function names to have C 
    // linkage so the functions can be used by the c code. 

#ifdef	__cplusplus
}
#endif /* __cplusplus */

#endif	/* XC_HEADER_TEMPLATE_H */

