/* Main.c: 16F1829 Internal 16MHz + EUSART 8N1@115200
 * Compiler: XC8 (v1.42) MPLABX (v4.15)
 * V1.0 - BENABADJI Salim - Oran - Dec. 08th, 2022 ... Jan. 07th, 2023
 */

#include <pic16f1829.h>
#include "Main.h"
#include "16F1829internal.h"
#include "usart_pic16.h"
#include "adc1829.h"
#include "SPI2_Header.h"
#include "NokiaDrv2.h"
#include "NokiaFont.h"

__EEPROM_DATA(0x04,0x3C,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF) ;
//@ 0: cycle (acquisition cycle: config 1, 2, 4, 8, ..., 64) default: 4s
//@ 1: oled (oled display delay: config 15, 30, 45, ..., 90) default: 60s

char cnt = 0, domeas = 1, doWOC = 0, dureeBP1pushed = 0 ;
unsigned char dgt, cycle, cycleOLD, cycleTO = 0 ;  // 0 < cycleTO < cycle
unsigned char oled, oledOLD, oledTO = 0 ;  // 0 < oledTO < oled
char delay10s = 0, cfgParam = 0, verbose = 0 ;
char txt[15] ;
short reglage = 0, runscroll = 0 ; // <--------- REMETTRE EN TYPE CHAR ?
short BP1pushed = -1, enfoncee = 0 ;  // <--------- REMETTRE EN TYPE CHAR ?
short i, j, k ;

//unsigned int calib = 242 ; // 10-bit numerical count to be retreived
unsigned int calib = 241 ; // 10-bit numerical count to be retreived

unsigned int meas_Vbat = 0 ; 
unsigned int meas_cCO = 0, meas_CO = 0, measCOinV = 0 ;//in NC, & PPM, & Volt
int measVbat ;

char nokiaSleep = 0 ;

short firstime = 1, p, ippm = 0, ippmin, ippmax ;
unsigned int ppm, ppminterval[24] ;
char lin, col ;
char dgt, xp, s, seuil[4] = {30, 50, 80, 120} ; // seuils CO alert
//unsigned int s, seuil[4] = {30, 50, 80, 120} ; // seuils CO alert

//----------------------------------------------------------------------------
// test @ T=205s => (F=4.8 kHz inaudible pour mini ceramic piezo diam:15.5mm) 
//do again T=410s => F=2.44 kHz  
//----------------------------------------------------------------------------
void BipHi() //alarm for CO alert (dure 16ms)
{
  for (int t = 0; t < 40; t++) 
  { 
    PIEZO = 0 ; PIEZOb = 1 ; __delay_us(200) ; // RA5,RA4 Lo,Hi => piezo on
    PIEZO = 1 ; PIEZOb = 0 ; __delay_us(200) ; // RA5,RA4 Hi,Lo => piezo on
  }
  PIEZO = 0 ; PIEZOb = 0 ;
}
//----------------------------------------------------------------------------
void BipLo() //alarm for battery LOW (dure 16ms)
{
  for (int t = 0; t < 20; t++) 
  { 
    PIEZO = 0 ; PIEZOb = 1 ; __delay_us(400) ; // RA5,RA4 Lo,Hi => piezo on
    PIEZO = 1 ; PIEZOb = 0 ; __delay_us(400) ; // RA5,RA4 Hi,Lo => piezo on
  }
  PIEZO = 0 ; PIEZOb = 0 ;
}
//----------------------------------------------------------------------------
void clic() //BP1 clic (dure 6ms)
{
  for (int t = 0; t < 15; t++) 
  { 
    PIEZO = 0 ; PIEZOb = 1 ; __delay_us(200) ; // RA5,RA4 Lo,Hi => piezo on
    PIEZO = 1 ; PIEZOb = 0 ; __delay_us(200) ; // RA5,RA4 Hi,Lo => piezo on
  }
  PIEZO = 0 ; PIEZOb = 0 ;
}

//----------------------------------------------------------------------------
void initMain()
{
  //OSCCON = 0X72;          // set internal oscillator frequency, 8 MHz
  //internal_8() ;      // Run at 8 MHz 
  internal_16() ;
  
  RES = 1 ;                    // disable reset of NOKIA5110
 
  TRISA = 0b00001111 ;         // outputs RA4/RA5 piezo, input RA2/AN2  
  TRISB = 0b01110000 ;         // RB7 outputs, others inputs
  TRISC = 0b00100000 ;         // RC4/TX output ; RC5/RX input 
                               // RC6 out to pwr aop ; RC7 out to pwr LED BL
  NOKIA_BL = 1 ; // turn on BL
  PWR_AOP = 0 ; // turn off power for the AOP MCP5001
  //PWR_AOP = 1 ; // turn on power for the AOP MCP5001
    
  OPTION_REG = 0b01000001 ; // pullup on, <5>=0:RA2 I/O, TMR0 prescale(1:4) 
 
  WPUA = 0b00001011 ;  // RA0, RA1, RA3 pullups enabled
  WPUB = 0b01110000 ;  // RB4, RB5, RB6 pullups enabled
  WPUC = 0 ; 
  
  //ATTENTION, dans SPI_Init_Master(), ADCON0 et ADCON1 touchs
  // ainsi que ANSELA, ANSELB, ANSELC
  ANSELA = 0b00000100 ;
  ANSELB = 0b00000000 ;
  ANSELC = 0b00000000 ;
  
    //----------Setup UART----------
  /*//deja vu  
  ANSELCbits.ANSC4 = 0 ; TRISCbits.TRISC4 = 0 ;
  ANSELCbits.ANSC5 = 0 ; TRISCbits.TRISC5 = 1 ;
  */

  BipLo() ; __delay_ms(500) ; BipHi() ;  //SPLASH sonore

  APFCON0 = 0b10000100 ; //<7>=1: RX is on RC5 ; <2>=1: TX is on RC4 
  
  //INTCONbits.GIE = 1 ;
  //INTCONbits.PEIE = 1 ;
  //INTCON = 0xC0 ;      // Set GIE, PEIE
  INTCON = 0xC8 ;      // Set GIE, PEIE(for intTMR1), IOCIE(for intWOC)
  
  //////INTCONbits.TMR0IE = 1 ;
  //////INTCON = 0xE0 ;      // Set GIE, PEIE, TMR0IE
    
  PIE1bits.RCIE = 1 ;  // set up UART 1 receive interrupt 

    //----------Setup WOC on RA3----------
  //INTCONbits.IOCIE = 1 ; //deja vu 
  IOCANbits.IOCAN3 = 1 ; //enable RA3 to detect a falling edge
  IOCAFbits.IOCAF3 = 0 ; //clearing flag
 
    //----------Setup I2C----------
  /*//deja vu  
    // Setup pins for I2C
  ANSELCbits.ANSB4 = 0 ; TRISCbits.TRISB4 = 1 ;
  ANSELCbits.ANSB6 = 0 ; TRISCbits.TRISB6 = 1 ;
  */
     //----------Setup ADC----------
  initADC10() ; 

    //----------Setup FVR----------
                         // PIC12F1840errata.PDF page 7/11 :
  FVRCONbits.FVREN = 1 ; // CAUTION: set the FVREN bit prior to adjusting...
                         //... the amplifier output selections with the ADFVR
  FVRCONbits.ADFVR = 0b10 ; // FVR = 2.048V
  //FVRCONbits.ADFVR = 0b11 ; // FVR = 4.096V  
  
    //----------Setup PWM----------
  //initPWM() ; 
}
//----------------------------------------------------------------------------
void val2txt(unsigned int iVal, char *chx, char nbrDigits)
{
char t = 0 ;  
    
  //buff11 = itoa (&status, i, 10) ;
  //if (nbrDigits > 4) { ch = iVal / 10000 ; OLED_PutChar(ch+48) ; }  //ten thousands
  if (nbrDigits > 3)  chx[t++] = (iVal / 1000) % 10 + 48 ; //thousands
  if (nbrDigits > 2)  chx[t++] = (iVal / 100) % 10 + 48 ;  //hundreds
  if (nbrDigits > 1)  chx[t++] = (iVal / 10) % 10 + 48 ;   //tens
                      chx[t++] = iVal % 10 + 48 ;          //units
  chx[t] = 0 ;
}
//-----------------------------------------------------------------------------
void AffZoom2 (unsigned int val, unsigned char row, unsigned char colpix)
{
unsigned char t, ch ;
      
  for (t=1; t<4; t++)        
  { ch = val % 10 + 48 ; val /= 10 ; LCD_PutCharZoom2( ch, row, colpix) ; colpix -= 13 ; 
  }   
}
//-----------------------------------------------------------------------------
void entete (void)
{
  //UARTWriteString("\r\nBat/cy\t CO2\tT[C]\tH[%]\tVbat\tRTCC\r\n") ;
  UARTWriteString("\r\nBat\tncCO\tTO/Cyc\tTO/Visu\r\n") ;
}
//=============================================================================
void APOMOS_cfg ()
{
  Nokia_PositionXY (0, 0) ; Nokia_SendString("APOMOS 7 - ") ; 
  Nokia_PositionXY (54, 0) ; Nokia_SendString("CONFIG") ; 
  Nokia_HLine(1, 0x08) ;
  
  Nokia_PositionXY (0, 2) ; Nokia_SendString("measure CYCLE") ;
  Nokia_PositionXY (72, 2) ; LCD_Write_Integer(cycle, 2) ;
  //Nokia_PositionXY (0, 3) ; Nokia_SendString("1 2 4 8 16 32 64") ;

  Nokia_PositionXY (0, 3) ; Nokia_SendString("display DELAY") ;
  Nokia_PositionXY (72, 3) ; LCD_Write_Integer(oled, 2) ;
  //Nokia_PositionXY (0, 5) ; Nokia_SendString("15 30 45 60 75 90") ;
  //Nokia_PositionXY (74, 5) ; Nokia_SendString("90") ; //avoid '0' end-slice
  
  Nokia_PositionXY (0, 5) ; Nokia_SendString("1 2 4 8 16 32 64") ;
  Nokia_HLine(4, 0x08) ; //avoid end-slice
}
//=============================================================================
void APOMOS_verbose ()
{ 
//char lin, col ;

  Nokia_Clear() ; p = 0 ;
  for (lin=0; lin<6; lin++)
    for (col=5; col<80; col+=20)
    { ppm = ppminterval[p] ;
      Nokia_PositionXY (col, lin) ; LCD_Write_Integer(ppm, 3) ;
      if (p == ippmax) { Nokia_PositionXY (col-5, lin) ; LCD_PutChar ('<') ; }
      if (p == ippmin) { Nokia_PositionXY (col-5, lin) ; LCD_PutChar ('>') ; }
      p++ ;
    } 
    //avoid end-slice at last lin, last colpix
  Nokia_PositionXY (0, 0) ; LCD_DrawLine (0x00, 1) ;  
}  
//=============================================================================
void APOMOS_main_disp_time ()
{
  //Nokia_Clear() ; //Nokia_HLine(2, 0x02) ; //Lin2 =====
    // display cycleTO / cycle
  Nokia_PositionXY (0, 0) ; Nokia_SendString("C:") ;
  LCD_Write_Integer(cycleTO, 2) ; LCD_PutChar('/') ;
  LCD_Write_Integer(cycle, 2) ; LCD_PutChar('s') ;
    // display oledTO / oled
  Nokia_PositionXY (0, 1) ; Nokia_SendString("V:") ;
  LCD_Write_Integer(oledTO, 2) ; LCD_PutChar('/') ;
  LCD_Write_Integer(oled, 2) ; LCD_PutChar('s') ;
    //display U or P (serial cable Unplugged or Plugged)
  Nokia_PositionXY (51, 1) ;
  if (RC5 == 1) LCD_PutChar('P') ; else LCD_PutChar('U') ;
          
  LCD_DrawBat() ;
}                            
//=============================================================================
void APOMOS_main_disp_meas ()
{
  Nokia_PositionXY (1, 3) ; LCD_Write_Integer(measCOinV, 3) ; 
  Nokia_PositionXY (17, 3) ; LCD_PutChar('v') ;
  Nokia_PositionXY (5, 3) ; LCD_DrawLine (0x80, 1) ; //decimal point
    // Dcaler le 1er dgt vers la gauche pour bien montrer le pt dcimal
  int z = measCOinV / 100 ;
  Nokia_PositionXY (0, 3) ; LCD_PutChar(48+z) ;
         
    //GLOBA: CE BLOC1 OCCUPE MOINS D'ESPACE ROM
  xp = 0 ;
  for (s=0; s<4; s++)
  { if (meas_CO < seuil[s]) dgt = 126 ; else dgt = 127 ; 
    Nokia_PositionXY (xp, 4) ; Nokia_SendData(dgt) ;
    xp += 6 ;
  }
      
  //Nokia_PositionXY (23, 3) ; LCD_Write_Integer(ppminterval[23], 3) ; //PROVISOIRE
  AffZoom2 (meas_CO, 3, 73) ;
  //Nokia_PositionXY (23, 4) ; LCD_Write_Integer(ppminterval[23], 3) ; //PROVISOIRE
       
  Nokia_PositionXY (1, 5) ; LCD_Write_Integer(ppminterval[ippmin], 3) ;  
  Nokia_PositionXY (24, 5) ; Nokia_SendString("< ppm <") ;
  Nokia_PositionXY (67, 5) ; LCD_Write_Integer(ppminterval[ippmax], 3) ;
        
  Nokia_HLine(2, 0x02) ; //Lin2 ===== //avoid end-slice       
}
     
///////////////////////////////////////////////////////////////////////////////
void main(void)
{
  initMain() ;
  
    // Initialize SPI
  SPI2_Init_Master() ; __delay_ms(1000) ; // MSdelay(1000) ; //delay to stabilize
  
    // Initialize LCD
  Nokia_Init() ;              
  Nokia_Clear() ;
  Nokia_HLine(0, 0x08) ; Nokia_HLine(3, 0x10) ;
  
     // Initialize I2C
  //I2C_Init() ; __delay_ms(1000) ; 
  
  //readDS1307() ;  
  
    // Initialize UART
  UART_Init() ; __delay_ms(1000) ; //delay to stabilize
  
    //init TMR1 interrupt
  TMR1IF = 0 ;             // clear TMR1IF
  //TMR1L = 0x00 ; TMR1H = 0x00 ;  // Initialize Timer1 register 
  T1CON = 0x30 ;           // 1:8 Prescale value, Timer1 OFF
  //T1CON = 0x8E ;           // 1:1 Prescale value, external 32768Hz, Timer1 OFF
  TMR1IE = 1 ;             // enable Timer1 interrupt
  //INTCON = 0xC0 ;          // Set GIE, PEIE

    //================== Display IMG1 (SPLASH) ====================== 
  char splash[7] = "APOMOS" ;  
  j = 1 ;
  for (i = 0; i < 6; i++) 
  { j += 2 ; LCD_PutCharZoom2( splash[i], 1, j ) ; j += 11 ;
    //OPTIONAL ANIMATION
    Nokia_PositionXY (j, 2) ; Nokia_SendData(i+49) ; 
    Nokia_HLine(0, 0x08) ; //avoid end-slice at last lin, last colpix 
    __delay_ms(700) ;
    Nokia_PositionXY (j, 2) ; Nokia_SendData(32) ; //blank car. 
  }
  Nokia_PositionXY (79, 2) ; Nokia_SendString("7") ;

  Nokia_HLine(0, 0x0A) ; Nokia_HLine(3, 0x0A) ;
  __delay_ms(1000) ;

                          //Nokia_SendString("12345678901234567");
  Nokia_PositionXY (0, 4) ; Nokia_SendString(" Ultra Low Power");
  Nokia_PositionXY (0, 5) ; Nokia_SendString(" CO Monitor Syst.");
  __delay_ms(4000) ; 
  Nokia_Clear() ;

  cycle = EEPROM_READ (0) ; cycleTO = cycle ; cycleOLD = cycle ;
  oled = EEPROM_READ (1) ; oledTO = oled ; oledOLD = oled ;
  
  UARTWriteString("\r\nApomos7v1: CO MONITOR LPv1 2023") ; //__delay_ms(1000) ;
  //UARTWriteString("\r\nRun Stop Dump Fulldump Plus Minus Next") ; //__delay_ms(1000) ;
  UARTWriteString("\r\nRun Stop Plus Minus Next") ; //__delay_ms(1000) ;
  UARTWriteString("\r\n") ;
  entete () ;  
    
  TMR1ON = 1 ;
  
  Nokia_HLine(2, 0x02) ;  

  /*  //test EEP
  UARTWriteString("writing 135 into 24LC64\r\n") ;
  valEEP = 135 ; writeEEP(0x1FFF, valEEP) ;
  __delay_ms(100) ;
  UARTWriteString("done\r\n") ;
  valEEP = 222 ;
  valEEP = readEEP(0x1FFF) ;
  UARTWriteString("valEEP = ") ; 
  val2txt(valEEP, txt, 3) ; UARTWriteString(txt) ;
  UARTWriteString("\r\n") ;
  */  
  while(1) ////////////////////// ENDLESS LOOP ////////////////////////////////  
  { 
    if (doWOC == 1)
    { doWOC = 0 ;
      NOKIA_BL = 1 ; clic() ; //ce clic simule aussi un debounce  6 ms
      if (nokiaSleep) 
      { nokiaSleep = 0 ; Nokia_Wake() ;
        oledTO = oled ; verbose = 0 ; cfgParam = 0 ; delay10s = 0 ;
        //Nokia_Clear() ; Nokia_HLine(2, 0x02) ; //Lin2 =====
      }
    }  
    
    if (delay10s >= 10)
    { NOKIA_BL = 0 ; // turn off BL
      if (cfgParam)
      { cfgParam = 0 ; Nokia_Clear() ; //Nokia_HLine(2, 0x02) ; //Lin2 =====
        if (verbose == 1) APOMOS_verbose () ; else APOMOS_main_disp_meas () ;
        
        if (cycle != cycleOLD) 
        { EEPROM_WRITE (0, cycle) ; __delay_ms(6) ; cycleOLD = cycle ;
        }
        if (oled != oledOLD) 
        { EEPROM_WRITE (1, oled) ; __delay_ms(6) ; oledOLD = oled ; 
        }
      }
    } 
    
    if (cnt == 0) //each 1s
    { cnt = 1 ; if (delay10s < 16) delay10s++ ;
    
        //---------------BP1 longpush or shortpush ?---------------
      //if ((BP1 == 0) || (enfoncee == -1))
      { if (BP1 == 0) 
        { clic() ;
          if (BP1pushed >= 2) //longpush
          { BP1pushed = -1 ;
            dureeBP1pushed = 0 ; delay10s = 0 ;
            Nokia_Clear() ; //blankOLEDdelay = 0 ;
            if (++cfgParam > 2) { cfgParam = 0 ; cycleTO = cycle ; domeas = 1 ; }
            if (cfgParam) APOMOS_cfg () ; //else if (verbose == 1) APOMOS_verbose () ;
            else
              if (verbose == 1) APOMOS_verbose () ; else APOMOS_main_disp_meas () ;
               
            if (cfgParam == 1) 
            { Nokia_PositionXY (66, 2) ; LCD_PutChar('=') ; 
              Nokia_PositionXY (66, 3) ; LCD_PutChar(' ') ;
              Nokia_PositionXY (0, 5) ; Nokia_SendString("1 2 4 8 16 32 64") ; 
            }
            if (cfgParam == 2) 
            { Nokia_PositionXY (66, 2) ; LCD_PutChar(' ') ; 
              Nokia_PositionXY (66, 3) ; LCD_PutChar('=') ;
              Nokia_PositionXY (0, 5) ; Nokia_SendString("15 30 45 60 75 ") ;
              Nokia_PositionXY (74, 5); Nokia_SendString("90") ; //avoid '0' end-slice
              Nokia_HLine(4, 0x08) ; //avoid end-slice
            }      
          }          
        }//endof if (BP1 == 0)
        else
          if ((BP1pushed == 0) && (cfgParam == 0))
          { BP1pushed = -1 ; dureeBP1pushed = 0 ;
            //if (cfgParam == 0) verbose = 1 - verbose ;
            verbose = 1 - verbose ; 
            if (verbose == 1) APOMOS_verbose () ; 
            else { Nokia_Clear() ; APOMOS_main_disp_meas () ; }
          }    
  
        if (enfoncee == -1) 
        { enfoncee = 0 ; dureeBP1pushed = 0 ; delay10s = 0 ;
          if (BP1pushed == 1) //shortpush  
          { //BP1pushed = -1 ;
            //if (cfgParam != 0) { dureeBP1pushed = 0 ; delay10s = 0 ; }
            if (cfgParam == 1) 
            { cycle *= 2 ; if (cycle > 64) { cycle = 1 ; } 
              cycleTO = cycle ; 
              Nokia_PositionXY (72, 2) ; LCD_Write_Integer(cycle, 2) ;
              Nokia_PositionXY (0, 5) ; LCD_PutChar ('1') ; //avoid end-slice
            }
            if (cfgParam == 2) 
            { oled += 15 ; if (oled > 90) { oled = 15; } 
              oledTO = oled ; 
              Nokia_PositionXY (72, 3) ; LCD_Write_Integer(oled, 2) ;
              Nokia_PositionXY (0, 5) ; LCD_PutChar ('1') ; //avoid end-slice
            } 
          } 
          BP1pushed = -1 ;
        } 
        
      }//endof if ((BP1 == 0) || (enfoncee == -1))
      
      //---------------hot keys ?---------------
      if (UARTDataAvailable()) 
      { char car = UARTReadData() ; UARTFlushBuffer() ; delay10s = 0 ;
        //UARTWriteChar(car); //OK! a marche enfin !
        car = car | 0x20 ; //to minuscule
        //if (car  == 'w') writeDS1307() ;
        //if (car  == 'x') readDS1307() ;
        if (car  == 'w') { EEPROM_WRITE (0, cycle) ; __delay_ms(6) ; cycleOLD = cycle ; 
                           EEPROM_WRITE (1, oled) ; __delay_ms(6) ; oledOLD = oled ;
                         }
        if (car  == 'x') { cycle = EEPROM_READ (0) ; cycleTO = cycle ; cycleOLD = cycle ;
                           oled = EEPROM_READ (1) ; oledTO = oled ; oledOLD = oled ;
                         }
        if (car == 'r') runscroll = 1 ;
        if (car == 's') runscroll = 0 ;
        if (car == 'n') { if (++reglage >= 2)  reglage = 0 ; }
        if (car == 'p') 
        { // increment cycle (if reglage==0) or oled (if reglage==1)
          if (reglage == 0) { cycle *= 2 ; if (cycle>64) { cycle = 1; } cycleTO=cycle;}  
          if (reglage == 1) { oled += 15 ; if (oled > 90) { oled = 15; } oledTO=oled ;} 
        }    
        if (car == 'm') 
        { // decrement cycle (if reglage==0) or oled (if reglage==1)
          if (reglage == 0) { cycle /= 2 ; if (cycle==0) { cycle = 64; } cycleTO=cycle;} 
          if (reglage == 1) { oled -= 15 ; if (oled < 15) { oled = 90 ; } oledTO=oled ;}
        }
      }//end if (UARTDataAvailable())
    
      UARTWriteChar('\r') ; if (runscroll) UARTWriteChar('\n') ;
       

        //--------------------------- meas. Vbat ------------------------------  
      meas_Vbat = pick1meas(31, 1) ;  //meas.FVR according to Vdd
      if (meas_Vbat) meas_Vbat = 209510L / meas_Vbat ; else meas_Vbat = 0 ;
      
      //if (meas_Vbat < 330)
      if (meas_Vbat < 270)     
      { UARTWriteString("\r\nBAT.LOW, SYST.STOP") ;  
        Nokia_PositionXY (0, 5) ; Nokia_SendString("BAT.LOW,SYSTOP") ;
        while(1) { SLEEP() ; }
      }
      measVbat = meas_Vbat ;

        //------------------------- meas. CO2 sensor --------------------------
      if (domeas == 1)  
      { PWR_AOP = 1 ; // turn on power for the AOP MCP5001
        domeas = 0 ; if (oledTO == 0) BipHi() ; //dure 16ms
        
        meas_cCO = pick1meas(2, 0) ; //AN2, Vref+ is FVR = 2.048V
        //meas = pick1meas(2, 1) ; //AN2, Vref+ = Vdd  
        
        PWR_AOP = 0 ; // turn off power for the AOP MCP5001

        measCOinV = 2 * meas_cCO / 10 ; // measCOinV, value in Volt
        
          //2-step calibration
        meas_CO = meas_cCO ;  
        if (meas_CO > calib) meas_CO -= calib ; else meas_CO = 0 ; //cancel ofs.AOP   
        meas_CO = (meas_CO * 12) / 10 ; //due to codebar (1.702 nA/ppm)
        if (meas_CO > 999) meas_CO = 999 ; //echelle mesurable 000 ... 999
        
        if (firstime)
        { firstime = 0 ;
          for (p=0; p<24; p++) ppminterval[p] = 0 ; 
          ippmin = ippmax = 23 ; ppminterval[23] = meas_CO ;
        }
        else  //------maj vect 24 derniers meas_CO----------
        { for (p=0; p<23; p++) ppminterval[p] = ppminterval[p+1] ; //shift left
          ppminterval[23] = meas_CO ;
          ippmin-- ; 
          if (ippmin >= 0) { if (meas_CO < ppminterval[ippmin]) ippmin = 23 ; }     
          else //RechIndiceNewMinimum
            { ippmin = 0 ; for (p=1; p<23; p++) if (ppminterval[p] < ppminterval[ippmin]) ippmin = p ;
            }  
          ippmax-- ; 
          if (ippmax >= 0) { if (meas_CO > ppminterval[ippmax]) ippmax = 23 ; }
          else //RechIndiceNewMaximum
            { ippmax = 0 ; for (p=1; p<23; p++) if (ppminterval[p] > ppminterval[ippmax]) ippmax = p ;
            }
        }//FIN------maj vect 24 derniers meas_CO----------
       
          //----------------------- maj VERBOSE display ----------------------- 
        if ((cfgParam == 0) && (verbose == 1)) APOMOS_verbose () ;
        if ((cfgParam == 0) && (verbose == 0)) APOMOS_main_disp_meas () ; 
      }//endof if (domeas == 1)
     
        //-------------------------- maj MAIN display ------------------------- 
      if ((cfgParam == 0) && (verbose == 0)) APOMOS_main_disp_time () ;
      
             
        //************ if CO alert, do it more and more frequently ************ 
      for (s=0; s<4; s++)
      { if (meas_CO >= seuil[s])  
        { BipHi() ;
          cycle /= 2 ; if (cycle == 0) { cycle = 1; } cycleTO = cycle ; 
          BipLo() ;
        }
      }
        //---------------------------- maj puTTY ------------------------------
      if (RC5 == 1) //serialink plugged
      { val2txt(meas_Vbat, txt, 3) ; UARTWriteString(txt) ; UARTWriteChar('\t') ;
        val2txt(meas_cCO, txt, 4) ; UARTWriteString(txt) ; UARTWriteChar('\t') ; 
       
        val2txt(cycleTO, txt, 2) ; UARTWriteString(txt) ; UARTWriteChar('/') ; 
        val2txt(cycle, txt, 2) ; UARTWriteString(txt) ; UARTWriteChar('\t') ;
      
        val2txt(oledTO, txt, 2) ; UARTWriteString(txt) ; UARTWriteChar('/') ; 
        val2txt(oled, txt, 2) ; UARTWriteString(txt) ; UARTWriteChar('\t') ;
      
          //------------------------- sense backspace -------------------------
          //do 17*backspace, if caret under hh
        k = 12 - (reglage * 8) ;
        for (j=0; j<k; j++) UARTWriteChar('\b') ; // ASCII 8
      }

        //-------------------------- monitor time out -------------------------
      if (cfgParam == 0)  
      { if (--cycleTO == 0) { cycleTO = cycle ; domeas = 1 ; }  // cycle timeout
      
        if (--oledTO > oled) // display timeout
        { oledTO = 0 ; //BipHi() ;
          Nokia_Clear() ; nokiaSleep = 1 ; Nokia_Sleep() ;
            // shutoff Fixed voltage ref, to lower Ipd when sleeping. 
            // test OK! Ipd lowered from 0.08mA to 0.02mA !
          FVRCONbits.FVREN = 0 ; 
          switch (cycle)  //config. software WATCHDOG
          { case  1: WDTCONbits.WDTPS = 0b01010 ; break ; // TO = 1s
            case  2: WDTCONbits.WDTPS = 0b01011 ; break ; // TO = 2s
            case  4: WDTCONbits.WDTPS = 0b01100 ; break ; // TO = 4s
            case  8: WDTCONbits.WDTPS = 0b01101 ; break ; // TO = 8s
            case 16: WDTCONbits.WDTPS = 0b01110 ; break ; // TO = 16s
            case 32: WDTCONbits.WDTPS = 0b01111 ; break ; // TO = 32s
            case 64: WDTCONbits.WDTPS = 0b10000 ;         // TO = 64s           
          }
          SWDTEN = 1 ; //activate software WATCHDOG 
          IOCAN3 = 1 ; //enable RA3 WOC
          SLEEP() ;  //sleep, then wake up and resume operation
          SWDTEN = 0 ;
          FVRCONbits.FVREN = 1 ; // set Fixed voltage ref
          cnt = 0 ; BipLo() ;
          cycleTO = cycle ; domeas = 1 ;
        }
      }
    }//end if (cnt == 0) //each 1s
  }//end while(1)
}
//////////////////////////////////////////////////////////////////////////////
void interrupt anyINT(void) 
//void interrupt intTMR1(void) //each 250 ms ( = 62500 * 8 / 2, in microseconds) //@8MHz
{
  //CLRWDT() ;
  
  //if (TMR1IE && TMR1IF)//each second, avec 32768Hz
  //if (TMR1IE && TMR1IF)//each 250 ms @8MHz ( = 62500 * 8 / 2, in s) sans 32768Hz  
  if (TMR1IE && TMR1IF)//each 125 ms @16MHz ( = 62500 * 8 / 4, in s) sans 32768Hz
  {
    //TMR1L = 0xDC ; TMR1H = 0x0B ;  // Timer1 = 0x0BDC = 3036 = 65536 - 62500
    TMR1ON = 0 ; //stop Timer1 before writing to TMR1H:TMR1L registers
    //TMR1L = 0xDC ; TMR1H = 0x0B ;  //0x0BDC = 3036 => retard 10" en 1'
    //TMR1L = 0xFA ; TMR1H = 0x0B ;  //0x0BFA = 3066 => retard 10" en 1'
    //TMR1L = 0x04 ; TMR1H = 0x10 ;  //0x1004 = 4100 => retard 7" en 1'
    //TMR1L = 0xCC ; TMR1H = 0x10 ;  //0x10CC = 4300 => retard 6" en 1'
    //TMR1L = 0x94 ; TMR1H = 0x11 ;  //0x1194 = 4500 => retard 6" en 1'
    //TMR1L = 0x58 ; TMR1H = 0x1B ;  //0x1B58 = 7000 => retard 3" en 1'
    //TMR1L = 0x40 ; TMR1H = 0x1F ;  //0x1F40 = 8000 => retard 3" en 1'
    TMR1L = 0x28 ; TMR1H = 0x23 ;  //0x2328 = 9000 => 
    
    //RAPPEL: cette valeur 0x1B58 = 7000 est aussi utilise en bas (pwmTH)
    // et aussi 65536 - 7000 = 58536 ;
               
    TMR1ON = 1 ; //restart Timer1
    TMR1IF = 0 ; //RA5 ^= 0x20 ; // toggle RA5
    
    //if (++cnt > 5) { cnt = 0 ; } //chrono 1s @ 8MHz
    //if (++cnt > 5) { cnt = 0 ; if (RA5) RA5 = 0 ; else RA5 = 1 ; if (RA3) updMode = 1 ; } //chrono 1s @ 8MHz
    if (++cnt > 9) { cnt = 0 ; } //chrono 1s @ 16MHz
    
    if (BP1 == 0) { dureeBP1pushed++ ; enfoncee = 1 ; }
    else if (enfoncee == 1) enfoncee = -1 ;
      
    if (dureeBP1pushed > 16) BP1pushed = 2 ; // > 2s => longpush 
    else if (dureeBP1pushed > 8) BP1pushed = 1 ; // shortpush 
         else if (dureeBP1pushed > 4) BP1pushed = 0 ; //toggle verbose
  }
  
//-----------------------
  if (RCIE && RCIF) //for keyboard event, thru PuTTY terminal
  {
    UARTHandleRxInt() ;
  }
  
//-----------------------
  if (IOCAN3 && IOCAF3) //if falling edge detected on RA3
  {
    SWDTEN = 0 ;
    IOCAN3 = 0 ; //disable WOC RA3 to avoid detecting debounce rising edges ...
    ///////FVRCONbits.FVREN = 1 ; // set Fixed voltage ref
    ///////cnt = 0 ; BipLo() ;
    ///////cycleTO = cycle ; domeas = 1 ;
        
    IOCAF = 0 ; //IOCIF flag bit is read-only and cleared when all the I.O.C. flags...
                //... in the IOCxF have been cleared by software.
    doWOC = 1 ;            
  }
}
