/* USART_PIC16.c: UART library
 * Compiler: XC8 (v1.42) MPLABX (v4.15)
 * V1.0 - BENABADJI Salim - Oran - Feb. 09th, 2021
 */

#include "16F1829internal.h"
#include "usart_pic16.h"

//-----------------------------------------------------------------------------
//char UART_Initialize(const long int baudrate)
//{
//void UART_Init(unsigned int baud_rate)
void UART_Init(void)
{
unsigned int x ;    
    //Setup queue
  UQFront = UQEnd = -1 ;
  
  /*x = (_XTAL_FREQ / (baud_rate*64L)) - 1 ;

  if (x > 255)
  { x = (_XTAL_FREQ / (baud_rate*16L)) - 1 ;
	BRGH = 1 ;
  }
  if (x < 256)*/
  x = 8 ; BRGH = 1 ; //cas 115200 @ 16 MHz
  { SPBRG = x ;
	SYNC = 0 ; //asynchronous mode
	SPEN = 1 ; //Serial port enabled (configures RX/DT and TX/CK pins as serial)
    RX9=0;    //8 bit mode
    /////TRISC7 = 1;
    /////TRISC6 = 1;
    CREN = 1 ; //Continuous Receive Enabled
    TXEN = 1 ; //Transmit enabled
	//return 1 ;
  }
  //return 0 ;
}

//-----------------------------------------------------------------------------
void UARTWriteChar(char ch)
{
  while (!PIR1bits.TXIF) ;
  TXREG = ch ;
}

//-----------------------------------------------------------------------------
//void UARTWriteString(const char *str)
void UARTWriteString(char *str)
{
  while (*str != '\0') { UARTWriteChar(*str) ; str++ ; }
}
/*
//-----------------------------------------------------------------------------
void UARTWriteLine(const char *str)
{
    UARTWriteChar('\r');//CR
    UARTWriteChar('\n');//LF

    UARTWriteString(str);
}
*/
//-----------------------------------------------------------------------------
void UARTHandleRxInt()
{
  //if (RB1==1) RB1 = 0 ; else RB1 = 1 ;
  
    //if overrun error, then clear overrun error bit & re-enable the receiver
  if (OERR) { CREN = 0 ; CREN = 1 ; }
    
  char data = RCREG ; //Read the data

    //Now add it to q
  if (((UQEnd == RECEIVE_BUFF_SIZE-1) && UQFront == 0) || ((UQEnd+1) == UQFront))
  { UQFront++ ;
	if (UQFront == RECEIVE_BUFF_SIZE) UQFront = 0 ; // if Q Full, then clear
  }

  if (UQEnd == RECEIVE_BUFF_SIZE-1) UQEnd = 0 ; else UQEnd++ ;

  URBuff[UQEnd] = data ;

  if (UQFront == -1) UQFront = 0 ;
}

//-----------------------------------------------------------------------------
char UARTReadData()
{
char data ;

  if (UQFront == -1) return 0 ; //Check if q is empty

  data = URBuff[UQFront] ;

    //If single data is left, So empty q
  if (UQFront == UQEnd) { UQFront = UQEnd = -1; }
  else
    { UQFront++ ; if (UQFront == RECEIVE_BUFF_SIZE) UQFront = 0 ;
    }

  return data ;
}

//-----------------------------------------------------------------------------
//uint8_t UARTDataAvailable()
char UARTDataAvailable()
{
  if (UQFront == -1) return 0 ;
  if (UQFront < UQEnd) return (UQEnd - UQFront + 1) ;
  else 
    if (UQFront > UQEnd) return (RECEIVE_BUFF_SIZE - UQFront + UQEnd + 1) ;
    else return 1 ;
}

/*
//-----------------------------------------------------------------------------
void UARTReadBuffer(char *buff,uint16_t len)
{
	uint16_t i;
	for(i=0;i<len;i++)
	{
		buff[i]=UARTReadData();
	}
}
*/

//-----------------------------------------------------------------------------
void UARTFlushBuffer()
{
  while (UARTDataAvailable() > 0) UARTReadData() ;	
}
