/*
 * PIC16F1829 SPI2 Header File
 * Compiler: XC8 (v1.42) MPLABX (v4.15)
 * V1.0 - BENABADJI Salim - Oran - Feb. 11th, 2021
 */

#include <pic16f1829.h>
#include "16F1829internal.h"
#include "SPI2_Header.h"

//-----------------------------------------------------------------------------
void SPI2_Init_Master()
{
    //PORT definition for SPI pins    
  TRISBbits.TRISB5 = 1 ;    // RB5 as input(SDI2)
  TRISBbits.TRISB7 = 0 ;    // RB7 as output(SCK2)
  TRISCbits.TRISC0 = 0 ;    // RC0 as a output(SS2)
  TRISCbits.TRISC1 = 0 ;    // RC1 as output(SDO2)
  
    //to initialize SPI2 Communication configure following Register
  CS = 1 ;
  SSP2STAT = 0x40 ;   //Data change on rising edge of clk , BF=0
  SSP2CON1 = 0x22 ;    //master mode,Serial enable, idle state low for clk, fosc/64 
  PIR4bits.SSP2IF = 0 ;
  
  /*//ICI: ces 2 lignes suivantes ne servent  rien ?
  //---------------------------------------------  
  //disable the ADC channel which are on for multiplexed pin when used as an input    
  ADCON0 = 0 ;     //this is for de-multiplexed the SCL and SDI from analog pins
  ADCON1 = 0x0F ;  //this makes all pins as a digital I/O pins  
  */
  
  //ANSELA = 0b00000000 ;
  ANSELB = 0b00000000 ;
  ANSELC = 0b00000000 ; 
}

//-----------------------------------------------------------------------------
void SPI2_Write(unsigned char x)
//void SPI2_Write(char x)
{
unsigned char data_flush ;
//char data_flush ;

  SSP2BUF = x ;                 // put data in buffer which has to transmit

  while (!PIR4bits.SSP2IF) ;    // wait for complete 1 byte transmission
  PIR4bits.SSP2IF = 0 ;         // clear SSP2IF flag
  data_flush = SSP2BUF ;        // flush the data as simultaneous read occurs
}

//-----------------------------------------------------------------------------
/*
unsigned char SPI2_Read()
{    
  SSP2BUF = 0xff ;              // Put flush data in buffer to read from device
  while(!PIR4bits.SSP2IF) ;     // wait for complete 1 byte transmission
  PIR4bits.SSP2IF = 0 ;
  return(SSP2BUF) ;             // read data as it is returned from slave to master
                               // so SSP2BUF is ready to receive new data.   
}
*/
