/* Nokia 5110 LCD interface with PIC16F1829 
 * Compiler: XC8 (v1.42) MPLABX (v4.15)
 * V1.0 - BENABADJI Salim - Oran - Feb. 11th, 2021
 */

#include <pic16f1829.h>
#include "16F1829internal.h"
#include "SPI2_Header.h"
#include "NokiaDrv2.h"
#include "NokiaFont.h"
#include "adc1829.h"

extern int measVbat ;
extern char nokiaSleep ;
char bytes[5], bytesZoom2 ; int ii, jj ;

//-----------------------------------------------------------------------------
void Nokia_SendCommand(char cmd)
{
  DC = 0 ;         // Data/Command pin, D/C=1 - Data, D/C = 0 - Command
  CS = 0 ;         // enable chip
  SPI2_Write(cmd) ; // write command to the Nokia 5110
  CS = 1 ;         // disable chip
}
//-----------------------------------------------------------------------------
void Nokia_SendData(char dat)
{   
short i ;

  if (nokiaSleep) return ; //NOKIA is in sleep mode  

  DC = 1 ;         // Data/Command pin, D/C=1 - Data, D/C = 0 - Command
  CS = 0 ;         // enable chip 
  for (i=0; i<5; i++) SPI2_Write(font[dat - 32][i]) ; //write data to Nokia 
  CS = 1 ;         // disable chip 
}
//-----------------------------------------------------------------------------
void Nokia_SendString(char *data)
{
  if (nokiaSleep) return ; //NOKIA is in sleep mode  
  
  while ((*data) != 0)
  {   
    Nokia_SendData(*data) ;
    data++ ;
  }   
}
//-----------------------------------------------------------------------------
void Nokia_PositionXY(char X, char Y) // 0 <= X <= 83   0 <= Y <= 5
{
  if (nokiaSleep) return ; //NOKIA is in sleep mode  

  Nokia_SendCommand(0x80 | X) ;    // set column pix X position
  Nokia_SendCommand(0x40 | Y) ;    // set line Y position  
}
//-----------------------------------------------------------------------------
void Nokia_Reset()
{
    //apply 100 ms reset(low to high) pulse
  RES = 0 ; __delay_ms(100) ; RES = 1 ;
}
//-----------------------------------------------------------------------------
void Nokia_Init()
{
  Nokia_Reset() ;

  Nokia_SendCommand(0x21) ;    // display extended commands

    // Bias voltage: 0x10...0x17 p.14&15/32 PCD8544.PDF
  //Nokia_SendCommand(0x13) ;  // des traces noirs ...    
  //Nokia_SendCommand(0x12) ;  // des traces noirs ...
  Nokia_SendCommand(0x11) ;    // OK (lgrement flou)

  Nokia_SendCommand(0x07) ;    // set temperature coefficient

    // LCD Vop for contrast: 0xC0...0xFF p.14/32 PCD8544.PDF 
  //Nokia_SendCommand(0xC0) ;  // OK    
  //Nokia_SendCommand(0xE0) ;  // screen BLACK (compltement)
  //Nokia_SendCommand(0xD0) ;    // screen BLACK (un peu moins)
  //Nokia_SendCommand(0xC8) ;    // screen (des traces noirs)
  //Nokia_SendCommand(0xC4) ;    // screen (des traces noirs,un peu moins)
  //Nokia_SendCommand(0xC2) ;    // screen (des traces noirs,encore moins)
  Nokia_SendCommand(0xC1) ;    // screen 

  Nokia_SendCommand(0x20) ;    // display basic commands    
  Nokia_SendCommand(0x0C) ;    // set normal mode
}
//-----------------------------------------------------------------------------
void Nokia_Clear()
{
char i, j ;

  if (nokiaSleep) return ; //NOKIA is in sleep mode  

  CS = 0 ;  // enable chip
  DC = 1 ;
  for (i=0; i<6; i++)
    for (j=0; j<84; j++) SPI2_Write(0) ;   // write 0 to clear display
        
  CS = 1 ;  // disable chip 
}
//*****************************************************************************
// Displays a horiz. line (according to byte motif8bit) with Length = nbrColpix
// returns nothing
//*****************************************************************************
void LCD_DrawLine (uint8_t motif8bit, unsigned char nbrColpix)
{
  if (nokiaSleep) return ; //NOKIA is in sleep mode  

  DC = 1 ;  // Data/Command pin, D/C=1 - Data, D/C = 0 - Command
  CS = 0 ;  // enable chip
  for (ii = 0; ii < nbrColpix; ii++) SPI2_Write(motif8bit) ;
    
  CS = 1 ;  // disable chip
}
//-----------------------------------------------------------------------------
void Nokia_HLine(char ligne, uint8_t motif8bit) //trait horizontal complet
{
  Nokia_PositionXY (0, ligne) ; LCD_DrawLine (motif8bit, 84) ; 
}

//-----------------------------------------------------------------------------
void Nokia_Sleep()
{
// A TESTER: activer Nokia_Clear() ; decrease Ipd davantage ?
 
  //Nokia_Clear() ; //zero's the whole RAM to lower Ipd
  Nokia_SendCommand(0x27) ;    // bit PD=1: chip is in Power-down mode
}
//-----------------------------------------------------------------------------
void Nokia_Wake()
{
  Nokia_SendCommand(0x20) ;    // bit PD=0: chip is active
}
/*******************************************************************************
 * void LCD_DrawBat(int pourcent)
 * returns nothing
 * Displays battery with percentage
 ******************************************************************************/
//void LCD_DrawBat(char ss)
void LCD_DrawBat()
{   
  if (nokiaSleep) return ; //NOKIA is in sleep mode  
  
  char x = 67 ;
  int i, j, seuilBat[4] = {330, 360, 380, 400} ;
  
    // icone BAT (left & right)
  for (i=0; i<16; i++)
  { Nokia_PositionXY (x++, 0) ; LCD_DrawLine (0x42, 1) ;
  }
  x-- ; Nokia_PositionXY (x, 0) ; LCD_DrawLine (0x18, 1) ;  //pole + of Bat
  x-- ; Nokia_PositionXY (x, 0) ; LCD_DrawLine (0x66, 1) ;
  x=67 ; Nokia_PositionXY (x, 0) ; LCD_DrawLine (0x7E, 1) ;  //pole - of Bat
  x++ ; Nokia_PositionXY (x, 0) ; LCD_DrawLine (0x7E, 1) ;

    // fill BAT
  x=69 ;
  for (i=0; i<4; i++)
  { if (measVbat > seuilBat[i])
    { for (j=0; j<3; j++)
      { Nokia_PositionXY (x++, 0) ; LCD_DrawLine (0x7E, 1) ;
      }
    }
    else
      for (j=0; j<3; j++)
      { Nokia_PositionXY (x++, 0) ; LCD_DrawLine (0x42, 1) ;
      }
  }
  
    //display measVbat
  Nokia_PositionXY (68, 1) ; LCD_Write_Integer(measVbat, 3) ; 
  //Nokia_PositionXY (72, 1) ; LCD_DrawLine (0x80, 1) ; //decimal point
    // pour dcaler  gauche, le 1er digit, et bien montrer le pt dcimal
  i = measVbat / 100 ; Nokia_PositionXY (67, 1) ; LCD_PutChar(48+i) ;
  Nokia_PositionXY (72, 1) ; LCD_DrawLine (0x80, 1) ; //decimal point

  Nokia_PositionXY (83, 2) ; LCD_DrawLine (0x00, 1) ;  //avoid end-slice
}
/*******************************************************************************
 * void OLED_PutChar(char ch)
 * returns nothing
 * Displays character ch into OLED
 ******************************************************************************/
void LCD_PutChar (char ch)
{
char i ;

  if (nokiaSleep) return ; //NOKIA is in sleep mode  

  if ( (ch < 32) || (ch > 127) ) { ch = ' ' ; }
  
  for (i=0; i<5; i++) bytes[i] = font[ch - 32][i] ;  
 
  for (i = 0; i < 5; i++) 
  { 
    DC = 1 ;         // Data/Command pin, D/C=1 - Data, D/C = 0 - Command
    CS = 0 ;         // enable chip
    SPI2_Write(bytes[i]) ;   
    CS = 1 ;         // disable chip 
  }
}
/*******************************************************************************
 * void LCD_PutCharZoom2 (char ch, unsigned char Row, unsigned char ColumnPix)
 * returns nothing
 * Displays character ch, zoomed x2, @ Row, ColumnPix
 ******************************************************************************/
void LCD_PutCharZoom2 (char ch, unsigned char Row, unsigned char ColumnPix)
{
  if (nokiaSleep) return ; //NOKIA is in sleep mode  

  if ( (ch < 32) || (ch > 127) ) { ch = ' ' ; }
     
  LCD_PutCharX2sendSPI2 (ch, Row, ColumnPix, 0) ;
  LCD_PutCharX2sendSPI2 (ch, Row+1, ColumnPix, 4) ;
}

  // INTERNAL FUNCTION: CALLED ONLY BY LCD_PutCharZoom2 
void LCD_PutCharX2sendSPI2 (char ch, unsigned char lin, unsigned char colpix, unsigned char qbits)
{
  for (ii=0; ii<5; ii++) bytes[ii] = font[ch - 32][ii] ;  

  Nokia_PositionXY (colpix, lin) ;
  
  for (ii = 0; ii < 5; ii++) 
  { jj = (bytes[ii] >> qbits) & 0x0F ; bytesZoom2 = lutZoom2[jj] ;
    
    DC = 1 ;         // Data/Command pin, D/C=1 - Data, D/C = 0 - Command
    CS = 0 ;         // enable chip
    SPI2_Write(bytesZoom2) ; SPI2_Write(bytesZoom2) ;  
    CS = 1 ;         // disable chip 
  }
}
/*OPTIMISATION***************************************************
 * void OLED_Write_Integer (unsigned int iVal, uint8_t nbrDigits)
 * returns nothing
 * Displays integer iVal into OLED, with nbrDigits places
****************************************************************/
void LCD_Write_Integer (unsigned int val, int nbrDigits)
{				
char str[5] = {0,0,0,0,0} ;

  if (nokiaSleep) return ; //NOKIA is in sleep mode  

  ii = 4 ;
  while(val) { str[ii] = val % 10 ; val /= 10 ; ii-- ; }
  jj = 5 - nbrDigits ;
  //if (val < 0) LCDData('-') ;
  for (ii=jj; ii<5; ii++) LCD_PutChar(48+str[ii]) ;
}
//-------------------------------------------------------------------
