/* adc1829.c: 16F1829 Internal 10-bit ADC config
 * Compiler: XC8 (v1.42) MPLABX (v4.15)
 * V1.0 - BENABADJI Salim - Oran - Feb. 14th, 2021
 */

#include "adc1829.h"

//----------------------------------------------------------------------------
void initADC10()
{
  //TRISAbits.TRISA4 = 1 ; // RA4 input, deja cfg dans initCMP1()
  //ANSELAbits.ANSA4 = 1 ; // RA4 analog, deja cfg dans initCMP1()
  
  //TRISAbits.TRISA0 = 1 ; // RA0 input
  //ANSELAbits.ANSA0 = 1 ; // RA0 analog  
 
  ADCON1bits.ADFM = 1 ;     // Right justified
  ADCON1bits.ADCS = 0b101 ; // Fosc/16 ADC conversion time is 1.0 us @ 16MHz
  //ADCON1bits.ADCS = 0b010 ; // Fosc/32 ADC conversion time is 2.0 us @ 16MHz
  //ADCON1bits.ADCS = 0b111 ; //FRC clock in order to use ADC in sleep mode
  
  //ADCON1bits.ADPREF = 0b00 ; // Vref+ is Vdd
  //ADCON1bits.ADNREF = 0 ;  // Vref- is Vss   
  ADRESL = 0 ; ADRESH = 0 ; // Zero ADRESL and ADRESH 
  //ADCON0bits.ADON = 1 ; //ICI

  //OTHERS
  //                       // PIC12F1840errata.PDF page 7/11 :
  //FVRCONbits.FVREN = 1 ; // CAUTION: set the FVREN bit prior to adjusting...
  //                       //... the amplifier output selections with the ADFVR0
  //FVRCONbits.ADFVR0 = 0b10 ; // Output 2.048v to adc
  ////FVRCONbits.ADFVR0 = 0b11 ; // Output 4.096v to adc
  //
  //INTCONbits.GIE = 1 ; // enable global interrupt
  //INTCONbits.PEIE = 1 ; // enable peripheral interrupts
  //PIE1bits.ADIE = 1 ; // enable adc interrupt
  //if (PIR1bits.ADIF) // adc interrupt is pending
}

//----------------------------------------------------------------------------
// do 10-bit ADC: canal = 0b00, 0b01, 0b10, 0b11 ==> AN0, AN1, AN2, AN3
//----------------------------------------------------------------------------
unsigned int pick1meas(unsigned int canal, char vr) //vr = 1 => Vref = Vdd
{                                                   //vr = 0 => Vref = 2.048V
unsigned int rtn ;

  INTCON = 0 ; //disable interrupts  
  //CM1CON0bits.C1ON = 0 ; // disable comparator
        ADCON0bits.CHS = canal ;  // select analog chanel
        ADCON1bits.ADNREF = 0 ;  // Vref- is Vss
        if (vr == 1) ADCON1bits.ADPREF = 0b00 ; // Vref+ is Vdd
                else ADCON1bits.ADPREF = 0b11 ; // Vref+ is 2.048V
        ADCON0bits.ADON = 1 ; __delay_us(30) ; // Turn ADC on, then some delay
        //ADCON0bits.ADON = 1 ; __delay_us(60) ; // Turn ADC on, then some delay
        ////ADRESL = 0 ; ADRESH = 0 ;
        ADCON0bits.GO = 1 ; 
        while (ADCON0bits.GO_nDONE) ; //while acquisition
        //SLEEP() ;  //sleep, then wake up and resume operation
        //PIR1bits.ADIF = 0 ; //clear ADC interrupt flag

        rtn = ((ADRESH<<8) + ADRESL) ; // Store ADC result
        ADCON0bits.ADON = 0 ; // Turn ADC off
  //CM1CON0bits.C1ON = 1 ; // re-enable comparator
  
  //INTCON = 0xC0 ; //re-enable interrupts 
  INTCON = 0xC8 ;
  //INTCON = 0xE0 ; //re-enable interrupts 
  
/*
//ADIF = 1 at the completion of every conversion, regardless of 
//whether or not the ADC interrupt is enabled.  
  ADIF = 0 ; 
*/
  return rtn ;
}
