/* 2nd May 2023
Program to count the number of times the water pump has turned on
within the last 14 hours. Displays data in 1 Hour blocks. Information
is displayed in 12 lines (Hr# - #of cycles - Pump on time seconds)
It uses a 128x64 OLED display using SPI for communication
Push button to activate the display
*/
//***********************************************************************
#include <TimerOne.h>  
#include <SPI.h>
#include <Wire.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>
#include <avr/wdt.h>

#define SCREEN_WIDTH 128 // OLED display width, in pixels
#define SCREEN_HEIGHT 64 // OLED display height, in pixels

// Declaration for SSD1306 display connected using software SPI (default case):
#define OLED_CLK    8  // D0
#define OLED_MOSI   9  // D1 
#define OLED_RESET 10  // RES
#define OLED_DC    11  // DC
#define OLED_CS    12  // CS
Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT,
  OLED_MOSI, OLED_CLK, OLED_DC, OLED_RESET, OLED_CS);

// Constants
const int PumpOnPin = A0;   // Analog input pin number
const int DisplayPower = 7; // OLED power
const int ButtonPin = 5;    // Push button to activate display

// Variables
int PumpDesired = 150;// this is the minimum desired current
int PumpCurrent = 0; // Analog value of pump current
int RealTime = 0;    // Real timer for 1 Hour intervals 0 to 3600
int FlagPumpOn = 0;  // Flag to show pump is ON
int ButtonState = 0; // variable for reading the pushbutton status
int SampleTime = 3600; // 3600 is 1 hour

// Arrays
int H [14] ={0,1,2,3,4,5,6,7,8,9,10,11,12,13}; // Hourly history
int C [14];    // Number of pump cycles per hour
int S [14];    // Pump run time per hour in seconds
int X [3] = {0,17,40}; // X cursor position on OLED display
int Y [14] = {0,9,18,27,36,45,54,63,72,81,90,99,108,117};// Y cursor pos
//***********************************************************************
void setup() {
  pinMode(ButtonPin,INPUT);     // Push button to activate display
  digitalWrite(ButtonPin, HIGH);// turn on pullup resistors
  pinMode(DisplayPower,OUTPUT); // OLED power
  digitalWrite(DisplayPower, HIGH); // OLED power
  delay(100);
  Timer1.initialize(1000000); // Software interrupt every 1 second
  Timer1.attachInterrupt(InterruptRoutine);
//  Serial.begin(9600); //remove later

  // SSD1306_SWITCHCAPVCC = generate display voltage from 3.3V internally
  if(!display.begin(SSD1306_SWITCHCAPVCC)) {
    
  //  Serial.println(F("SSD1306 allocation failed"));
    for(;;); // Don't proceed, loop forever
  }
   display.setRotation(1); // rotate screen (portrait)
   wdt_disable(); //Disable WDT
   delay(100);
   wdt_enable(WDTO_2S); //Enable WDT with a timeout of 2 seconds
}
//***********************************************************************
void loop() {
  do {
    display.ssd1306_command(SSD1306_DISPLAYOFF); // Display OFF
    ButtonState = digitalRead(ButtonPin);
    wdt_reset(); //Reset the watchdog
  }
  while (ButtonState==HIGH);

  display.ssd1306_command(SSD1306_DISPLAYON); // Display ON
  display.clearDisplay();
  display.setTextSize(1);             // Normal 1:1 pixel scale
  display.setTextColor(SSD1306_WHITE);        // Draw white text
  DisplayAll(); // subroutine to display entire screen
  display.display();
  wdt_reset(); //Reset the watchdog
  
  do{
    ButtonState = digitalRead(ButtonPin);
    wdt_reset(); //Reset the watchdog
  }
  while (ButtonState==LOW);
  delay (100);
  wdt_reset(); //Reset the watchdog
}
//***********************************************************************
void RotateData(){ // Subroutine to rotate all Array data to the next Hour
for (int i=12; i >= 0; i--){  //
//  Serial.print (i);
  C[i+1]=C[(i)];  // C is the number of Pump cycles
  S[i+1]=S[(i)];  // S is the Pump run time in Seconds
  }
}
//***********************************************************************
void DisplayAll(){  // Subroutine to display the entire screen
  for (int i=0; i <= 13; i++ ){
    display.setCursor (X[0],Y[i] );
    display.print (H[i]);           // display Hour number
    display.setCursor (X[1],Y[i] );
    display.print (C[i]);           // display Number of pump cycles
    display.setCursor (X[2],Y[i] );
    display.print (S[i]);           // display pump run time seconds
  }
}
//***********************************************************************
// Interrupt routine occurs every second
void InterruptRoutine(){ 
  wdt_reset(); //Reset the watchdog
  RealTime = RealTime+1;  // Incrament the 1 hour timer
  PumpCurrent = analogRead(PumpOnPin); // check if motor is on
  if (PumpCurrent < PumpDesired){
    FlagPumpOn = 0; //Motor is Not on - so clear the flag
    if (RealTime == SampleTime){
      RotateData();
      (C[0]) = 0; // Cycle Number
      (S[0]) = 0;  // Run Seconds
      RealTime = 0;
    }
    return;
  }
  if (FlagPumpOn == 0){
    FlagPumpOn = 1;
    ++(C[0]); // Cycle Number
  }
  ++(S[0]); // Run Seconds
  if (RealTime == SampleTime){
    RotateData();
    (C[0]) = 0; // Cycle Number
    (S[0]) = 0; // Run Seconds
    RealTime = 0;
  }  
  wdt_reset(); //Reset the watchdog
}
  
//***********************************************************************