#ifndef UTIL_H
#define	UTIL_H

#include <xc.h> // include processor files - each processor file is guarded.  
#include "globalPins.h"
#include "portbits.h"
#include "io.h"
#include "dcc.h"
#include "globalPins.h"
#include "portbits.h"
#include "uart.h"
#include "oled.h"
#include "font.h"

#define ISCALE (10)
#define VSCALE (11)
#define CLEAR_DCC_EN_LATCH 0,3
#define SET_DCC_EN_LATCH 0,1

#define TRIP_STEP 100
#define TRIP_MIN 0
#define TRIP_MAX 9900
#define OFFSET_STEP 100
#define OFFSET_MIN 0
#define OFFSET_MAX 9000
#define OFFSET_THRESHOLD 1000
#define AUTO_TEST_DELAY 50
#define DAC_TEST_SETTING 128
#define IOFFSET_DEFAULT 4200
#define FLASH_LED_ON_DCC_FAIL
#define SHUTOFF_ON_DCC_FAIL

typedef enum {   
    MODE_BOOSTREV=0,            
    MODE_BASE_OLED,
    MODE_BOOSTER_OLED,
    MODE_REVERSER_OLED,
    MODE_DUMMY
} mainMode_t;

typedef enum {
    BASEMODE_NORMAL=0,
    BASEMODE_ILIMIT,
    BASEMODE_IOFFSET,
    BASEMODE_IAUTO,
    BASEMODE_AUTO_ON,
    BASEMODE_MAIN_MODE,
    BASEMODE_RESET_PROCESSOR,
    BASEMODE_DUMMY    
} baseMode_t;

extern unsigned int vSupply;
extern unsigned int iDCC;
__eeprom mainMode_t mainMode;
__eeprom extern unsigned int iOffset;
__eeprom extern unsigned int tripCurrent;
__eeprom extern unsigned char autoOn;
extern volatile char updateFlag;
extern volatile char hostCheckTimer;
extern volatile char tripTimer;
extern volatile char dccOKtimer;
extern volatile char flashCtr;
extern baseMode_t baseMode;
extern char buttonPress;
extern const unsigned int tripSettings[8];  //picked by jumpers
extern char polarity;      //0=normal, 1=reversed
extern unsigned int boosterTripCurrent;

void dccTripInit(void);    //various IO configurations for CLC etc
void dccThruInit(void); //DCC passthrough
unsigned char getTripDAC(unsigned int i); //input in mA, output in DAC position on 2V scale
void baseModeHousekeeping(void);
void runAutoOffsetOLED(void);    
void runHeadlessSequence(void);
char runAutoOffsetHeadless(void);
unsigned int getRawI(void);
void boostRevIoInit(void);    //io pins etc
void simpleLEDstatus(void);
void ledDCCstatus(void);
void boosterHousekeeping(void); //common core
void reverserHousekeeping(void);    //common core
void settingsPages(void);       //common OLED settings
void setPPSforAutoOffset(void);
void restorePPSafterAutoOffset(void);

#endif	/* UTIL_H */
