#include "util.h"

unsigned int vSupply=0;
unsigned int iDCC=0;
__eeprom mainMode_t mainMode=MODE_BOOSTREV;    //EEPROM
__eeprom unsigned int iOffset=IOFFSET_DEFAULT; //typical value
__eeprom unsigned int tripCurrent=1000;
__eeprom unsigned char autoOn=0;
volatile char updateFlag=0;
volatile char hostCheckTimer=0;
volatile char tripTimer=0;
volatile char dccOKtimer=0;
volatile char flashCtr=0;
baseMode_t baseMode=0;
char buttonPress=0;
//for reverser
char polarity=0;            //keep track, 0=normal, 1=reversed
char polarityToggles=0;     //so we know to toggle or trip
const unsigned int tripSettings[8]={1000,2000,3000,4000,5000,6000,8000,10000};  //picked by jumpers
char ppsDCCOUTA=0;  //save/restore
char ppsDCCOUTB=0;
unsigned int boosterTripCurrent=0;

void dccTripInit(void){  //various IO configurations for CLC etc
    //PPS
    unsigned char intcon=INTCON;
    GIE=0;
    PPSLOCK = 0x55; //Required sequence
    PPSLOCK = 0xAA; //Required sequence
    PPSLOCKbits.PPSLOCKED = 0; //clear PPSLOCKED bit
    pps.DCCOUT_EN=PPSO_CLC1_OUT;
    PPSLOCK = 0x55; //Required sequence
    PPSLOCK = 0xAA; //Required sequence
    PPSLOCKbits.PPSLOCKED = 1; //set PPSLOCKED bit           
    INTCON=intcon;   
    //comparator & DAC for current sensing DCCOUT_I on c1=C2IN1-
    initFVR_DAC(FVR_2048);    
    DAC2CON=DAC_ON|DAC_REF_FVR_GND; //internal only
    DAC2DATL=0;   //safe
    CM2CON0=0;  //reset CMP2, async, no hyst, not inv
    CM2CON1=0;  //no interrupts
    CM2NCH=1;   //C2IN1-
    //CM2PCH=0;   //C2IN0+
    //CM2PCH=4;   //DAC1OUT
    CM2PCH=5;   //DAC2OUT
    CM2CON0bits.C2POL=1;    //invert
    CM2CON0bits.C2EN=1; //on
    //CLC
    CLCSELECT=0;    //use 1
    CLCnCON=0;   //reset, no interrupts
    CLCnPOL = 0;    //all normal
    CLCnCON = 3;    //SR latch
    CLCnSEL0 = 0x00;
    CLCnSEL1 = 0x00;
    CLCnSEL2 = 0x00;
    CLCnSEL3 = 32;  //CMP2 out
    CLCnGLS0 = 0x00;
    CLCnGLS1 = 0x00;
    CLCnGLS2 = 0x00;
    CLCnGLS3 = 0x80;    //gate SEL3+ into gate 4 (reset)
    CLCnCONbits.EN=1;   //on
}

void dccThruInit(void){ //DCC passthrough
    unsigned char intcon;
    CLCSELECT=1;    //use 2
    CLCnCON=0;   //reset, no interrupts
    CLCnPOL = 2;    //select CLCnGLS0, 8=> CLCnGLS2
    CLCnCON = 0;    //AND/OR
    CLCnSEL0 = PPSI_CLCIN0PPS;  //IO pin=DCCIN_A
    CLCnSEL1 = PPSI_CLCIN1PPS;  //IO pin=DCCIN_B
    CLCnSEL2 = 0x00;
    CLCnSEL3 = 0x00;
    CLCnGLS0 = 0x02;    //CLCnSEL0 = PPSI_CLCIN0PPS;  //IO pin=DCCIN_A
    CLCnGLS1 = 0x00;
    CLCnGLS2 = 0x08;    //CLCnSEL1 = PPSI_CLCIN1PPS;  //IO pin=DCCIN_B
    CLCnGLS3 = 0x00;
    CLCnCONbits.EN=1;   //on
    CLCSELECT=2;    //use 3
    CLCnCON=0;   //reset, no interrupts
    CLCnPOL = 2;    //select CLCnGLS0, 8=> CLCnGLS2
    CLCnCON = 0;    //AND/OR
    CLCnSEL0 = PPSI_CLCIN0PPS;  //IO pin=DCCIN_A
    CLCnSEL1 = PPSI_CLCIN1PPS;  //IO pin=DCCIN_B
    CLCnSEL2 = 0x00;
    CLCnSEL3 = 0x00;
    CLCnGLS0 = 0x08;    //CLCnSEL1 = PPSI_CLCIN1PPS;  //IO pin=DCCIN_B
    CLCnGLS1 = 0x00;
    CLCnGLS2 = 0x02;    //CLCnSEL0 = PPSI_CLCIN0PPS;  //IO pin=DCCIN_A
    CLCnGLS3 = 0x00;
    CLCnCONbits.EN=1;   //on
    //PPS
    intcon=INTCON;
    GIE=0;
    PPSLOCK = 0x55; //Required sequence
    PPSLOCK = 0xAA; //Required sequence
    PPSLOCKbits.PPSLOCKED = 0; //clear PPSLOCKED bit
    pps.DCCOUT_A=PPSO_CLC2_OUT; //outputs
    pps.DCCOUT_B=PPSO_CLC3_OUT;
    CLCIN0PPS=DCCIN_A;
    CLCIN1PPS=DCCIN_B;
    PPSLOCK = 0x55; //Required sequence
    PPSLOCK = 0xAA; //Required sequence
    PPSLOCKbits.PPSLOCKED = 1; //set PPSLOCKED bit           
    INTCON=intcon;   
    //IO
    //all outputs off
    anselbits.DCCOUT_EN=0;
    anselbits.DCCOUT_A=0;
    anselbits.DCCOUT_B=0;
    trisbits.DCCOUT_EN=0;
    trisbits.DCCOUT_A=0;
    trisbits.DCCOUT_B=0;
    latbits.DCCOUT_EN=0;
    latbits.DCCOUT_A=0;
    latbits.DCCOUT_B=0;    
    //inputs
    anselbits.DCCIN_A=0;
    anselbits.DCCIN_B=0;
    trisbits.DCCIN_A=1;
    trisbits.DCCIN_B=1;
    wpubits.DCCIN_A=0;
    wpubits.DCCIN_B=0;
}

unsigned char getTripDAC(unsigned int i){ //input in mA, output in DAC position on 2V scale
    unsigned long n=i+iOffset;
    n=(n*256)/ISCALE; //raw millivolt reading, 256 is DAC full scale
    if(n>(255UL*dacref2)){return 255;}    //avoid overflow wrap
    return (unsigned char)(n/dacref2);
}

void baseModeHousekeeping(void){
    handleSLIP();
    if(hostCheckTimer>=(HOST_CHECK_INTERVAL/COUNTER_INTERVAL)){
        hostCheckTimer=0;
        sendHostCheck();
    }
    if(dccSwitch){          //try resetting as needed, show LED
        if(tripTimer==0){
            clcGateToggle(SET_DCC_EN_LATCH); //set
            tripTimer=(TRIP_TIME/COUNTER_INTERVAL);
        }
        latbits.LED2_PIN=1;
    }else{
        clcGateToggle(CLEAR_DCC_EN_LATCH); //reset
        latbits.LED2_PIN=0; 
    }    
}

void runAutoOffsetOLED(void){
    unsigned int test0,test1,test2;   //sampled values
    //shut off DCC
    dccSwitch=0;
    clcGateToggle(CLEAR_DCC_EN_LATCH); //reset
    TMR2IE=0;   
    setPPSforAutoOffset();
    trisbits.DCCOUT_EN=0;
    latbits.LED2_PIN=0; 
    latbits.DCCOUT_A=0;
    latbits.DCCOUT_B=0;
    DAC2DATL=DAC_TEST_SETTING;   //disable limiting
    delay(AUTO_TEST_DELAY);
    test0=getRawI();    //enable off
    clcGateToggle(SET_DCC_EN_LATCH); //set
    delay(AUTO_TEST_DELAY);
    test1=getRawI();    //both low
    clcGateToggle(CLEAR_DCC_EN_LATCH); //reset
    latbits.DCCOUT_A=1;
    latbits.DCCOUT_B=1;
    clcGateToggle(SET_DCC_EN_LATCH); //set
    delay(AUTO_TEST_DELAY);
    test2=getRawI();    //both high
    clcGateToggle(CLEAR_DCC_EN_LATCH); //reset
    latbits.DCCOUT_A=0; //off
    latbits.DCCOUT_B=0; //off
    OLEDcol=2;
    OLEDpage=0;
    if((test0<OFFSET_THRESHOLD)&&(test1>OFFSET_THRESHOLD)&&(test2>OFFSET_THRESHOLD)&&(test1>OFFSET_MIN)&&(test2>OFFSET_MIN)){
        if((test1<OFFSET_MAX)&&(test2<OFFSET_MAX)){
            iOffset=(test1+test2)/2;
            OLEDchararray("OK, SET:",arial);
            OLEDscanshort(iOffset);        
            OLEDchar(OLEDbuf[6],arial);
            OLEDchar('.',arial);
            OLEDchar(OLEDbuf[7],arial);
            OLEDchar(OLEDbuf[8],arial);
            OLEDchar(OLEDbuf[9],arial);
            OLEDchar('A',arial);
        }else{
            OLEDchararray("OUTPUT HIGH   ",arial);
        }
    }else{
        OLEDchararray("OUTPUT LOW    ",arial);
    }
    //resume
    TMR2IE=1;   
    restorePPSafterAutoOffset();
    DAC2DATL=getTripDAC(tripCurrent);   
}

void runHeadlessSequence(void){
    //shut off
    char i;
    clcGateToggle(CLEAR_DCC_EN_LATCH);
    dccSwitch=0;     
    while(PRESSED(S3)){
        latbits.LED2_PIN=1; 
        delay(100);
        latbits.LED2_PIN=0; 
        delay(100);
    }
    for(i=0;i<10;i++){
        latbits.LED2_PIN=1; 
        delay(100);
        latbits.LED2_PIN=0; 
        delay(100);
    }
    if(runAutoOffsetHeadless()){
        latbits.LED2_PIN=1; 
        delay(1000);
        latbits.LED2_PIN=0; 
    }
}

char runAutoOffsetHeadless(void){
    unsigned int test0,test1,test2;   //sampled values
    unsigned char testOK=0;
    //shut off DCC
    dccSwitch=0;
    clcGateToggle(CLEAR_DCC_EN_LATCH); //reset
    TMR2IE=0;   
    setPPSforAutoOffset();
    trisbits.DCCOUT_EN=0;
    latbits.LED2_PIN=0; 
    latbits.DCCOUT_A=0;
    latbits.DCCOUT_B=0;
    DAC2DATL=DAC_TEST_SETTING;   //disable limiting
    delay(AUTO_TEST_DELAY);
    test0=getRawI();    //enable off
    clcGateToggle(SET_DCC_EN_LATCH); //set
    delay(AUTO_TEST_DELAY);
    test1=getRawI();    //both low
    clcGateToggle(CLEAR_DCC_EN_LATCH); //reset
    latbits.DCCOUT_A=1;
    latbits.DCCOUT_B=1;
    clcGateToggle(SET_DCC_EN_LATCH); //set
    delay(AUTO_TEST_DELAY);
    test2=getRawI();    //both high
    clcGateToggle(CLEAR_DCC_EN_LATCH); //reset
    latbits.DCCOUT_A=0; //off
    latbits.DCCOUT_B=0; //off
    if((test0<OFFSET_THRESHOLD)&&(test1>OFFSET_THRESHOLD)&&(test2>OFFSET_THRESHOLD)&&(test1>OFFSET_MIN)&&(test2>OFFSET_MIN)){
        if((test1<OFFSET_MAX)&&(test2<OFFSET_MAX)){
            iOffset=(test1+test2)/2;
            testOK=1;
        }
    }
    TMR2IE=1;   
    restorePPSafterAutoOffset();
    DAC2DATL=getTripDAC(boosterTripCurrent);   
    return testOK;
}

unsigned int getRawI(void){
    unsigned int r;
    r=getScaled(getADC(DCCOUT_I),adcref2);  //value in mV
    r=r*ISCALE;   //convert to mA
    return r;
}

void boostRevIoInit(void){    //io pins etc
    //switches, analogs, LED taken care of in ioInit
    anselbits.JP1A_PIN=0;
    trisbits.JP1A_PIN=1;
    wpubits.JP1A_PIN=1;
    anselbits.JP1B_PIN=0;
    trisbits.JP1B_PIN=1;
    wpubits.JP1B_PIN=1;
    anselbits.JP1C_PIN=0;
    trisbits.JP1C_PIN=1;
    wpubits.JP1C_PIN=1;
    anselbits.JP1D_PIN=0;
    trisbits.JP1D_PIN=1;
    wpubits.JP1D_PIN=1;    
}

void simpleLEDstatus(void){
    if(dccSwitch){      //show LED    
        latbits.LED2_PIN=1;
    }else{
        latbits.LED2_PIN=0;        
    }    
}

void ledDCCstatus(void){
#ifdef FLASH_LED_ON_DCC_FAIL
    if(dccOKtimer==0){     //error flash
        if(dccSwitch){      //show LED    
            if(flashCtr==0){
                latbits.LED2_PIN=0;        
            }else{
                latbits.LED2_PIN=1;
            }
        }else{
            if(flashCtr==0){
                latbits.LED2_PIN=1;        
            }else{
                latbits.LED2_PIN=0;
            }
        }
    }else{                  //normal indication
        if(dccSwitch){      //show LED    
            latbits.LED2_PIN=1;
        }else{
            latbits.LED2_PIN=0;        
        }
    }
#else
    if(dccSwitch){      //show LED    
        latbits.LED2_PIN=1;
    }else{
        latbits.LED2_PIN=0;        
    }
#endif
}

void boosterHousekeeping(void){
    if(dccRx.byteCount){
        cleanPacket(&dccRx);        //check checksum, void if invalid
        if(dccRx.byteCount){dccOKtimer=(DCC_PACKET_INTERVAL/COUNTER_INTERVAL);}
        dccRx.byteCount=0;
    }
    if(dccSwitch){          //try resetting as needed, show LED
        if(tripTimer==0){
            clcGateToggle(SET_DCC_EN_LATCH); //set
            tripTimer=(TRIP_TIME/COUNTER_INTERVAL);
        }
        //latbits.LED2_PIN=1;
    }else{
        clcGateToggle(CLEAR_DCC_EN_LATCH); //reset
        //latbits.LED2_PIN=0; 
    }    
#ifdef SHUTOFF_ON_DCC_FAIL
    if(dccOKtimer){
        trisbits.DCCOUT_EN=0;   //enable output drive
    }else{
        trisbits.DCCOUT_EN=1;   //float
    }    
#endif    
}

void reverserHousekeeping(void){
    if(dccRx.byteCount){
        cleanPacket(&dccRx);        //check checksum, void if invalid
        if(dccRx.byteCount){dccOKtimer=(DCC_PACKET_INTERVAL/COUNTER_INTERVAL);}
        dccRx.byteCount=0;
    }
    if(dccSwitch){          //try resetting as needed, show LED
        if(portbits.DCCOUT_EN==0){  //tripped
            if(polarityToggles==0){    //first trip
                polarityToggles=1;      //flag
                if(polarity){           //toggle
                    polarity=0;                        
                }else{
                    polarity=1;
                }
                latbits.LED2_PIN=0; //flicker off
                delay(10);
                if(polarity){       //set output
                    clcSetPol(1,8);
                    clcSetPol(2,8);
                }else{
                    clcSetPol(1,2);
                    clcSetPol(2,2);                        
                }
                delay(10);
                clcGateToggle(SET_DCC_EN_LATCH); //set
            }
        }
        if(tripTimer==0){
            clcGateToggle(SET_DCC_EN_LATCH); //set
            tripTimer=(TRIP_TIME/COUNTER_INTERVAL);
            polarityToggles=0;  //reset
        }
        //latbits.LED2_PIN=1;
    }else{
        clcGateToggle(CLEAR_DCC_EN_LATCH); //reset
        //latbits.LED2_PIN=0; 
    }    
#ifdef SHUTOFF_ON_DCC_FAIL
    if(dccOKtimer){
        trisbits.DCCOUT_EN=0;   //enable output drive
    }else{
        trisbits.DCCOUT_EN=1;   //float
    }    
#endif    
}

void settingsPages(void){
    switch(baseMode){
        case BASEMODE_NORMAL:
            break;
        case BASEMODE_ILIMIT:
            buttonPress=buttonPressAndHold();
            if(buttonPress==1){
                if(tripCurrent<=(TRIP_MAX-TRIP_STEP)){
                    tripCurrent=tripCurrent+TRIP_STEP;
                }else{
                    tripCurrent=TRIP_MAX;
                }
            }
            if(buttonPress==2){
                if(tripCurrent>=(TRIP_MIN+TRIP_STEP)){
                    tripCurrent=tripCurrent-TRIP_STEP;
                }else{
                    tripCurrent=TRIP_MIN;
                }
            }              
            OLEDcol=2;
            OLEDpage=0;
            OLEDchararray("TRIP=",arial);
            OLEDscanshort(tripCurrent);        
            OLEDchar(OLEDbuf[6],arial);
            OLEDchar('.',arial);
            OLEDchar(OLEDbuf[7],arial);
            OLEDchar('A',arial);
            OLEDchar(' ',arial);
            OLEDchar(' ',arial);
            OLEDscanshort(DAC2DATL);  
            OLEDlzb(8);
            OLEDchar(OLEDbuf[7],arial);
            OLEDchar(OLEDbuf[8],arial);
            OLEDchar(OLEDbuf[9],arial);
            OLEDcol=2;
            OLEDpage=4;
            OLEDchararray("UP   DOWN  SEL",arial);
            break;
        case BASEMODE_IOFFSET:
            buttonPress=buttonPressAndHold();
            if(buttonPress==1){
                if(iOffset<=(OFFSET_MAX-OFFSET_STEP)){
                    iOffset=iOffset+OFFSET_STEP;
                }else{
                    iOffset=OFFSET_MAX;
                }
            }
            if(buttonPress==2){
                if(iOffset>=(OFFSET_MIN+OFFSET_STEP)){
                    iOffset=iOffset-OFFSET_STEP;
                }else{
                    iOffset=OFFSET_MIN;
                }
            } 
            OLEDcol=2;
            OLEDpage=0;
            OLEDchararray("OFFSET=",arial);
            OLEDscanshort(iOffset);        
            OLEDchar(OLEDbuf[6],arial);
            OLEDchar('.',arial);
            OLEDchar(OLEDbuf[7],arial);
            OLEDchar(OLEDbuf[8],arial);
            OLEDchar('A',arial);
            OLEDchar(' ',arial);
            OLEDcol=2;
            OLEDpage=4;
            OLEDchararray("UP   DOWN  SEL",arial);
            break;
        case BASEMODE_IAUTO:
            OLEDcol=2;
            OLEDpage=0;
            OLEDchararray("AUTO-OFFSET   ",arial);
            OLEDcol=2;
            OLEDpage=4;
            OLEDchararray("RUN        SEL",arial);
            if(checkButton(1)){
                runAutoOffsetOLED();
                while(anyButton()==0){
                    baseModeHousekeeping();  
                }
            }
            break;
        case BASEMODE_AUTO_ON:
            OLEDcol=2;
            OLEDpage=0;
            if(autoOn){
                OLEDchararray("AUTOPOWER: ON ",arial);                    
            }else{
                OLEDchararray("AUTOPOWER: OFF",arial);                    

            }
            OLEDcol=2;
            OLEDpage=4;
            OLEDchararray("ON   OFF   SEL",arial);
            if(PRESSED(S1)){
                if(autoOn==0){autoOn=1;}    //avoid rewriting
            }
            if(PRESSED(S2)){
                if(autoOn!=0){autoOn=0;}    //avoid rewriting
            }                
            break;
        case BASEMODE_MAIN_MODE:
            OLEDcol=2;
            OLEDpage=0;
            switch(mainMode){
                case MODE_BOOSTREV:
                    OLEDchararray("MODE: NO OLED ",arial);
                    break;
                case MODE_BASE_OLED:
                    OLEDchararray("MODE: BASE STN",arial);
                    break;
                case MODE_BOOSTER_OLED:
                    OLEDchararray("MODE: BOOSTER ",arial);
                    break;
                case MODE_REVERSER_OLED:
                    OLEDchararray("MODE: REVERSER",arial);
                    break;
                case MODE_DUMMY:
                    mainMode=0;
                    break;

            }
            OLEDcol=2;
            OLEDpage=4;
            OLEDchararray("MODE       SEL",arial);
            if(checkButton(1)){
                mainMode=mainMode+1;
                if(mainMode>=MODE_DUMMY){mainMode=0;}
            }                    
            break;
        case BASEMODE_RESET_PROCESSOR:
            OLEDcol=2;
            OLEDpage=0;
            OLEDchararray("RESET MICRO   ",arial);
            OLEDcol=2;
            OLEDpage=4;
            OLEDchararray("RESET      SEL",arial);
            if(checkButton(1)){
                OLEDclear(0);   //ensure display is not carried over
                RESET();
            }                    
            break;
        case BASEMODE_DUMMY:
            baseMode=0;
            break;
    }        
}

void setPPSforAutoOffset(void){
    unsigned char intcon;
    intcon=INTCON;
    GIE=0;
    ppsDCCOUTA=pps.DCCOUT_A;
    ppsDCCOUTB=pps.DCCOUT_B;
    PPSLOCK = 0x55; //Required sequence
    PPSLOCK = 0xAA; //Required sequence
    PPSLOCKbits.PPSLOCKED = 0; //clear PPSLOCKED bit
    pps.DCCOUT_A=PPSO_LAT;
    pps.DCCOUT_B=PPSO_LAT;
    PPSLOCK = 0x55; //Required sequence
    PPSLOCK = 0xAA; //Required sequence
    PPSLOCKbits.PPSLOCKED = 1; //set PPSLOCKED bit           
    INTCON=intcon;       
}

void restorePPSafterAutoOffset(void){
    unsigned char intcon;
    intcon=INTCON;
    GIE=0;
    PPSLOCK = 0x55; //Required sequence
    PPSLOCK = 0xAA; //Required sequence
    PPSLOCKbits.PPSLOCKED = 0; //clear PPSLOCKED bit
    pps.DCCOUT_A=ppsDCCOUTA;
    pps.DCCOUT_B=ppsDCCOUTB;
    PPSLOCK = 0x55; //Required sequence
    PPSLOCK = 0xAA; //Required sequence
    PPSLOCKbits.PPSLOCKED = 1; //set PPSLOCKED bit           
    INTCON=intcon;       
}