#ifndef UART_H
#define	UART_H

#include <xc.h> 
#include "portbits.h"
#include "globalPins.h"

#define UART_GLOBAL_BUFSIZE 256
#define UART1_TXBUFSIZE UART_GLOBAL_BUFSIZE
#define UART1_RXBUFSIZE UART_GLOBAL_BUFSIZE
#define UART2_TXBUFSIZE UART_GLOBAL_BUFSIZE
#define UART2_RXBUFSIZE UART_GLOBAL_BUFSIZE
#define BAUD(x) ((_XTAL_FREQ/4)/x)
extern const char hex[];

void uart1_init(unsigned int b);    //b is constant for baudcon register
void uart1_deInit(void);
void uart2_init(unsigned int b);    //b is constant for baudcon register
void uart2_deInit(void);
void uartISR(void);
#ifdef UART_TX1_PIN
void uart1_send(const char c);
void uart1_sends(const char *c);
unsigned char uart1_sendFree(void);   //bytes free for sending in uart1_txbuf
#endif
#ifdef UART_RX1_PIN
char uart1_receive(void);
unsigned char uart1_available(void); //bytes to be uart1_receive()
#endif
#ifdef UART_TX2_PIN
void uart2_send(const char c);
void uart2_sends(const char *c);
unsigned char uart2_sendFree(void);   //bytes free for sending in uart2_txbuf
#endif
#ifdef UART_RX2_PIN
char uart2_receive(void);
unsigned char uart2_available(void); //bytes to be uart2_receive()
#endif


#endif	/* UART_H */

