/*
 * File:   main.c
 * Author: Tim Blythman
 */

//see globalPins.h for _XTAL_FREQ and pins

#include "config.h"
#include <xc.h>
#include "util.h"

//effectively different apps which can run, decided at boot
void runOLEDBaseApp(void){
    initADC();
    initFVR_ADC(FVR_2048);    
    dccTripInit();      //comparator => DCC_EN
    DAC2DATL=getTripDAC(tripCurrent);
    clcGateToggle(CLEAR_DCC_EN_LATCH); //reset
    uart1_init(BAUD(9600));
    OLEDinit();
    OLEDflip(OLED_CONNECTOR_AT_RIGHT);
    OLEDclear(0);
    OLEDbrightness(255);
    t0init();   //GP timer interrupt    
    dccInit();
    setIdleCallback(baseModeHousekeeping);
    GIE=1;
    dccSwitch=autoOn;
    while(1){
        //get analogs
        vSupply=getScaled(getADC(VSENSE),adcref2)*VSCALE;  //value in mV
        iDCC=getScaled(getADC(DCCOUT_I),adcref2);  //value in mV
        iDCC=iDCC*ISCALE;   //convert to mA
        if(iDCC<iOffset){iDCC=0;}else{iDCC=iDCC-iOffset;}        //offset
        if(iDCC>9900){iDCC=9900;}   //clamp
        //display modes
        if(checkButton(3)){
            baseMode=baseMode+1;
            OLEDclear(0);            
        }
        if(baseMode==BASEMODE_NORMAL){
            //check IO
            if(PRESSED(S1)){
                if(dccSwitch==0){clcGateToggle(SET_DCC_EN_LATCH);} //set
                dccSwitch=1;            
            }
            if(PRESSED(S2)){
                clcGateToggle(CLEAR_DCC_EN_LATCH); //reset
                dccSwitch=0;            
            }        
            //update display
            OLEDcol=2;
            OLEDpage=0;
            OLEDchararray("BASE:",arial); 
            OLEDcol=47;
            OLEDpage=0;
            OLEDscanshort(vSupply+500);         //rounding
            OLEDlzb(5);
            OLEDchar(OLEDbuf[5],smallFont);
            OLEDchar(OLEDbuf[6],smallFont);
            OLEDchar('V',smallFont);
            OLEDchar(' ',smallFont);
            OLEDcol=47;
            OLEDpage=2;
            OLEDscanshort(iDCC+50);         //rounding
            OLEDchar(OLEDbuf[6],smallFont);
            OLEDchar('.',smallFont);
            OLEDchar(OLEDbuf[7],smallFont);
            OLEDchar('A',smallFont);
            OLEDcol=75;
            OLEDpage=0;
            if(dccSwitch){  //on
                if(portbits.DCCOUT_EN){
                    OLEDchararray("ON   ",arial); 
                }else{  //tripped
                    OLEDchararray("TRIP ",arial);                                
                }
            }else{  //off
                OLEDchararray("OFF  ",arial);
            }
            if(packetRX){   //on serial port
                OLEDchar('*',arial);
            }else{
                OLEDchar(' ',arial);            
            }
            packetRX=0;
            OLEDcol=2;
            OLEDpage=4;
            OLEDchararray("ON   OFF   SET",arial);
        }else{
            settingsPages();
        }
        //housekeeping
        while(updateFlag==0){   //wait for timer ISR to set
            baseModeHousekeeping();  
            if(anyButton()){updateFlag=1;}  //break on any button
        }
        updateFlag=0;   
        DAC2DATL=getTripDAC(tripCurrent);        
    }    
}

void runOLEDBoosterApp(void){
    dccSwitch=autoOn;
    //analogs, switches set by ioInit
    boostRevIoInit();    
    dccTripInit();      //comparator => DCC_EN
    dccThruInit();      //DCC inputs and outputs, CLC logic
    clcGateToggle(CLEAR_DCC_EN_LATCH); //reset
    OLEDinit();
    OLEDflip(OLED_CONNECTOR_AT_RIGHT);
    OLEDclear(0);
    OLEDbrightness(255);
    t0init();   //GP timer interrupt    
    t4init();   //DCC 22us interrupt
    DAC2DATL=getTripDAC(tripCurrent);   //use EEPROM value
    initADC();
    initFVR_ADC(FVR_2048);    
    GIE=1;
    while(1){
        //get analogs
        vSupply=getScaled(getADC(VSENSE),adcref2)*VSCALE;  //value in mV
        iDCC=getScaled(getADC(DCCOUT_I),adcref2);  //value in mV
        iDCC=iDCC*ISCALE;   //convert to mA
        if(iDCC<iOffset){iDCC=0;}else{iDCC=iDCC-iOffset;}        //offset
        if(iDCC>9900){iDCC=9900;}   //clamp
        //display modes
        if(checkButton(3)){
            baseMode=baseMode+1;
            OLEDclear(0);            
        }
        if(baseMode==BASEMODE_NORMAL){
            //check IO
            if(PRESSED(S1)){
                if(dccSwitch==0){clcGateToggle(SET_DCC_EN_LATCH);} //set
                dccSwitch=1;            
            }
            if(PRESSED(S2)){
                clcGateToggle(CLEAR_DCC_EN_LATCH); //reset
                dccSwitch=0;            
            }        
            //update display
            OLEDcol=2;
            OLEDpage=0;
            OLEDchararray("BOOST:",arial); 
            OLEDcol=56;
            OLEDpage=0;
            OLEDscanshort(vSupply+500);         //rounding
            OLEDlzb(5);
            OLEDchar(OLEDbuf[5],smallFont);
            OLEDchar(OLEDbuf[6],smallFont);
            OLEDchar('V',smallFont);
            OLEDchar(' ',smallFont);
            OLEDcol=56;
            OLEDpage=2;
            OLEDscanshort(iDCC+50);         //rounding
            OLEDchar(OLEDbuf[6],smallFont);
            OLEDchar('.',smallFont);
            OLEDchar(OLEDbuf[7],smallFont);
            OLEDchar('A',smallFont);
            OLEDcol=84;
            OLEDpage=0;
            if(dccOKtimer==0){
                OLEDchararray("ERROR",arial); 
            }else{
                if(dccSwitch){  //on
                    if(portbits.DCCOUT_EN){
                        OLEDchararray("ON   ",arial); 
                    }else{  //tripped
                        OLEDchararray("TRIP ",arial);                                
                    }
                }else{  //off
                    OLEDchararray("OFF  ",arial);
                }                
            }
            OLEDcol=2;
            OLEDpage=4;
            OLEDchararray("ON   OFF   SET",arial);
        }else{
            settingsPages();
        }
        boosterHousekeeping();
        //ledDCCstatus();
        simpleLEDstatus();
        DAC2DATL=getTripDAC(tripCurrent);        
    }
}

void runOLEDReverserApp(void){
    dccSwitch=autoOn;
    //analogs, switches set by ioInit
    boostRevIoInit();    
    dccTripInit();      //comparator => DCC_EN
    dccThruInit();      //DCC inputs and outputs, CLC logic
    clcGateToggle(CLEAR_DCC_EN_LATCH); //reset
    OLEDinit();
    OLEDflip(OLED_CONNECTOR_AT_RIGHT);
    OLEDclear(0);
    OLEDbrightness(255);
    t0init();   //GP timer interrupt    
    t4init();   //DCC 22us interrupt
    DAC2DATL=getTripDAC(tripCurrent);   //use EEPROM value
    initADC();
    initFVR_ADC(FVR_2048);    
    GIE=1;
    while(1){
        //get analogs
        vSupply=getScaled(getADC(VSENSE),adcref2)*VSCALE;  //value in mV
        iDCC=getScaled(getADC(DCCOUT_I),adcref2);  //value in mV
        iDCC=iDCC*ISCALE;   //convert to mA
        if(iDCC<iOffset){iDCC=0;}else{iDCC=iDCC-iOffset;}        //offset
        if(iDCC>9900){iDCC=9900;}   //clamp
        //display modes
        if(checkButton(3)){
            baseMode=baseMode+1;
            OLEDclear(0);            
        }
        if(baseMode==BASEMODE_NORMAL){
            //check IO
            if(PRESSED(S1)){
                if(dccSwitch==0){clcGateToggle(SET_DCC_EN_LATCH);} //set
                dccSwitch=1;            
            }
            if(PRESSED(S2)){
                clcGateToggle(CLEAR_DCC_EN_LATCH); //reset
                dccSwitch=0;            
            }        
            //update display
            OLEDcol=2;
            OLEDpage=0;
            OLEDchararray("REV:",arial); 
            OLEDcol=38;
            OLEDpage=0;
            OLEDscanshort(vSupply+500);         //rounding
            OLEDlzb(5);
            OLEDchar(OLEDbuf[5],smallFont);
            OLEDchar(OLEDbuf[6],smallFont);
            OLEDchar('V',smallFont);
            OLEDchar(' ',smallFont);
            OLEDcol=38;
            OLEDpage=2;
            OLEDscanshort(iDCC+50);         //rounding
            OLEDchar(OLEDbuf[6],smallFont);
            OLEDchar('.',smallFont);
            OLEDchar(OLEDbuf[7],smallFont);
            OLEDchar('A',smallFont);
            OLEDcol=66;
            OLEDpage=0;
            if(dccOKtimer==0){
                OLEDchararray("ERROR ",arial); 
            }else{
                if(dccSwitch){  //on
                    if(portbits.DCCOUT_EN){
                        OLEDchararray("ON    ",arial); 
                    }else{  //tripped
                        OLEDchararray("TRIP  ",arial);                                
                    }
                }else{  //off
                    OLEDchararray("OFF   ",arial);
                }                
            }
            OLEDchar(polarity,dccIcons);
            OLEDcol=2;
            OLEDpage=4;
            OLEDchararray("ON   OFF   SET",arial);
        }else{
            settingsPages();
        }
        reverserHousekeeping();
        //ledDCCstatus();
        simpleLEDstatus();
        DAC2DATL=getTripDAC(tripCurrent);        
    }    
}

void runBoostApp(void){
    while(1){
        if(PRESSED(S1)){
            if(dccSwitch==0){clcGateToggle(SET_DCC_EN_LATCH);} //set
            dccSwitch=1;            
        }
        if(PRESSED(S2)){
            clcGateToggle(CLEAR_DCC_EN_LATCH); //reset
            dccSwitch=0;            
        }
        if(PRESSED(S3)){
            runHeadlessSequence();            
        }        
        boosterHousekeeping();
        ledDCCstatus();
    }    
}

void runRevApp(void){
    while(1){
        if(PRESSED(S1)){
            if(dccSwitch==0){clcGateToggle(SET_DCC_EN_LATCH);} //set
            dccSwitch=1;            
        }
        if(PRESSED(S2)){
            clcGateToggle(CLEAR_DCC_EN_LATCH); //reset
            dccSwitch=0;            
        }
        if(PRESSED(S3)){
            runHeadlessSequence();            
        }        
        reverserHousekeeping();
        ledDCCstatus();
    }        
}

void runBoostRevApp(void){
    boosterTripCurrent=tripSettings[0];    //default to lowest
    char i=0;
    //check for S1,S2 to set autoOn
    if(PRESSED(S1)){
        latbits.LED2_PIN=1;         //LED on
        while(PRESSED(S1)){}         //until button released
        autoOn=1;
        latbits.LED2_PIN=0;
        delay(200);
    }
    if(PRESSED(S2)){
        latbits.LED2_PIN=0;         //LED off
        while(PRESSED(S2)){}         //until button released
        autoOn=0;
    }
    dccSwitch=autoOn;
    //analogs, switches set by ioInit
    boostRevIoInit();    
    dccTripInit();      //comparator => DCC_EN
    dccThruInit();      //DCC inputs and outputs, CLC logic
    clcGateToggle(CLEAR_DCC_EN_LATCH); //reset
    t0init();   //GP timer interrupt    
    t4init();   //DCC 22us interrupt
    delay(10);
    if(PRESSED(JP1B_PIN)){i=i+1;}
    if(PRESSED(JP1C_PIN)){i=i+2;}
    if(PRESSED(JP1D_PIN)){i=i+4;}
    boosterTripCurrent=tripSettings[i]; 
    DAC2DATL=getTripDAC(boosterTripCurrent);
    initADC();
    initFVR_ADC(FVR_2048);    
    GIE=1;
    if(PRESSED(JP1A_PIN)){      //REV jumper
        latbits.LED2_PIN=1;
        delay(200);
        latbits.LED2_PIN=0;
        delay(200);
        latbits.LED2_PIN=1;
        delay(200);
        latbits.LED2_PIN=0; //flash twice
        delay(400);
        runRevApp();       //does not return
    }else{
        latbits.LED2_PIN=1;
        delay(200);
        latbits.LED2_PIN=0; //flash once
        delay(400);
        runBoostApp();       //does not return
    }
    RESET();    //shouldn't get here, but reset if we do
}

void main(void) {
    ioInit();   //common pins
    delay(10);
    if(PRESSED(S3)){
        while(PRESSED(S3)){         //flash LED until button released
            latbits.LED2_PIN=1;
            delay(100);
            latbits.LED2_PIN=0;
            delay(100);
        }
        //runOLEDBaseApp();       //does not return
        if(mainMode==MODE_BOOSTREV){runOLEDBaseApp();}    //does not return
    }
    switch(mainMode){
        case MODE_BOOSTREV:      runBoostRevApp(); break;
        case MODE_BASE_OLED:     runOLEDBaseApp(); break;
        case MODE_BOOSTER_OLED:  runOLEDBoosterApp(); break;
        case MODE_REVERSER_OLED: runOLEDReverserApp(); break;
        default: runBoostRevApp();break;
    }
    RESET();    //shouldn't get here, but reset if we do
}

void __interrupt() isr(){
    if(TMR4IF && TMR4IE){   //22us
        TMR4IF=0;
        dccRXISR();
    }    
    if(TMR2IF && TMR2IE){   //58us
        TMR2IF=0;
        dccTXISR();
    }    
    if(TMR0IF && TMR0IE){   //8Hz
        TMR0IF=0;
        hostCheckTimer++;
        updateFlag=1;
        if(tripTimer){tripTimer--;}
        if(dccOKtimer){dccOKtimer--;}
        flashCtr=(flashCtr+1)&7;
    }
    uartISR();
}
