#ifndef IO_H
#define	IO_H

#include <xc.h> // include processor files - each processor file is guarded.  
#include "globalPins.h"
#include "portbits.h"


#define PRESSED(x) (portbits.x==0)
//from DIA
extern unsigned int adcref1,dacref1;
extern unsigned int adcref2,dacref2;
extern unsigned int adcref4,dacref4;

//ADC
//ideally set to give max~0xFFFF
#define ADC_OS (16)

//for FVRCON
#define FVR_OFF (0)
#define FVR_4096 (3)
#define FVR_2048 (2)
#define FVR_1024 (1)
//ADC channels
#define FVRBUF1 0b111110 
#define FVRBUF2 0b111111
#define ADC_VSS 0b111010
#define ADC_DAC1 0b111100
#define ADC_DAC2 0b111101

//for DAC1CON/DAC2CON
//eg DAC1CON=DAC_RA2|DAC_REF_FVR_GND;
#define DAC_RA2 (0b10100000)
#define RAC_RA0 (0b10010000)
#define DAC_OFF (0b00000000)
#define DAC_ON  (0b10000000)
#define DAC_REF_FVR_GND (0b1000)
#define DAC_REF_VDD_GND (0b0000)
#define ADCC_MD_ACCUM (1)
#define ADCC_MD_AVE (2)
#define ADCC_MD_BURST (3)
#define ADCC_MD_LPF (4)
#define ADCC_ALWAYS_INT (7)

//buttons
#define BUTTON_DELAY (10)
#define BUTTON_LONG (500)
#define SHORT_PRESS (1)
#define LONG_PRESS (2)
//buttonPressAndHold timings
#define PRESS_DELAY 200
#define HOLD_DELAY 100
#define DELAY_INCREMENT 10

void ioInit(void);
void t0init(void);      //t0
void t2init(void);         //t2
void initADC(void);
void deInitADC(void);
unsigned int getADC(char c);
unsigned int getVCC(void);  //in mV
unsigned int readNVM(unsigned int add);
void initFVR_DAC(char n);
void initFVR_ADC(char n);
void deInitFVR(void);
char checkButton(char n);
char checkButtonLongShort(char n);  //return long or short
char buttonState(char n);
char anyButton(void);
char buttonPressAndHold(void);  //return repeats when held
void setIdleCallback(void(*f)(void));
unsigned int getScaled(unsigned int a,unsigned int b);  //a*b/65536
void clcGateToggle(char inst, char gate);   //turn off interrupts so latch input is not held
void clcGateSet(char inst, char gate, char val);    //atomic access to CLCSELECT
void clcSetPol(char inst, char pol);        //write pol register

#endif	/* IO_H */

