//put all pin defines and globals here to be included in respective IO files

#ifndef GLOBAL_PINS_H
#define	GLOBAL_PINS_H

#include <xc.h> // include processor files - each processor file is guarded.  

#define _XTAL_FREQ (32000000UL)
#define delay __delay_ms

//global defines

//IO
#define S1 a5
#define S2 c7
#define S3 b7
#define I2C_SDA c2
#define I2C_SCL c0
#define DCCIN_A a4
#define DCCIN_B c5
#define DCCOUT_A c3
#define DCCOUT_B c6
#define DCCOUT_EN c4
#define DCCOUT_I c1
#define VSENSE a2
#define LED2_PIN b6
//alts (jumpers) for BOOSTER/REVERSER mode 
#define JP1A_PIN b5
#define JP1B_PIN b4
#define JP1C_PIN c2
#define JP1D_PIN c0

//UART
//leave these undef'd to disable
#define UART_TX1_PIN b4
#define UART_RX1_PIN b5
//#define UART_TX2_PIN a5
//#define UART_RX2_PIN a2

//RA0/RA1 PGD/PGC only
#define PGD_PIN a0
#define PGC_PIN a1

#endif	/* GLOBAL_PINS_H */

