#ifndef UART_H
#define	UART_H

#include <xc.h> 
#include "portbits.h"
#include "globalPins.h"

#define UART_GLOBAL_BUFSIZE 256
#define UART1_TXBUFSIZE UART_GLOBAL_BUFSIZE
#define UART1_RXBUFSIZE UART_GLOBAL_BUFSIZE
#define UART2_TXBUFSIZE UART_GLOBAL_BUFSIZE
#define UART2_RXBUFSIZE UART_GLOBAL_BUFSIZE
#define BAUD(x) ((_XTAL_FREQ/4)/x)

void uart1_init(unsigned int b);    //b is constant for baudcon register
void uart1_deInit(void);
void uart2_init(unsigned int b);    //b is constant for baudcon register
void uart2_deInit(void);
void uartISR(void);
#ifdef UART_TX1_PIN
void uart1_send(const char c);
void uart1_sends(const char *c);
unsigned char uart1_sendFree(void);   //bytes free for sending in uart1_txbuf
#endif
#ifdef UART_RX1_PIN
char uart1_receive(void);
unsigned char uart1_available(void); //bytes to be uart1_receive()
#endif
#ifdef UART_TX2_PIN
void uart2_send(const char c);
void uart2_sends(const char *c);
unsigned char uart2_sendFree(void);   //bytes free for sending in uart2_txbuf
#endif
#ifdef UART_RX2_PIN
char uart2_receive(void);
unsigned char uart2_available(void); //bytes to be uart2_receive()
#endif





/*



#define BRG_9600 (833)
#define BRG_38400 (208)
#define BRG_115200 (69)

//assume main oscillator at _XTAL_FREQ
#define BUFSIZE 256
char txbuf[BUFSIZE]="";
char rxbuf[BUFSIZE]="";
volatile unsigned char tx_head,tx_tail;
volatile unsigned char rx_head,rx_tail;
extern const char hex[];

extern char debugOn;
extern char scanBuf[11];

#define SCAN_LEN (30)
#define BACKSPACE (8)

char* scanSerial(void);
void uartDeInit(void);          //off
void uartInit(unsigned int b);  //b=baud rate constant
void uartSend(char c);      //add to txbuf
void uartSends(char* c);    //char array
unsigned char uartSendAvailable(void);   //bytes free for sending in txbuf
unsigned char uartAvailable(void);   //bytes to receive in rxbuf
char uartReceive(void);     //take from rxbuf
void uartISR(void);         //call from main ISR
void scanShort(unsigned int n);     //converts an unsigned int into a decimal
void uartSendHex(unsigned int c);
*/

#endif	/* UART_H */

