//put all pin defines and globals here to be included in respective IO files

#ifndef GLOBAL_PINS_H
#define	GLOBAL_PINS_H

#include <xc.h> // include processor files - each processor file is guarded.  

#define _XTAL_FREQ (32000000UL)
#define delay __delay_ms

//global defines
#define TICK_INTERVAL 25
#define SCREEN_INTERVAL 200
#define MIN_INTERVAL 100
#define MAX_INTERVAL 400
#define HEARTBEAT_INTERVAL 6000

//IO
#define S1 c4
#define S2 c1
#define S3 c5
#define S4 b4
#define S5 c0
#define S6 a4
#define I2C_SDA c3
#define I2C_SCL c2
#define VPOT c6
#define LED_GREEN b5
#define LED_RED b6

//UART
//leave these undef'd to disable
#define UART_TX1_PIN b7
#define UART_RX1_PIN c7
#define UART_TX2_PIN a5
#define UART_RX2_PIN a2

//RA0/RA1 PGD/PGC only
#define PGD_PIN a0
#define PGC_PIN a1

#endif	/* GLOBAL_PINS_H */

