#ifndef DCC_H
#define	DCC_H

#include <xc.h> 
#define PACKET_MAX_BYTES 8
#define DCC_FORWARD 1
#define DCC_REVERSE 0

typedef struct{
  unsigned int address; //XC8 can't do 14-bit bitfield, so use unsigned int
  unsigned int useLongAddress:1;
  unsigned int speed:7; 
  unsigned int dir:1;   //1=forward
  unsigned int F0:1;
  unsigned int F1:1;
  unsigned int F2:1;
  unsigned int F3:1;
  unsigned int F4:1;
} loco_t;

//packet contents
typedef struct {
  uint8_t byteCount;
  uint8_t data[PACKET_MAX_BYTES];
} dccPacket_t;

void idlePacket(dccPacket_t* p);  //load idle packet into p
void resetPacket(dccPacket_t* p); //load reset packet into p
void addChecksum(dccPacket_t* p); //add checksum byte
void addSpeed128(dccPacket_t* p, loco_t loco);
void addF04(dccPacket_t* p, loco_t loco);
void setAddress(dccPacket_t* p, loco_t loco);
void speedPacket128(dccPacket_t* p, loco_t loco);
void F04Packet(dccPacket_t* p, loco_t loco);
void DCCopsLongWrite(dccPacket_t* p,loco_t loco,int cv, unsigned char data);  //NB: address (from loco) needed s-9.2.1_dcc_extended_packet_formats: s2.3.7.3 Configuration Variable Access Instruction - Long Form
char checkPacketMatch(dccPacket_t* p1, dccPacket_t* p2);    //simple equality over valid bytes (ie up to len)

#endif	/* DCC_H */

