#include "dcc.h"

void resetPacket(dccPacket_t* p){
  p->data[0]=0;
  p->data[1]=0;
  p->byteCount=2;
  addChecksum(p);
}

void idlePacket(dccPacket_t* p){
  p->data[0]=255;
  p->data[1]=0;
  p->byteCount=2;
  addChecksum(p);
}

void addChecksum(dccPacket_t* p){
  uint8_t cx=0;
  uint8_t i;
  for(i=0;i<p->byteCount;i++){cx=cx^p->data[i];}
  p->data[p->byteCount]=cx;
  p->byteCount++;
}

void addSpeed128(dccPacket_t* p, loco_t loco){
  p->data[p->byteCount]=0x3F;   //128 step
  p->byteCount++;
  if(loco.dir){
    p->data[p->byteCount]=(loco.speed&0x7F)|128;
  }else{
    p->data[p->byteCount]=(loco.speed&0x7F);
  }
  p->byteCount++;
  addChecksum(p);
}

void addF04(dccPacket_t* p, loco_t loco){
  p->data[p->byteCount]=0x80; //F0-F0 packet
  if(loco.F0){p->data[p->byteCount]=p->data[p->byteCount]|0x10;}
  if(loco.F1){p->data[p->byteCount]=p->data[p->byteCount]|0x01;}
  if(loco.F2){p->data[p->byteCount]=p->data[p->byteCount]|0x02;}
  if(loco.F3){p->data[p->byteCount]=p->data[p->byteCount]|0x04;}
  if(loco.F4){p->data[p->byteCount]=p->data[p->byteCount]|0x08;}
  p->byteCount++;
  addChecksum(p);
}

void setAddress(dccPacket_t* p, loco_t loco){
  if(loco.useLongAddress){
    p->data[0]=0xC0|((loco.address>>8)&0x3F);
    p->data[1]=loco.address&0xFF;    
    p->byteCount=2;
  }else{
    p->data[0]=loco.address&0x7F;
    p->byteCount=1;
  }
}

void speedPacket128(dccPacket_t* p, loco_t loco){
  setAddress(p,loco);
  addSpeed128(p,loco);
}

void F04Packet(dccPacket_t* p, loco_t loco){
  setAddress(p,loco);
  addF04(p,loco);
}

//operations mode programming
void DCCopsLongWrite(dccPacket_t* p,loco_t loco,int cv, unsigned char data){  //s-9.2.1_dcc_extended_packet_formats: s2.3.7.3 Configuration Variable Access Instruction - Long Form
  cv=(cv-1)&0x3FF;            //CV1= HW address 0, 10 bits only
  setAddress(p,loco);  
  p->data[p->byteCount+0]=0xEC|((cv>>8)&0x3); //top two bits of cv
  p->data[p->byteCount+1]=cv&0xFF; //lower 8 bits of cv
  p->data[p->byteCount+2]=data; //value
  p->byteCount=p->byteCount+3;
  addChecksum(p);  
}

char checkPacketMatch(dccPacket_t* p1, dccPacket_t* p2){    //simple equality over valid bytes (up to len)
    unsigned char n=p1->byteCount;
    unsigned char i;
    if(n!=p2->byteCount){return 0;}
    for(i=0;i<n;i++){if(p1->data[0]!=p2->data[0]){return 0;}}
    return 1;
}
