#ifndef UTIL_H
#define	UTIL_H

#include <xc.h> 
#include "uart.h"
#include "io.h"
#include "dcc.h"
#include "text.h"
#include "font.h"
#include "oled.h"

#define SLIP_END (192)
#define SLIP_ESC (219)
#define SLIP_ESC_END (220)
#define SLIP_ESC_ESC (221)
#define SLIP_PACKET_SIZE 32
#define CHAINID_INVALID (0xFF)

#define LOCO_COUNT 3
#define UPDATE_COUNT 3
extern loco_t curLoco;
extern loco_t locos[LOCO_COUNT];
extern char updateFlags[LOCO_COUNT];
extern dccPacket_t speedPacket;
extern dccPacket_t functionPacket;
extern char potActive[LOCO_COUNT];   //stopped or using pot
extern char potMatched;  //is pot ready on this screen?
extern __eeprom unsigned char f1Mode;
extern __eeprom unsigned char f2Mode;
extern __eeprom loco_t savedLocos[LOCO_COUNT];

#define BUTTON_DOWN (1)
#define BUTTON_UP (2)
#define BUTTON_SEL (3)
#define BUTTON_F0 (4)
#define BUTTON_F1 (5)
#define BUTTON_F2 (6)
#define SCREEN_COUNT LOCO_COUNT+1
#define FUNCTION_MOM 0
#define FUNCTION_TOG 1

typedef struct  {  
  unsigned char byteCount;
  char data[SLIP_PACKET_SIZE];
} slipPacket_t;

typedef struct {
  unsigned char byte1;
  unsigned char byte2;
} slip_bytes_t;

extern volatile unsigned char minTimers[LOCO_COUNT];
extern volatile unsigned char maxTimers[LOCO_COUNT];
extern volatile unsigned char screenTick;
extern volatile unsigned char tickDone;
extern volatile unsigned char heartbeatTimer;
extern unsigned char chainID;
extern const char* sysMsg;

unsigned char getSpeed(void);
unsigned char getTwoDigits(void);
void sendDCCPacket(dccPacket_t* p);
slip_bytes_t slipEncode(unsigned char b); //SLIP encoding
void sendSlipByte( void(*f)(const char),slip_bytes_t s);
char processFeed(slipPacket_t* p, char c); //feed c into p, return true completion
char getSLIPlen(slipPacket_t* p);   //how many bytes needed on wire
void sendSLIPpacket(void(*f)(const char),slipPacket_t* p);
void handleThruTraffic(void);
unsigned char slipChecksum(slipPacket_t* p);
void addSlipChecksum(slipPacket_t* p);
void drawMain(char n);  //draw main page for slot n
void drawSys(void);     //draw system page
void sendTraffic(void); //any pending data
void getAddress(char n);
void idleFunction(void);    //something that can be called for busy work

#endif	/* UTIL_H */

