/*
 * File:   main.c
 * Author: Tim Blythman
 */

//see globalPins.h for _XTAL_FREQ and pins

#include "config.h"
#include "globalPins.h"
#include <xc.h>
#include "portbits.h"
#include "io.h"
#include "uart.h"
#include "oled.h"
#include "font.h"
#include "text.h"
#include "dcc.h"
#include "util.h"

char i; //counting over LOCO_COUNT
char screenIndex=0; //first few match LOCO_COUNT
//unsigned int p=0;
//char thisButton=0;  //local use
//unsigned char potSpeed=0;
//char dccState=0;
slipPacket_t sysPacket={0,""};

void main(void) {
    //unsigned int n=0;
    ioInit();
    initADC();
    t0init();
    uart1_init(BAUD(9600));
    uart2_init(BAUD(9600));
    OLEDinit();
    OLEDflip(OLED_CONNECTOR_AT_RIGHT);
    OLEDclear(0);
    OLEDbrightness(255);
    GIE=1;
    setIdleCallback(&idleFunction);
    for(i=0;i<LOCO_COUNT;i++){
        updateFlags[i]=0;
        locos[i]=savedLocos[i];
        locos[i].speed=0;   //safety!        
        potActive[i]=0;
    }
    while(1){
        idleFunction();
        if(heartbeatTimer==0){chainID=CHAINID_INVALID;} //cleared by host packets arriving
        switch(checkButtonLongShort(BUTTON_SEL)){
            case SHORT_PRESS:
                screenIndex=screenIndex+1;
                screenTick=0;
                if(screenIndex>=SCREEN_COUNT){screenIndex=0;}
                potMatched=0;
                sysMsg="";
                OLEDclear(0);
                setLED(LED_SET_OFF);
                break;
            case LONG_PRESS:
                screenTick=0;
                OLEDclear(0);
                getAddress(screenIndex);
                potMatched=0;
                OLEDclear(0);
                break;
        }
        idleFunction();
        if(screenIndex<LOCO_COUNT){
            if(checkButton(BUTTON_DOWN)){
                screenTick=0;
                if(locos[screenIndex].dir!=DCC_REVERSE){
                    if(locos[screenIndex].speed==0){locos[screenIndex].dir=DCC_REVERSE;}    //reverse if stopped
                    locos[screenIndex].speed=0;      //force stop anyway
                    potActive[screenIndex]=0;
                }else{
                    if(potActive[screenIndex]){     //toggle otherwise
                        potActive[screenIndex]=0;
                    }else{
                        potActive[screenIndex]=1;
                    }
                }        
            }
            if(checkButton(BUTTON_UP)){
                screenTick=0;
                if(locos[screenIndex].dir!=DCC_FORWARD){
                    if(locos[screenIndex].speed==0){locos[screenIndex].dir=DCC_FORWARD;}    //forward if stopped
                    locos[screenIndex].speed=0;      //force stop anyway
                    potActive[screenIndex]=0;
                }else{
                    if(potActive[screenIndex]){
                        potActive[screenIndex]=0;
                    }else{
                        potActive[screenIndex]=1;
                    }
                }                
            }
            if(checkButton(BUTTON_F0)){     //normal toggle action
                screenTick=0;
                if(locos[screenIndex].F0){
                    locos[screenIndex].F0=0;
                }else{
                    locos[screenIndex].F0=1;
                }
            }
            if(f1Mode==FUNCTION_MOM){
                if(buttonState(BUTTON_F1)){
                    locos[screenIndex].F1=1;
                }else{
                    locos[screenIndex].F1=0;
                }
            }else{
                if(checkButton(BUTTON_F1)){
                    if(locos[screenIndex].F1){
                        locos[screenIndex].F1=0;
                    }else{
                        locos[screenIndex].F1=1;
                    }
                }                
            }
            if(f2Mode==FUNCTION_MOM){
                if(buttonState(BUTTON_F2)){
                    locos[screenIndex].F2=1;
                }else{
                    locos[screenIndex].F2=0;
                }
            }else{
                if(checkButton(BUTTON_F2)){
                    if(locos[screenIndex].F2){
                        locos[screenIndex].F2=0;
                    }else{
                        locos[screenIndex].F2=1;
                    }
                }
            }
            if(locos[screenIndex].speed==getSpeed()){potMatched=1;}
            if(potMatched){
                if(potActive[screenIndex]){
                    locos[screenIndex].speed=getSpeed();
                    if(locos[screenIndex].speed){
                        setLED(LED_SET_GREEN);
                    }else{
                        setLED(LED_SET_RED);
                    }
                }else{
                    setLED(LED_SET_RED);
                    locos[screenIndex].speed=0;
                }
            }else{     //otherwise don't change       
                setLED(LED_SET_OFF);                
            }
            //check for changes and flag
            if(curLoco.speed!=locos[screenIndex].speed){updateFlags[screenIndex]=UPDATE_COUNT;}
            if(curLoco.dir!=locos[screenIndex].dir){updateFlags[screenIndex]=UPDATE_COUNT;}
            if(curLoco.F0!=locos[screenIndex].F0){updateFlags[screenIndex]=UPDATE_COUNT;}
            if(curLoco.F1!=locos[screenIndex].F1){updateFlags[screenIndex]=UPDATE_COUNT;}
            if(curLoco.F2!=locos[screenIndex].F2){updateFlags[screenIndex]=UPDATE_COUNT;}
            curLoco=locos[screenIndex];
            idleFunction();
            if(screenTick==0){
                screenTick=SCREEN_INTERVAL/TICK_INTERVAL;
                drawMain(screenIndex);            
            }            
        }else{
            //system page
            if(checkButton(BUTTON_DOWN)){
                screenTick=0;
                sysPacket.data[0]='I';
                sysPacket.data[1]=0;
                sysPacket.byteCount=2;
                addSlipChecksum(&sysPacket);
                sendSLIPpacket(&uart1_send,&sysPacket);  
                sysMsg="OFF SENT ";
                setLED(LED_SET_RED);
            }
            if(checkButton(BUTTON_UP)){
                screenTick=0;
                sysPacket.data[0]='I';
                sysPacket.data[1]=1;
                sysPacket.byteCount=2;
                addSlipChecksum(&sysPacket);
                sendSLIPpacket(&uart1_send,&sysPacket);                  
                sysMsg="ON SENT  ";
                setLED(LED_SET_GREEN);
            }
            if(checkButton(BUTTON_F0)){
                screenTick=0;
                for(i=0;i<LOCO_COUNT;i++){savedLocos[i]=locos[i];}
                sysMsg="SAVED    ";
            }
            if(checkButton(BUTTON_F1)){
                screenTick=0;
                if(f1Mode==FUNCTION_MOM){
                    f1Mode=FUNCTION_TOG;
                }else{
                    f1Mode=FUNCTION_MOM;
                }
            }
            if(checkButton(BUTTON_F2)){
                screenTick=0;
                if(f2Mode==FUNCTION_MOM){
                    f2Mode=FUNCTION_TOG;
                }else{
                    f2Mode=FUNCTION_MOM;
                }
            }
            idleFunction();
            if(screenTick==0){
                screenTick=SCREEN_INTERVAL/TICK_INTERVAL;
                drawSys();
            }            
        }
        handleThruTraffic();
        sendTraffic();
    }
}

void __interrupt() isr() {
    char i;
    uartISR();
    if(TMR0IF && TMR0IE){
        TMR0IF=0;
        tickDone=1;
        for(i=0;i<LOCO_COUNT;i++){
            if(minTimers[i]){minTimers[i]--;}
            if(maxTimers[i]){maxTimers[i]--;}            
        }
        if(heartbeatTimer){heartbeatTimer--;}
        if(screenTick){screenTick--;}
    }
}
